---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 73
  claims_with_evidence: 73
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：supply_chain モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの該当箇所が存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：モジュール内の主要なクラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：73 / 73、根拠なし：0
- 優先レビュー（高）
  1. 全てのテストケースに根拠が存在
  2. 追加で検討すべき項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `app/models/supply_chain/attestation.rb` - Attestationモデル定義
- E-02: `app/models/supply_chain/slsa/resource_descriptor.rb` - ResourceDescriptor定義
- E-03: `app/models/supply_chain/slsa/provenance_statement.rb` - ProvenanceStatement及び関連クラス定義
- E-04: `app/uploaders/supply_chain/attestation_uploader.rb` - AttestationUploader定義
- E-05: `lib/supply_chain/artifacts_reader.rb` - ArtifactsReader定義
- E-06: `lib/api/entities/supply_chain/attestation.rb` - API Entity定義
- E-07: `lib/api/supply_chain/attestations.rb` - API エンドポイント定義
- E-08: `spec/models/supply_chain/attestation_spec.rb` - 既存テスト仕様（参考）
- E-09: `spec/models/supply_chain/slsa/provenance_statement_spec.rb` - 既存テスト仕様（参考）
- E-10: `spec/lib/supply_chain/artifacts_reader_spec.rb` - 既存テスト仕様（参考）

## 3) Claims と根拠の対応（レビューの主戦場）

### SupplyChain::Attestation モデル（UT-SUC-001〜027）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | belongs_to :project リレーション | E-01 L13 | ○ |
| C-02 | belongs_to :build リレーション（optional） | E-01 L14 | ○ |
| C-03 | build optional時のnil挙動 | E-01 L14 `optional: true` | ○ |
| C-04 | validates :project_id presence | E-01 L18 | ○ |
| C-05 | validates :file presence (unless error?) | E-01 L19 | ○ |
| C-06 | error?時のfile不要検証 | E-01 L19 `unless: :error?` | ○ |
| C-07 | validates :predicate_kind presence | E-01 L20 | ○ |
| C-08 | validates :predicate_type presence | E-01 L21 | ○ |
| C-09 | validates :subject_digest presence | E-01 L22 | ○ |
| C-10 | subject_digest length minimum: 64 | E-01 L22 | ○ |
| C-11 | subject_digest length maximum: 255 | E-01 L22 | ○ |
| C-12 | subject_digest 64文字境界値 | E-01 L22 | ○ |
| C-13 | subject_digest 255文字境界値 | E-01 L22 | ○ |
| C-14 | subject_digest uniqueness scope | E-01 L24 | ○ |
| C-15 | 異なるproject_idでの重複許可 | E-01 L24 `scope: [:project_id, :predicate_kind]` | ○ |
| C-16 | scope :for_project | E-01 L26 | ○ |
| C-17 | scope :with_digest | E-01 L27 | ○ |
| C-18 | scope :with_predicate_kind | E-01 L28 | ○ |
| C-19 | scope :with_iid | E-01 L29 | ○ |
| C-20 | self.find_provenance 正常系 | E-01 L47-49 | ○ |
| C-21 | find_provenance 未存在時nil | E-01 L48 `.take` | ○ |
| C-22 | enum :status success | E-01 L37-40 | ○ |
| C-23 | enum :status error | E-01 L37-40 | ○ |
| C-24 | enum :predicate_kind provenance | E-01 L42-45 | ○ |
| C-25 | enum :predicate_kind sbom | E-01 L42-45 | ○ |
| C-26 | attribute :file_store default | E-01 L31 | ○ |
| C-27 | attribute :predicate_file_store default | E-01 L32 | ○ |

### SupplyChain::AttestationUploader（UT-SUC-028〜031）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | store_dir メソッド | E-04 L7-8 | ○ |
| C-29 | direct_upload_enabled? false | E-04 L18-20 | ○ |
| C-30 | default_store REMOTE | E-04 L22-23 | ○ |
| C-31 | default_store LOCAL | E-04 L22-23 | ○ |

### SupplyChain::Slsa::ResourceDescriptor（UT-SUC-032〜034）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | attr_accessor :name | E-02 L8 | ○ |
| C-33 | attr_accessor :digest | E-02 L8 | ○ |
| C-34 | attr_accessor :uri | E-02 L8 | ○ |

### SupplyChain::Slsa::CamelCaseJson（UT-SUC-035〜038）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | deep_change_case camelCase変換 | E-03 L6-18 | ○ |
| C-36 | _type例外キー | E-03 L7 `exceptions = %w[_type variables]` | ○ |
| C-37 | variables例外キー | E-03 L7 | ○ |
| C-38 | ネストHash再帰処理 | E-03 L12 | ○ |

### SupplyChain::Slsa::ProvenanceStatement（UT-SUC-039〜044）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | initialize デフォルト値 | E-03 L43-46 | ○ |
| C-40 | from_build 正常系 | E-03 L29-41 | ○ |
| C-41 | from_build archive不存在エラー | E-03 L31 | ○ |
| C-42 | from_build 複数archiveエラー | E-03 L31 `archives.length != 1` | ○ |
| C-43 | as_json camelCase変換 | E-03 L48-50 | ○ |
| C-44 | attributes メソッド | E-03 L52-54 | ○ |

### SupplyChain::Slsa::ProvenanceStatement 内部クラス（UT-SUC-045〜055）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | BuildDefinition.from_build | E-03 L61-78 | ○ |
| C-46 | build_type URL | E-03 L62 | ○ |
| C-47 | RunDetails.from_build | E-03 L86-102 | ○ |
| C-48 | metadata startedOn RFC3339 | E-03 L97 `.rfc3339` | ○ |
| C-49 | started_at nil安全処理 | E-03 L97 `&.utc&.rfc3339` | ○ |
| C-50 | ExternalParameters.from_build | E-03 L110-124 | ○ |
| C-51 | masked変数の[MASKED]処理 | E-03 L116-120 | ○ |
| C-52 | 通常変数の値設定 | E-03 L119 | ○ |
| C-53 | Predicate.from_build | E-03 L143-151 | ○ |
| C-54 | runner_manager未存在エラー | E-03 L144 | ○ |
| C-55 | Predicate.as_json | E-03 L153-155 | ○ |

### SupplyChain::ArtifactsReader（UT-SUC-056〜068）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | initialize 正常系 | E-05 L15-26 | ○ |
| C-57 | build nil エラー | E-05 L18 | ○ |
| C-58 | NoArtifacts エラー | E-05 L19 | ○ |
| C-59 | metadata不存在エラー | E-05 L20 | ○ |
| C-60 | BundleTooLarge | E-05 L60-65 | ○ |
| C-61 | TooManyFiles | E-05 L67-68 | ○ |
| C-62 | files イテレーション | E-05 L28-43 | ○ |
| C-63 | ディレクトリスキップ | E-05 L50 `next if path.end_with?("/")` | ○ |
| C-64 | DiskFull エラー | E-05 L41-42 | ○ |
| C-65 | ArtifactTooLarge | E-05 L77-80 | ○ |
| C-66 | メタデータnil検証 | E-05 L72 | ○ |
| C-67 | build_id フォーマット | E-05 L83-85 | ○ |
| C-68 | bytes_to_human_size | E-05 L87-89 | ○ |

### API::Entities::SupplyChain::Attestation（UT-SUC-069〜073）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | expose :id | E-06 L9 | ○ |
| C-70 | expose :iid | E-06 L10 | ○ |
| C-71 | expose :download_url | E-06 L23-26 | ○ |
| C-72 | expose :status | E-06 L17 | ○ |
| C-73 | expose :predicate_kind | E-06 L18 | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目なし
- 既存テストファイル（spec/）を参照して追加のテストケースを検討可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースにソースコード根拠あり
- 注意点：
  - セキュリティ関連（マスク変数処理）のテストは優先度高で実装推奨
  - サイズ制限関連のテストは設定値(MAX_SIZE, MAX_FILES_IN_BUNDLE)の変更時に見直し必要

## 6) レビュアーチェックリスト（最小）
- [ ] Attestationモデルのバリデーションテストケースが網羅的か確認
- [ ] SLSA関連クラスのfrom_buildメソッドの例外処理が適切にテストされているか確認
- [ ] ArtifactsReaderの各種エラー条件が全てカバーされているか確認
- [ ] API Entityのexpose項目が実際のAPIレスポンスと一致するか確認
- [ ] セキュリティ観点：masked変数の[MASKED]処理テストが実装されることを確認
