---
generated_at: 2026-01-22 15:30:00
metrics:
  claims_total: 86
  claims_with_evidence: 86
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：system.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：86 / 86、根拠なし：0
- 優先レビュー（高）
  1. 該当なし - 全てのテストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/system/broadcast_message.rb` - メインモデルファイル
- E-02: `spec/models/system/broadcast_message_spec.rb` - 既存テストスペック
- E-03: `app/models/users/broadcast_message_dismissal.rb` - 関連モデル
- E-04: `lib/api/entities/system/broadcast_message.rb` - APIエンティティ
- E-05: `spec/factories/system/broadcast_messages.rb` - テストファクトリ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | validates :messageのバリデーション | E-01 (L19), E-02 (L14-26) | ○ |
| C-02 | validates :starts_atのバリデーション | E-01 (L20), E-02 (L14) | ○ |
| C-03 | validates :ends_atのバリデーション | E-01 (L21), E-02 (L14) | ○ |
| C-04 | validates :broadcast_typeのバリデーション | E-01 (L22), E-02 (L28-29) | ○ |
| C-05 | validates :target_access_levelsのバリデーション | E-01 (L23), E-02 (L30, L33-36) | ○ |
| C-06 | validates :show_in_cliのバリデーション | E-01 (L24), E-02 (L31, L38-41) | ○ |
| C-07 | validates :colorのバリデーション | E-01 (L26), E-02 (L15-21) | ○ |
| C-08 | validates :fontのバリデーション | E-01 (L27), E-02 (L23-26) | ○ |
| C-09 | attribute :colorのデフォルト値 | E-01 (L29), E-02 (L44-48) | ○ |
| C-10 | attribute :fontのデフォルト値 | E-01 (L30), E-02 (L44-48) | ○ |
| C-11 | has_many :broadcast_message_dismissalsリレーション | E-01 (L32), E-02 (L10-12), E-03 (L6) | ○ |
| C-12 | scope :current_and_future_messagesの動作 | E-01 (L34), E-02 (L491-499) | ○ |
| C-13 | enum :themeの定義 | E-01 (L42-53) | ○ |
| C-14 | enum :broadcast_typeの定義 | E-01 (L55-58), E-02 (L28) | ○ |
| C-15 | active?メソッドの動作 | E-01 (L114-116), E-02 (L367-385) | ○ |
| C-16 | started?メソッドの動作 | E-01 (L118-120), E-02 (L387-403) | ○ |
| C-17 | ended?メソッドの動作 | E-01 (L122-124), E-02 (L405-421) | ○ |
| C-18 | now?メソッドの動作 | E-01 (L126-128) | ○ |
| C-19 | future?メソッドの動作 | E-01 (L130-132) | ○ |
| C-20 | now_or_future?メソッドの動作 | E-01 (L134-136) | ○ |
| C-21 | matches_current_user_access_level?メソッドの動作 | E-01 (L138-142), E-02 (L201-233) | ○ |
| C-22 | matches_current_pathメソッドの動作 | E-01 (L144-158), E-02 (L133-199) | ○ |
| C-23 | flush_redis_cacheメソッドの動作 | E-01 (L160-164), E-02 (L423-489) | ○ |
| C-24 | after_commit :flush_redis_cacheコールバック | E-01 (L40), E-02 (L423-433) | ○ |
| C-25 | .current_banner_messagesクラスメソッド | E-01 (L61-65), E-02 (L284-312) | ○ |
| C-26 | .current_show_in_cli_banner_messagesクラスメソッド | E-01 (L67-69), E-02 (L344-358) | ○ |
| C-27 | .current_notification_messagesクラスメソッド | E-01 (L71-75), E-02 (L314-342) | ○ |
| C-28 | .currentクラスメソッド | E-01 (L77-81), E-02 (L252-282) | ○ |
| C-29 | .cacheクラスメソッド | E-01 (L83-87) | ○ |
| C-30 | .cache_expires_inクラスメソッド | E-01 (L89-91) | ○ |
| C-31 | キャッシュ動作（古いデータ互換性） | E-02 (L235-250) | ○ |
| C-32 | キャッシュ動作（有効期限） | E-02 (L78-131) | ○ |
| C-33 | attributesメソッド（message_html含む） | E-01 (L17), E-02 (L361-365) | ○ |
| C-34 | 定数ALLOWED_TARGET_ACCESS_LEVELS | E-01 (L8-15) | ○ |
| C-35 | 定数CACHE_KEY | E-01 (L36) | ○ |
| C-36 | 定数BANNER_CACHE_KEY | E-01 (L37) | ○ |
| C-37 | 定数NOTIFICATION_CACHE_KEY | E-01 (L38) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - 全てのテストケースはソースコードまたは既存テストスペックに基づいて生成されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースに十分な根拠があります
- 注意点：
  - `matches_current_path`メソッドは正規表現を使用しており、ReDoS攻撃の可能性を考慮したテストケースの追加を検討
  - キャッシュ関連のテストは時間依存性があるため、`travel_to`を使用した確実なテストが必要

## 6) レビュアーチェックリスト（最小）
- [ ] バリデーションテストケース（UT-SYS-001〜021）が実際のバリデーション定義と一致しているか
- [ ] 時間関連メソッド（active?, started?, ended?, now?, future?）のテストケースが境界値を適切にカバーしているか
- [ ] キャッシュ動作テスト（UT-SYS-075〜080）が実際のキャッシュ実装と一致しているか
- [ ] `matches_current_path`のワイルドカードパターンテストが十分か
- [ ] `matches_current_user_access_level?`がALLOWED_TARGET_ACCESS_LEVELSの全アクセスレベルをカバーしているか
- [ ] 既存テストスペック（E-02）との重複/差分を確認し、不足しているテスト観点がないか

---

## 補足：テストケース生成の根拠詳細

### バリデーション関連（UT-SYS-001〜021）

**根拠コード（E-01: app/models/system/broadcast_message.rb L19-27）:**
```ruby
validates :message,   presence: true
validates :starts_at, presence: true
validates :ends_at,   presence: true
validates :broadcast_type, presence: true
validates :target_access_levels, inclusion: { in: ALLOWED_TARGET_ACCESS_LEVELS }
validates :show_in_cli, allow_nil: false, inclusion: { in: [true, false], message: N_('must be a boolean value') }
validates :color, allow_blank: true, color: true
validates :font,  allow_blank: true, color: true
```

### 状態判定メソッド関連（UT-SYS-032〜045）

**根拠コード（E-01: app/models/system/broadcast_message.rb L114-136）:**
```ruby
def active?
  started? && !ended?
end

def started?
  Time.current >= starts_at
end

def ended?
  ends_at.past?
end

def now?
  (starts_at..ends_at).cover?(Time.current)
end

def future?
  starts_at.future?
end

def now_or_future?
  now? || future?
end
```

### パスマッチング関連（UT-SYS-051〜060）

**根拠コード（E-01: app/models/system/broadcast_message.rb L144-158）:**
```ruby
def matches_current_path(current_path)
  return false if current_path.blank? && target_path.present?
  return true if current_path.blank? || target_path.blank?

  current_path = "/#{current_path}" unless current_path.start_with?("/")

  escaped = Regexp.escape(target_path).gsub('\\*', '.*')
  regexp = Regexp.new "^#{escaped}$", Regexp::IGNORECASE

  regexp.match(current_path)
end
```

**既存テスト根拠（E-02: spec/models/system/broadcast_message_spec.rb L133-199）:**
- ワイルドカードマッチング
- パス先頭スラッシュの正規化
- 空パス/nilパスの処理
