---
generated_at: 2026-01-22 15:30:00
metrics:
  claims_total: 119
  claims_with_evidence: 119
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：time_tracking 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：119 / 119、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースがソースコードに基づいて生成されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/time_tracking/timelog_category.rb` - TimelogCategoryモデル定義
- E-02: `app/models/timelog.rb` - Timelogモデル定義
- E-03: `app/models/concerns/time_trackable.rb` - TimeTrackable concern定義
- E-04: `app/models/work_items/widgets/time_tracking.rb` - WorkItems TimeTrackingウィジェット
- E-05: `app/services/system_notes/time_tracking_service.rb` - システムノートサービス
- E-06: `app/services/issuable/callbacks/time_tracking.rb` - Issuableコールバック
- E-07: `app/services/work_items/data_sync/widgets/time_tracking.rb` - DataSyncウィジェット
- E-08: `app/controllers/time_tracking/timelogs_controller.rb` - Timelogsコントローラ
- E-09: `app/policies/time_tracking/timelog_category_policy.rb` - TimelogCategoryポリシー
- E-10: `app/graphql/types/time_tracking/timelog_category_type.rb` - GraphQL TimelogCategoryType
- E-11: `app/graphql/types/time_tracking/timelog_connection_type.rb` - GraphQL TimelogConnectionType
- E-12: `app/graphql/types/time_tracking/timelog_sort_enum.rb` - GraphQL TimelogSortEnum
- E-13: `app/graphql/types/work_items/widgets/time_tracking/time_tracking_type.rb` - GraphQL TimeTrackingType
- E-14: `app/graphql/types/work_items/widgets/time_tracking/timelog_type.rb` - GraphQL TimelogType
- E-15: `app/graphql/types/work_items/widgets/time_tracking/time_tracking_input_type.rb` - GraphQL TimeTrackingInputType
- E-16: `app/graphql/types/work_items/widgets/time_tracking/human_readable_attributes_type.rb` - GraphQL HumanReadableAttributesType
- E-17: `app/graphql/types/work_items/widgets/time_tracking/timelog_input_type.rb` - GraphQL TimelogInputType
- E-18: `lib/gitlab/time_tracking_formatter.rb` - TimeTrackingFormatter ユーティリティ

## 3) Claims と根拠の対応（レビューの主戦場）

### TimeTracking::TimelogCategory (UT-TT-001 〜 UT-TT-019)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | namespaceリレーション | E-01 (L10: `belongs_to :namespace`) | ○ |
| C-02 | timelogsリレーション | E-01 (L12: `has_many :timelogs`) | ○ |
| C-03 | namespace必須バリデーション | E-01 (L16: `validates :namespace, presence: true`) | ○ |
| C-04 | name必須バリデーション | E-01 (L17: `validates :name, presence: true`) | ○ |
| C-05 | name一意性バリデーション | E-01 (L18: `uniqueness: { case_sensitive: false, scope: [:namespace_id] }`) | ○ |
| C-06 | name最大長255 | E-01 (L19: `length: { maximum: 255 }`) | ○ |
| C-07 | description最大長1024 | E-01 (L20: `length: { maximum: 1024 }`) | ○ |
| C-08 | colorバリデーション | E-01 (L21: `color: true, allow_blank: false, length: { maximum: 7 }`) | ○ |
| C-09 | billing_rate条件付き必須 | E-01 (L22-25: `if: :billable?, presence: true, numericality: { greater_than: 0 }`) | ○ |
| C-10 | colorデフォルト値 | E-01 (L27-29: `DEFAULT_COLOR = '#6699cc'`, `default: DEFAULT_COLOR`) | ○ |
| C-11 | find_by_nameメソッド | E-01 (L31-34: `iwhere(name: name)`) | ○ |

### Timelog (UT-TT-020 〜 UT-TT-049)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | issueリレーション | E-02 (L20: `belongs_to :issue, touch: true`) | ○ |
| C-13 | merge_requestリレーション | E-02 (L21: `belongs_to :merge_request, touch: true`) | ○ |
| C-14 | projectリレーション | E-02 (L22: `belongs_to :project`) | ○ |
| C-15 | userリレーション | E-02 (L23: `belongs_to :user`) | ○ |
| C-16 | timelog_categoryリレーション | E-02 (L25: `belongs_to :timelog_category, optional: true`) | ○ |
| C-17 | time_spent必須 | E-02 (L15: `validates :time_spent, :user, :namespace, presence: true`) | ○ |
| C-18 | user必須 | E-02 (L15) | ○ |
| C-19 | namespace必須 | E-02 (L15) | ○ |
| C-20 | summary最大長255 | E-02 (L16: `length: { maximum: 255 }`) | ○ |
| C-21 | issue/merge_request排他制約 | E-02 (L17: `ExactlyOnePresentValidator, fields: [:issue, :merge_request]`) | ○ |
| C-22 | MAX_TOTAL_TIME_SPENT定数 | E-02 (L6: `MAX_TOTAL_TIME_SPENT = 31557600.seconds.to_i`) | ○ |
| C-23 | check_total_time_spent_is_within_range | E-02 (L71-76) | ○ |
| C-24 | issuableメソッド | E-02 (L55-57: `issue \|\| merge_request`) | ○ |
| C-25 | スコープin_group | E-02 (L28-30) | ○ |
| C-26 | スコープin_project | E-02 (L32-34) | ○ |
| C-27 | スコープfor_user | E-02 (L36-38) | ○ |
| C-28 | スコープat_or_after | E-02 (L40-42) | ○ |
| C-29 | スコープat_or_before | E-02 (L44-46) | ○ |
| C-30 | スコープwith_summary | E-02 (L48-50) | ○ |
| C-31 | sort_by_fieldメソッド | E-02 (L59-67) | ○ |
| C-32 | set_projectコールバック | E-02 (L78-80) | ○ |
| C-33 | ensure_namespace_idコールバック | E-02 (L82-88) | ○ |

### TimeTrackable Concern (UT-TT-050 〜 UT-TT-066)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | spend_timeメソッド | E-03 (L45-61) | ○ |
| C-35 | total_time_spentメソッド | E-03 (L65-73) | ○ |
| C-36 | human_total_time_spentメソッド | E-03 (L76-78) | ○ |
| C-37 | time_changeメソッド | E-03 (L80-82) | ○ |
| C-38 | human_time_changeメソッド | E-03 (L84-86) | ○ |
| C-39 | human_time_estimateメソッド | E-03 (L88-90) | ○ |
| C-40 | time_estimate=セッター | E-03 (L92-94) | ○ |
| C-41 | check_time_estimateバリデーション | E-03 (L143-149) | ○ |
| C-42 | check_negative_time_spentバリデーション | E-03 (L129-135) | ○ |
| C-43 | category_idメソッド | E-03 (L151-153) | ○ |

### WorkItems::Widgets::TimeTracking (UT-TT-067 〜 UT-TT-071)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | デリゲート: time_estimate | E-04 (L6-7: `delegate :time_estimate, :total_time_spent, :timelogs...`) | ○ |
| C-45 | デリゲート: total_time_spent | E-04 (L6-7) | ○ |
| C-46 | デリゲート: timelogs | E-04 (L6-7) | ○ |
| C-47 | quick_action_commandsメソッド | E-04 (L9-19) | ○ |
| C-48 | quick_action_paramsメソッド | E-04 (L22-24) | ○ |

### SystemNotes::TimeTrackingService (UT-TT-072 〜 UT-TT-083)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | change_start_date_or_due_dateメソッド | E-05 (L19-32) | ○ |
| C-50 | change_time_estimateメソッド | E-05 (L45-51) | ○ |
| C-51 | change_time_spentメソッド | E-05 (L64-75) | ○ |
| C-52 | created_timelogメソッド | E-05 (L88-94) | ○ |
| C-53 | remove_timelogメソッド | E-05 (L96-104) | ○ |
| C-54 | formatted_spent_atメソッド | E-05 (L114-119) | ○ |
| C-55 | time_estimate_system_noteメソッド | E-05 (L158-170) | ○ |

### Issuable::Callbacks::TimeTracking (UT-TT-084 〜 UT-TT-093)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | after_initializeメソッド | E-06 (L8-26) | ○ |
| C-57 | parse_timelog_dataメソッド | E-06 (L30-44) | ○ |
| C-58 | parse_time_estimate_dataメソッド | E-06 (L46-54) | ○ |
| C-59 | 権限チェック | E-06 (L15: `has_permission?(:"admin_#{issuable.to_ability_name}")`) | ○ |

### WorkItems::DataSync::Widgets::TimeTracking (UT-TT-094 〜 UT-TT-099)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | before_createメソッド | E-07 (L7-11) | ○ |
| C-61 | after_save_commitメソッド | E-07 (L13-18) | ○ |
| C-62 | post_move_cleanupメソッド | E-07 (L21-25) | ○ |

### TimeTracking::TimelogsController (UT-TT-100 〜 UT-TT-101)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | indexアクション | E-08 (L8-10) | ○ |
| C-64 | フィーチャーフラグチェック | E-08 (L9: `Feature.enabled?(:global_time_tracking_report, current_user)`) | ○ |

### TimeTracking::TimelogCategoryPolicy (UT-TT-102)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | namespaceへの委譲 | E-09 (L5: `delegate { @subject.namespace }`) | ○ |

### Gitlab::TimeTrackingFormatter (UT-TT-103 〜 UT-TT-113)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | parseメソッド | E-18 (L10-25) | ○ |
| C-67 | 負の時間パース | E-18 (L13-14, L23: `negative_time = string.start_with?('-')`) | ○ |
| C-68 | CUSTOM_DAY_AND_MONTH_LENGTH | E-18 (L8: `hours_per_day: 8, days_per_month: 20`) | ○ |
| C-69 | outputメソッド | E-18 (L27-29) | ○ |
| C-70 | 負数出力 | E-18 (L44-46: `negative_output`) | ○ |

### GraphQL Types (UT-TT-114 〜 UT-TT-119)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | TimelogConnectionType.total_spent_time | E-11 (L12-18) | ○ |
| C-72 | TimelogType.userメソッド | E-14 (L38-42) | ○ |
| C-73 | TimelogType.spent_atメソッド | E-14 (L44-46) | ○ |
| C-74 | default_ghostメソッド | E-14 (L50-52) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特に不足している情報はありません
- 全てのテストケースがソースコードに基づいて生成されています

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースにソースコードの根拠があり、信頼度は高いです
- 以下の点については追加のレビューを推奨:
  - MAX_TOTAL_TIME_SPENT (31557600秒 = 約1年) の妥当性
  - TimeTrackingFormatterのCUSTOM_DAY_AND_MONTH_LENGTH設定（8時間/日、20日/月）がビジネス要件と整合しているか
  - timelog_categoryのbilling_rateに関するビジネスロジック

## 6) レビュアーチェックリスト（最小）
- [ ] TimelogCategoryのバリデーション（特にname一意性の大文字小文字無視）が期待通りか確認
- [ ] Timelog.MAX_TOTAL_TIME_SPENTの値（31557600秒 = 約1年）が適切か確認
- [ ] TimeTrackableのspend_time実装がリセット含めて正しく動作するか確認
- [ ] SystemNotes::TimeTrackingServiceの各メソッドが正しいノートテキストを生成するか確認
- [ ] Issuable::Callbacks::TimeTrackingの権限チェックが適切か確認
- [ ] WorkItems::DataSync::Widgets::TimeTrackingのmove操作時の非同期処理が適切か確認
- [ ] Gitlab::TimeTrackingFormatterのparse/outputが双方向で整合性があるか確認
- [ ] GraphQL TypesのBatchModelLoaderとghost userフォールバックが適切か確認
