---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 230
  claims_with_evidence: 230
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：users.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：230 / 230、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全てのテストケースにソースコード根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

### Models
- E-01: `app/models/users/project_callout.rb`
- E-02: `app/models/users/project_visit.rb`
- E-03: `app/models/users/credit_card_validation.rb`
- E-04: `app/models/users/group_callout.rb`
- E-05: `app/models/users/phone_number_validation.rb`
- E-06: `app/models/users/callout.rb`
- E-07: `app/models/users/merge_request_interaction.rb`
- E-08: `app/models/users/group_visit.rb`
- E-09: `app/models/users/user_follow_user.rb`
- E-10: `app/models/users/saved_reply.rb`
- E-11: `app/models/users/banned_user.rb`
- E-12: `app/models/users/calloutable.rb`
- E-13: `app/models/users/namespace_commit_email.rb`
- E-14: `app/models/users/broadcast_message_dismissal.rb`
- E-15: `app/models/users/anonymous.rb`
- E-16: `app/models/users/ghost_user_migration.rb`

### Services
- E-17: `app/services/users/ban_service.rb`
- E-18: `app/services/users/unban_service.rb`
- E-19: `app/services/users/block_service.rb`
- E-20: `app/services/users/unblock_service.rb`
- E-21: `app/services/users/activate_service.rb`
- E-22: `app/services/users/deactivate_service.rb`
- E-23: `app/services/users/destroy_service.rb`
- E-24: `app/services/users/create_service.rb`
- E-25: `app/services/users/update_service.rb`
- E-26: `app/services/users/approve_service.rb`
- E-27: `app/services/users/reject_service.rb`
- E-28: `app/services/users/trust_service.rb`
- E-29: `app/services/users/set_status_service.rb`
- E-30: `app/services/users/banned_user_base_service.rb`
- E-31: `app/services/users/dismiss_callout_service.rb`
- E-32: `app/services/users/activity_service.rb`
- E-33: `app/services/users/migrate_records_to_ghost_user_service.rb`
- E-34: `app/services/users/refresh_authorized_projects_service.rb`
- E-35: `app/services/users/upsert_credit_card_validation_service.rb`
- E-36: `app/services/users/set_namespace_commit_email_service.rb`
- E-37: `app/services/users/dismiss_broadcast_message_service.rb`
- E-38: `app/services/users/build_service.rb`
- E-39: `app/services/users/email_verification/validate_token_service.rb`
- E-40: `app/services/users/respond_to_terms_service.rb`

## 3) Claims と根拠の対応（レビューの主戦場）

### Models - ProjectCallout (UT-USR-001 ~ UT-USR-006)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ProjectCalloutがbelongs_to :projectリレーションを持つ | E-01 (L9) | ○ |
| C-02 | ProjectCalloutがbelongs_to :userリレーションを持つ（Calloutableから継承） | E-01 (L5), E-12 (L8) | ○ |
| C-03 | projectがnilの場合バリデーションエラー | E-01 (L23) | ○ |
| C-04 | feature_nameがnilの場合バリデーションエラー | E-01 (L24-27) | ○ |
| C-05 | feature_nameの一意制約（user_id, project_id scope） | E-01 (L24-27) | ○ |
| C-06 | feature_name enumが定義されている | E-01 (L12-21) | ○ |

### Models - ProjectVisit (UT-USR-007 ~ UT-USR-011)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-07 | frecent_projectsメソッドが最大5件返却 | E-02 (L17, L19-22) | ○ |
| C-08 | entity_id, user_id, visited_atのpresenceバリデーション | E-02 (L13-15) | ○ |

### Models - CreditCardValidation (UT-USR-012 ~ UT-USR-029)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-09 | belongs_to :user, belongs_to :banned_userリレーション | E-03 (L11-13) | ○ |
| C-10 | holder_name最大50文字バリデーション | E-03 (L15) | ○ |
| C-11 | last_digits 0-9999範囲バリデーション | E-03 (L17-19) | ○ |
| C-12 | similar_records, similar_holder_names_count, used_by_banned_user?メソッド | E-03 (L54-64) | ○ |
| C-13 | set_*_hashメソッドによるbefore_saveコールバック | E-03 (L49-52, L66-80) | ○ |
| C-14 | exceeded_daily_verification_limit? (DAILY_VERIFICATION_LIMIT=5) | E-03 (L5, L82-88) | ○ |

### Models - GroupCallout (UT-USR-030 ~ UT-USR-033)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | belongs_to :groupリレーション | E-04 (L9) | ○ |
| C-16 | groupのpresenceバリデーション | E-04 (L53) | ○ |
| C-17 | feature_nameの一意制約（user_id, group_id scope） | E-04 (L54-57) | ○ |
| C-18 | source_feature_nameメソッド | E-04 (L59-61) | ○ |

### Models - PhoneNumberValidation (UT-USR-034 ~ UT-USR-055)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | belongs_to :user, belongs_to :banned_userリレーション | E-05 (L15-16) | ○ |
| C-20 | country最大3文字バリデーション | E-05 (L18) | ○ |
| C-21 | international_dial_code 1-999範囲バリデーション | E-05 (L20-26) | ○ |
| C-22 | phone_number数字のみ最大12文字バリデーション | E-05 (L28-34) | ○ |
| C-23 | similar_records, duplicate_recordsメソッド | E-05 (L47-52) | ○ |
| C-24 | related_to_banned_user?クラスメソッド | E-05 (L55-63) | ○ |
| C-25 | validated?メソッド | E-05 (L69-71) | ○ |
| C-26 | sms_send_allowed_after待機時間ロジック | E-05 (L8, L73-82) | ○ |

### Models - Callout (UT-USR-056 ~ UT-USR-058)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | feature_name presenceと一意制約バリデーション | E-06 (L129-132) | ○ |
| C-28 | with_feature_nameスコープ | E-06 (L134) | ○ |

### Models - MergeRequestInteraction (UT-USR-059 ~ UT-USR-067)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | initializeメソッド | E-07 (L5-9) | ○ |
| C-30 | can_merge?, can_update?メソッド | E-07 (L15-21) | ○ |
| C-31 | review_state, reviewed?, approved?メソッド | E-07 (L23-33) | ○ |

### Models - GroupVisit (UT-USR-068 ~ UT-USR-069)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | frecent_groupsメソッド（MAX_FRECENT_ITEMS=3） | E-08 (L17, L19-22) | ○ |

### Models - UserFollowUser (UT-USR-070 ~ UT-USR-073)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | belongs_to :follower, :followeeリレーション | E-09 (L6-7) | ○ |
| C-34 | max_follow_limitバリデーション（MAX_FOLLOWEE_LIMIT=300） | E-09 (L4, L9, L13-23) | ○ |

### Models - SavedReply (UT-USR-074 ~ UT-USR-075)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | belongs_to :userリレーション | E-10 (L12) | ○ |
| C-36 | namespace_foreign_keyクラスメソッド | E-10 (L5-7) | ○ |

### Models - BannedUser (UT-USR-076 ~ UT-USR-083)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | belongs_to :user, has_one :credit_card_validation, has_many :emailsリレーション | E-11 (L9-12) | ○ |
| C-38 | user presenceと一意制約バリデーション | E-11 (L14-15) | ○ |
| C-39 | by_detumbled_emailスコープ | E-11 (L17-23) | ○ |

### Models - Calloutable (UT-USR-084 ~ UT-USR-087)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | belongs_to :userとpresenceバリデーション | E-12 (L7-10) | ○ |
| C-41 | dismissed_after?メソッド | E-12 (L13-15) | ○ |

### Models - NamespaceCommitEmail (UT-USR-088 ~ UT-USR-097)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | belongs_to :user, :namespace, :emailリレーション | E-13 (L5-7) | ○ |
| C-43 | presence、一意制約バリデーション | E-13 (L9-12) | ○ |
| C-44 | validate_root_groupカスタムバリデーション | E-13 (L13, L20-28) | ○ |
| C-45 | delete_for_namespaceクラスメソッド | E-13 (L15-17) | ○ |

### Models - BroadcastMessageDismissal (UT-USR-098 ~ UT-USR-108)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | belongs_to :user, :broadcast_messageリレーション | E-14 (L5-6) | ○ |
| C-47 | presenceと一意制約バリデーション | E-14 (L8-9) | ○ |
| C-48 | valid_dismissals, for_userスコープ | E-14 (L13-16) | ○ |
| C-49 | cookie_key, find_or_initialize_dismissal, get_cookie_keyメソッド | E-14 (L20-31) | ○ |

### Models - Anonymous (UT-USR-109 ~ UT-USR-110)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | can?クラスメソッド | E-15 (L6-8) | ○ |

### Models - GhostUserMigration (UT-USR-111 ~ UT-USR-114)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | belongs_to :user, :initiator_userリレーション | E-16 (L7-8) | ○ |
| C-52 | user_id presenceバリデーション | E-16 (L10) | ○ |
| C-53 | consume_orderスコープ | E-16 (L12) | ○ |

### Services - BanService (UT-USR-115 ~ UT-USR-118)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | update_user, valid_state?, actionメソッド | E-17 (L9-24) | ○ |
| C-55 | ban_duplicate_usersでWorkerをキュー | E-17 (L26-28) | ○ |

### Services - UnbanService (UT-USR-119 ~ UT-USR-121)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | update_user, valid_state?, actionメソッド | E-18 (L7-17) | ○ |

### Services - BlockService (UT-USR-122 ~ UT-USR-125)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | executeメソッドで内部ユーザーチェック | E-19 (L10) | ○ |
| C-58 | after_block_hookでカスタム属性設定 | E-19 (L24-30) | ○ |

### Services - UnblockService (UT-USR-126 ~ UT-USR-128)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | executeメソッド | E-20 (L9-15) | ○ |
| C-60 | after_unblock_hookでカスタム属性設定 | E-20 (L20-26) | ○ |

### Services - ActivateService (UT-USR-129 ~ UT-USR-133)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | executeメソッドで権限・状態チェック | E-21 (L9-23) | ○ |
| C-62 | log_eventでログ記録 | E-21 (L37-45) | ○ |

### Services - DeactivateService (UT-USR-134 ~ UT-USR-141)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | executeメソッドで権限・状態・アクティビティチェック | E-22 (L10-46) | ○ |
| C-64 | skip_authorizationオプション | E-22 (L5-8, L57-60) | ○ |
| C-65 | log_eventでログ記録 | E-22 (L63-71) | ○ |

### Services - DestroyService (UT-USR-142 ~ UT-USR-150)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | executeメソッドで権限・所有権チェック | E-23 (L39-54) | ○ |
| C-67 | solo_owned_groups, personal_projects削除 | E-23 (L59-73) | ○ |
| C-68 | create_ghost_userでGhostUserMigration作成 | E-23 (L86-95) | ○ |

### Services - CreateService (UT-USR-151 ~ UT-USR-154)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | executeメソッド | E-24 (L12-16) | ○ |
| C-70 | after_create_hookで通知送信 | E-24 (L24-26) | ○ |

### Services - UpdateService (UT-USR-155 ~ UT-USR-162)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | executeメソッドでパスワード確認・ステータス更新 | E-25 (L23-48) | ○ |
| C-72 | organization_users_errorバリデーション | E-25 (L91-98) | ○ |
| C-73 | remove_followers_and_followee!メソッド | E-25 (L190-205) | ○ |

### Services - ApproveService (UT-USR-163 ~ UT-USR-169)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | executeメソッドで権限・状態チェック、承認処理 | E-26 (L9-30) | ○ |
| C-75 | log_eventでログ記録 | E-26 (L49-57) | ○ |

### Services - RejectService (UT-USR-170 ~ UT-USR-173)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-76 | executeメソッドで権限・状態チェック、拒否処理 | E-27 (L9-21) | ○ |
| C-77 | log_eventでログ記録 | E-27 (L36-44) | ○ |

### Services - TrustService (UT-USR-174)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-78 | executeメソッドでtrusted_by設定 | E-28 (L9-12) | ○ |

### Services - SetStatusService (UT-USR-175 ~ UT-USR-179)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | executeメソッドで権限チェック、ステータス設定/削除 | E-29 (L15-23) | ○ |
| C-80 | デフォルト絵文字設定 | E-29 (L28) | ○ |
| C-81 | bump_userでタイムスタンプ更新 | E-29 (L53-58) | ○ |

### Services - BannedUserBaseService (UT-USR-180 ~ UT-USR-183)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-82 | executeメソッドで権限・状態チェック | E-30 (L9-21) | ○ |
| C-83 | log_eventでログ記録 | E-30 (L42-50) | ○ |

### Services - DismissCalloutService (UT-USR-184 ~ UT-USR-185)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-84 | executeメソッドでdismissed_at設定 | E-31 (L5-9) | ○ |

### Services - ActivityService (UT-USR-186 ~ UT-USR-190)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-85 | executeメソッドでアクティビティ記録判定 | E-32 (L19-25) | ○ |
| C-86 | record_activityで排他制御とHLLイベント記録 | E-32 (L31-54) | ○ |

### Services - MigrateRecordsToGhostUserService (UT-USR-191 ~ UT-USR-196)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-87 | executeメソッドでレコード移行 | E-33 (L24-29) | ○ |
| C-88 | hard_delete時はmigrate_recordsをスキップ | E-33 (L38) | ○ |
| C-89 | batched_migrateでバッチ処理 | E-33 (L132-138) | ○ |

### Services - RefreshAuthorizedProjectsService (UT-USR-197 ~ UT-USR-200)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-90 | executeメソッドで排他ロック取得 | E-34 (L32-54) | ○ |
| C-91 | update_authorizationsで認可更新 | E-34 (L74-89) | ○ |

### Services - UpsertCreditCardValidationService (UT-USR-201 ~ UT-USR-205)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-92 | executeメソッドでレコード作成/更新 | E-35 (L11-38) | ○ |
| C-93 | 日次検証上限チェック | E-35 (L28) | ○ |
| C-94 | expiration_dateで月末日計算 | E-35 (L78-83) | ○ |

### Services - SetNamespaceCommitEmailService (UT-USR-206 ~ UT-USR-211)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-95 | executeメソッドで権限チェック、CRUD処理 | E-36 (L16-38) | ○ |

### Services - DismissBroadcastMessageService (UT-USR-212 ~ UT-USR-213)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-96 | executeメソッドでdismissal保存 | E-37 (L10-17) | ○ |

### Services - BuildService (UT-USR-214 ~ UT-USR-221)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-97 | executeメソッドでユーザー構築 | E-38 (L18-23) | ○ |
| C-98 | admin?による分岐処理 | E-38 (L37-46) | ○ |
| C-99 | validate_access!でサインアップ制限チェック | E-38 (L146-154) | ○ |
| C-100 | allowed_user_type?でユーザータイプ制限 | E-38 (L133-135) | ○ |

### Services - EmailVerification::ValidateTokenService (UT-USR-222 ~ UT-USR-227)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-101 | executeメソッドでトークン検証 | E-39 (L16-21) | ○ |
| C-102 | expired_token?で期限チェック | E-39 (L24-33) | ○ |

### Services - RespondToTermsService (UT-USR-228 ~ UT-USR-230)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-103 | executeメソッドで利用規約同意処理 | E-40 (L11-19) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全てのテストケースはソースコードに基づいて生成されている

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースにソースコード根拠あり
- 注意点:
  - EE-onlyの機能（enum値）についてはCE環境でテストできない可能性あり
  - 一部サービスは`prepend_mod_with`でEEモジュールが追加される可能性があり、追加のテストケースが必要な場合あり

## 6) レビュアーチェックリスト（最小）
- [ ] 各モデルのバリデーションテストが網羅されているか確認
- [ ] リレーション（belongs_to, has_many等）のテストが含まれているか確認
- [ ] サービスクラスの正常系・異常系・境界値テストが含まれているか確認
- [ ] 権限チェック（can?, allowed?）のテストが含まれているか確認
- [ ] コールバック（before_save, after_*）のテストが含まれているか確認
- [ ] スコープのテストが含まれているか確認
- [ ] EE-only機能の取り扱いについて確認
