---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 79
  claims_with_evidence: 79
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：vs_code.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：79 / 79、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全てのテストケースにソースコードの根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/vs_code/settings/vs_code_setting.rb` - VsCodeSettingモデル定義
- E-02: `app/finders/vs_code/settings/settings_finder.rb` - SettingsFinder実装
- E-03: `app/services/vs_code/settings/create_or_update_service.rb` - CreateOrUpdateService実装
- E-04: `app/services/vs_code/settings/delete_service.rb` - DeleteService実装
- E-05: `app/presenters/vs_code/settings/vs_code_manifest_presenter.rb` - VsCodeManifestPresenter実装
- E-06: `app/presenters/vs_code/settings/vs_code_setting_presenter.rb` - VsCodeSettingPresenter実装
- E-07: `lib/vs_code/settings.rb` - 定数定義モジュール
- E-08: `lib/api/vs_code/settings/vs_code_settings_sync.rb` - API実装
- E-09: `lib/api/vs_code/settings/entities/vs_code_setting.rb` - VsCodeSettingエンティティ
- E-10: `lib/api/vs_code/settings/entities/vs_code_setting_reference.rb` - VsCodeSettingReferenceエンティティ
- E-11: `lib/api/vs_code/settings/entities/vs_code_manifest.rb` - VsCodeManifestエンティティ
- E-12: `spec/models/vs_code/settings/vs_code_setting_spec.rb` - 既存テスト参照
- E-13: `spec/services/vs_code/settings/create_or_update_service_spec.rb` - 既存テスト参照
- E-14: `spec/services/vs_code/settings/delete_service_spec.rb` - 既存テスト参照
- E-15: `spec/finders/vs_code/settings/settings_finder_spec.rb` - 既存テスト参照
- E-16: `spec/presenters/vs_code/settings/vs_code_setting_presenter_spec.rb` - 既存テスト参照
- E-17: `spec/presenters/vs_code/settings/vs_code_manifest_presenter_spec.rb` - 既存テスト参照

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | VsCodeSetting belongs_to :user | E-01 (line 8) | ○ |
| C-02 | setting_type validates presence | E-01 (line 15-17) | ○ |
| C-03 | setting_type validates inclusion | E-01 (line 16) | ○ |
| C-04 | setting_type nil validation | E-01 (line 15) | ○ |
| C-05 | content validates presence | E-01 (line 18) | ○ |
| C-06 | uuid validates presence | E-01 (line 18) | ○ |
| C-07 | version validates presence | E-01 (line 18) | ○ |
| C-08 | settings_context_hash length validation | E-01 (line 10-11) | ○ |
| C-09 | settings_context_hash 256文字境界値 | E-01 (line 11) | ○ |
| C-10 | uniqueness validation (複合キー) | E-01 (line 11-12, 17) | ○ |
| C-11 | extensions型でsettings_context_hash必須 | E-01 (line 42-52) | ○ |
| C-12 | extensions型でsettings_context_hash nil禁止 | E-01 (line 44-47) | ○ |
| C-13 | 非extensions型でsettings_context_hash nil許可 | E-01 (line 48-51) | ○ |
| C-14 | 非extensions型でsettings_context_hash値禁止 | E-01 (line 48-51) | ○ |
| C-15 | scope :by_setting_types (非extensions) | E-01 (line 34-36) | ○ |
| C-16 | scope :by_setting_types (extensions+hash) | E-01 (line 23-25) | ○ |
| C-17 | scope :by_setting_types (複合条件) | E-01 (line 26-32) | ○ |
| C-18 | scope :by_setting_types (空配列) | E-01 (line 20-37) | ○ |
| C-19 | scope :by_user | E-01 (line 38) | ○ |
| C-20 | SettingsFinder initialize | E-02 (line 6-10) | ○ |
| C-21 | SettingsFinder execute (nil setting_types) | E-02 (line 12-17) | ○ |
| C-22 | SettingsFinder execute (フィルタ) | E-02 (line 17) | ○ |
| C-23 | SettingsFinder execute (extensions+hash) | E-02 (line 17), E-15 | ○ |
| C-24 | SettingsFinder execute (空結果) | E-02, E-15 | ○ |
| C-25 | SettingsFinder 存在しないユーザー | E-02 (line 13) | ○ |
| C-26 | CreateOrUpdateService initialize | E-03 (line 8-12) | ○ |
| C-27 | CreateOrUpdateService machines型処理 | E-03 (line 17) | ○ |
| C-28 | CreateOrUpdateService 新規settings作成 | E-03 (line 43-46), E-13 | ○ |
| C-29 | CreateOrUpdateService settings更新 | E-03 (line 47-48), E-13 | ○ |
| C-30 | CreateOrUpdateService extensions新規作成 | E-03 (line 22-24), E-13 | ○ |
| C-31 | CreateOrUpdateService extensions更新 | E-03 (line 22-24), E-13 | ○ |
| C-32 | CreateOrUpdateService 異なるhash作成 | E-03, E-13 | ○ |
| C-33 | CreateOrUpdateService バリデーションエラー | E-03 (line 53-57), E-13 | ○ |
| C-34 | remove_duplicate_settings 重複削除 | E-03 (line 37-40), E-13 | ○ |
| C-35 | remove_duplicate_settings 重複なし | E-03 (line 38) | ○ |
| C-36 | トランザクション処理 | E-03 (line 29-32) | ○ |
| C-37 | DeleteService initialize | E-04 (line 6-8) | ○ |
| C-38 | DeleteService execute (全削除) | E-04 (line 10-13), E-14 | ○ |
| C-39 | DeleteService execute (他ユーザー影響なし) | E-04 (line 11), E-14 | ○ |
| C-40 | DeleteService execute (設定なし) | E-04, E-14 | ○ |
| C-41 | VsCodeManifestPresenter initialize | E-05 (line 8-10) | ○ |
| C-42 | VsCodeManifestPresenter latest (空設定) | E-05 (line 12-17), E-17 | ○ |
| C-43 | VsCodeManifestPresenter latest (設定あり) | E-05 (line 19-23), E-17 | ○ |
| C-44 | VsCodeManifestPresenter latest (複数設定) | E-05 (line 19-23) | ○ |
| C-45 | VsCodeManifestPresenter session | E-05 (line 26-28), E-17 | ○ |
| C-46 | VsCodeSettingPresenter initialize | E-06 (line 8-10) | ○ |
| C-47 | VsCodeSettingPresenter content (非machines) | E-06 (line 12-14), E-16 | ○ |
| C-48 | VsCodeSettingPresenter content (machines) | E-06 (line 13), E-16 | ○ |
| C-49 | VsCodeSettingPresenter machines (machines型) | E-06 (line 16-18), E-16 | ○ |
| C-50 | VsCodeSettingPresenter machines (非machines) | E-06 (line 17), E-16 | ○ |
| C-51 | VsCodeSettingPresenter version | E-06 (line 20-22), E-16 | ○ |
| C-52 | VsCodeSettingPresenter machine_id (非machines) | E-06 (line 24-26), E-16 | ○ |
| C-53 | VsCodeSettingPresenter machine_id (machines) | E-06 (line 25), E-16 | ○ |
| C-54 | VsCodeSetting Entity content | E-09 (line 8) | ○ |
| C-55 | VsCodeSetting Entity machines | E-09 (line 9) | ○ |
| C-56 | VsCodeSetting Entity version | E-09 (line 10) | ○ |
| C-57 | VsCodeSetting Entity machineId | E-09 (line 11) | ○ |
| C-58 | VsCodeSettingReference url (hashなし) | E-10 (line 21-22) | ○ |
| C-59 | VsCodeSettingReference url (hashあり) | E-10 (line 19-20) | ○ |
| C-60 | VsCodeSettingReference created | E-10 (line 27-29) | ○ |
| C-61 | VsCodeSettingReference created (nil) | E-10 (line 28) | ○ |
| C-62 | VsCodeManifest Entity latest | E-11 (line 8) | ○ |
| C-63 | VsCodeManifest Entity session | E-11 (line 9) | ○ |
| C-64 | find_settings (machines) | E-08 (line 14) | ○ |
| C-65 | find_settings (非machines) | E-08 (line 16-18) | ○ |
| C-66 | GET /v1/manifest 正常 | E-08 (line 40-47) | ○ |
| C-67 | GET /v1/manifest 未認証 | E-08 (line 22-23) | ○ |
| C-68 | GET /v1/resource/:name/:id 正常 | E-08 (line 65-82) | ○ |
| C-69 | GET /v1/resource/:name/:id 204 | E-08 (line 68-71) | ○ |
| C-70 | GET /v1/resource/:name/:id 無効name | E-08 (line 61-62) | ○ |
| C-71 | GET /v1/resource/:name 正常 | E-08 (line 97-101) | ○ |
| C-72 | POST /v1/resource/:name 正常 | E-08 (line 115-131) | ○ |
| C-73 | POST /v1/resource/:name エラー | E-08 (line 128-130) | ○ |
| C-74 | DELETE /v1/collection 正常 | E-08 (line 140-144) | ○ |
| C-75 | SETTINGS_TYPES定数 | E-07 (line 19) | ○ |
| C-76 | DEFAULT_MACHINE定数 | E-07 (line 5-17) | ○ |
| C-77 | EXTENSIONS定数 | E-07 (line 18) | ○ |
| C-78 | DEFAULT_SESSION定数 | E-07 (line 20) | ○ |
| C-79 | NO_CONTENT_ETAG定数 | E-07 (line 21) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全てのテストケースはソースコードに基づいて生成されています。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードから直接導出されています

### モジュール特性に関する補足
- VS Code Settings Syncはユーザー単位で設定を保存・同期する機能
- `extensions`タイプのみ`settings_context_hash`で区別される特殊な処理がある
- `machines`タイプはDEFAULT_MACHINEとして固定値を返す仕様
- APIは認証必須（before filterで`authenticate!`を呼び出し）

## 6) レビュアーチェックリスト（最小）
- [ ] VsCodeSettingモデルのバリデーションテストケース（UT-VSC-002〜014）が要件を網羅しているか確認
- [ ] extensions型の特殊処理（settings_context_hash）のテストケース（UT-VSC-011〜017, UT-VSC-023, UT-VSC-030〜032）が十分か確認
- [ ] CreateOrUpdateServiceのトランザクション処理と重複削除（UT-VSC-034〜036）のテストケースが適切か確認
- [ ] API認証テスト（UT-VSC-067）が全エンドポイントで必要か検討
- [ ] 既存specファイルとの整合性（テストID命名、観点の重複）を確認
