---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 60
  claims_with_evidence: 60
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: wiki_page単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：60 / 60、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースに根拠あり
  2. **UT-WKP-017〜018**：エラーハンドリングテストの実装優先度が高い
  3. **UT-WKP-041〜042**：権限チェックテストは手動確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/wiki_page/meta.rb` - WikiPage::Metaクラス定義
- E-02: `app/models/wiki_page/slug.rb` - WikiPage::Slugクラス定義
- E-03: `app/models/wiki_page.rb` - WikiPageクラス定義（親クラス参照用）
- E-04: `spec/models/wiki_page/meta_spec.rb` - Meta既存テスト仕様
- E-05: `spec/models/wiki_page/slug_spec.rb` - Slug既存テスト仕様

## 3) Claims と根拠の対応（レビューの主戦場）

### WikiPage::Meta リレーション関連（UT-WKP-001〜007）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | belongs_to :projectリレーションの検証 | E-01 L16, E-04 L10 | ○ |
| C-02 | belongs_to :namespaceリレーションの検証 | E-01 L17 | ○ |
| C-03 | has_many :slugsリレーションの検証 | E-01 L20, E-04 L11 | ○ |
| C-04 | has_many :eventsリレーションの検証 | E-01 L19, E-04 L12 | ○ |
| C-05 | has_many :notesリレーションの検証 | E-01 L21, E-04 L14 | ○ |
| C-06 | has_many :todosリレーションの検証 | E-01 L22, E-04 L13 | ○ |
| C-07 | has_many :user_mentionsリレーションの検証 | E-01 L23-24, E-04 L16-21 | ○ |

### WikiPage::Meta バリデーション関連（UT-WKP-008〜012）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-08 | titleの最大長バリデーション（255文字） | E-01 L26, E-04 L37 | ○ |
| C-09 | titleのnil禁止バリデーション | E-01 L26, E-04 L38 | ○ |
| C-10 | project_id/namespace_idの排他的必須バリデーション | E-01 L28-29, E-04 L49-53 | ○ |
| C-11 | canonical_slug重複禁止バリデーション | E-01 L27, L239-250, E-04 L40-47 | ○ |

### WikiPage::Meta スコープ関連（UT-WKP-013〜014）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | with_canonical_slugスコープの動作 | E-01 L33-37 | ○ |
| C-13 | for_projectスコープの動作 | E-01 L38-40 | ○ |

### WikiPage::Meta find_or_create関連（UT-WKP-015〜018）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-14 | 新規Metaレコード作成 | E-01 L55-75, E-04 L259-288 | ○ |
| C-15 | 既存Metaレコード更新 | E-01 L55-75, E-04 L312-336 | ○ |
| C-16 | 無効wiki_pageでのWikiPageInvalid例外 | E-01 L14, L56 | ○ |
| C-17 | 空スラッグでのRuntimeError | E-01 L60 | ○ |

### WikiPage::Meta find_by_canonical_slug関連（UT-WKP-019〜022）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | canonical_slugによる検索 | E-01 L77-102 | ○ |
| C-19 | 重複レコード削除処理 | E-01 L84-98 | ○ |
| C-20 | nil/空スラッグでのnil返却 | E-01 L78 | ○ |
| C-21 | nilコンテナでのnil返却 | E-01 L78 | ○ |

### WikiPage::Meta アクセサ・ミューテータ関連（UT-WKP-023〜046）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | wiki_pageメソッドの動作 | E-01 L127-129, E-04 L211-220 | ○ |
| C-23 | containerアクセサ | E-01 L131-133 | ○ |
| C-24 | container=ミューテータ | E-01 L135-138 | ○ |
| C-25 | resource_parentメソッド | E-01 L140-142, E-04 L56-62 | ○ |
| C-26 | for_group_wiki?メソッド | E-01 L144-146 | ○ |
| C-27 | container_keyメソッド | E-01 L148-150 | ○ |
| C-28 | canonical_slugアクセサ | E-01 L152-155, E-04 L94-139 | ○ |
| C-29 | canonical_slug=ミューテータ | E-01 L157-171, E-04 L141-208 | ○ |
| C-30 | update_stateメソッド | E-01 L173-177 | ○ |
| C-31 | gfm_referenceメソッド | E-01 L179-181, E-04 L72-79 | ○ |
| C-32 | reference_link_textメソッド | E-01 L183-185 | ○ |
| C-33 | readable_by?メソッド | E-01 L188-190 | ○ |
| C-34 | to_ability_nameメソッド | E-01 L192-194 | ○ |
| C-35 | notes_with_associationsメソッド | E-01 L196-198 | ○ |
| C-36 | subscribed_without_subscriptions?メソッド | E-01 L200-202 | ○ |
| C-37 | declarative_policy_classメソッド | E-01 L104-106 | ○ |
| C-38 | to_referenceメソッド | E-01 L43, E-04 L64-69 | ○ |
| C-39 | participantsメソッド | E-04 L81-92 | ○ |

### WikiPage::Slug リレーション関連（UT-WKP-047）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | belongs_to :wiki_page_metaリレーション | E-02 L7, E-05 L8-16 | ○ |

### WikiPage::Slug バリデーション関連（UT-WKP-048〜054）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | slug一意性バリデーション（meta_idスコープ） | E-02 L9, E-05 L51 | ○ |
| C-42 | slug長さバリデーション（2048文字） | E-02 L10, E-05 L52 | ○ |
| C-43 | slugのnil禁止 | E-02 L10, E-05 L53 | ○ |
| C-44 | canonical一意性バリデーション | E-02 L11-15, E-05 L55-93 | ○ |

### WikiPage::Slug スコープ関連（UT-WKP-055〜056）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | canonicalスコープの動作 | E-02 L17, E-05 L18-41 | ○ |

### WikiPage::Slug メソッドオーバーライド関連（UT-WKP-057〜060）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | update_allのupdated_at自動設定 | E-02 L19-21 | ○ |
| C-47 | update_columnsのupdated_at自動設定 | E-02 L23-25 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全てのテストケースがソースコードまたは既存テストスペックに基づいて生成されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースにソースコード根拠あり
- 注意点:
  - WikiPage::Metaのfind_or_createはトランザクション処理を含むため、並行実行時の挙動確認推奨
  - readable_by?メソッドはAbilityクラスに依存するため、統合テストでの確認も推奨
  - canonical_slug=のトランザクション処理はデッドロックリスクの確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] WikiPage::Metaのリレーション定義（L16-24）がテストケースと一致しているか
- [ ] バリデーション（L26-29）の条件がテストケースで網羅されているか
- [ ] find_or_createのトランザクション処理（L62-74）の正常系・異常系が網羅されているか
- [ ] WikiPage::Slugのバリデーション（L9-15）がテストケースで網羅されているか
- [ ] update_all/update_columnsのオーバーライド（L19-25）の挙動がテストケースで確認されているか
- [ ] 既存テストスペック（E-04, E-05）との整合性が取れているか
