---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 49
  claims_with_evidence: 49
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：wikis.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：49 / 49、根拠なし：0
- 優先レビュー（高）
  1. 全てのテストケースにソースコードからの根拠が存在
  2. 既存のテストファイルを参照し、テスト観点を網羅
  3. 高優先度のテストケースは全て権限・認可・データ整合性に関連

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/wikis/user_mention.rb` - Wikis::UserMentionモデル定義
- E-02: `app/services/wikis/create_attachment_service.rb` - Wiki添付ファイル作成サービス
- E-03: `app/workers/wikis/git_garbage_collect_worker.rb` - WikiリポジトリGCワーカー
- E-04: `app/graphql/mutations/wikis/wiki_page_subscribe.rb` - WikiPage購読ミューテーション
- E-05: `app/graphql/resolvers/wikis/wiki_page_resolver.rb` - WikiPageリゾルバ
- E-06: `app/graphql/types/wikis/wiki_page_type.rb` - WikiPageGraphQL型定義
- E-07: `app/graphql/types/permission_types/wikis/wiki_page.rb` - WikiPage権限型定義
- E-08: `spec/models/wikis/user_mention_spec.rb` - UserMentionモデルテスト
- E-09: `spec/services/wikis/create_attachment_service_spec.rb` - CreateAttachmentServiceテスト
- E-10: `spec/workers/wikis/git_garbage_collect_worker_spec.rb` - GitGarbageCollectWorkerテスト
- E-11: `spec/graphql/resolvers/wikis/wiki_page_resolver_spec.rb` - WikiPageResolverテスト
- E-12: `spec/graphql/types/wikis/wiki_page_type_spec.rb` - WikiPageTypeテスト

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UserMention#belongs_to :wiki_page_meta - 正常系 | E-01, E-08 | ○ |
| C-02 | UserMention#belongs_to :wiki_page_meta - 異常系 | E-01 | ○ |
| C-03 | UserMention#belongs_to :note - 正常系 | E-01, E-08 | ○ |
| C-04 | UserMention#belongs_to :note - 異常系 | E-01 | ○ |
| C-05 | UserMention#table_name設定 | E-01 | ○ |
| C-06 | CreateAttachmentService#initialize - nilユーザー | E-02, E-09 | ○ |
| C-07 | CreateAttachmentService#initialize - author情報デフォルト | E-02, E-09 | ○ |
| C-08 | CreateAttachmentService#initialize - author情報カスタム | E-02, E-09 | ○ |
| C-09 | CreateAttachmentService#initialize - commit_messageデフォルト | E-02, E-09 | ○ |
| C-10 | CreateAttachmentService#initialize - commit_messageカスタム | E-02, E-09 | ○ |
| C-11 | CreateAttachmentService#initialize - branch_nameデフォルト | E-02, E-09 | ○ |
| C-12 | CreateAttachmentService#initialize - branch_nameカスタム | E-02, E-09 | ○ |
| C-13 | CreateAttachmentService#clean_file_name - 空白置換 | E-02, E-09 | ○ |
| C-14 | CreateAttachmentService#clean_file_name - 無効文字置換 | E-02, E-09 | ○ |
| C-15 | CreateAttachmentService#clean_file_name - nil処理 | E-02 | ○ |
| C-16 | CreateAttachmentService#clean_file_name - 空文字処理 | E-02 | ○ |
| C-17 | CreateAttachmentService#truncate_file_name - 255文字以下 | E-02, E-09 | ○ |
| C-18 | CreateAttachmentService#truncate_file_name - 256文字以上 | E-02, E-09 | ○ |
| C-19 | CreateAttachmentService#truncate_file_name - 拡張子保持 | E-02, E-09 | ○ |
| C-20 | CreateAttachmentService#validate_file_name! - エラー | E-02, E-09 | ○ |
| C-21 | CreateAttachmentService#validate_permissions! - 権限なし | E-02, E-09 | ○ |
| C-22 | CreateAttachmentService#validate_permissions! - nilユーザー | E-02, E-09 | ○ |
| C-23 | CreateAttachmentService#create_commit! - 正常系 | E-02 | ○ |
| C-24 | CreateAttachmentService#create_commit! - エラー | E-02 | ○ |
| C-25 | CreateAttachmentService#commit_result | E-02 | ○ |
| C-26 | GitGarbageCollectWorker#find_resource - 正常系 | E-03, E-10 | ○ |
| C-27 | GitGarbageCollectWorker#find_resource - 異常系 | E-03 | ○ |
| C-28 | GitGarbageCollectWorker#update_db_repository_statistics | E-03, E-10 | ○ |
| C-29 | GitGarbageCollectWorker#stats | E-03, E-10 | ○ |
| C-30 | WikiPageSubscribe#resolve - 正常系 | E-04 | ○ |
| C-31 | WikiPageSubscribe#resolve - 権限エラー | E-04 | ○ |
| C-32 | WikiPageSubscribe#resolve - 無効ID | E-04 | ○ |
| C-33 | WikiPageSubscribe#update_subscription | E-04 | ○ |
| C-34 | WikiPageResolver#resolve - project_id指定 | E-05, E-11 | ○ |
| C-35 | WikiPageResolver#resolve - namespace_id指定 | E-05 | ○ |
| C-36 | WikiPageResolver#resolve - 両方指定エラー | E-05, E-11 | ○ |
| C-37 | WikiPageResolver#resolve - 存在しないslug | E-05, E-11 | ○ |
| C-38 | WikiPageResolver#resolve - 空slug | E-05 | ○ |
| C-39 | WikiPageResolver#resolve - Meta自動作成 | E-05, E-11 | ○ |
| C-40 | WikiPageResolver#extract_project_id | E-05 | ○ |
| C-41 | WikiPageResolver#extract_namespace_id | E-05 | ○ |
| C-42 | WikiPageType#subscribed - 購読中 | E-06, E-12 | ○ |
| C-43 | WikiPageType#subscribed - 未購読 | E-06 | ○ |
| C-44 | WikiPageType#web_url | E-06 | ○ |
| C-45 | WikiPageType#authorize - 成功 | E-06, E-12 | ○ |
| C-46 | WikiPageType#authorize - 失敗 | E-06, E-12 | ○ |
| C-47 | WikiPagePermissions#read_wiki_page | E-07 | ○ |
| C-48 | WikiPagePermissions#create_note | E-07 | ○ |
| C-49 | WikiPagePermissions#mark_note_as_internal | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全てのテストケースがソースコードから直接抽出されている

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースにソースコードからの明確な根拠が存在
- 既存テストファイルとの整合性も確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Wikis::UserMentionのリレーションテストケースが妥当か確認
- [ ] CreateAttachmentServiceのファイル名バリデーションロジックが網羅されているか確認
- [ ] GraphQL関連のauthorize/permissionテストが適切か確認
- [ ] GitGarbageCollectWorkerの統計更新ロジックのテストが十分か確認
- [ ] 既存のspec/ファイルとテストケース内容の整合性を確認
