---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 181
  claims_with_evidence: 181
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：work_items単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：181 / 181、根拠なし：0
- 優先レビュー（高）
  1. **WorkItems::ParentLink検証系テスト（C-22〜C-31）**：階層制限・循環参照・機密性の複合バリデーションロジック
  2. **WorkItems::Type.default_by_type（C-01〜C-03）**：例外処理とDB状態依存のテスト
  3. **WorkItems::SavedViews::UserSavedView購読系（C-106〜C-111）**：トランザクション処理と制限ロジック

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/work_items/type.rb`
- E-02: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/work_items/parent_link.rb`
- E-03: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/work_items/related_work_item_link.rb`
- E-04: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/work_items/widget_definition.rb`
- E-05: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/work_items/dates_source.rb`
- E-06: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/work_items/user_preference.rb`
- E-07: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/work_items/transition.rb`
- E-08: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/work_items/description.rb`
- E-09: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/work_items/resource_link_event.rb`
- E-10: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/work_items/rollupable_dates.rb`
- E-11: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/work_items/sorting_keys.rb`
- E-12: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/work_items/types_filter.rb`
- E-13: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/work_items/saved_views/saved_view.rb`
- E-14: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/work_items/saved_views/user_saved_view.rb`
- E-15: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/work_items/types_framework/system_defined/hierarchy_restriction.rb`
- E-16: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/work_items/types_framework/system_defined/widget_definition.rb`
- E-17: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/work_items/types_framework/system_defined/type.rb`
- E-18: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/work_items/types_framework/system_defined/related_link_restriction.rb`
- E-19: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/work_items/widgets/base.rb`
- E-20: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/work_items/widgets/hierarchy.rb`
- E-21: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/work_items/widgets/assignees.rb`
- E-22: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/work_items/widgets/labels.rb`
- E-23: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/work_items/widgets/milestone.rb`
- E-24: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/work_items/widgets/start_and_due_date.rb`
- E-25: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/work_items/widgets/notes.rb`
- E-26: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/work_items/widgets/description.rb`
- E-27: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/work_items/widgets/linked_items.rb`
- E-28: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/work_items/widgets/time_tracking.rb`
- E-29: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/work_items/widgets/notifications.rb`
- E-30: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/work_items/widgets/award_emoji.rb`
- E-31: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/work_items/widgets/participants.rb`
- E-32: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/work_items/widgets/current_user_todos.rb`
- E-33: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/work_items/widgets/crm_contacts.rb`
- E-34: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/work_items/widgets/designs.rb`
- E-35: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/work_items/widgets/development.rb`
- E-36: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/work_items/widgets/email_participants.rb`
- E-37: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/work_items/widgets/error_tracking.rb`
- E-38: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/work_items/widgets/linked_resources.rb`
- E-39: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/work_items/types_framework/system_defined/definitions/issue.rb`
- E-40: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/work_items/types_framework/system_defined/definitions/incident.rb`
- E-41: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/work_items/types_framework/system_defined/definitions/task.rb`
- E-42: `/Users/tomoka.baba/Work/gitlabhq-master/app/models/work_items/types_framework/system_defined/definitions/ticket.rb`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WorkItems::Type.default_by_type正常系テスト | E-01 (L79-93) | ○ |
| C-02 | WorkItems::Type.default_by_type異常系（不正タイプ） | E-01 (L81) | ○ |
| C-03 | WorkItems::Type.default_by_type異常系（未シード例外） | E-01 (L83-92) | ○ |
| C-04 | WorkItems::Type.default_issue_typeテスト | E-01 (L95-97) | ○ |
| C-05 | WorkItems::Type.widgetsテスト | E-01 (L100-102) | ○ |
| C-06 | WorkItems::Type.widget_classesテスト | E-01 (L104-106) | ○ |
| C-07 | WorkItems::Type.supports_assignee?テスト | E-01 (L108-110) | ○ |
| C-08 | WorkItems::Type.supports_assignee?（非サポート）テスト | E-01 (L108-110) | ○ |
| C-09 | WorkItems::Type.supports_time_tracking?テスト | E-01 (L112-114) | ○ |
| C-10 | WorkItems::Type.allowed_child_types_by_nameテスト | E-01 (L116-122) | ○ |
| C-11 | WorkItems::Type.allowed_parent_types_by_nameテスト | E-01 (L124-129) | ○ |
| C-12 | WorkItems::Type.supported_conversion_typesテスト | E-01 (L131-134) | ○ |
| C-13 | WorkItems::Type.unavailable_widgets_on_conversionテスト | E-01 (L136-141) | ○ |
| C-14 | WorkItems::Type.descendant_typesテスト | E-01 (L159-173) | ○ |
| C-15 | WorkItems::Type.descendant_types循環参照対策テスト | E-01 (L167) | ○ |
| C-16 | WorkItems::Type.strip_whitespaceテスト | E-01 (L243-245) | ○ |
| C-17 | WorkItems::Type name必須バリデーション | E-01 (L70) | ○ |
| C-18 | WorkItems::Type name長さバリデーション | E-01 (L72) | ○ |
| C-19 | WorkItems::Type name一意性バリデーション | E-01 (L71) | ○ |
| C-20 | WorkItems::ParentLink.work_itemリレーション | E-02 (L12) | ○ |
| C-21 | WorkItems::ParentLink.work_item_parentリレーション | E-02 (L13) | ○ |
| C-22 | WorkItems::ParentLink階層制限バリデーション（正常） | E-02 (L74-88) | ○ |
| C-23 | WorkItems::ParentLink階層制限バリデーション（異常） | E-02 (L82-84) | ○ |
| C-24 | WorkItems::ParentLink自己参照バリデーション | E-02 (L102-104) | ○ |
| C-25 | WorkItems::ParentLink循環参照バリデーション | E-02 (L106-108) | ○ |
| C-26 | WorkItems::ParentLink最大子数バリデーション | E-02 (L53-59) | ○ |
| C-27 | WorkItems::ParentLink最大子数境界値（5000） | E-02 (L10, L57) | ○ |
| C-28 | WorkItems::ParentLink最大子数境界値（4999） | E-02 (L10, L56) | ○ |
| C-29 | WorkItems::ParentLink機密性バリデーション（異常） | E-02 (L62-72) | ○ |
| C-30 | WorkItems::ParentLink機密性バリデーション（正常） | E-02 (L62-72) | ○ |
| C-31 | WorkItems::ParentLinkリンク重複防止バリデーション | E-02 (L111-118) | ○ |
| C-32 | WorkItems::ParentLink.has_public_children?（存在） | E-02 (L27-29) | ○ |
| C-33 | WorkItems::ParentLink.has_public_children?（不存在） | E-02 (L27-29) | ○ |
| C-34 | WorkItems::ParentLink.has_confidential_parent?テスト | E-02 (L31-36) | ○ |
| C-35 | WorkItems::ParentLink.for_work_item（存在） | E-02 (L46-48) | ○ |
| C-36 | WorkItems::ParentLink.for_work_item（不存在） | E-02 (L46-48) | ○ |
| C-37 | WorkItems::RelatedWorkItemLink.sourceリレーション | E-03 (L13) | ○ |
| C-38 | WorkItems::RelatedWorkItemLink.targetリレーション | E-03 (L14) | ○ |
| C-39 | WorkItems::RelatedWorkItemLinkリンク制限バリデーション（正常） | E-03 (L35-48) | ○ |
| C-40 | WorkItems::RelatedWorkItemLinkリンク制限バリデーション（異常） | E-03 (L35-48) | ○ |
| C-41 | WorkItems::RelatedWorkItemLink.issuable_typeテスト | E-03 (L23-25) | ○ |
| C-42 | WorkItems::RelatedWorkItemLink.issuable_nameテスト | E-03 (L27-29) | ○ |
| C-43 | WorkItems::WidgetDefinition.work_item_typeリレーション | E-04 (L7) | ○ |
| C-44 | WorkItems::WidgetDefinition name必須バリデーション | E-04 (L9) | ○ |
| C-45 | WorkItems::WidgetDefinition name一意性バリデーション | E-04 (L10) | ○ |
| C-46 | WorkItems::WidgetDefinition widget_optionsスキーマバリデーション | E-04 (L13-14) | ○ |
| C-47 | WorkItems::WidgetDefinition widget_options制限バリデーション | E-04 (L15) | ○ |
| C-48 | WorkItems::WidgetDefinition.available_widgetsテスト | E-04 (L59-61) | ○ |
| C-49 | WorkItems::WidgetDefinition.widget_classesテスト | E-04 (L63-69) | ○ |
| C-50 | WorkItems::WidgetDefinition.widget_classテスト（正常） | E-04 (L71-77) | ○ |
| C-51 | WorkItems::WidgetDefinition.widget_classテスト（異常） | E-04 (L71-77) | ○ |
| C-52 | WorkItems::WidgetDefinition.build_widgetテスト | E-04 (L79-81) | ○ |
| C-53 | WorkItems::DatesSource.work_itemリレーション | E-05 (L15) | ○ |
| C-54 | WorkItems::DatesSource.namespaceリレーション | E-05 (L14) | ○ |
| C-55 | WorkItems::DatesSource.set_namespaceテスト | E-05 (L52-57) | ○ |
| C-56 | WorkItems::DatesSource日付上限バリデーション | E-05 (L8, L29-38) | ○ |
| C-57 | WorkItems::DatesSource日付下限バリデーション | E-05 (L9, L29-38) | ○ |
| C-58 | WorkItems::DatesSource.set_fixed_start_dateテスト | E-05 (L59-61) | ○ |
| C-59 | WorkItems::DatesSource.set_fixed_due_dateテスト | E-05 (L63-65) | ○ |
| C-60 | WorkItems::UserPreference.userリレーション | E-06 (L7) | ○ |
| C-61 | WorkItems::UserPreference.work_item_typeリレーション | E-06 (L9-12) | ○ |
| C-62 | WorkItems::UserPreference.create_or_update（新規） | E-06 (L17-22) | ○ |
| C-63 | WorkItems::UserPreference.create_or_update（更新） | E-06 (L17-22) | ○ |
| C-64 | WorkItems::UserPreference sortバリデーション（正常） | E-06 (L34-55) | ○ |
| C-65 | WorkItems::UserPreference sortバリデーション（異常） | E-06 (L34-55) | ○ |
| C-66 | WorkItems::UserPreference.find_by_user_namespace_and_work_item_type_idテスト | E-06 (L24-30) | ○ |
| C-67 | WorkItems::Transition.work_itemリレーション | E-07 (L8) | ○ |
| C-68 | WorkItems::Transition.duplicated_toリレーション | E-07 (L10) | ○ |
| C-69 | WorkItems::Transition.moved_toリレーション | E-07 (L11) | ○ |
| C-70 | WorkItems::Transition.set_namespaceテスト | E-07 (L17-22) | ○ |
| C-71 | WorkItems::Transition namespace必須バリデーション | E-07 (L13) | ○ |
| C-72 | WorkItems::Description.work_itemリレーション | E-08 (L16) | ○ |
| C-73 | WorkItems::Description description長さバリデーション | E-08 (L10, L23) | ○ |
| C-74 | WorkItems::Description既存データ保護テスト | E-08 (L38-46) | ○ |
| C-75 | WorkItems::Description.set_namespaceテスト | E-08 (L27-32) | ○ |
| C-76 | WorkItems::ResourceLinkEvent.child_work_itemリレーション | E-09 (L5) | ○ |
| C-77 | WorkItems::ResourceLinkEvent child必須バリデーション | E-09 (L7) | ○ |
| C-78 | WorkItems::ResourceLinkEvent action enumテスト（add） | E-09 (L9-12) | ○ |
| C-79 | WorkItems::ResourceLinkEvent action enumテスト（remove） | E-09 (L9-12) | ○ |
| C-80 | WorkItems::ResourceLinkEvent.synthetic_note_classテスト | E-09 (L14-16) | ○ |
| C-81 | WorkItems::RollupableDates.fixed?テスト（can_rollup=false） | E-10 (L13) | ○ |
| C-82 | WorkItems::RollupableDates.fixed?テスト（固定日付） | E-10 (L14-16) | ○ |
| C-83 | WorkItems::RollupableDates.fixed?テスト（非固定） | E-10 (L17-18) | ○ |
| C-84 | WorkItems::RollupableDates.start_dateテスト（固定） | E-10 (L22-25) | ○ |
| C-85 | WorkItems::RollupableDates.start_dateテスト（非固定） | E-10 (L22-25) | ○ |
| C-86 | WorkItems::RollupableDates.due_dateテスト | E-10 (L31-35) | ○ |
| C-87 | WorkItems::SortingKeys.allテスト | E-11 (L73-75) | ○ |
| C-88 | WorkItems::SortingKeys.widgets_sorting_keysテスト | E-11 (L77-81) | ○ |
| C-89 | WorkItems::SortingKeys.available?テスト（デフォルト） | E-11 (L84-90) | ○ |
| C-90 | WorkItems::SortingKeys.available?テスト（ウィジェット） | E-11 (L84-90) | ○ |
| C-91 | WorkItems::SortingKeys.available?テスト（無効） | E-11 (L84-90) | ○ |
| C-92 | WorkItems::TypesFilter.allowed_typesテスト（Project） | E-12 (L33-42) | ○ |
| C-93 | WorkItems::TypesFilter.allowed_typesテスト（Group） | E-12 (L57-61) | ○ |
| C-94 | WorkItems::TypesFilter.allowed_typesテスト（nil） | E-12 (L34) | ○ |
| C-95 | WorkItems::TypesFilter.allowed_types_for_issuesテスト | E-12 (L13-15) | ○ |
| C-96 | WorkItems::TypesFilter.filter_disabled_workflowsテスト | E-12 (L65-67) | ○ |
| C-97 | WorkItems::TypesFilter.filter_service_deskテスト | E-12 (L69-73) | ○ |
| C-98 | WorkItems::SavedViews::SavedView.namespaceリレーション | E-13 (L8) | ○ |
| C-99 | WorkItems::SavedViews::SavedView.authorリレーション | E-13 (L9-10) | ○ |
| C-100 | WorkItems::SavedViews::SavedView.user_saved_viewsリレーション | E-13 (L12) | ○ |
| C-101 | WorkItems::SavedViews::SavedView name必須バリデーション | E-13 (L15) | ○ |
| C-102 | WorkItems::SavedViews::SavedView name長さバリデーション | E-13 (L15) | ○ |
| C-103 | WorkItems::SavedViews::SavedView versionバリデーション | E-13 (L17) | ○ |
| C-104 | WorkItems::SavedViews::SavedView filter_dataスキーマバリデーション | E-13 (L20) | ○ |
| C-105 | WorkItems::SavedViews::UserSavedView.saved_viewリレーション | E-14 (L10) | ○ |
| C-106 | WorkItems::SavedViews::UserSavedView.subscribeテスト（正常） | E-14 (L22-36) | ○ |
| C-107 | WorkItems::SavedViews::UserSavedView.subscribeテスト（制限） | E-14 (L26-28) | ○ |
| C-108 | WorkItems::SavedViews::UserSavedView.subscribeテスト（自動解除） | E-14 (L29-31) | ○ |
| C-109 | WorkItems::SavedViews::UserSavedView.unsubscribeテスト | E-14 (L39-43) | ○ |
| C-110 | WorkItems::SavedViews::UserSavedView.at_subscription_limit?テスト（達成） | E-14 (L53-55) | ○ |
| C-111 | WorkItems::SavedViews::UserSavedView.at_subscription_limit?テスト（未達） | E-14 (L53-55) | ○ |
| C-112 | WorkItems::SavedViews::UserSavedView.user_saved_view_limitテスト | E-14 (L66-68) | ○ |
| C-113 | WorkItems::SavedViews::UserSavedView.set_initial_positionテスト | E-14 (L73-75) | ○ |
| C-114 | HierarchyRestriction.with_parent_type_idテスト | E-15 (L22-24) | ○ |
| C-115 | HierarchyRestriction.hierarchy_relationship_allowed?テスト（許可） | E-15 (L26-28) | ○ |
| C-116 | HierarchyRestriction.hierarchy_relationship_allowed?テスト（拒否） | E-15 (L26-28) | ○ |
| C-117 | SystemDefined::WidgetDefinition.widget_classテスト（正常） | E-16 (L71-77) | ○ |
| C-118 | SystemDefined::WidgetDefinition.widget_classテスト（異常） | E-16 (L71-77) | ○ |
| C-119 | SystemDefined::WidgetDefinition.build_widgetテスト | E-16 (L79-81) | ○ |
| C-120 | SystemDefined::WidgetDefinition.licensed?テスト | E-16 (L84-86) | ○ |
| C-121 | SystemDefined::Type.find_by_typeテスト | E-17 (L30-32) | ○ |
| C-122 | SystemDefined::Type.default_issue_typeテスト | E-17 (L36-38) | ○ |
| C-123 | SystemDefined::Type.widget_definitionsテスト | E-17 (L65-68) | ○ |
| C-124 | SystemDefined::Type.supports_widget?テスト | E-17 (L86-88) | ○ |
| C-125 | SystemDefined::Type.configuration_classテスト | E-17 (L156-158) | ○ |
| C-126 | SystemDefined::Type.to_global_idテスト | E-17 (L60-63) | ○ |
| C-127 | RelatedLinkRestriction.ITEMS定数テスト | E-18 (L21-174) | ○ |
| C-128 | WorkItems::Widgets::Base.typeテスト | E-19 (L8-10) | ○ |
| C-129 | WorkItems::Widgets::Base.api_symbolテスト | E-19 (L12-14) | ○ |
| C-130 | WorkItems::Widgets::Base.callback_classテスト（存在） | E-19 (L24-32) | ○ |
| C-131 | WorkItems::Widgets::Base.callback_classテスト（不存在） | E-19 (L24-32) | ○ |
| C-132 | WorkItems::Widgets::Hierarchy.parentテスト | E-20 (L8-10) | ○ |
| C-133 | WorkItems::Widgets::Hierarchy.parentテスト（不在） | E-20 (L8-10) | ○ |
| C-134 | WorkItems::Widgets::Hierarchy.childrenテスト | E-20 (L12-17) | ○ |
| C-135 | WorkItems::Widgets::Hierarchy.childrenテスト（状態フィルタ） | E-20 (L14) | ○ |
| C-136 | WorkItems::Widgets::Hierarchy.has_parent?テスト | E-20 (L23-25) | ○ |
| C-137 | WorkItems::Widgets::Hierarchy.rolled_up_counts_by_typeテスト | E-20 (L27-31) | ○ |
| C-138 | WorkItems::Widgets::Hierarchy.depth_limit_reached_by_typeテスト | E-20 (L33-37) | ○ |
| C-139 | WorkItems::Widgets::Hierarchy.process_quick_action_paramテスト（set_parent） | E-20 (L47-57) | ○ |
| C-140 | WorkItems::Widgets::Hierarchy.process_quick_action_paramテスト（add_child） | E-20 (L47-57) | ○ |
| C-141 | WorkItems::Widgets::Assignees.assigneesテスト | E-21 (L6) | ○ |
| C-142 | WorkItems::Widgets::Assignees.allows_multiple_assignees?テスト | E-21 (L6) | ○ |
| C-143 | WorkItems::Widgets::Assignees.can_invite_members?テスト | E-21 (L16-18) | ○ |
| C-144 | WorkItems::Widgets::Labels.labelsテスト | E-22 (L6) | ○ |
| C-145 | WorkItems::Widgets::Labels.allows_scoped_labels?テスト | E-22 (L7) | ○ |
| C-146 | WorkItems::Widgets::Labels.sorting_keysテスト | E-22 (L18-27) | ○ |
| C-147 | WorkItems::Widgets::Milestone.milestoneテスト | E-23 (L6) | ○ |
| C-148 | WorkItems::Widgets::Milestone.sorting_keysテスト | E-23 (L17-26) | ○ |
| C-149 | WorkItems::Widgets::StartAndDueDate.start_dateテスト | E-24 (L58-62) | ○ |
| C-150 | WorkItems::Widgets::StartAndDueDate.due_dateテスト | E-24 (L64-68) | ○ |
| C-151 | WorkItems::Widgets::StartAndDueDate.fixed?テスト | E-24 (L48-50) | ○ |
| C-152 | WorkItems::Widgets::StartAndDueDate.process_quick_action_paramテスト | E-24 (L39-44) | ○ |
| C-153 | WorkItems::Widgets::Notes.notesテスト | E-25 (L6) | ○ |
| C-154 | WorkItems::Widgets::Notes.discussion_lockedテスト | E-25 (L7) | ○ |
| C-155 | WorkItems::Widgets::Description.descriptionテスト | E-26 (L6) | ○ |
| C-156 | WorkItems::Widgets::Description.edited?テスト | E-26 (L6) | ○ |
| C-157 | WorkItems::Widgets::Description.last_edited_byテスト（編集済み） | E-26 (L8-12) | ○ |
| C-158 | WorkItems::Widgets::Description.last_edited_byテスト（未編集） | E-26 (L9) | ○ |
| C-159 | WorkItems::Widgets::LinkedItems.linked_work_itemsテスト | E-27 (L6) | ○ |
| C-160 | WorkItems::Widgets::TimeTracking.time_estimateテスト | E-28 (L6-7) | ○ |
| C-161 | WorkItems::Widgets::TimeTracking.total_time_spentテスト | E-28 (L6-7) | ○ |
| C-162 | WorkItems::Widgets::TimeTracking.timelogsテスト | E-28 (L6-7) | ○ |
| C-163 | WorkItems::Widgets::Notifications.subscribed?テスト | E-29 (L6) | ○ |
| C-164 | WorkItems::Widgets::AwardEmoji.award_emojiテスト | E-30 (L6) | ○ |
| C-165 | WorkItems::Widgets::AwardEmoji.upvotesテスト | E-30 (L6) | ○ |
| C-166 | WorkItems::Widgets::AwardEmoji.downvotesテスト | E-30 (L6) | ○ |
| C-167 | WorkItems::Widgets::AwardEmoji.new_custom_emoji_pathテスト（権限あり） | E-30 (L8-16) | ○ |
| C-168 | WorkItems::Widgets::AwardEmoji.new_custom_emoji_pathテスト（権限なし） | E-30 (L13) | ○ |
| C-169 | WorkItems::Widgets::Participants.participantsテスト | E-31 (L6) | ○ |
| C-170 | WorkItems::Widgets::CurrentUserTodos.process_quick_action_paramテスト（add） | E-32 (L14-17) | ○ |
| C-171 | WorkItems::Widgets::CurrentUserTodos.process_quick_action_paramテスト（done） | E-32 (L14-17) | ○ |
| C-172 | WorkItems::Widgets::CrmContacts.customer_relations_contactsテスト | E-33 (L6) | ○ |
| C-173 | WorkItems::Widgets::Designs.designsテスト | E-34 (L6) | ○ |
| C-174 | WorkItems::Widgets::Designs.design_versionsテスト | E-34 (L6) | ○ |
| C-175 | WorkItems::Widgets::Development.closing_merge_requestsテスト | E-35 (L14-16) | ○ |
| C-176 | WorkItems::Widgets::Development.will_auto_close_by_merge_requestテスト（true） | E-35 (L18-22) | ○ |
| C-177 | WorkItems::Widgets::Development.will_auto_close_by_merge_requestテスト（false） | E-35 (L19) | ○ |
| C-178 | WorkItems::Widgets::EmailParticipants.email_participantsテスト | E-36 (L6, L8) | ○ |
| C-179 | WorkItems::Widgets::ErrorTracking.sentry_issue_identifierテスト（存在） | E-37 (L6-8) | ○ |
| C-180 | WorkItems::Widgets::ErrorTracking.sentry_issue_identifierテスト（不存在） | E-37 (L8) | ○ |
| C-181 | WorkItems::Widgets::LinkedResources.zoom_meetingsテスト | E-38 (L6-8) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全テストケースについてソースコードから根拠を確認できました
- EE専用機能（health_status, weight, iteration, progress等）のウィジェットは本テストケース一覧には含まれていません（CE対象）
- 候補：EE拡張モジュール / 統合テスト仕様 / パフォーマンステスト要件

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - ウィジェットのdelegateメソッドのテスト（C-141〜C-181の大部分）
  - 単純な委譲であり、テスト設計が明確
- **1: 中リスク** - バリデーションと状態管理のテスト（C-17〜C-19, C-44〜C-47等）
  - エッジケースの網羅性を確認すべき
- **2: 高リスク** - 階層制限・循環参照・トランザクション処理のテスト（C-22〜C-31, C-106〜C-108）
  - 複雑なビジネスロジックであり、テストの正確性と網羅性を重点的にレビュー

## 6) レビュアーチェックリスト（最小）
- [ ] ParentLinkのバリデーション系テスト（C-22〜C-31）が実際の制限ルールと一致しているか確認
- [ ] MAX_CHILDREN=5000の境界値テスト（C-26〜C-28）が正しく設計されているか確認
- [ ] SavedViews購読機能のトランザクション処理テスト（C-106〜C-108）がデッドロック等を考慮しているか確認
- [ ] EE専用ウィジェット（health_status, weight等）が意図的に除外されていることを確認
- [ ] 日付バリデーション（C-56〜C-59）のMIN/MAX範囲がElasticSearch制限と整合しているか確認
