---
generated_at: 2026-01-22 15:30:00
metrics:
  claims_total: 70
  claims_with_evidence: 70
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：受入テストケース一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：70 / 70、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全てのテストケースに対応するフィーチャースペックが存在
  2. **テスト手順の詳細化**：実際のテスト実行時により詳細なステップが必要な可能性あり
  3. **環境依存テスト**：外部サービス連携テスト（OAuth、Slack、Jira等）は環境設定が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `spec/features/users/login_spec.rb`
- E-02: `spec/features/users/signup_spec.rb`
- E-03: `spec/features/projects/new_project_spec.rb`
- E-04: `spec/features/security/project/internal_access_spec.rb`
- E-05: `spec/features/projects/members/manage_members_spec.rb`
- E-06: `spec/features/projects/pipelines/pipelines_spec.rb`
- E-07: `spec/features/projects/settings/repository_settings_spec.rb`
- E-08: `spec/features/admin/admin_users_spec.rb`
- E-09: `spec/features/snippets/user_creates_snippet_spec.rb`
- E-10: `spec/features/snippets/user_edits_snippet_spec.rb`
- E-11: `spec/features/snippets/user_deletes_snippet_spec.rb`
- E-12: `spec/features/snippets/private_snippets_spec.rb`
- E-13: `spec/features/snippets/public_snippets_spec.rb`
- E-14: `spec/features/groups/new_group_page_spec.rb`
- E-15: `spec/features/groups/group_settings_spec.rb`
- E-16: `spec/features/groups/board_spec.rb`
- E-17: `spec/features/error_tracking/user_sees_error_index_spec.rb`
- E-18: `spec/features/error_tracking/user_sees_error_details_spec.rb`
- E-19: `spec/features/error_tracking/user_filters_errors_by_status_spec.rb`
- E-20: `spec/features/markdown/markdown_spec.rb`
- E-21: `spec/features/markdown/math_spec.rb`
- E-22: `spec/features/markdown/sandboxed_mermaid_spec.rb`
- E-23: `spec/features/file_uploads/user_avatar_spec.rb`
- E-24: `spec/features/file_uploads/attachment_spec.rb`
- E-25: `spec/features/file_uploads/ci_artifact_spec.rb`
- E-26: `spec/features/webauthn_spec.rb`
- E-27: `spec/features/frequently_visited_projects_and_groups_spec.rb`
- E-28: `spec/features/calendar_spec.rb`
- E-29: `spec/features/global_search_spec.rb`
- E-30: `spec/features/projects/integrations/user_activates_jira_spec.rb`
- E-31: `spec/features/projects/integrations/user_activates_slack_notifications_spec.rb`
- E-32: `spec/features/environments/environments_folder_spec.rb`
- E-33: `spec/features/milestone_spec.rb`
- E-34: `spec/features/merge_requests/user_views_open_merge_requests_spec.rb`
- E-35: `spec/features/merge_requests/user_filters_by_labels_spec.rb`
- E-36: `spec/features/merge_requests/user_filters_by_assignees_spec.rb`
- E-37: `spec/features/merge_requests/user_sorts_merge_requests_spec.rb`
- E-38: `spec/features/merge_requests/user_views_closed_merge_requests_spec.rb`
- E-39: `spec/features/alerts_settings/user_views_alerts_settings_spec.rb`
- E-40: `spec/features/broadcast_messages_spec.rb`
- E-41: `spec/features/oauth_login_spec.rb`
- E-42: `spec/features/help_pages_spec.rb`
- E-43: `spec/features/help_dropdown_spec.rb`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 正常ログインでダッシュボード画面に遷移する | E-01 | ○ |
| C-02 | ブロックされたアカウントはログイン拒否される | E-01 | ○ |
| C-03 | 未確認メールアカウントは猶予期間後にログイン制限される | E-01 | ○ |
| C-04 | ログイン成功後にパスワードリセットトークンが無効化される | E-01 | ○ |
| C-05 | 有効な情報で新規ユーザー登録が成功する | E-02 | ○ |
| C-06 | 既存ユーザー名入力時にエラーボーダーが表示される | E-02 | ○ |
| C-07 | 256文字以上のユーザー名でエラーが表示される | E-02 | ○ |
| C-08 | 特殊文字を含むユーザー名でエラーボーダーが表示される | E-02 | ○ |
| C-09 | 空のプロジェクトが作成できる | E-03 | ○ |
| C-10 | テンプレートからプロジェクトが作成できる | E-03 | ○ |
| C-11 | URLからプロジェクトをインポートできる | E-03 | ○ |
| C-12 | 制限された可視性レベルが無効化されている | E-03 | ○ |
| C-13 | 管理者がInternalプロジェクトにアクセスできる | E-04 | ○ |
| C-14 | オーナーがInternalプロジェクトにアクセスできる | E-04 | ○ |
| C-15 | メンテナーがInternalプロジェクトにアクセスできる | E-04 | ○ |
| C-16 | デベロッパーがInternalプロジェクトにアクセスできる | E-04 | ○ |
| C-17 | レポーターがInternalプロジェクトにアクセスできる | E-04 | ○ |
| C-18 | ゲストがInternalプロジェクトにアクセスできる | E-04 | ○ |
| C-19 | 外部ユーザーはInternalプロジェクトにアクセスできない | E-04 | ○ |
| C-20 | 未認証ユーザーはInternalプロジェクトにアクセスできない | E-04 | ○ |
| C-21 | グループメンバーとプロジェクトメンバーが一覧表示される | E-05 | ○ |
| C-22 | メンテナーが非オーナーメンバーのアクセスレベルを変更できる | E-05 | ○ |
| C-23 | メンテナーはオーナーのアクセスレベルを変更できない | E-05 | ○ |
| C-24 | グループオーナーがプロジェクトオーナーのアクセスレベルを変更できる | E-05 | ○ |
| C-25 | パイプラインのコミットSHAとブランチ名が表示される | E-06 | ○ |
| C-26 | All、Finished、Branches、Tagsタブが表示される | E-06 | ○ |
| C-27 | Finishedタブクリックでメッセージが表示される | E-06 | ○ |
| C-28 | 「New pipeline」リンクが表示される | E-06 | ○ |
| C-29 | 新しいデプロイキーが追加できる | E-07 | ○ |
| C-30 | デプロイキー一覧が表示される | E-07 | ○ |
| C-31 | デベロッパーはリポジトリ設定にアクセスできない | E-07 | ○ |
| C-32 | ブランチルールセクションが表示される | E-07 | ○ |
| C-33 | Usersタブが表示される | E-08 | ○ |
| C-34 | Cohortsタブで月ごとのユーザー数が表示される | E-08 | ○ |
| C-35 | レガシールートが新しいパスにリダイレクトされる | E-08 | ○ |
| C-36 | 新規スニペットが作成できる | E-09 | ○ |
| C-37 | スニペットが編集できる | E-10 | ○ |
| C-38 | スニペットが削除できる | E-11 | ○ |
| C-39 | プライベートスニペットへのアクセスが拒否される | E-12 | ○ |
| C-40 | パブリックスニペットが表示される | E-13 | ○ |
| C-41 | 新規グループが作成できる | E-14 | ○ |
| C-42 | グループ設定が更新できる | E-15 | ○ |
| C-43 | グループボードが表示される | E-16 | ○ |
| C-44 | エラー一覧が表示される | E-17 | ○ |
| C-45 | エラー詳細が表示される | E-18 | ○ |
| C-46 | ステータスでエラーをフィルタリングできる | E-19 | ○ |
| C-47 | MarkdownがHTMLにレンダリングされる | E-20 | ○ |
| C-48 | 数式が正しくレンダリングされる | E-21 | ○ |
| C-49 | Mermaid図がサンドボックス内でレンダリングされる | E-22 | ○ |
| C-50 | アバター画像がアップロードできる | E-23 | ○ |
| C-51 | 添付ファイルがアップロードできる | E-24 | ○ |
| C-52 | CIアーティファクトがアップロードできる | E-25 | ○ |
| C-53 | WebAuthnデバイスが登録できる | E-26 | ○ |
| C-54 | よくアクセスするプロジェクトが表示される | E-27 | ○ |
| C-55 | アクティビティカレンダーが表示される | E-28 | ○ |
| C-56 | グローバル検索結果が表示される | E-29 | ○ |
| C-57 | Jiraインテグレーションが設定できる | E-30 | ○ |
| C-58 | Slack通知インテグレーションが設定できる | E-31 | ○ |
| C-59 | 環境がフォルダ別に表示される | E-32 | ○ |
| C-60 | マイルストーン一覧と進捗が表示される | E-33 | ○ |
| C-61 | マージリクエスト一覧が表示される | E-34 | ○ |
| C-62 | ラベルでマージリクエストをフィルタリングできる | E-35 | ○ |
| C-63 | 担当者でマージリクエストをフィルタリングできる | E-36 | ○ |
| C-64 | マージリクエストをソートできる | E-37 | ○ |
| C-65 | クローズドマージリクエストが表示される | E-38 | ○ |
| C-66 | アラート設定オプションが表示される | E-39 | ○ |
| C-67 | ブロードキャストメッセージが表示される | E-40 | ○ |
| C-68 | OAuthプロバイダー経由でログインできる | E-41 | ○ |
| C-69 | ヘルプドキュメントが表示される | E-42 | ○ |
| C-70 | ヘルプメニューが表示される | E-43 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全てのテストケースに対応するフィーチャースペックが存在するため、根拠不足の項目はありません
- 以下の追加テストケースの検討を推奨：
  - Issues関連の受入テスト（イシュー作成、編集、クローズ、ラベル付与等）
  - Wiki関連の受入テスト
  - Container Registry関連の受入テスト
  - Package Registry関連の受入テスト
  - Design Management関連の受入テスト

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: ユーザー認証、プロジェクト作成、メンバー管理等のコア機能は十分なテストカバレッジあり
- **1 (中リスク)**: 外部サービス連携（OAuth、Slack、Jira）はモック環境でのテストとなるため、実環境での追加検証を推奨
- **1 (中リスク)**: CI/CDパイプラインテストは基本的なUI確認が中心。実際のパイプライン実行フローの E2E テストは別途必要

## 6) レビュアーチェックリスト（最小）
- [ ] 各ユーザーロール（管理者、オーナー、メンテナー、デベロッパー、レポーター、ゲスト）の権限テストが網羅されているか確認
- [ ] クリティカルな業務フロー（ログイン、登録、プロジェクト作成、MR作成/マージ）のテストケースが含まれているか確認
- [ ] エラーケースとバリデーションテストが十分に含まれているか確認
- [ ] セキュリティ関連テスト（アクセス制御、認証）が適切に含まれているか確認
- [ ] 優先度の高いテストケースから実行計画を策定
- [ ] 外部サービス連携テストの環境準備状況を確認
