---
generated_at: 2026-01-22 15:30:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：帳票一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 全ての項目が根拠付きで生成されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/services/issues/export_csv_service.rb`
- E-02: `app/services/merge_requests/export_csv_service.rb`
- E-03: `app/services/work_items/export_csv_service.rb`
- E-04: `app/services/import/source_users/generate_csv_service.rb`
- E-05: `lib/gitlab/pdf/security/project_vulnerabilities_history.rb`
- E-06: `lib/gitlab/pdf/security/group_vulnerabilities_history.rb`
- E-07: `lib/gitlab/pdf/security/group_vulnerabilities_projects_grades.rb`
- E-08: `app/services/ci/pipeline_artifacts/coverage_report_service.rb`
- E-09: `app/services/ci/generate_terraform_reports_service.rb`
- E-10: `app/services/ci/generate_codequality_mr_diff_report_service.rb`
- E-11: `app/services/projects/import_export/export_service.rb`
- E-12: `app/services/groups/import_export/export_service.rb`
- E-13: `app/controllers/admin/dev_ops_report_controller.rb`
- E-14: `app/controllers/admin/cohorts_controller.rb`
- E-15: `app/controllers/admin/usage_trends_controller.rb`
- E-16: `app/services/ci/compare_test_reports_service.rb`
- E-17: `app/serializers/accessibility_reports_comparer_serializer.rb`
- E-18: `app/serializers/codequality_reports_comparer_serializer.rb`
- E-19: `app/services/ci/daily_build_group_report_result_service.rb`
- E-20: `app/services/ci/job_artifacts/track_artifact_report_service.rb`
- E-21: `app/services/export_csv/base_service.rb`
- E-22: `gems/csv_builder/lib/csv_builder.rb`
- E-23: `lib/gitlab/pdf.rb`
- E-24: `lib/gitlab/pdf/header.rb`
- E-25: `app/workers/issuable_export_csv_worker.rb`
- E-26: `app/workers/export_csv_worker.rb`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Issue CSV Export - プロジェクトのIssue一覧をCSV形式でエクスポート | E-01, E-21, E-22, E-25 | ○ |
| C-02 | Merge Request CSV Export - MR一覧をCSV形式でエクスポート | E-02, E-21, E-22, E-25 | ○ |
| C-03 | Work Items CSV Export - Work Items一覧をCSV形式でエクスポート | E-03, E-21, E-22, E-25 | ○ |
| C-04 | Import Source Users CSV - インポート元ユーザー情報をCSV形式で出力 | E-04, E-22 | ○ |
| C-05 | Vulnerability History PDF - 脆弱性履歴をPDF形式で出力 | E-05, E-23, E-24 | ○ |
| C-06 | Group Vulnerability History PDF - グループ全体の脆弱性履歴をPDF形式で出力 | E-06, E-23, E-24 | ○ |
| C-07 | Project Security Grades PDF - プロジェクトセキュリティグレードをPDF形式で出力 | E-07, E-23, E-24 | ○ |
| C-08 | Coverage Report - パイプラインのコードカバレッジレポートをJSON形式で生成 | E-08 | ○ |
| C-09 | Terraform Reports - Terraformプランの実行結果レポートを生成 | E-09 | ○ |
| C-10 | CodeQuality MR Diff Report - マージリクエストに対するコード品質差分レポートを生成 | E-10 | ○ |
| C-11 | Project Export - プロジェクト全体をアーカイブファイルとしてエクスポート | E-11 | ○ |
| C-12 | Group Export - グループ全体をアーカイブファイルとしてエクスポート | E-12 | ○ |
| C-13 | DevOps Report - インスタンス全体のDevOps採用状況を表示 | E-13 | ○ |
| C-14 | Cohorts Report - ユーザーコホート分析レポートを表示 | E-14 | ○ |
| C-15 | Usage Trends Report - インスタンスの利用傾向レポートを表示 | E-15 | ○ |
| C-16 | Test Report - CIパイプラインのテスト実行結果レポートを生成 | E-16 | ○ |
| C-17 | Accessibility Reports - アクセシビリティテスト結果レポートを生成 | E-17 | ○ |
| C-18 | CodeQuality Reports - コード品質レポートを生成 | E-18 | ○ |
| C-19 | Daily Build Group Report - 日次ビルドグループレポートを生成 | E-19 | ○ |
| C-20 | Job Artifacts Report - ジョブアーティファクトの追跡レポートを生成 | E-20 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての帳票機能はソースコードから直接確認済み。
- ただし、EE（Enterprise Edition）固有の帳票機能は本リポジトリに含まれていないため、対象外としています。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての帳票定義はソースコードから直接抽出しており、信頼性が高い
- 注意点：
  - PDF出力機能（E-05〜E-07）はPrawnライブラリを使用しており、セキュリティ関連のレポート用途
  - CSV出力機能は共通基盤（E-21, E-22）を使用しており、一貫した実装パターン
  - アーカイブ出力機能（E-11, E-12）はImport/Export機能の一部として提供

## 6) レビュアーチェックリスト（最小）
- [ ] 帳票名が実際の機能を正しく表現しているか確認
- [ ] 説明文がソースコードの実装内容と一致しているか確認
- [ ] カテゴリ分類（CSV出力/PDF出力/JSON出力/アーカイブ出力/画面表示）が適切か確認
- [ ] 備考欄のファイルパスが実在し、内容が正しいか確認
- [ ] EE専用機能が漏れていないか（本リポジトリはCE版のため対象外）確認
