# 帳票設計書 4-Import Source Users CSV

## 概要

本ドキュメントは、GitLabのインポート機能におけるソースユーザー情報をCSV形式で出力する機能の帳票設計書である。

### 本帳票の処理概要

本帳票は、外部サービスからGitLabへのプロジェクトインポート時に作成されたプレースホルダーユーザー（ソースユーザー）の情報をCSV形式で出力する。このCSVファイルはユーザーマッピングのためのスプレッドシートとして使用され、インポート元ユーザーとGitLabユーザーの対応付けを行うために活用される。

**業務上の目的・背景**：GitHub、Bitbucket等の外部サービスからGitLabへプロジェクトを移行する際、外部サービスのユーザー情報はそのままGitLabユーザーとして登録されない。代わりにプレースホルダーユーザーが作成される。このCSVを使用して、管理者がインポート元ユーザーを適切なGitLabユーザーにマッピングすることで、コミット履歴やIssue担当者等の情報を正しく引き継ぐことができる。

**帳票の利用シーン**：システム管理者がプロジェクト移行後にユーザーマッピングを設定する際、組織の移行担当者がユーザー対応表を作成する際、監査担当者がユーザーマッピング状況を確認する際などに利用される。

**主要な出力内容**：
1. インポート元ホスト情報（Source host）
2. インポート種別（Import type）
3. ソースユーザー識別情報（Source user identifier、Source user name、Source username）
4. マッピング先入力欄（GitLab username、GitLab public email）

**帳票の出力タイミング**：ネームスペースオーナーがインポートソースユーザー管理画面からCSVエクスポートを実行した際に同期的に生成される。

**帳票の利用者**：グループオーナー、ネームスペース管理者、システム移行担当者

## 帳票種別

マッピング用テンプレート（CSVエクスポート）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | Import Source Users | `/:namespace/-/settings/import_source_users` | "Export CSV"ボタン |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | CSV |
| 用紙サイズ | - |
| 向き | - |
| ファイル名 | import_source_users.csv |
| 出力方法 | ダウンロード |
| 文字コード | UTF-8 |

### CSV固有設定

| 項目 | 内容 |
|-----|------|
| ヘッダー行 | あり |
| 区切り文字 | カンマ |
| 囲み文字 | ダブルクォート |
| 最大ファイルサイズ | 10MB |
| 改行置換 | あり（replace_newlines: true） |

## 帳票レイアウト

### レイアウト概要

CSVファイルはヘッダー行と明細行で構成される。各行は7項目のカラムを持ち、最後の2カラムはユーザーが入力するためのテンプレート欄となる。

```
┌─────────────────────────────────────┐
│         ヘッダー行（1行目）           │
├─────────────────────────────────────┤
│         明細行（2行目以降）           │
│    （ソースユーザー毎に1行）          │
│    ※最後の2列は入力用空欄           │
└─────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Source host | インポート元ホスト名 | import_source_users.source_hostname | 文字列 |
| 2 | Import type | インポート種別 | import_source_users.import_type | 文字列 |
| 3 | Source user identifier | ソースユーザー識別子 | import_source_users.source_user_identifier | 文字列 |
| 4 | Source user name | ソースユーザー名 | import_source_users.source_name | 文字列 |
| 5 | Source username | ソースユーザーユーザー名 | import_source_users.source_username | 文字列 |
| 6 | GitLab username | マッピング先GitLabユーザー名 | - | 空欄（入力用） |
| 7 | GitLab public email | マッピング先GitLabメール | - | 空欄（入力用） |

### 明細部

各ソースユーザーごとに1行を出力。再割当可能なステータスのユーザーのみが対象。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| ネームスペース | 対象のネームスペースまたはグループ | Yes |
| ステータス | REASSIGNABLE_STATUSESに該当するステータスのみ | Yes |
| オーナー権限 | ネームスペースへのオーナーアクセス権限 | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | デフォルト順序 | - |

### 改ページ条件

CSVのため改ページなし

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| import_source_users | ソースユーザー情報 | 主テーブル |
| namespaces | ネームスペース情報 | import_source_users.namespace_id = namespaces.id |

### テーブル別参照項目詳細

#### import_source_users

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| source_hostname | Source host | status IN REASSIGNABLE_STATUSES | - |
| import_type | Import type | status IN REASSIGNABLE_STATUSES | - |
| source_user_identifier | Source user identifier | status IN REASSIGNABLE_STATUSES | - |
| source_name | Source user name | status IN REASSIGNABLE_STATUSES | - |
| source_username | Source username | status IN REASSIGNABLE_STATUSES | - |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| GitLab username | 空文字列を返すラムダ | - | ユーザー入力用テンプレート |
| GitLab public email | 空文字列を返すラムダ | - | ユーザー入力用テンプレート |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[Export CSV操作] --> B[GenerateCsvService.execute]
    B --> C{オーナー権限確認}
    C -->|権限なし| D[error_invalid_permissions]
    C -->|権限あり| E{ソースユーザー確認}
    E -->|0件| F[error_no_source_users]
    E -->|存在する| G[import_source_users取得]
    G --> H[REASSIGNABLE_STATUSESでフィルタ]
    H --> I[CsvBuilder.new]
    I --> J[render（10MB制限）]
    J --> K[ServiceResponse.success]
    K --> L[CSVダウンロード]
    D --> M[エラーレスポンス]
    F --> M
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 権限エラー | オーナー権限がない | "You do not have permission to view import source users for this namespace" | オーナー権限を付与 |
| データなし | 再割当可能なソースユーザーが0件 | "No placeholder users are awaiting reassignment." | - |
| ファイルサイズ超過 | 10MB超過 | 処理が途中で打ち切られる | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数百〜数千件 |
| 目標出力時間 | 同期処理のため数秒以内 |
| 同時出力数上限 | リクエスト単位 |

## セキュリティ考慮事項

- ネームスペースオーナー権限（owner_access）が必須
- インポート元ユーザー情報は個人情報を含む可能性があるため、権限チェックを厳格に実施
- 出力されたCSVファイルの取り扱いには注意が必要（ユーザー識別情報を含む）

## 備考

- COLUMN_MAPPINGはfrozenされた定数として定義されている
- FILESIZE_LIMITは10MBに設定されており、不正利用防止の目的がある
- replace_newlines: trueオプションにより、改行文字が適切に処理される
- 再アップロードによるユーザーマッピングフローに使用される

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

CSV出力のカラム定義とデータソースを理解することが最初のステップ。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | generate_csv_service.rb | `app/services/import/source_users/generate_csv_service.rb` | COLUMN_MAPPING定数でCSVカラム定義を確認（14-22行目） |

**読解のコツ**: COLUMN_MAPPINGの値が文字列の場合はモデルの属性名、ラムダの場合は動的に値を生成する。最後の2カラムは空文字を返すラムダで入力用テンプレートとなっている。

#### Step 2: サービスのエントリーポイントを理解する

サービスの実行フローと権限チェックを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | generate_csv_service.rb | `app/services/import/source_users/generate_csv_service.rb` | executeメソッド（31-37行目） |

**主要処理フロー**:
1. **31行目**: `execute`メソッド開始
2. **34行目**: オーナー権限確認
3. **35行目**: ソースユーザーの存在確認
4. **37行目**: 成功時にpayloadとしてcsv_dataを返却

#### Step 3: データ取得ロジックを理解する

対象データの取得条件を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | generate_csv_service.rb | `app/services/import/source_users/generate_csv_service.rb` | import_source_usersメソッド（48-51行目） |

**主要処理フロー**:
- **48-51行目**: REASSIGNABLE_STATUSESでフィルタリング

### プログラム呼び出し階層図

```
Import::SourceUsers::GenerateCsvService
    │
    ├─ execute
    │      │
    │      ├─ current_user.can?(:owner_access, namespace)
    │      │      └─ 権限チェック
    │      │
    │      ├─ import_source_users
    │      │      └─ namespace.import_source_users.by_statuses
    │      │
    │      └─ csv_data
    │             └─ CsvBuilder.new.render(FILESIZE_LIMIT)
    │
    ├─ error_invalid_permissions
    │      └─ ServiceResponse.error(reason: :forbidden)
    │
    └─ error_no_source_users
           └─ ServiceResponse.error(reason: :no_source_users)
```

### データフロー図

```
[入力]                   [処理]                        [出力]

設定画面 ───▶ GenerateCsvService.execute
    │                      │
    │                      ▼
    │              権限チェック
    │                      │
    │                      ▼
    │         import_source_users取得
    │         (REASSIGNABLE_STATUSESでフィルタ)
    │                      │
    │                      ▼
    │              CsvBuilder.render
    │                      │
    │                      ▼
    └──────────────────────────────────▶ CSVダウンロード
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| generate_csv_service.rb | `app/services/import/source_users/generate_csv_service.rb` | ソース | CSV生成サービス |
| import_source_user.rb | `app/models/import/source_user.rb` | ソース | ソースユーザーモデル |
| csv_builder.rb | `lib/csv_builder.rb` | ソース | CSV構築ユーティリティ |
| namespace.rb | `app/models/namespace.rb` | ソース | ネームスペースモデル |
