# 帳票設計書 5-Vulnerability History PDF

## 概要

本ドキュメントは、GitLabのプロジェクトにおける脆弱性履歴をPDF形式で出力する機能の帳票設計書である。

### 本帳票の処理概要

本帳票は、プロジェクトのデフォルトブランチにおける脆弱性の履歴情報をPDF形式で可視化する。重大度（Severity）別に脆弱性の推移をグラフで表示し、セキュリティ状況の経時変化を把握できるようにする。

**業務上の目的・背景**：セキュリティ管理において、プロジェクトの脆弱性状況を時系列で把握することは重要である。この帳票により、セキュリティチームはプロジェクトのセキュリティ改善状況を視覚的に確認でき、経営層への報告資料としても活用できる。解決済みまたは却下済みの脆弱性は除外され、現在オープンな脆弱性の推移に焦点を当てている。

**帳票の利用シーン**：セキュリティ監査時の報告資料作成、経営会議へのセキュリティ状況報告、プロジェクトセキュリティレビュー時の資料作成、コンプライアンス対応の証跡記録などに利用される。

**主要な出力内容**：
1. 脆弱性履歴タイトルと説明文
2. SVGチャート（フロントエンドから提供される脆弱性推移グラフ）
3. 重大度凡例（Critical、High、Medium、Low、Info、Unknown）

**帳票の出力タイミング**：ユーザーがセキュリティダッシュボードからPDFエクスポートを実行した際に生成される。

**帳票の利用者**：セキュリティエンジニア、プロジェクトマネージャー、セキュリティ監査担当者、経営層

## 帳票種別

セキュリティレポート（PDF出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | Project Security Dashboard | `/:namespace/:project/-/security/dashboard` | "Export PDF"操作 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | PDF |
| 用紙サイズ | デフォルト（Prawnの標準設定） |
| 向き | 縦 |
| ファイル名 | vulnerability_history.pdf |
| 出力方法 | ダウンロード |
| 文字コード | UTF-8 |

### PDF固有設定

| 項目 | 内容 |
|-----|------|
| パスワード保護 | 無 |
| 印刷制限 | 無 |
| 電子署名 | 無 |
| SVGサポート | prawn-svg使用 |

## 帳票レイアウト

### レイアウト概要

PDFは背景領域、タイトル、説明文、SVGチャート、凡例で構成される。高さ250pxの固定領域を使用。

```
┌─────────────────────────────────────┐
│         タイトル部（太字14pt）        │
│      "Vulnerability History"        │
├─────────────────────────────────────┤
│           説明文部（10pt）           │
│  "Historical view of open..."       │
├─────────────────────────────────────┤
│         SVGチャート部               │
│      （高さ200px、幅：全幅）         │
│     脆弱性推移グラフ                 │
├─────────────────────────────────────┤
│           区切り線                  │
├─────────────────────────────────────┤
│           凡例部（8pt太字）          │
│  Critical | High | Medium | ...     │
└─────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | タイトル | "Vulnerability History" | 固定テキスト | 14pt太字、左寄せ |
| 2 | 説明 | 脆弱性履歴の説明文 | 固定テキスト | 10pt、左寄せ |

### 明細部（チャート）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | SVGチャート | 脆弱性推移グラフ | フロントエンドからのSVGデータ | SVG描画（200px高） |

### フッター部（凡例）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Critical | 重大度Critical | SEVERITY_LEGEND定数 | 色: #660e00 |
| 2 | High | 重大度High | SEVERITY_LEGEND定数 | 色: #ae1800 |
| 3 | Medium | 重大度Medium | SEVERITY_LEGEND定数 | 色: #9e5400 |
| 4 | Low | 重大度Low | SEVERITY_LEGEND定数 | 色: #c17d10 |
| 5 | Info | 重大度Info | SEVERITY_LEGEND定数 | 色: #428fdc |
| 6 | Unknown | 重大度Unknown | SEVERITY_LEGEND定数 | 色: #868686 |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| プロジェクト | 対象プロジェクト | Yes |
| SVGデータ | フロントエンドから渡されるSVGチャート | Yes |

### ソート順

該当なし（グラフ形式のため）

### 改ページ条件

単一ページで完結

## データベース参照仕様

### 参照テーブル一覧

本機能はフロントエンドから提供されるSVGデータを処理するため、直接のデータベース参照は行わない。脆弱性データはフロントエンドでGraphQL API経由で取得され、SVGチャートとして本サービスに渡される。

### CSS変数変換

| CSS変数 | 変換後の色 | 用途 |
|---------|----------|------|
| var(--gl-chart-axis-line-color) | #dddddd | グラフ軸線 |
| var(--gl-text-color-default) | #333333 | テキストデフォルト色 |
| var(--gl-chart-axis-text-color) | #666666 | グラフ軸テキスト |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| SVG抽出 | CGI.unescape(data).delete!("\n")[/<svg.*<\/svg>/, 1] | - | URLエンコードされたSVGを抽出 |
| CSS変換 | gsub(css_variable, color) | - | CSS変数をハードコード色に置換 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[PDF Export要求] --> B[ProjectVulnerabilitiesHistory.render]
    B --> C{SVGデータ確認}
    C -->|データなし| D[return :noop]
    C -->|データあり| E[process_raw でSVG処理]
    E --> F[CGI.unescape でデコード]
    F --> G[改行削除]
    G --> H[正規表現でSVGタグ抽出]
    H --> I[CSS変数を色に置換]
    I --> J[bounding_box描画開始]
    J --> K[背景色 F9F9F9 描画]
    K --> L[タイトル描画]
    L --> M[説明文描画]
    M --> N[SVGチャート描画]
    N --> O[区切り線描画]
    O --> P[凡例描画]
    P --> Q[PDF出力完了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | SVGデータがblank | :noop を返却 | 脆弱性データがないため出力なし |
| SVG解析エラー | 不正なSVG形式 | PDF生成失敗 | SVGデータを確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 単一プロジェクト |
| 目標出力時間 | 数秒以内 |
| 同時出力数上限 | リクエスト単位 |

## セキュリティ考慮事項

- セキュリティダッシュボードへのアクセス権限が必要
- 脆弱性情報は機密性が高いため、PDFの取り扱いに注意
- SVGデータはCGI.unescapeで処理されるため、入力データの検証が重要

## 備考

- PrawnとPrawn-SVGライブラリを使用してPDF生成
- フロントエンドのCSS変数はprawn-svgでサポートされないため、ハードコードされた色に変換
- 凡例は6つの重大度レベルを水平に配置
- 高さ250px、SVGチャート高さ200pxの固定レイアウト

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

重大度凡例の定義とCSS変換設定を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | project_vulnerabilities_history.rb | `lib/gitlab/pdf/security/project_vulnerabilities_history.rb` | SEVERITY_LEGEND定数（12-18行目） |
| 1-2 | project_vulnerabilities_history.rb | `lib/gitlab/pdf/security/project_vulnerabilities_history.rb` | CSS_TRANSLATIONS定数（24-28行目） |

**読解のコツ**: SEVERITY_LEGENDは各重大度の名前と色を定義。CSS_TRANSLATIONSはフロントエンドのCSS変数をprawn-svgで使用可能な色に変換するためのマッピング。

#### Step 2: 初期化とレンダリング開始を理解する

クラスの初期化とrenderメソッドの開始点を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | project_vulnerabilities_history.rb | `lib/gitlab/pdf/security/project_vulnerabilities_history.rb` | self.render（30-32行目） |
| 2-2 | project_vulnerabilities_history.rb | `lib/gitlab/pdf/security/project_vulnerabilities_history.rb` | initialize（34-40行目） |

**主要処理フロー**:
1. **30-32行目**: クラスメソッドrenderでインスタンス生成
2. **34-40行目**: PDF、データ、レイアウト設定の初期化

#### Step 3: レンダリング処理を理解する

PDF描画の詳細ロジックを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | project_vulnerabilities_history.rb | `lib/gitlab/pdf/security/project_vulnerabilities_history.rb` | render（43-113行目） |
| 3-2 | project_vulnerabilities_history.rb | `lib/gitlab/pdf/security/project_vulnerabilities_history.rb` | process_raw（118-125行目） |

**主要処理フロー**:
- **44行目**: データがblankの場合は:noopを返却
- **46-112行目**: bounding_box内でPDF要素を描画
- **118-125行目**: SVGデータの前処理（デコード、抽出、CSS変換）

### プログラム呼び出し階層図

```
Gitlab::PDF::Security::ProjectVulnerabilitiesHistory
    │
    ├─ self.render(pdf, data:)
    │      └─ new(pdf, data).render
    │
    ├─ initialize(pdf, data)
    │      └─ process_raw(data)
    │             ├─ CGI.unescape
    │             ├─ 正規表現でSVG抽出
    │             └─ CSS_TRANSLATIONS変換
    │
    └─ render
           ├─ bounding_box
           │      ├─ fill_rectangle（背景）
           │      ├─ text_box（タイトル）
           │      ├─ text_box（説明）
           │      └─ bounding_box
           │             ├─ svg（チャート）
           │             ├─ stroke_line（区切り）
           │             └─ SEVERITY_LEGEND.each（凡例）
           │
           └─ Prawn::View（mixin）
```

### データフロー図

```
[入力]                   [処理]                        [出力]

フロントエンドSVG ───▶ process_raw ───▶ SVG抽出・変換
    │                      │                   │
    │                      ▼                   ▼
    │              CSS変数→色変換        Prawn描画
    │                                          │
    │                                          ▼
    └──────────────────────────────────▶ PDF出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| project_vulnerabilities_history.rb | `lib/gitlab/pdf/security/project_vulnerabilities_history.rb` | ソース | PDF生成クラス |
| prawn gem | - | ライブラリ | PDF生成ライブラリ |
| prawn-svg gem | - | ライブラリ | SVG描画サポート |
