# 帳票設計書 6-Group Vulnerability History PDF

## 概要

本ドキュメントは、GitLabのグループ全体における脆弱性履歴をPDF形式で出力する機能の帳票設計書である。

### 本帳票の処理概要

本帳票は、グループに属する全プロジェクトの脆弱性履歴情報をPDF形式で可視化する。重大度（Severity）別に脆弱性の推移を個別のチャートで表示し、各重大度の変化率と現在の件数を一覧形式で確認できるようにする。

**業務上の目的・背景**：大規模な組織では複数のプロジェクトを持つグループ単位でセキュリティ状況を把握する必要がある。この帳票により、セキュリティチームはグループ全体のセキュリティ改善傾向を把握でき、リソース配分の判断材料として活用できる。期間選択機能により、任意の期間での脆弱性推移を確認できる。

**帳票の利用シーン**：グループレベルのセキュリティ監査時、経営層への定期セキュリティ報告、複数プロジェクト間のセキュリティ状況比較、セキュリティ投資の効果測定などに利用される。

**主要な出力内容**：
1. 脆弱性履歴タイトル
2. 日付範囲情報（対象期間）
3. 重大度別テーブルヘッダー（Severity、%、#）
4. 重大度別行（アイコン、名前、チャート、変化率、件数）

**帳票の出力タイミング**：ユーザーがグループセキュリティダッシュボードからPDFエクスポートを実行した際に生成される。

**帳票の利用者**：グループオーナー、セキュリティマネージャー、CISO、経営層

## 帳票種別

セキュリティレポート（PDF出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | Group Security Dashboard | `/:group/-/security/dashboard` | "Export PDF"操作 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | PDF |
| 用紙サイズ | デフォルト（Prawnの標準設定） |
| 向き | 縦 |
| ファイル名 | group_vulnerability_history.pdf |
| 出力方法 | ダウンロード |
| 文字コード | UTF-8 |

### PDF固有設定

| 項目 | 内容 |
|-----|------|
| パスワード保護 | 無 |
| 印刷制限 | 無 |
| 電子署名 | 無 |
| SVGサポート | prawn-svg使用 |

## 帳票レイアウト

### レイアウト概要

PDFは背景領域、タイトル、日付情報、テーブルヘッダー、重大度別行で構成される。高さ400pxの固定領域を使用し、各重大度の行は70pxの高さを持つ。

```
┌─────────────────────────────────────┐
│      タイトル（中央、16pt太字）       │
│      "Vulnerability History"        │
├─────────────────────────────────────┤
│       日付情報（中央、12pt）         │
│    "2024-01-01 - 2024-12-31 (365)"  │
├─────────────────────────────────────┤
│  Severity    |    Chart    |  %  | # │
├─────────────────────────────────────┤
│  [icon] Critical | [chart] | +5% | 10│
├─────────────────────────────────────┤
│  [icon] High     | [chart] | -2% | 25│
├─────────────────────────────────────┤
│  [icon] Medium   | [chart] | +1% | 50│
├─────────────────────────────────────┤
│  [icon] Low      | [chart] |  0% | 30│
├─────────────────────────────────────┤
│  [icon] Info     | [chart] | -3% | 15│
├─────────────────────────────────────┤
│  [icon] Unknown  | [chart] | +2% |  5│
└─────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | タイトル | "Vulnerability History" | 固定テキスト | 16pt太字、中央寄せ |
| 2 | 日付情報 | 対象期間と日数 | date_info + selected_day_range | 12pt、中央寄せ |

### テーブルヘッダー

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Severity | 重大度ラベル | 固定テキスト | 12pt太字 |
| 2 | % | 変化率ラベル | 固定テキスト | 12pt太字、中央寄せ |
| 3 | # | 件数ラベル | 固定テキスト | 12pt太字、中央寄せ |

### 明細部（重大度別行）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | アイコン | 重大度アイコンSVG | SEVERITY_ICONS定数 | 14x14 SVG |
| 2 | 重大度名 | 重大度名（先頭大文字） | chart.severity.capitalize | 文字列 |
| 3 | チャート | 推移グラフ | chart.svg | SVG（幅50%） |
| 4 | 変化率 | 期間内の変化率 | chart.change_in_percent | 12pt太字、中央寄せ |
| 5 | 件数 | 現在の脆弱性件数 | chart.current_count | 12pt太字、中央寄せ |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| グループ | 対象グループ | Yes |
| 日付範囲 | 対象期間（selected_day_range） | Yes |
| チャートデータ | 各重大度のSVGチャート | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | 重大度順 | 固定順序（Critical→High→Medium→Low→Info→Unknown） |

### 改ページ条件

単一ページで完結

## データベース参照仕様

### 参照テーブル一覧

本機能はフロントエンドから提供されるチャートデータを処理するため、直接のデータベース参照は行わない。脆弱性データはフロントエンドでGraphQL API経由で取得され、SVGチャートと統計情報として本サービスに渡される。

### 重大度アイコン定義

| 重大度 | アイコン色 | 形状 |
|--------|----------|------|
| Critical | #dd2b0e | 六角形 |
| High | #dd2b0e | 菱形 |
| Medium | #fc9403 | 三角形 |
| Low | #fc9403 | 楕円 |
| Info | #428fdc | 円形（情報アイコン） |
| Unknown | #868686 | 円形（疑問符アイコン） |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| SVG抽出 | CGI.unescape(chart[:svg]).delete!("\n")[/<svg.*<\/svg>/, 1] | - | 各チャートのSVG抽出 |
| 行高さ | row_height = 70 | - | 固定値 |
| 行Y位置 | chart_start_position - (index * row_height) | - | インデックスベースの位置計算 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[PDF Export要求] --> B[GroupVulnerabilitiesHistory.render]
    B --> C{チャートデータ確認}
    C -->|データなし| D[return :noop]
    C -->|データあり| E[process_raw でチャート処理]
    E --> F[各チャートのSVGを抽出]
    F --> G[bounding_box描画開始]
    G --> H[背景色 F9F9F9 描画]
    H --> I[タイトル描画]
    I --> J[日付情報描画]
    J --> K[draw_table_header]
    K --> L[charts.each_with_index]
    L --> M[draw_chart_row]
    M --> N[アイコンSVG描画]
    N --> O[重大度名描画]
    O --> P[チャートSVG描画]
    P --> Q[変化率描画]
    Q --> R[件数描画]
    R --> S{次の行あり?}
    S -->|Yes| L
    S -->|No| T[PDF出力完了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | chartsがblank | :noop を返却 | 脆弱性データがないため出力なし |
| SVG解析エラー | 不正なSVG形式 | PDF生成失敗 | SVGデータを確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 6行（重大度別） |
| 目標出力時間 | 数秒以内 |
| 同時出力数上限 | リクエスト単位 |

## セキュリティ考慮事項

- グループセキュリティダッシュボードへのアクセス権限が必要
- グループ全体の脆弱性情報は高い機密性を持つため、PDFの取り扱いに注意
- SVGデータはCGI.unescapeで処理されるため、入力データの検証が重要

## 備考

- PrawnとPrawn-SVGライブラリを使用してPDF生成
- 各重大度のアイコンはSVG形式でインライン定義（SEVERITY_ICONS定数）
- 行高さ70px固定、全体高さ400px固定のレイアウト
- アイコンサイズは14x14

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

重大度アイコンのSVG定義を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | group_vulnerabilities_history.rb | `lib/gitlab/pdf/security/group_vulnerabilities_history.rb` | SEVERITY_ICONS定数（13-20行目） |

**読解のコツ**: SEVERITY_ICONSは各重大度のSVGアイコンをインラインで定義。キーはシンボル形式で小文字。

#### Step 2: 初期化とデータ前処理を理解する

クラスの初期化とデータ前処理を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | group_vulnerabilities_history.rb | `lib/gitlab/pdf/security/group_vulnerabilities_history.rb` | self.render（23-25行目） |
| 2-2 | group_vulnerabilities_history.rb | `lib/gitlab/pdf/security/group_vulnerabilities_history.rb` | initialize（27-36行目） |
| 2-3 | group_vulnerabilities_history.rb | `lib/gitlab/pdf/security/group_vulnerabilities_history.rb` | process_raw（137-147行目） |

**主要処理フロー**:
1. **27-36行目**: PDF、チャートデータ、日付情報、レイアウト設定の初期化
2. **137-147行目**: 各チャートのSVGデータを抽出

#### Step 3: テーブルレンダリングを理解する

テーブルヘッダーと行の描画ロジックを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | group_vulnerabilities_history.rb | `lib/gitlab/pdf/security/group_vulnerabilities_history.rb` | draw_table_header（77-98行目） |
| 3-2 | group_vulnerabilities_history.rb | `lib/gitlab/pdf/security/group_vulnerabilities_history.rb` | draw_chart_row（100-135行目） |

**主要処理フロー**:
- **77-98行目**: ヘッダー行（Severity、%、#）の描画
- **100-135行目**: 各重大度行の描画（アイコン、名前、チャート、変化率、件数）

### プログラム呼び出し階層図

```
Gitlab::PDF::Security::GroupVulnerabilitiesHistory
    │
    ├─ self.render(pdf, data:)
    │      └─ new(pdf, data).render
    │
    ├─ initialize(pdf, data)
    │      └─ process_raw(data)
    │             └─ charts.each { SVG抽出 }
    │
    └─ render
           ├─ bounding_box
           │      ├─ fill_rectangle（背景）
           │      ├─ text_box（タイトル）
           │      ├─ text_box（日付情報）
           │      ├─ draw_table_header
           │      │      └─ ヘッダー行描画
           │      └─ charts.each_with_index
           │             └─ draw_chart_row
           │                    ├─ svg（アイコン）
           │                    ├─ text_box（重大度名）
           │                    ├─ svg（チャート）
           │                    ├─ text_box（変化率）
           │                    └─ text_box（件数）
           │
           └─ Prawn::View（mixin）
```

### データフロー図

```
[入力]                      [処理]                        [出力]

フロントエンド ───▶ process_raw ───▶ チャートSVG抽出
    │ charts[]          │                    │
    │ date_info         ▼                    ▼
    │ selected_day_range  draw_table_header    Prawn描画
    │                          │                   │
    │                          ▼                   ▼
    └──────────────────▶ draw_chart_row ───▶ PDF出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| group_vulnerabilities_history.rb | `lib/gitlab/pdf/security/group_vulnerabilities_history.rb` | ソース | PDF生成クラス |
| prawn gem | - | ライブラリ | PDF生成ライブラリ |
| prawn-svg gem | - | ライブラリ | SVG描画サポート |
