# 帳票設計書 7-Project Security Grades PDF

## 概要

本ドキュメントは、GitLabのグループ内プロジェクトのセキュリティグレード一覧をPDF形式で出力する機能の帳票設計書である。

### 本帳票の処理概要

本帳票は、グループに属する各プロジェクトをセキュリティグレード（A〜F）で分類し、PDF形式で可視化する。プロジェクトは最も深刻な脆弱性の重大度に基づいてグレーディングされ、各グレードのプロジェクト一覧と脆弱性数を表示する。

**業務上の目的・背景**：大規模な組織では多数のプロジェクトのセキュリティ状況を一目で把握する必要がある。この帳票により、セキュリティチームは危険なプロジェクトを即座に特定でき、優先的な対応が必要なプロジェクトを識別できる。グレードシステムにより、技術的な詳細を理解していないステークホルダーにもセキュリティ状況を伝えやすくなる。

**帳票の利用シーン**：グループレベルのセキュリティ状況確認、経営層へのセキュリティダッシュボード提供、プロジェクト優先度の決定、セキュリティ監査への対応などに利用される。

**主要な出力内容**：
1. タイトルと説明文（プロジェクトセキュリティステータス）
2. グレード別セクション（F、D、C、B、A順）
3. 展開されたグレードのプロジェクト一覧
4. 各プロジェクトの脆弱性重大度別件数

**帳票の出力タイミング**：ユーザーがグループセキュリティダッシュボードからPDFエクスポートを実行した際に生成される。

**帳票の利用者**：グループオーナー、セキュリティマネージャー、CISO、プロジェクトマネージャー

## 帳票種別

セキュリティレポート（PDF出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | Group Security Dashboard | `/:group/-/security/dashboard` | "Export PDF"操作 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | PDF |
| 用紙サイズ | デフォルト（Prawnの標準設定） |
| 向き | 縦 |
| ファイル名 | project_security_grades.pdf |
| 出力方法 | ダウンロード |
| 文字コード | UTF-8 |

### PDF固有設定

| 項目 | 内容 |
|-----|------|
| パスワード保護 | 無 |
| 印刷制限 | 無 |
| 電子署名 | 無 |
| SVGサポート | prawn-svg使用 |

## 帳票レイアウト

### レイアウト概要

PDFはヘッダー、グレード別行（展開/折りたたみ）、プロジェクト一覧で構成される。高さ700pxの固定領域を使用。

```
┌─────────────────────────────────────┐
│   ヘッダー部（背景 #f9fafb）         │
│   "Project security status"         │
│   説明文                            │
├─────────────────────────────────────┤
│   [F] 10 projects (展開時)          │
│     └─ プロジェクト名               │
│         - 5 critical               │
│         - 3 high                   │
├─────────────────────────────────────┤
│   [D] 5 projects (折りたたみ)       │
├─────────────────────────────────────┤
│   [C] 8 projects (折りたたみ)       │
├─────────────────────────────────────┤
│   [B] 12 projects (折りたたみ)      │
├─────────────────────────────────────┤
│   [A] 20 projects (折りたたみ)      │
└─────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | タイトル | "Project security status" | 固定テキスト | 16pt太字、中央寄せ |
| 2 | 説明 | グレーディング説明文 | 固定テキスト | 12pt、中央寄せ |

### グレード別行

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | グレード文字 | A〜F | grade.letter | 16pt太字、グレード色 |
| 2 | プロジェクト数 | "X projects" | grade.count | 14pt |

### プロジェクト一覧（展開時）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | プロジェクト名 | プロジェクトフルネーム | project.nameWithNamespace | 12ptリンク（青） |
| 2 | 脆弱性件数 | 重大度別件数 | vulnerabilitySeveritiesCount | 11pt、グレード色 |

## グレード定義

| グレード | 色 | 対象脆弱性 |
|---------|-----|----------|
| A | #16a34a（緑） | なし |
| B | #f97316（オレンジ） | Low |
| C | #ea580c（濃いオレンジ） | Medium |
| D | #b91c1c（赤） | High, Unknown |
| F | #991b1b（濃い赤） | Critical |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| グループ | 対象グループ | Yes |
| vulnerability_grades | グレード別プロジェクト情報 | Yes |
| expanded_grade | 展開するグレード（デフォルト: F） | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | グレード順 | F→D→C→B→A |
| 2 | 脆弱性件数順 | Critical→High→Medium→Low→Info→Unknown降順 |

### 改ページ条件

単一ページで完結

## データベース参照仕様

### 参照テーブル一覧

本機能はフロントエンドから提供されるGraphQLデータを処理するため、直接のデータベース参照は行わない。脆弱性グレードデータはフロントエンドでGraphQL API経由で取得され、本サービスに渡される。

### プロジェクトデータ構造

| フィールド | 説明 |
|-----------|------|
| nameWithNamespace | プロジェクトフルネーム |
| securityDashboardPath | セキュリティダッシュボードへのパス |
| vulnerabilitySeveritiesCount | 重大度別脆弱性件数オブジェクト |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| プロジェクトソート | -critical, -high, -medium, -low, -info, -unknown順 | - | 上位5件を表示 |
| 展開時高さ | (projects.count * 45) + 80 | - | ドロワー高さ計算 |
| 折りたたみ時高さ | 40 | - | 固定値 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[PDF Export要求] --> B[GroupVulnerabilitiesProjectsGrades.render]
    B --> C{グレードデータ確認}
    C -->|データなし| D[return :noop]
    C -->|データあり| E[process_raw でグレード処理]
    E --> F[グレード順にソート]
    F --> G[プロジェクトを脆弱性数でソート]
    G --> H[上位5件を抽出]
    H --> I[bounding_box描画開始]
    I --> J[背景描画]
    J --> K[タイトル・説明描画]
    K --> L[build_base_svg]
    L --> M[各グレードを順に処理]
    M --> N{展開グレード?}
    N -->|Yes| O[expanded_grade_svg]
    N -->|No| P[collapsed_grade_svg]
    O --> Q[プロジェクト一覧描画]
    P --> Q
    Q --> R[render_project_names]
    R --> S[PDF出力完了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | gradesがblank | :noop を返却 | グレードデータがないため出力なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 5グレード x 最大5プロジェクト |
| 目標出力時間 | 数秒以内 |
| 同時出力数上限 | リクエスト単位 |

## セキュリティ考慮事項

- グループセキュリティダッシュボードへのアクセス権限が必要
- プロジェクト名とセキュリティ状況は機密情報を含む可能性があるため、PDFの取り扱いに注意
- プロジェクト名はセキュリティダッシュボードへのリンクとして表示

## 備考

- PrawnとPrawn-SVGライブラリを使用してPDF生成
- DEFAULT_COUNTSは"0 projects"（プロジェクトなしの場合）
- 展開グレードのプロジェクトは上位5件のみ表示
- プロジェクトはformatted_text_boxでリンクとして描画
- GitLabホストURLはRails.application.routes.url_helpersから取得

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

グレード定義とスタイル設定を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | group_vulnerabilities_projects_grades.rb | `lib/gitlab/pdf/security/group_vulnerabilities_projects_grades.rb` | GRADES_DISPLAY_INFO定数（13-19行目） |
| 1-2 | group_vulnerabilities_projects_grades.rb | `lib/gitlab/pdf/security/group_vulnerabilities_projects_grades.rb` | SVG_STYLES定数（21-37行目） |

**読解のコツ**: GRADES_DISPLAY_INFOは各グレードの色と対象脆弱性を定義。SVG_STYLESはCSSクラスを定義しPDF内のSVGで使用される。

#### Step 2: 初期化とデータ前処理を理解する

クラスの初期化とデータ前処理を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | group_vulnerabilities_projects_grades.rb | `lib/gitlab/pdf/security/group_vulnerabilities_projects_grades.rb` | initialize（43-51行目） |
| 2-2 | group_vulnerabilities_projects_grades.rb | `lib/gitlab/pdf/security/group_vulnerabilities_projects_grades.rb` | process_raw（214-236行目） |
| 2-3 | group_vulnerabilities_projects_grades.rb | `lib/gitlab/pdf/security/group_vulnerabilities_projects_grades.rb` | sort_projects（241-255行目） |

**主要処理フロー**:
1. **43-51行目**: PDF、グレードデータ、展開グレード、ホストURLの初期化
2. **214-236行目**: グレードをF→D→C→B→A順にソート、プロジェクト情報を整理
3. **241-255行目**: プロジェクトを脆弱性数でソートし上位5件を抽出

#### Step 3: SVG構築を理解する

PDFに埋め込むSVGの構築ロジックを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | group_vulnerabilities_projects_grades.rb | `lib/gitlab/pdf/security/group_vulnerabilities_projects_grades.rb` | build_base_svg（88-123行目） |
| 3-2 | group_vulnerabilities_projects_grades.rb | `lib/gitlab/pdf/security/group_vulnerabilities_projects_grades.rb` | expanded_grade_svg（142-158行目） |
| 3-3 | group_vulnerabilities_projects_grades.rb | `lib/gitlab/pdf/security/group_vulnerabilities_projects_grades.rb` | collapsed_grade_svg（183-195行目） |

**主要処理フロー**:
- **88-123行目**: 基本SVG構造を構築、各グレードを順に処理
- **142-158行目**: 展開グレードのSVG（ドロワー形式）
- **183-195行目**: 折りたたみグレードのSVG

### プログラム呼び出し階層図

```
Gitlab::PDF::Security::GroupVulnerabilitiesProjectsGrades
    │
    ├─ self.render(pdf, data:)
    │      └─ new(pdf, data).render
    │
    ├─ initialize(pdf, data)
    │      └─ process_raw(data)
    │             ├─ グレードソート
    │             └─ sort_projects（上位5件）
    │
    └─ render
           ├─ bounding_box
           │      ├─ fill_rectangle（背景）
           │      ├─ text_box（タイトル・説明）
           │      └─ svg（build_base_svg）
           │             ├─ svg_background_layers
           │             ├─ svg_headers
           │             └─ grades.each
           │                    ├─ expanded_grade_svg
           │                    │      └─ severity_counts_svg
           │                    └─ collapsed_grade_svg
           │
           └─ render_project_names
                  └─ formatted_text_box（リンク）
```

### データフロー図

```
[入力]                      [処理]                        [出力]

フロントエンド ───▶ process_raw ───▶ グレードソート
    │ vulnerability_grades    │             │
    │ expanded_grade          ▼             ▼
    │                    sort_projects   build_base_svg
    │                         │                │
    │                         ▼                ▼
    └─────────────────▶ render_project_names ───▶ PDF出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| group_vulnerabilities_projects_grades.rb | `lib/gitlab/pdf/security/group_vulnerabilities_projects_grades.rb` | ソース | PDF生成クラス |
| prawn gem | - | ライブラリ | PDF生成ライブラリ |
| prawn-svg gem | - | ライブラリ | SVG描画サポート |
