---
generated_at: 2026-01-22 14:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：1-Issue CSV Export

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **出力ファイル名**：ソースコードでの明示的な定義箇所が未確認
  2. **同時出力数上限**：Sidekiq設定に依存するため未確認
  3. **EE拡張機能**：prepend_mod_withの実際の拡張内容は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/services/issues/export_csv_service.rb` 1-71行目
- E-02: `app/services/export_csv/base_service.rb` 1-57行目
- E-03: `app/controllers/projects/issues_controller.rb` 272-279行目
- E-04: `app/controllers/projects/issues_controller.rb` 84-85行目（feature_category定義）
- E-05: `app/controllers/projects/issues_controller.rb` 22行目（authenticate_user!）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CSVエクスポートサービスはExportCsv::BaseServiceを継承 | E-01:4行目 | ○ |
| C-02 | header_to_value_hashで20カラムを定義 | E-01:31-53行目 | ○ |
| C-03 | Title, Description, Issue IDなどのカラム構成 | E-01:32-35行目 | ○ |
| C-04 | State項目はOpen/Closedで表示 | E-01:37行目 | ○ |
| C-05 | Assigneeは複数名をカンマ区切りで出力 | E-01:40行目 | ○ |
| C-06 | Confidential項目はYes/Noで表示 | E-01:42行目 | ○ |
| C-07 | Due Dateはto_fs(:csv)形式で出力 | E-01:44行目 | ○ |
| C-08 | LabelsはソートしてJOIN | E-01:11行目, 56-58行目 | ○ |
| C-09 | Time SpentはTimelogsの合計 | E-01:60-62行目 | ○ |
| C-10 | associations_to_preloadで関連テーブルをプリロード | E-01:20-28行目 | ○ |
| C-11 | emailメソッドでNotify.issues_csv_emailを呼び出し | E-01:14-16行目 | ○ |
| C-12 | TARGET_FILESIZEは15MB | E-02:6行目 | ○ |
| C-13 | csv_builderでCsvBuilderを使用 | E-02:31-41行目 | ○ |
| C-14 | export_csvアクションでIssuableExportCsvWorkerを呼び出し | E-03:273行目 | ○ |
| C-15 | 非同期処理後にリダイレクト | E-03:275-278行目 | ○ |
| C-16 | feature_categoryはimporters | E-04:84行目 | ○ |
| C-17 | urgencyはlow | E-04:85行目 | ○ |
| C-18 | 認証済みユーザーのみexport_csv利用可能 | E-05:22行目 | ○ |
| C-19 | prepend_mod_withで拡張可能 | E-01:70行目 | ○ |
| C-20 | Feature Flag export_csv_preload_in_batchesが存在 | E-01:64-66行目 | ○ |
| C-21 | work_item_typeをプリロード | E-01:22行目 | ○ |
| C-22 | milestoneをプリロード | E-01:26行目 | ○ |
| C-23 | project.namespaceをプリロード | E-01:27行目 | ○ |
| C-24 | GitlabRoutingHelperを使用してURLを生成 | E-01:5-6行目, 36行目 | ○ |
| C-25 | 出力ファイル名はissues_export.csv | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **出力ファイル名**: ソースコードで明示的なファイル名定義が見つからなかった。Notifyクラスまたはメーラーテンプレートで定義されている可能性がある。
  - 候補：`app/mailers/notify.rb` / `app/mailers/emails/` / メーラービューテンプレート

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - CSV出力機能の基本構造は明確に定義されている
- 0: 低リスク - カラム定義はソースコードで完全に確認可能
- 1: 中リスク - EE拡張による追加カラムがある可能性（prepend_mod_with）

## 6) レビュアーチェックリスト（最小）
- [ ] 出力ファイル名の確認（Notifyクラスまたはメーラーテンプレート）
- [ ] EE版での追加カラムがある場合の確認
- [ ] 実際のCSV出力結果とカラム定義の一致確認
- [ ] Time Estimate/Time Spentの単位（秒）が正しいか確認
