---
generated_at: 2026-01-22 14:32:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：2-Merge Request CSV Export

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **export_csvアクションの実装箇所**：コントローラーでの具体的な行番号が未確認
  2. **Approvers機能**：EE拡張による実装の可能性
  3. **ファイルサイズ制限**：BaseServiceからの継承値

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/services/merge_requests/export_csv_service.rb` 1-40行目
- E-02: `app/services/export_csv/base_service.rb` 1-57行目
- E-03: `app/controllers/projects/merge_requests_controller.rb` 19行目（skip_before_action）
- E-04: `app/controllers/projects/merge_requests_controller.rb` 70行目（urgency定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CSVエクスポートサービスはExportCsv::BaseServiceを継承 | E-01:4行目 | ○ |
| C-02 | header_to_value_hashで17カラムを定義 | E-01:14-36行目 | ○ |
| C-03 | Title, Description, MR IIDなどのカラム構成 | E-01:16-18行目 | ○ |
| C-04 | State項目はそのまま出力 | E-01:20行目 | ○ |
| C-05 | Source/Target Branch情報を出力 | E-01:21-22行目 | ○ |
| C-06 | Source/Target Project IDを出力 | E-01:23-24行目 | ○ |
| C-07 | Author情報を出力 | E-01:25-26行目 | ○ |
| C-08 | Assigneesは複数名をカンマ区切りで出力 | E-01:27-28行目 | ○ |
| C-09 | Approversは複数名をカンマ区切りで出力 | E-01:29-30行目 | ○ |
| C-10 | Merged User情報を出力 | E-01:31-32行目 | ○ |
| C-11 | Milestone IDを出力 | E-01:33行目 | ○ |
| C-12 | Created At/Updated Atを出力 | E-01:34-35行目 | ○ |
| C-13 | emailメソッドでNotify.merge_requests_csv_emailを呼び出し | E-01:8-9行目 | ○ |
| C-14 | GitlabRoutingHelperをinclude | E-01:5-6行目 | ○ |
| C-15 | merge_request_urlでURLを生成 | E-01:19行目 | ○ |
| C-16 | metricsからmerged_byを取得 | E-01:31-32行目 | ○ |
| C-17 | approved_by_usersからApproversを取得 | E-01:29-30行目 | ○ |
| C-18 | TARGET_FILESIZEは15MB | E-02:6行目 | ○ |
| C-19 | export_csvアクションはskip_before_actionで除外 | E-03:19行目 | ○ |
| C-20 | export_csvのurgencyはhigh | E-04:70行目 | ○ |
| C-21 | Created At/Updated AtはUTC形式 | E-01:34-35行目 | ○ |
| C-22 | コントローラーでのexport_csv実装詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **export_csvアクションの実装詳細**: コントローラーでの具体的なexport_csvメソッド実装箇所が確認できなかった。親クラスまたはconcernで定義されている可能性がある。
  - 候補：`app/controllers/concerns/` / 親クラス / EE拡張

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - CSV出力機能の基本構造は明確に定義されている
- 0: 低リスク - カラム定義はソースコードで完全に確認可能
- 1: 中リスク - Approvers/Merged User情報の取得ロジックは複雑な関連を持つ

## 6) レビュアーチェックリスト（最小）
- [ ] export_csvアクションの実装箇所確認（親クラスまたはconcern）
- [ ] Approvers機能のEE依存確認
- [ ] Merged User情報が正しく取得されるか確認（metricsテーブル経由）
- [ ] 実際のCSV出力結果とカラム定義の一致確認
