---
generated_at: 2026-01-22 14:35:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：3-Work Items CSV Export

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **Feature Flag制御**：機能の有効/無効を制御するフラグの詳細が未確認
  2. **グループレベルでのエクスポート**：グループWork Itemsのサポート状況
  3. **ウィジェット依存**：有効なウィジェットによる出力内容の変動

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/services/work_items/export_csv_service.rb` 1-102行目
- E-02: `app/services/export_csv/base_service.rb` 1-57行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CSVエクスポートサービスはExportCsv::BaseServiceを継承 | E-01:4行目 | ○ |
| C-02 | NotAvailableErrorを定義 | E-01:8行目 | ○ |
| C-03 | emailメソッドでNotify.export_work_items_csv_emailを呼び出し | E-01:10-11行目 | ○ |
| C-04 | associations_to_preloadでプリロード設定 | E-01:16-18行目 | ○ |
| C-05 | widget_preloadsで関連ウィジェットをプリロード | E-01:20-22行目 | ○ |
| C-06 | ID, IID, Title, Descriptionカラムを出力 | E-01:26-29行目 | ○ |
| C-07 | TypeはWork Item Type名を出力 | E-01:30行目 | ○ |
| C-08 | URLはwork_item_urlで生成 | E-01:31行目 | ○ |
| C-09 | base_metadataをmerge | E-01:32-33行目 | ○ |
| C-10 | author_and_assignees_dataをmerge | E-01:34-35行目 | ○ |
| C-11 | dates_dataをmerge | E-01:36-37行目 | ○ |
| C-12 | parent_item_dataをmerge | E-01:38-39行目 | ○ |
| C-13 | time_tracking_dataをmerge | E-01:40-41行目 | ○ |
| C-14 | StateはOpen/Closedで表示 | E-01:47行目 | ○ |
| C-15 | ConfidentialはYes/Noで表示 | E-01:48行目 | ○ |
| C-16 | LockedはnotesウィジェットのdiscussionLockedを参照 | E-01:49行目 | ○ |
| C-17 | Milestoneはmilestoneウィジェットのtitleを取得 | E-01:50行目 | ○ |
| C-18 | Labelsはlabelsウィジェットから取得してjoin | E-01:51行目 | ○ |
| C-19 | Authorはauthor_nameを使用 | E-01:57行目 | ○ |
| C-20 | Due DateはCSV形式で出力 | E-01:71行目 | ○ |
| C-21 | Start DateはCSV形式で出力 | E-01:72行目 | ○ |
| C-22 | Parent ID/IID/Titleはhierarchyウィジェット経由 | E-01:78-80行目 | ○ |
| C-23 | Time Estimateはhuman_time_estimateを使用 | E-01:86行目 | ○ |
| C-24 | Time Spentはhuman_total_time_spentを使用 | E-01:87行目 | ○ |
| C-25 | widget_value_forでウィジェットから値取得 | E-01:91-97行目 | ○ |
| C-26 | get_widgetでウィジェットを取得 | E-01:92行目 | ○ |
| C-27 | prepend_modで拡張可能 | E-01:101行目 | ○ |
| C-28 | Feature Flagによる機能制御 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **Feature Flag制御**: NotAvailableErrorの存在からFeature Flagによる制御が示唆されるが、具体的なフラグ名や制御箇所が確認できなかった。
  - 候補：`config/feature_flags/` / コントローラーまたはAPIでの`Feature.enabled?`チェック

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ウィジェットベースのアーキテクチャは明確に実装されている
- 1: 中リスク - ウィジェットが無効な場合のカラム値の挙動確認が必要
- 1: 中リスク - 親子関係（hierarchy）がない場合のParent項目の出力確認

## 6) レビュアーチェックリスト（最小）
- [ ] Feature Flagの存在と名前の確認
- [ ] グループレベルでのWork Itemsエクスポートのサポート確認
- [ ] ウィジェットが無効な場合のカラム値（空文字/null）の確認
- [ ] 親Work Itemがない場合のParent項目の出力確認
- [ ] 実際のCSV出力結果とカラム定義の一致確認
