---
generated_at: 2026-01-22 14:38:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-Import Source Users CSV

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. **REASSIGNABLE_STATUSESの具体的な値**：Import::SourceUserモデルで確認推奨
  2. **ユーザーマッピングフローの全体像**：再アップロード処理の確認
  3. **エンドポイントの確認**：コントローラー実装の確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/services/import/source_users/generate_csv_service.rb` 1-68行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FILESIZE_LIMITは10MB | E-01:12行目 | ○ |
| C-02 | COLUMN_MAPPINGで7カラムを定義 | E-01:14-22行目 | ○ |
| C-03 | Source hostカラムはsource_hostname | E-01:15行目 | ○ |
| C-04 | Import typeカラムはimport_type | E-01:16行目 | ○ |
| C-05 | Source user identifierカラムはsource_user_identifier | E-01:17行目 | ○ |
| C-06 | Source user nameカラムはsource_name | E-01:18行目 | ○ |
| C-07 | Source usernameカラムはsource_username | E-01:19行目 | ○ |
| C-08 | GitLab usernameは空文字を返すラムダ | E-01:20行目 | ○ |
| C-09 | GitLab public emailは空文字を返すラムダ | E-01:21行目 | ○ |
| C-10 | initializeでnamespaceとcurrent_userを受け取る | E-01:26-28行目 | ○ |
| C-11 | executeでowner_access権限を確認 | E-01:34行目 | ○ |
| C-12 | ソースユーザーが空の場合エラーを返す | E-01:35行目 | ○ |
| C-13 | 成功時はServiceResponse.successを返す | E-01:37行目 | ○ |
| C-14 | csv_dataでCsvBuilderを使用 | E-01:44-45行目 | ○ |
| C-15 | replace_newlines: trueオプションを使用 | E-01:45行目 | ○ |
| C-16 | REASSIGNABLE_STATUSESでフィルタ | E-01:49行目 | ○ |
| C-17 | by_statusesでステータスフィルタ | E-01:50行目 | ○ |
| C-18 | error_invalid_permissionsでforbiddenを返す | E-01:53-57行目 | ○ |
| C-19 | error_no_source_usersでno_source_usersを返す | E-01:59-63行目 | ○ |
| C-20 | COLUMN_MAPPINGはfreezeされている | E-01:22行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張に根拠が確認できた
- 追加確認推奨事項：
  - REASSIGNABLE_STATUSESの具体的なステータス値（Import::SourceUserモデルで定義）
  - コントローラーでのサービス呼び出し箇所

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - CSV出力機能のロジックは明確に実装されている
- 0: 低リスク - エラーハンドリングが適切に実装されている
- 0: 低リスク - 権限チェックが明確に実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] REASSIGNABLE_STATUSESの具体的な値の確認（Import::SourceUserモデル）
- [ ] コントローラーでのサービス呼び出し箇所の確認
- [ ] 再アップロードによるユーザーマッピング処理の全体フロー確認
- [ ] 10MBファイルサイズ制限の妥当性確認
