---
generated_at: 2026-01-22 14:42:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-Vulnerability History PDF

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  1. **フロントエンドからのSVGデータ形式**：データ渡しの詳細確認推奨
  2. **PDFエクスポートのエンドポイント**：コントローラー実装の確認
  3. **Prawn-SVGの互換性**：使用されるSVG機能の確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/gitlab/pdf/security/project_vulnerabilities_history.rb` 1-130行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Prawn::Viewをinclude | E-01:10行目 | ○ |
| C-02 | SEVERITY_LEGENDで6つの重大度を定義 | E-01:12-18行目 | ○ |
| C-03 | Critical色は660e00 | E-01:13行目 | ○ |
| C-04 | High色はae1800 | E-01:14行目 | ○ |
| C-05 | Medium色は9e5400 | E-01:15行目 | ○ |
| C-06 | Low色はc17d10 | E-01:16行目 | ○ |
| C-07 | Info色は428fdc | E-01:17行目 | ○ |
| C-08 | Unknown色は868686 | E-01:18行目 | ○ |
| C-09 | CSS_TRANSLATIONSで3つのCSS変数変換 | E-01:24-28行目 | ○ |
| C-10 | --gl-chart-axis-line-colorを#ddddddに変換 | E-01:25行目 | ○ |
| C-11 | --gl-text-color-defaultを#333333に変換 | E-01:26行目 | ○ |
| C-12 | --gl-chart-axis-text-colorを#666666に変換 | E-01:27行目 | ○ |
| C-13 | self.renderでインスタンス生成 | E-01:30-32行目 | ○ |
| C-14 | 高さ250px、SVG高さ200pxで初期化 | E-01:37-38行目 | ○ |
| C-15 | データがblankの場合:noopを返す | E-01:44行目 | ○ |
| C-16 | 背景色F9F9F9を描画 | E-01:49行目 | ○ |
| C-17 | タイトル"Vulnerability History"を14pt太字で描画 | E-01:57-61行目 | ○ |
| C-18 | 説明文を10ptで描画 | E-01:65-69行目 | ○ |
| C-19 | SVGを描画 | E-01:76行目 | ○ |
| C-20 | 区切り線を描画 | E-01:82-85行目 | ○ |
| C-21 | 凡例をSEVERITY_LEGEND.each_with_indexで描画 | E-01:93-109行目 | ○ |
| C-22 | process_rawでCGI.unescapeを実行 | E-01:121行目 | ○ |
| C-23 | 正規表現でSVGタグを抽出 | E-01:121行目 | ○ |
| C-24 | CSS_TRANSLATIONS.eachでCSS変数を変換 | E-01:122行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張に根拠が確認できた
- 追加確認推奨事項：
  - PDFエクスポートを呼び出すコントローラーまたはAPIエンドポイント
  - フロントエンドからのSVGデータ形式と渡し方
  - 脆弱性データを取得するGraphQLクエリ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - PDF生成ロジックは明確に実装されている
- 0: 低リスク - 重大度の色定義は明確
- 1: 中リスク - SVGデータの入力検証（XSS等）の確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] PDFエクスポートエンドポイントの確認
- [ ] フロントエンドからのSVGデータ形式の確認
- [ ] SVGデータのサニタイズ処理の確認
- [ ] 実際のPDF出力結果の確認
