---
generated_at: 2026-01-22 14:46:00
metrics:
  claims_total: 26
  claims_with_evidence: 26
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-Group Vulnerability History PDF

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：26 / 26、根拠なし：0
- 優先レビュー（高）
  1. **フロントエンドからのデータ形式**：charts配列の詳細構造確認推奨
  2. **PDFエクスポートのエンドポイント**：コントローラー実装の確認
  3. **日付範囲の算出方法**：date_infoとselected_day_rangeの生成元確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/gitlab/pdf/security/group_vulnerabilities_history.rb` 1-152行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Prawn::Viewをinclude | E-01:10行目 | ○ |
| C-02 | SEVERITY_ICONSで6つの重大度アイコンを定義 | E-01:13-20行目 | ○ |
| C-03 | criticalアイコンはdd2b0e色の六角形 | E-01:14行目 | ○ |
| C-04 | highアイコンはdd2b0e色の菱形 | E-01:15行目 | ○ |
| C-05 | mediumアイコンはfc9403色の三角形 | E-01:16行目 | ○ |
| C-06 | lowアイコンはfc9403色の楕円 | E-01:17行目 | ○ |
| C-07 | infoアイコンは428fdc色の情報マーク | E-01:18行目 | ○ |
| C-08 | unknownアイコンは868686色の疑問符 | E-01:19行目 | ○ |
| C-09 | self.renderでインスタンス生成 | E-01:23-25行目 | ○ |
| C-10 | 幅500px、高さ400pxで初期化 | E-01:32-33行目 | ○ |
| C-11 | アイコンサイズは14x14 | E-01:34行目 | ○ |
| C-12 | chartsがblankの場合:noopを返す | E-01:39行目 | ○ |
| C-13 | 背景色F9F9F9を描画 | E-01:43-46行目 | ○ |
| C-14 | タイトル"Vulnerability History"を16pt太字中央で描画 | E-01:49-56行目 | ○ |
| C-15 | 日付情報を12pt中央で描画 | E-01:59-65行目 | ○ |
| C-16 | draw_table_headerでヘッダー行描画 | E-01:68行目 | ○ |
| C-17 | charts.each_with_indexで行描画 | E-01:69-71行目 | ○ |
| C-18 | ヘッダーにSeverity、%、#を表示 | E-01:82-91行目 | ○ |
| C-19 | 行高さ70px | E-01:101行目 | ○ |
| C-20 | アイコンSVGを描画 | E-01:104-105行目 | ○ |
| C-21 | 重大度名をcapitalizeで表示 | E-01:107-111行目 | ○ |
| C-22 | チャートSVGを幅50%で描画 | E-01:113-114行目 | ○ |
| C-23 | change_in_percentを12pt太字中央で表示 | E-01:116-124行目 | ○ |
| C-24 | current_countを12pt太字中央で表示 | E-01:126-134行目 | ○ |
| C-25 | process_rawでchartsを処理 | E-01:137-147行目 | ○ |
| C-26 | 各チャートのSVGをCGI.unescapeで処理 | E-01:141-143行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張に根拠が確認できた
- 追加確認推奨事項：
  - PDFエクスポートを呼び出すコントローラーまたはAPIエンドポイント
  - フロントエンドからのchartsデータ形式（severity、svg、change_in_percent、current_count）
  - date_infoとselected_day_rangeの生成元

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - PDF生成ロジックは明確に実装されている
- 0: 低リスク - テーブルレイアウトの描画ロジックは明確
- 1: 中リスク - SVGデータの入力検証（XSS等）の確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] PDFエクスポートエンドポイントの確認
- [ ] フロントエンドからのchartsデータ形式の確認
- [ ] 日付範囲情報の生成元確認
- [ ] 実際のPDF出力結果の確認
