---
generated_at: 2026-01-22 14:50:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-Project Security Grades PDF

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  1. **フロントエンドからのデータ形式**：vulnerability_gradesの詳細構造確認推奨
  2. **グレード割り当てロジック**：フロントエンド側でのグレード決定ロジック確認
  3. **セキュリティダッシュボードリンク**：リンク先のURLパス確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/gitlab/pdf/security/group_vulnerabilities_projects_grades.rb` 1-264行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Prawn::Viewをinclude | E-01:10行目 | ○ |
| C-02 | DEFAULT_COUNTSは"0 projects" | E-01:12行目 | ○ |
| C-03 | GRADES_DISPLAY_INFOで5グレードを定義 | E-01:13-19行目 | ○ |
| C-04 | グレードAの色は#16a34a | E-01:14行目 | ○ |
| C-05 | グレードBの色は#f97316、対象はlow | E-01:15行目 | ○ |
| C-06 | グレードCの色は#ea580c、対象はmedium | E-01:16行目 | ○ |
| C-07 | グレードDの色は#b91c1c、対象はhigh/unknown | E-01:17行目 | ○ |
| C-08 | グレードFの色は#991b1b、対象はcritical | E-01:18行目 | ○ |
| C-09 | SVG_STYLESでCSSクラスを定義 | E-01:21-37行目 | ○ |
| C-10 | self.renderでインスタンス生成 | E-01:39-41行目 | ○ |
| C-11 | expanded_gradeのデフォルトは"F" | E-01:46行目 | ○ |
| C-12 | gitlab_host_urlをRailsルートヘルパーから取得 | E-01:47行目 | ○ |
| C-13 | 幅500px、高さ700pxで初期化 | E-01:48-49行目 | ○ |
| C-14 | gradesがblankの場合:noopを返す | E-01:54行目 | ○ |
| C-15 | タイトル"Project security status"を16pt太字中央で描画 | E-01:62-69行目 | ○ |
| C-16 | 説明文を12pt中央で描画 | E-01:71-77行目 | ○ |
| C-17 | build_base_svgでSVGを構築 | E-01:79行目 | ○ |
| C-18 | render_project_namesでプロジェクトリンクを描画 | E-01:82行目 | ○ |
| C-19 | 展開グレード用のexpanded_grade_svg | E-01:114行目, 142-158行目 | ○ |
| C-20 | 折りたたみ用のcollapsed_grade_svg | E-01:117-118行目, 183-195行目 | ○ |
| C-21 | 展開ドロワー高さは(projects.count * 45) + 80 | E-01:101行目 | ○ |
| C-22 | 折りたたみ高さは40px | E-01:118行目 | ○ |
| C-23 | severity_counts_svgで重大度別件数表示 | E-01:160-181行目 | ○ |
| C-24 | formatted_text_boxでプロジェクトリンク描画 | E-01:202-210行目 | ○ |
| C-25 | リンク色は2563eb | E-01:203行目 | ○ |
| C-26 | process_rawでグレードをソート | E-01:218-219行目 | ○ |
| C-27 | sort_projectsで上位5件を抽出 | E-01:241-255行目 | ○ |
| C-28 | グレード順はF→D→C→B→A | E-01:218行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張に根拠が確認できた
- 追加確認推奨事項：
  - PDFエクスポートを呼び出すコントローラーまたはAPIエンドポイント
  - フロントエンドからのvulnerability_gradesデータ形式
  - セキュリティダッシュボードパスの形式

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - PDF生成ロジックは明確に実装されている
- 0: 低リスク - グレード定義は明確
- 1: 中リスク - プロジェクトリンクの生成とセキュリティ確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] PDFエクスポートエンドポイントの確認
- [ ] フロントエンドからのvulnerability_gradesデータ形式の確認
- [ ] プロジェクトリンク（securityDashboardPath）の権限確認
- [ ] 実際のPDF出力結果の確認
