---
generated_at: 2026-01-22 09:15:00
metrics:
  claims_total: 71
  claims_with_evidence: 68
  claims_without_evidence: 3
confidence_derived: 0.96
---

# 根拠レポート：業務要件一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：68 / 71、根拠なし：3
- 優先レビュー（高）
  1. **BR-057 Terraform State管理機能**：Terraform専用サービスの詳細確認が必要
  2. **BR-066 組織管理機能**：組織機能は比較的新しく、実装の完全性確認が必要
  3. **BR-069 Wiki管理機能**：Wikiコントローラーの詳細実装未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/application_controller.rb`
- E-02: `app/controllers/sessions_controller.rb`
- E-03: `app/controllers/registrations_controller.rb`
- E-04: `app/controllers/projects_controller.rb`
- E-05: `app/controllers/groups_controller.rb`
- E-06: `app/controllers/projects/issues_controller.rb`
- E-07: `app/controllers/projects/merge_requests_controller.rb`
- E-08: `app/services/projects/create_service.rb`
- E-09: `app/services/groups/create_service.rb`
- E-10: `app/services/issues/create_service.rb`
- E-11: `app/services/merge_requests/create_service.rb`
- E-12: `app/models/project.rb`
- E-13: `app/models/merge_request.rb`
- E-14: `app/models/issue.rb`
- E-15: `app/models/ci/pipeline.rb`
- E-16: `app/models/deployment.rb`
- E-17: `app/models/user.rb`
- E-18: `app/controllers/omniauth_callbacks_controller.rb`
- E-19: `app/services/auto_merge/merge_when_checks_pass_service.rb`
- E-20: `app/services/spam/spam_action_service.rb`
- E-21: `app/services/audit_events/build_service.rb`
- E-22: `app/services/organizations/create_service.rb`
- E-23: `app/services/snippets/create_service.rb`
- E-24: `app/services/releases/create_service.rb`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BR-001 ユーザー認証機能 | E-02, E-18 | ○ |
| C-02 | BR-002 ユーザー登録機能 | E-03 | ○ |
| C-03 | BR-003 パスワード管理機能 | E-01, E-02 | ○ |
| C-04 | BR-004 セッション管理機能 | E-02 | ○ |
| C-05 | BR-005 二要素認証機能 | E-02 | ○ |
| C-06 | BR-006 プロジェクト作成機能 | E-04, E-08 | ○ |
| C-07 | BR-007 プロジェクト編集・更新機能 | E-04 | ○ |
| C-08 | BR-008 プロジェクト削除機能 | E-04 | ○ |
| C-09 | BR-009 プロジェクト移管機能 | E-04 | ○ |
| C-10 | BR-010 プロジェクトアーカイブ機能 | E-04 | ○ |
| C-11 | BR-011 プロジェクトエクスポート機能 | E-04 | ○ |
| C-12 | BR-012 グループ作成機能 | E-05, E-09 | ○ |
| C-13 | BR-013 グループ編集・更新機能 | E-05 | ○ |
| C-14 | BR-014 グループ削除機能 | E-05 | ○ |
| C-15 | BR-015 グループ移管機能 | E-05 | ○ |
| C-16 | BR-016 グループエクスポート機能 | E-05 | ○ |
| C-17 | BR-017 イシュー作成機能 | E-06, E-10 | ○ |
| C-18 | BR-018 イシュー編集・更新機能 | E-06 | ○ |
| C-19 | BR-019 イシュー移動機能 | E-06 | ○ |
| C-20 | BR-020 イシュー削除機能 | E-06 | ○ |
| C-21 | BR-021 イシューCSVインポート機能 | E-06 | ○ |
| C-22 | BR-022 イシューCSVエクスポート機能 | E-06 | ○ |
| C-23 | BR-023 イシューとブランチの関連付け機能 | E-06 | ○ |
| C-24 | BR-024 マージリクエスト作成機能 | E-07, E-11 | ○ |
| C-25 | BR-025 マージリクエスト編集・更新機能 | E-07 | ○ |
| C-26 | BR-026 マージリクエストマージ機能 | E-07 | ○ |
| C-27 | BR-027 自動マージ機能 | E-07, E-19 | ○ |
| C-28 | BR-028 リベース機能 | E-07 | ○ |
| C-29 | BR-029 差分・コミット表示機能 | E-07 | ○ |
| C-30 | BR-030 マージリクエストレポート機能 | E-07 | ○ |
| C-31 | BR-031 パイプライン実行機能 | E-15 | ○ |
| C-32 | BR-032 パイプライン状態管理機能 | E-15 | ○ |
| C-33 | BR-033 ジョブ実行機能 | E-15 | ○ |
| C-34 | BR-034 アーティファクト管理機能 | E-15 | ○ |
| C-35 | BR-035 デプロイメント作成機能 | E-16 | ○ |
| C-36 | BR-036 デプロイメント状態管理機能 | E-16 | ○ |
| C-37 | BR-037 環境管理機能 | E-16 | ○ |
| C-38 | BR-038 ブランチ管理機能 | E-04 | ○ |
| C-39 | BR-039 タグ管理機能 | E-04 | ○ |
| C-40 | BR-040 ファイル操作機能 | E-08 | ○ |
| C-41 | BR-041 コミット操作機能 | E-08 | ○ |
| C-42 | BR-042 リリース作成機能 | E-24 | ○ |
| C-43 | BR-043 リリース編集・削除機能 | E-24 | ○ |
| C-44 | BR-044 コメント・ディスカッション機能 | E-13, E-14 | ○ |
| C-45 | BR-045 レビュアー・担当者管理機能 | E-13, E-14 | ○ |
| C-46 | BR-046 ラベル管理機能 | E-13, E-14 | ○ |
| C-47 | BR-047 マイルストーン管理機能 | E-13, E-14 | ○ |
| C-48 | BR-048 ToDo管理機能 | E-13, E-14 | ○ |
| C-49 | BR-049 絵文字リアクション機能 | E-07 | ○ |
| C-50 | BR-050 メール通知機能 | E-03 | ○ |
| C-51 | BR-051 Webhook通知機能 | E-08 | ○ |
| C-52 | BR-052 プロジェクトメンバー管理機能 | E-08 | ○ |
| C-53 | BR-053 グループメンバー管理機能 | E-09 | ○ |
| C-54 | BR-054 可視性レベル管理機能 | E-08, E-09 | ○ |
| C-55 | BR-055 招待機能 | E-03 | ○ |
| C-56 | BR-056 サービスインテグレーション機能 | E-08 | ○ |
| C-57 | BR-057 Terraform State管理機能 | **根拠不足** | △ |
| C-58 | BR-058 グローバル検索機能 | E-14 | ○ |
| C-59 | BR-059 監査イベント記録機能 | E-21 | ○ |
| C-60 | BR-060 認証イベント記録機能 | E-02 | ○ |
| C-61 | BR-061 スパム検出・防止機能 | E-10, E-20 | ○ |
| C-62 | BR-062 インシデント作成・管理機能 | E-10 | ○ |
| C-63 | BR-063 サービスデスク機能 | E-06 | ○ |
| C-64 | BR-064 レートリミット機能 | E-01, E-10 | ○ |
| C-65 | BR-065 利用規約同意管理機能 | E-01, E-03 | ○ |
| C-66 | BR-066 組織作成・管理機能 | **根拠不足** | △ |
| C-67 | BR-067 ワークアイテム管理機能 | E-14 | ○ |
| C-68 | BR-068 スニペット管理機能 | E-23 | ○ |
| C-69 | BR-069 Wiki管理機能 | **根拠不足** | △ |
| C-70 | BR-070 ユーザープロフィール管理機能 | E-01 | ○ |
| C-71 | BR-071 アカウント削除機能 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- **BR-057 Terraform State管理機能**：Terraformサービスのコントローラー・サービス層の詳細確認が必要
  - 候補：`app/services/terraform/` / `app/controllers/terraform/` / `app/models/terraform/`
- **BR-066 組織管理機能**：Organizations機能は比較的新しい機能であり、完全な実装確認が必要
  - 候補：`app/services/organizations/` / `app/controllers/organizations/` / `app/models/organizations/`
- **BR-069 Wiki管理機能**：WikiコントローラーとWikiPageモデルの詳細な実装確認が必要
  - 候補：`app/controllers/projects/wikis_controller.rb` / `app/models/wiki.rb` / `app/models/wiki_page/`

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 認証・認可機能（BR-001〜BR-005）：コードベースに十分な根拠あり
- **0: 低リスク** - プロジェクト管理機能（BR-006〜BR-011）：コードベースに十分な根拠あり
- **0: 低リスク** - イシュー・マージリクエスト管理機能（BR-017〜BR-030）：コードベースに十分な根拠あり
- **0: 低リスク** - CI/CD機能（BR-031〜BR-037）：コードベースに十分な根拠あり
- **1: 中リスク** - Terraform State管理機能（BR-057）：サービス層の詳細未確認
- **1: 中リスク** - 組織管理機能（BR-066）：新しい機能のため実装完全性要確認
- **1: 中リスク** - Wiki管理機能（BR-069）：コントローラー詳細未確認

## 6) レビュアーチェックリスト（最小）
- [ ] 認証・認可カテゴリ（BR-001〜BR-005）の要件がセキュリティポリシーと整合しているか確認
- [ ] プロジェクト/グループ管理カテゴリ（BR-006〜BR-016）の削除・移管フローがデータ保護要件を満たしているか確認
- [ ] マージリクエスト管理カテゴリ（BR-024〜BR-030）の自動マージ条件が適切に定義されているか確認
- [ ] CI/CDカテゴリ（BR-031〜BR-037）のパイプライン状態遷移が業務フローと一致しているか確認
- [ ] 監査カテゴリ（BR-059〜BR-060）のイベント記録がコンプライアンス要件を満たしているか確認
- [ ] 根拠不足の3項目（BR-057, BR-066, BR-069）について追加調査が必要か判断
- [ ] 優先度の設定（高/中/低）がビジネス優先度と一致しているか確認
