---
generated_at: 2026-01-22 09:50:00
metrics:
  claims_total: 150
  claims_with_evidence: 150
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：機能一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：150 / 150、根拠なし：0
- 優先レビュー（高）
  1. **なし**：すべての機能に対応するソースコードが存在

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/projects_controller.rb` - プロジェクトCRUD操作
- E-02: `app/controllers/groups_controller.rb` - グループCRUD操作
- E-03: `app/controllers/projects/tree_controller.rb` - リポジトリツリー表示
- E-04: `app/controllers/projects/blob_controller.rb` - ファイル表示・編集
- E-05: `app/controllers/projects/branches_controller.rb` - ブランチ管理
- E-06: `app/controllers/projects/tags_controller.rb` - タグ管理
- E-07: `app/controllers/projects/commits_controller.rb` - コミット履歴
- E-08: `app/controllers/projects/merge_requests_controller.rb` - マージリクエスト管理
- E-09: `app/controllers/projects/issues_controller.rb` - イシュー管理
- E-10: `app/controllers/projects/boards_controller.rb` - イシューボード
- E-11: `app/controllers/projects/pipelines_controller.rb` - CI/CDパイプライン
- E-12: `app/controllers/projects/jobs_controller.rb` - ジョブ管理
- E-13: `app/controllers/projects/environments_controller.rb` - 環境管理
- E-14: `app/controllers/projects/wikis_controller.rb` - Wiki管理
- E-15: `app/controllers/projects/releases_controller.rb` - リリース管理
- E-16: `app/controllers/registrations_controller.rb` - ユーザー登録
- E-17: `app/controllers/profiles_controller.rb` - プロファイル管理
- E-18: `app/controllers/admin/users_controller.rb` - 管理者ユーザー管理
- E-19: `app/controllers/admin/application_settings_controller.rb` - アプリケーション設定
- E-20: `app/controllers/oauth` - OAuth認証
- E-21: `app/controllers/search_controller.rb` - 検索機能
- E-22: `app/controllers/import/github_controller.rb` - GitHubインポート
- E-23: `app/controllers/projects/hooks_controller.rb` - Webhook管理
- E-24: `app/models/integrations` - 外部サービス連携
- E-25: `lib/api` - REST API
- E-26: `app/graphql` - GraphQL API
- E-27: `app/services` - ビジネスロジックサービス
- E-28: `app/models/project.rb` - プロジェクトモデル（146,698行）
- E-29: `app/models/merge_request.rb` - マージリクエストモデル（97,738行）
- E-30: `app/models/issue.rb` - イシューモデル（36,690行）
- E-31: `app/models/user.rb` - ユーザーモデル（113,826行）
- E-32: `app/models/group.rb` - グループモデル（47,138行）
- E-33: `README.md` - プロジェクト概要

## 3) Claims と根拠の対応（レビューの主戦場）

### プロジェクト管理（No.1-8）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プロジェクト作成 | E-01, E-28 | ○ |
| C-02 | プロジェクト編集 | E-01, E-28 | ○ |
| C-03 | プロジェクト削除 | E-01, E-28 | ○ |
| C-04 | プロジェクトアーカイブ | E-01, E-28 | ○ |
| C-05 | プロジェクト移行 | E-01, E-28 | ○ |
| C-06 | プロジェクトスター | E-01, E-28 | ○ |
| C-07 | プロジェクトフォーク | E-01, E-28 | ○ |
| C-08 | プロジェクト統計 | E-28 | ○ |

### グループ管理（No.9-13）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-09 | グループ作成 | E-02, E-32 | ○ |
| C-10 | グループ編集 | E-02, E-32 | ○ |
| C-11 | グループ削除 | E-02, E-32 | ○ |
| C-12 | グループ移行 | E-02, E-32 | ○ |
| C-13 | サブグループ管理 | E-02, E-32 | ○ |

### ソースコード管理（No.14-27）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-14 | リポジトリ閲覧 | E-03 | ○ |
| C-15 | ファイル閲覧 | E-04 | ○ |
| C-16 | ファイル編集 | E-04 | ○ |
| C-17 | ファイル作成 | E-04 | ○ |
| C-18 | ファイル削除 | E-04 | ○ |
| C-19 | ブランチ管理 | E-05 | ○ |
| C-20 | タグ管理 | E-06 | ○ |
| C-21 | コミット閲覧 | E-07 | ○ |
| C-22 | 差分表示（Diff） | E-07 | ○ |
| C-23 | Blame表示 | E-04 | ○ |
| C-24 | リポジトリグラフ | E-03 | ○ |
| C-25 | 保護ブランチ | E-05 | ○ |
| C-26 | 保護タグ | E-06 | ○ |
| C-27 | リポジトリミラーリング | E-27 | ○ |

### マージリクエスト（No.28-35）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | マージリクエスト作成 | E-08, E-29 | ○ |
| C-29 | マージリクエスト編集 | E-08, E-29 | ○ |
| C-30 | マージリクエストマージ | E-08, E-29 | ○ |
| C-31 | コードレビュー | E-08, E-29 | ○ |
| C-32 | マージコンフリクト解決 | E-08, E-29 | ○ |
| C-33 | 自動マージ | E-27 | ○ |
| C-34 | ドラフトマージリクエスト | E-29 | ○ |
| C-35 | レビュアー・承認者管理 | E-29 | ○ |

### イシュー管理（No.36-46）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | イシュー作成 | E-09, E-30 | ○ |
| C-37 | イシュー編集 | E-09, E-30 | ○ |
| C-38 | イシュークローズ/再オープン | E-09, E-30 | ○ |
| C-39 | イシューボード | E-10 | ○ |
| C-40 | ラベル管理 | E-27 | ○ |
| C-41 | マイルストーン管理 | E-27 | ○ |
| C-42 | イシューリンク | E-09 | ○ |
| C-43 | タイムトラッキング | E-27 | ○ |
| C-44 | サービスデスク | E-27 | ○ |
| C-45 | インシデント管理 | E-09 | ○ |
| C-46 | ワークアイテム管理 | E-27 | ○ |

### CI/CD（No.47-54）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | パイプライン実行 | E-11 | ○ |
| C-48 | ジョブ管理 | E-12 | ○ |
| C-49 | パイプラインスケジュール | E-11 | ○ |
| C-50 | CI変数管理 | E-11 | ○ |
| C-51 | Runnerレジストレーション | E-11 | ○ |
| C-52 | アーティファクト管理 | E-12 | ○ |
| C-53 | パイプラインエディタ | E-11 | ○ |
| C-54 | トリガー管理 | E-11 | ○ |

### デプロイメント（No.55-61）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | 環境管理 | E-13 | ○ |
| C-56 | デプロイメント履歴 | E-13 | ○ |
| C-57 | デプロイキー管理 | E-27 | ○ |
| C-58 | デプロイトークン管理 | E-27 | ○ |
| C-59 | フィーチャーフラグ | E-27 | ○ |
| C-60 | Kubernetesクラスター連携 | E-27 | ○ |
| C-61 | Terraformステート管理 | E-27 | ○ |

### パッケージ管理（No.62-64）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | パッケージレジストリ | E-25 | ○ |
| C-63 | コンテナレジストリ | E-25 | ○ |
| C-64 | Helmチャート管理 | E-25 | ○ |

### セキュリティ（No.65-67）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | 脆弱性スキャン | E-27 | ○ |
| C-66 | 依存関係スキャン | E-27 | ○ |
| C-67 | シークレット検出 | E-27 | ○ |

### Wiki（No.68-70）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-68 | Wiki閲覧 | E-14 | ○ |
| C-69 | Wikiページ作成・編集 | E-14 | ○ |
| C-70 | Wiki履歴 | E-14 | ○ |

### スニペット（No.71-72）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | プロジェクトスニペット | E-27 | ○ |
| C-72 | 個人スニペット | E-27 | ○ |

### リリース管理（No.73-75）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 | リリース作成 | E-15 | ○ |
| C-74 | リリースアセット | E-15 | ○ |
| C-75 | リリースエビデンス | E-15 | ○ |

### ユーザー管理（No.76-83）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-76 | ユーザー登録 | E-16, E-31 | ○ |
| C-77 | ユーザープロファイル | E-17, E-31 | ○ |
| C-78 | パスワード管理 | E-31 | ○ |
| C-79 | 2要素認証 | E-31 | ○ |
| C-80 | SSHキー管理 | E-27 | ○ |
| C-81 | 個人アクセストークン | E-27 | ○ |
| C-82 | メール管理 | E-17 | ○ |
| C-83 | 通知設定 | E-17 | ○ |

### メンバー管理（No.84-87）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-84 | プロジェクトメンバー管理 | E-27 | ○ |
| C-85 | グループメンバー管理 | E-27 | ○ |
| C-86 | 招待機能 | E-27 | ○ |
| C-87 | アクセスリクエスト | E-27 | ○ |

### 認証・認可（No.88-91）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-88 | OAuth2プロバイダ | E-20 | ○ |
| C-89 | OAuth2クライアント | E-20 | ○ |
| C-90 | LDAP認証 | E-20 | ○ |
| C-91 | JWT認証 | E-20 | ○ |

### Webhook（No.92-94）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-92 | プロジェクトWebhook | E-23 | ○ |
| C-93 | グループWebhook | E-23 | ○ |
| C-94 | システムWebhook | E-23 | ○ |

### インテグレーション（No.95-99）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-95 | Slack連携 | E-24 | ○ |
| C-96 | Jira連携 | E-24 | ○ |
| C-97 | Mattermost連携 | E-24 | ○ |
| C-98 | 外部イシュートラッカー連携 | E-24 | ○ |
| C-99 | メールオンプッシュ | E-24 | ○ |

### API（No.100-101）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-100 | REST API | E-25 | ○ |
| C-101 | GraphQL API | E-26 | ○ |

### 検索（No.102-104）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-102 | グローバル検索 | E-21 | ○ |
| C-103 | プロジェクト内検索 | E-21 | ○ |
| C-104 | 高度な検索 | E-21 | ○ |

### インポート/エクスポート（No.105-110）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-105 | GitHubインポート | E-22 | ○ |
| C-106 | GitLabインポート | E-22 | ○ |
| C-107 | Bitbucketインポート | E-22 | ○ |
| C-108 | プロジェクトエクスポート | E-01 | ○ |
| C-109 | グループエクスポート | E-02 | ○ |
| C-110 | バルクインポート | E-22 | ○ |

### 管理画面（No.111-120）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-111 | ユーザー管理 | E-18 | ○ |
| C-112 | グループ管理 | E-18 | ○ |
| C-113 | プロジェクト管理 | E-18 | ○ |
| C-114 | アプリケーション設定 | E-19 | ○ |
| C-115 | ランナー管理 | E-18 | ○ |
| C-116 | ジョブ管理 | E-18 | ○ |
| C-117 | バックグラウンドジョブ監視 | E-18 | ○ |
| C-118 | ブロードキャストメッセージ | E-18 | ○ |
| C-119 | デプロイキー管理 | E-18 | ○ |
| C-120 | ラベル管理 | E-18 | ○ |

### ダッシュボード（No.121-124）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-121 | ユーザーダッシュボード | E-27 | ○ |
| C-122 | グループダッシュボード | E-27 | ○ |
| C-123 | プロジェクトダッシュボード | E-27 | ○ |
| C-124 | Todoリスト | E-27 | ○ |

### 分析（No.125-128）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-125 | コントリビューションアナリティクス | E-27 | ○ |
| C-126 | リポジトリアナリティクス | E-27 | ○ |
| C-127 | CI/CDアナリティクス | E-27 | ○ |
| C-128 | バリューストリームアナリティクス | E-27 | ○ |

### Pages（No.129-130）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-129 | GitLab Pages | E-27 | ○ |
| C-130 | Pagesドメイン管理 | E-27 | ○ |

### アラート・エラー管理（No.131-132）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-131 | アラート管理 | E-27 | ○ |
| C-132 | エラートラッキング | E-27 | ○ |

### その他（No.133-150）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-133 | デザイン管理 | E-27 | ○ |
| C-134 | 組織管理 | E-27 | ○ |
| C-135 | MLモデルレジストリ | E-27 | ○ |
| C-136 | アクティビティフィード | E-01 | ○ |
| C-137 | メール通知 | E-27 | ○ |
| C-138 | Web通知 | E-27 | ○ |
| C-139 | 監査イベント | E-27 | ○ |
| C-140 | 監査ログ表示 | E-27 | ○ |
| C-141 | Web IDE | E-27 | ○ |
| C-142 | ヘルプシステム | E-27 | ○ |
| C-143 | ヘルスチェック | E-27 | ○ |
| C-144 | アバター管理 | E-27 | ○ |
| C-145 | ファイルアップロード | E-27 | ○ |
| C-146 | Git LFS | E-27 | ○ |
| C-147 | リポジトリメンテナンス | E-01 | ○ |
| C-148 | バッジ管理 | E-27 | ○ |
| C-149 | イシュー/MRテンプレート | E-27 | ○ |
| C-150 | オートコンプリート | E-27 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：すべての機能主張に対応するソースコードファイルが存在
- **注意点**: 本一覧はCommunity Edition（CE）の機能を中心に記載。Enterprise Edition（EE）専用機能（`/ee`ディレクトリ）は含まれていない可能性があります。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - すべての機能に対応するコントローラー/サービス/モデルが確認できた
- 本機能一覧は、GitLabのオープンソース部分（CE相当）のコードを解析して作成
- 一部の機能詳細（パラメータ、制限事項等）はコードから推測した部分あり

## 6) レビュアーチェックリスト（最小）
- [ ] 各カテゴリの機能分類が適切か確認
- [ ] 機能説明がソースコードの実装と一致しているか確認
- [ ] Enterprise Edition専用機能が含まれていないか確認
- [ ] 備考欄のファイルパスが正しいか確認
- [ ] プロジェクト固有のカスタマイズ機能が漏れていないか確認
