# 機能設計書 100-REST API

## 概要

本ドキュメントは、GitLabにおけるREST API機能の設計仕様を記載する。本機能は、GitLabの全機能に対するプログラマティックなアクセスを提供するRESTfulなWeb APIを実装する。

### 本機能の処理概要

REST API機能は、Grapeフレームワーク上に構築され、GitLabの全リソースに対するCRUD操作を提供する。OAuth 2.0、Personal Access Token、Deploy Token等の複数の認証方式をサポートし、スコープベースのアクセス制御を実装する。

**業務上の目的・背景**：GitLabの機能をWebインターフェース以外からも利用可能にし、自動化スクリプト、CI/CDパイプライン、サードパーティ連携、カスタムツール等からの操作を可能にする。

**機能の利用シーン**：本機能は以下のシーンで利用される。
- CI/CDパイプラインからのGitLab操作
- カスタムスクリプトによる一括処理
- IDE拡張機能（VS Code、JetBrains等）からのアクセス
- サードパーティツールとの連携
- ボット・自動化システムの構築

**主要な処理内容**：
1. 認証・認可処理
2. リクエストパラメータのバリデーション
3. ビジネスロジックの実行
4. レスポンスのシリアライズ
5. エラーハンドリング
6. レート制限

**関連システム・外部連携**：外部クライアント、CI/CDシステム、IDE拡張機能

**権限による制御**：エンドポイントごとに異なる権限が必要。スコープによるアクセス制限。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | API経由のアクセス | 全画面 | APIと画面は同じリソースを操作 |

## 機能種別

プラットフォーム / Web API

## 入力仕様

### 認証方式

| 認証方式 | 説明 | ヘッダー/パラメータ |
|---------|------|-------------------|
| Personal Access Token | 個人アクセストークン | PRIVATE-TOKEN ヘッダー |
| OAuth 2.0 Access Token | OAuth認証トークン | Authorization: Bearer ヘッダー |
| Job Token | CI/CDジョブトークン | JOB-TOKEN ヘッダー |
| Deploy Token | デプロイトークン | DEPLOY-TOKEN ヘッダー |
| HTTP Basic Auth | 基本認証 | Authorization: Basic |

### 入力パラメータ（共通）

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|-----|-----|------|
| per_page | Integer | No | ページあたりの件数（デフォルト: 20） |
| page | Integer | No | ページ番号（デフォルト: 1） |
| sudo | Integer/String | No | 管理者のみ、他ユーザーとして実行 |

### 入力データソース

- HTTPリクエスト（GET, POST, PUT, PATCH, DELETE）
- クエリパラメータ
- リクエストボディ（JSON）
- HTTPヘッダー

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| JSON応答 | Object/Array | リソースデータ |
| ページネーションヘッダー | Header | X-Page, X-Per-Page, X-Total, X-Total-Pages等 |
| エラー応答 | Object | message, errorsフィールド |

### HTTPステータスコード

| コード | 意味 |
|--------|------|
| 200 | 成功（GET/PUT/PATCH） |
| 201 | 作成成功（POST） |
| 204 | 削除成功（DELETE） |
| 400 | 不正なリクエスト |
| 401 | 認証エラー |
| 403 | 権限エラー |
| 404 | リソース未検出 |
| 409 | 競合（ロック） |
| 422 | バリデーションエラー |
| 429 | レート制限超過 |
| 500 | サーバーエラー |
| 503 | サービス利用不可 |

## 処理フロー

### 処理シーケンス

```
1. リクエスト受信
   └─ Rackミドルウェアスタック

2. 認証処理
   └─ APIGuard (OAuth2, PAT, Job Token等)

3. 認可処理
   └─ スコープ検証、権限チェック

4. パラメータ処理
   └─ Grapeによるパース・バリデーション

5. ビジネスロジック
   └─ サービスクラス、モデル操作

6. シリアライズ
   └─ Grape::Entity

7. レスポンス返却
   └─ JSONフォーマット
```

### フローチャート

```mermaid
flowchart TD
    A[HTTPリクエスト] --> B[Rackミドルウェア]
    B --> C[APIGuard認証]
    C --> D{認証成功?}
    D -->|No| E[401 Unauthorized]
    D -->|Yes| F[スコープ検証]
    F --> G{スコープOK?}
    G -->|No| H[403 Forbidden]
    G -->|Yes| I[パラメータバリデーション]
    I --> J{バリデーションOK?}
    J -->|No| K[400/422 Error]
    J -->|Yes| L[ビジネスロジック実行]
    L --> M{成功?}
    M -->|No| N[エラーレスポンス]
    M -->|Yes| O[シリアライズ]
    O --> P[JSON応答]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-100-01 | APIバージョン | V4のみサポート（V3は410エラー） | 全リクエスト |
| BR-100-02 | ページネーション | デフォルト20件、最大100件 | リスト取得 |
| BR-100-03 | APIスコープ | `api`スコープで全API、`read_api`でGET/HEADのみ | 認証時 |
| BR-100-04 | Sudo | 管理者のみ、他ユーザーとして操作可能 | sudo パラメータ指定時 |
| BR-100-05 | セキュリティヘッダー | X-Frame-Options, X-Content-Type-Options設定 | 全レスポンス |
| BR-100-06 | ロケール | 認証ユーザーの言語設定を適用 | 認証後 |
| BR-100-07 | 2FA必須 | 2FA猶予期間切れはアクセス拒否 | 2FA必須設定時 |

### スコープ一覧

| スコープ | 説明 |
|---------|------|
| api | 全API操作 |
| read_api | GET/HEADのみ |
| read_user | ユーザー情報読み取り |
| read_repository | リポジトリ読み取り |
| write_repository | リポジトリ書き込み |
| admin_mode | 管理者モード |

### 主要エンドポイントカテゴリ

| カテゴリ | パス | 説明 |
|---------|------|------|
| Projects | /api/v4/projects | プロジェクト操作 |
| Groups | /api/v4/groups | グループ操作 |
| Users | /api/v4/users | ユーザー操作 |
| Merge Requests | /api/v4/merge_requests | MR操作 |
| Issues | /api/v4/issues | イシュー操作 |
| Pipelines | /api/v4/projects/:id/pipelines | パイプライン操作 |
| Jobs | /api/v4/projects/:id/jobs | ジョブ操作 |
| Repositories | /api/v4/projects/:id/repository | リポジトリ操作 |

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 認証 | personal_access_tokens | SELECT | トークン検証 |
| 認証 | oauth_access_tokens | SELECT | OAuth検証 |
| 認証 | deploy_tokens | SELECT | デプロイトークン検証 |
| 各操作 | 対象リソーステーブル | CRUD | リソースに応じた操作 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 401 | MissingTokenError | トークン未提供 | トークンを付与 |
| 401 | TokenNotFoundError | トークンが無効 | 有効なトークンを使用 |
| 401 | ExpiredError | トークン期限切れ | トークンを更新 |
| 401 | RevokedError | トークン取り消し済み | 新規トークンを発行 |
| 403 | InsufficientScopeError | スコープ不足 | 適切なスコープのトークンを使用 |
| 403 | AccessDeniedError | 権限なし | 権限を確認 |
| 409 | StaleObjectError | リソースロック | 再試行 |
| 429 | RateLimitedError | レート制限超過 | 待機後再試行 |

## セキュリティ考慮事項

- **認証トークン保護**：トークンは暗号化保存、ログからマスク
- **HTTPS必須**：本番環境ではHTTPS推奨
- **セキュリティヘッダー**：X-Frame-Options, X-Content-Type-Options, CSP
- **レート制限**：過剰なリクエストを制限
- **スコープ制限**：最小権限の原則
- **2FA検証**：設定に応じて2FA検証
- **IP制限**：TooManyIpsエラーでブルートフォース防止

## 備考

- Grapeフレームワーク（Ruby）ベース
- JSONフォーマットのみサポート
- ログは`log/api_json.log`に出力
- IDE拡張機能の使用状況を追跡（VS Code, JetBrains等）
- 内部API（/api/v4/internal/*）は別途認証

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: APIエントリーポイント

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | api.rb | `lib/api/api.rb` | APIのメインエントリーポイント |

**主要処理フロー**:
- **4-6行目**: API::Baseを継承、APIGuard、OpenApiをinclude
- **10-19行目**: ログ設定（api_json.log）
- **53-54行目**: allow_access_with_scope（api, read_api）
- **55行目**: prefix :api
- **57-61行目**: V3は410エラー
- **63行目**: V4バージョン設定
- **65-74行目**: beforeフック（セキュリティヘッダー、CSP）
- **76-97行目**: beforeフック（ApplicationContext設定）
- **130-191行目**: rescue_from（エラーハンドリング）
- **193-203行目**: JSON設定、ヘルパー
- **213-412行目**: エンドポイントのマウント

#### Step 2: 認証・認可

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | api_guard.rb | `lib/api/api_guard.rb` | 認証ガード |

**主要処理フロー**:
- **14-19行目**: Rack::OAuth2使用
- **36-44行目**: allow_access_with_scope（スコープ登録）
- **51-55行目**: access_token取得
- **57-71行目**: find_current_user!（ユーザー認証）
- **73-85行目**: find_user_from_sources（認証元の優先順位）
- **117-119行目**: api_access_allowed?（APIアクセス許可判定）
- **178-186行目**: エラークラス定義

#### Step 3: ヘルパー

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | helpers.rb | `lib/api/helpers.rb` | 共通ヘルパー |

**主要処理フロー**:
- **14-16行目**: SUDO_HEADER, SUDO_PARAM定義
- **81-100行目**: current_user（認証ユーザー取得）
- **30-33行目**: declared_params（パラメータ取得）
- **47-60行目**: destroy_conditionally!（条件付き削除）

#### Step 4: 個別エンドポイント例

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | projects.rb | `lib/api/projects.rb` | プロジェクトAPI |
| 4-2 | issues.rb | `lib/api/issues.rb` | イシューAPI |
| 4-3 | merge_requests.rb | `lib/api/merge_requests.rb` | MR API |

### プログラム呼び出し階層図

```
HTTPリクエスト
    |
    +-- Rack ミドルウェアスタック
            |
            +-- Gitlab::Middleware::IpAddress
            +-- GrapeLogging::Middleware::RequestLogger
            +-- Rack::OAuth2::Server::Resource::Bearer
            +-- API::APIGuard::AdminModeMiddleware
            +-- API::APIGuard::ResponseCoercerMiddleware
                    |
                    +-- API::API
                            |
                            +-- before hooks (認証、セキュリティヘッダー)
                            |
                            +-- 各エンドポイント (API::Projects, API::Issues等)
                                    |
                                    +-- API::Helpers (共通処理)
                                    +-- Services (ビジネスロジック)
                                    +-- Grape::Entity (シリアライズ)
                            |
                            +-- after hooks (Activity, 使用状況追跡)
                            |
                            +-- rescue_from (エラーハンドリング)
```

### データフロー図

```
[認証フロー]
リクエスト
    ↓
Authorization / PRIVATE-TOKEN ヘッダー
    ↓
APIGuard::HelperMethods#find_current_user!
    ↓
find_user_from_sources
    |-- deploy_token_from_request
    |-- find_user_from_bearer_token
    |-- find_user_from_job_token
    +-- user_from_warden
    ↓
api_access_allowed? (権限チェック)
    ↓
validate_and_save_access_token! (スコープ検証)
    ↓
@current_user

[エンドポイント実行フロー]
リクエスト
    ↓
Grape ルーティング
    ↓
before フィルター
    ↓
エンドポイントメソッド
    ↓
サービスクラス / モデル操作
    ↓
Grape::Entity シリアライズ
    ↓
after フィルター
    ↓
JSON レスポンス
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| api.rb | `lib/api/api.rb` | ソース | APIメインエントリーポイント |
| api_guard.rb | `lib/api/api_guard.rb` | ソース | 認証ガード |
| helpers.rb | `lib/api/helpers.rb` | ソース | 共通ヘルパー |
| base.rb | `lib/api/base.rb` | ソース | API基底クラス |
| pagination_params.rb | `lib/api/pagination_params.rb` | ソース | ページネーション |
| scope.rb | `lib/api/scope.rb` | ソース | スコープ定義 |
| projects.rb | `lib/api/projects.rb` | ソース | プロジェクトAPI |
| issues.rb | `lib/api/issues.rb` | ソース | イシューAPI |
| merge_requests.rb | `lib/api/merge_requests.rb` | ソース | MR API |
| users.rb | `lib/api/users.rb` | ソース | ユーザーAPI |
| groups.rb | `lib/api/groups.rb` | ソース | グループAPI |
| pipelines.rb | `lib/api/ci/pipelines.rb` | ソース | パイプラインAPI |
