# 機能設計書 107-Bitbucketインポート

## 概要

本ドキュメントは、GitLabのBitbucketからのプロジェクトインポート機能についての機能設計書である。

### 本機能の処理概要

Bitbucketインポートは、Bitbucket Cloud（bitbucket.org）からGitLabへプロジェクト（リポジトリ、イシュー、プルリクエスト等）を移行する機能である。OAuth2認証を使用してBitbucket APIにアクセスし、データを取得・変換・インポートする。

**業務上の目的・背景**：Bitbucket CloudからGitLabへの移行を支援する。既存のプロジェクト履歴やイシューを保持したまま、シームレスな移行を実現する。

**機能の利用シーン**：
- BitbucketからGitLabへの組織移行
- 個人プロジェクトのGitLabへの移行
- Bitbucketの廃止に伴う移行

**主要な処理内容**：
1. Bitbucket OAuth2認証
2. インポート可能なリポジトリ一覧の取得
3. ターゲット名前空間の選択・作成
4. リポジトリのクローンとインポート
5. イシュー、プルリクエストのインポート
6. インポート進捗の表示

**関連システム・外部連携**：
- Bitbucket REST API
- Bitbucket OAuth2
- Sidekiq（バックグラウンドインポートジョブ）
- Gitaly（リポジトリ操作）

**権限による制御**：
- ターゲット名前空間への`import_projects`権限が必要
- Bitbucketリポジトリへのアクセス権限が必要

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 291 | Bitbucket Serverインポート | 主画面 | Bitbucket Serverからのインポート開始 |
| 292 | Bitbucket Serverインポート状態 | 主画面 | Bitbucket Serverインポート状態 |
| 293 | Bitbucketインポート状態 | 主画面 | Bitbucketインポート状態 |

## 機能種別

データインポート / 外部API連携 / OAuth2認証

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| repo_id | String | Yes | Bitbucketリポジトリ識別子 | slug形式 |
| new_name | String | No | 新しいプロジェクト名 | 英数字、ハイフン、アンダースコア |
| new_namespace | String | No | ターゲット名前空間パス | 有効な名前空間パス |
| filter | String | No | リポジトリフィルタ | 検索キーワード |

### 入力データソース

- Bitbucketインポート画面
- OAuth2認証フロー

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| project | Object | 作成されたプロジェクト |
| import_status | String | インポート状態 |

### 出力先

- プロジェクト（GitLab内）
- インポート状態画面

## 処理フロー

### 処理シーケンス

```
1. OAuth2認証
   └─ Bitbucket OAuth2フローを実行
2. トークン取得
   └─ 認可コードをアクセストークンに交換
3. リポジトリ一覧取得
   └─ Bitbucket APIからリポジトリを取得
4. リポジトリ選択
   └─ インポートするリポジトリを選択
5. プロジェクト作成
   └─ GitLabにプロジェクトを作成
6. インポート実行
   └─ バックグラウンドでデータインポート
```

### フローチャート

```mermaid
flowchart TD
    A[Bitbucketインポート開始] --> B{OAuth認証済み?}
    B -->|No| C[Bitbucket OAuth認証]
    B -->|Yes| D[リポジトリ一覧取得]
    C --> E{認証成功?}
    E -->|No| F[認証エラー]
    E -->|Yes| G[トークン保存]
    G --> D
    D --> H[リポジトリ選択]
    H --> I{有効なリポジトリ?}
    I -->|No| J[互換性エラー]
    I -->|Yes| K[名前空間選択]
    K --> L{import_projects権限?}
    L -->|No| M[権限エラー]
    L -->|Yes| N[プロジェクト作成]
    N --> O[インポート実行]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-107-01 | OAuth2認証必須 | Bitbucket OAuth2認証が必要 | 全インポート |
| BR-107-02 | リポジトリ有効性 | 無効なリポジトリ（Mercurial等）は除外 | リポジトリ一覧 |
| BR-107-03 | 名前空間解決 | 未指定時はリポジトリオーナーまたは現在ユーザー | プロジェクト作成時 |
| BR-107-04 | トークン更新 | アクセストークンは自動更新 | API呼び出し時 |

### 計算ロジック

ページネーション:
- 25件/ページでリポジトリを取得
- after_cursorパラメータで次ページを取得

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| プロジェクト作成 | projects | INSERT | 新規プロジェクトレコード作成 |
| イシュー作成 | issues | INSERT | Bitbucketイシューをインポート |

### テーブル別操作詳細

#### projects テーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | リポジトリ名またはnew_name | - |
| INSERT | import_type | 'bitbucket' | - |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 401 | Unauthorized | OAuth認証失敗 | 再認証 |
| 422 | Unprocessable Entity | 権限エラー | 権限を確認 |

### リトライ仕様

- OAuth認証エラー: 再認証フローへリダイレクト
- API エラー: バックオフ付きリトライ

## トランザクション仕様

- プロジェクト作成はトランザクション内で実行

## パフォーマンス要件

- リポジトリ一覧取得: ページネーション対応（25件/ページ）

## セキュリティ考慮事項

- OAuth state検証でCSRF防止
- アクセストークンはセッションに保存

## 備考

- Mercurialリポジトリはインポート不可（互換性なし）
- Bitbucket Server（オンプレミス）は別コントローラで処理

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | bitbucket_controller.rb | `app/controllers/import/bitbucket_controller.rb` | コントローラの全体構造 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bitbucket_controller.rb | `app/controllers/import/bitbucket_controller.rb` | 各アクションの処理 |

**主要処理フロー**:
1. **16-35行目**: `callback`アクションでOAuth2コールバック処理
2. **37-54行目**: `status`アクションでリポジトリ一覧表示
3. **56-99行目**: `create`アクションでインポート開始
4. **103-111行目**: `importable_repos`/`incompatible_repos`でリポジトリ分類
5. **175-182行目**: `go_to_bitbucket_for_permissions`でOAuth認証開始

### プログラム呼び出し階層図

```
Import::BitbucketController
    │
    ├─ #callback
    │      └─ OAuth2トークン取得・保存
    │
    ├─ #status
    │      └─ Bitbucket::Client#repos
    │
    └─ #create
           │
           ├─ Bitbucket::Client#repo
           ├─ find_or_create_namespace
           │
           └─ Gitlab::BitbucketImport::ProjectCreator
                  └─ プロジェクト作成・インポート開始
```

### データフロー図

```
[入力]                        [処理]                           [出力]

Bitbucket OAuth2 ───────▶ BitbucketController ───────────▶ プロジェクト
リポジトリ選択                  │
ターゲット名前空間              ├─ Bitbucket::Client
                               │      │
                               │      └─ Bitbucket API
                               │
                               └─ ProjectCreator
                                      └─ インポート実行
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bitbucket_controller.rb | `app/controllers/import/bitbucket_controller.rb` | ソース | HTTPエンドポイント |
| project_creator.rb | `lib/gitlab/bitbucket_import/project_creator.rb` | ソース | プロジェクト作成 |
| client.rb | `lib/bitbucket/client.rb` | ソース | Bitbucket APIクライアント |
