# 機能設計書 114-アプリケーション設定

## 概要

本ドキュメントは、GitLab管理画面におけるアプリケーション設定機能の設計仕様を記述する。システム管理者がGitLabインスタンス全体の設定を管理するための機能である。

### 本機能の処理概要

**業務上の目的・背景**：GitLabインスタンスの運用において、セキュリティ設定、CI/CD設定、ネットワーク設定、ユーザー登録ポリシーなど、インスタンス全体に影響する設定を一元管理する必要がある。本機能は管理者がこれらの設定を効率的に参照・変更するための中核機能である。

**機能の利用シーン**：
- 新規GitLabインスタンスの初期設定
- セキュリティポリシーの変更（OAuth、2FA、サインアップ制限等）
- CI/CD関連設定の調整
- リポジトリ関連設定の変更
- 外部連携（インテグレーション）の設定
- パフォーマンス・リソース制限の設定

**主要な処理内容**：
1. 設定パネル別の設定画面表示と更新（General、Repository、CI/CD、Reporting、Metrics/Profiling、Network、Preferences）
2. インスタンスレベルのインテグレーション設定
3. Runner登録トークンのリセット
4. ヘルスチェックアクセストークンのリセット
5. エラートラッキングアクセストークンのリセット
6. リポジトリチェック状態のクリア
7. Let's Encrypt利用規約への遷移
8. Slack App Manifestの共有・ダウンロード
9. Service Ping（使用状況データ）の表示・ダウンロード

**関連システム・外部連携**：
- Let's Encrypt（SSL証明書）
- Slack（Slack App Manifest）
- Elasticsearch（高度な検索設定）
- AWS/GCP連携設定

**権限による制御**：
- 本機能は管理者（Admin）権限を持つユーザーのみがアクセス可能

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 271 | 外見設定 | 補助画面 | システム外見設定（ロゴ、テーマ等） |
| 275 | 初期セットアップ | 補助画面 | 管理者初期セットアップ画面 |
| 317 | インスタンス設定 | 補助画面 | インスタンス設定情報表示 |

## 機能種別

設定管理 / CRUD操作（Read/Update）

## 入力仕様

### 入力パラメータ

アプリケーション設定は多岐にわたるため、代表的なパラメータを以下に示す。

#### General設定

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| signup_enabled | Boolean | No | サインアップ許可 | true/false |
| require_admin_approval_after_user_signup | Boolean | No | 新規ユーザー承認必須 | true/false |
| domain_denylist_enabled | Boolean | No | ドメインブロックリスト有効化 | true/false |
| domain_denylist | Array[String] | No | ブロックするドメイン一覧 | 有効なドメイン形式 |
| email_restrictions_enabled | Boolean | No | メール制限有効化 | true/false |
| error_tracking_enabled | Boolean | No | エラートラッキング有効化 | true/false |

#### CI/CD設定

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| auto_devops_enabled | Boolean | No | Auto DevOps有効化 | true/false |
| shared_runners_enabled | Boolean | No | 共有Runner有効化 | true/false |
| required_instance_ci_template | String | No | 必須CIテンプレート | テンプレート名 |
| pipeline_limit_per_project_user_sha | Integer | No | パイプライン制限数 | 正の整数 |

#### Repository設定

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| default_branch_name | String | No | デフォルトブランチ名 | 有効なブランチ名 |
| default_branch_protection_defaults | Object | No | デフォルトブランチ保護設定 | ネストされた設定オブジェクト |

### 入力データソース

- 画面入力（各設定パネルのフォーム）
- ファイルアップロード（domain_denylist_file等）
- セッション情報（現在の管理者ユーザー）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| application_setting | ApplicationSetting | 現在の設定値 |
| integrations | Array[Integration] | インスタンスレベルのインテグレーション一覧 |
| usage_data | Hash | Service Pingデータ（JSON形式） |
| plans | Array[Plan] | 利用可能なプラン一覧 |
| flash_message | String | 操作結果メッセージ |

### 出力先

- 画面表示（HTML/JSON）
- リダイレクト（操作完了後）
- ファイルダウンロード（Slack Manifest、Usage Data）

## 処理フロー

### 処理シーケンス

```
1. 設定パネル表示（general/repository/ci_cd/reporting/metrics_and_profiling/network/preferences）
   └─ set_application_setting → render (submitted?ならperform_update)
2. 設定更新（update/各パネルへのPATCH）
   └─ application_setting_params → ApplicationSettings::UpdateService → redirect
3. Runner登録トークンリセット（reset_registration_token）
   └─ Ci::Runners::ResetRegistrationTokenService → redirect
4. ヘルスチェックトークンリセット（reset_health_check_token）
   └─ @application_setting.reset_health_check_access_token! → redirect
5. インテグレーション一覧（integrations）
   └─ Integration.find_or_initialize_all_non_project_specific → render
6. 使用状況データ表示（usage_data）
   └─ prerecorded_service_ping_data → render (HTML/JSON)
```

### フローチャート

```mermaid
flowchart TD
    A[管理者がアプリケーション設定画面にアクセス] --> B{アクション種別}
    B -->|設定パネル表示| C[set_application_setting]
    C --> D{PATCH リクエスト?}
    D -->|Yes| E[application_setting_params処理]
    E --> F[ApplicationSettings::UpdateService.execute]
    F --> G{成功?}
    G -->|Yes| H[成功メッセージ表示]
    G -->|No| I[エラーメッセージ表示]
    D -->|No| J[設定画面表示]

    B -->|トークンリセット| K{トークン種別}
    K -->|Runner登録| L[ResetRegistrationTokenService]
    K -->|ヘルスチェック| M[reset_health_check_access_token!]
    K -->|エラートラッキング| N[reset_error_tracking_access_token!]
    L --> O[Runner一覧へリダイレクト]
    M --> P[設定画面へリダイレクト]
    N --> P

    B -->|インテグレーション| Q[Integration.find_or_initialize_all]
    Q --> R[インテグレーション一覧表示]

    B -->|使用状況データ| S[prerecorded_service_ping_data]
    S --> T{形式}
    T -->|HTML| U[ハイライト表示]
    T -->|JSON| V[ダウンロード]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-114-01 | OAuth設定変換 | enabled_oauth_sign_in_sourcesをdisabled_oauth_sign_in_sourcesに変換して保存 | OAuth設定更新時 |
| BR-114-02 | 空テンプレートクリア | required_instance_ci_templateが空の場合はnilに変換 | CI/CD設定更新時 |
| BR-114-03 | デフォルトブランチ保護正規化 | default_branch_protection_defaultsを正規化 | Repository設定更新時 |
| BR-114-04 | Service Pingキャッシュ | Usage Dataはキャッシュから取得、なければRawUsageDataから取得 | usage_data表示時 |
| BR-114-05 | インテグレーション制限 | インスタンスレベルのインテグレーションのみ表示 | integrations表示時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 設定取得 | application_settings | SELECT | 現在の設定値取得（キャッシュバイパス） |
| 設定更新 | application_settings | UPDATE | 設定値の更新 |
| インテグレーション取得 | integrations | SELECT | インスタンスレベルのインテグレーション取得 |
| Usage Data取得 | raw_usage_data | SELECT | 記録済みService Pingデータ取得 |

### テーブル別操作詳細

#### application_settingsテーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | 全カラム | current_without_cache | キャッシュをバイパスして最新値取得 |
| UPDATE | 多数の設定カラム | フォーム入力値 | ApplicationSettings::UpdateService経由 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 404 | 存在しないリソース | インテグレーション機能が無効 | 404エラーページ表示 |
| 400 | バリデーションエラー | 設定値が不正 | エラーアラート表示、同一パネル再表示 |

### リトライ仕様

特になし

## トランザクション仕様

- 設定更新はApplicationSettings::UpdateService内で単一トランザクションとして処理

## パフォーマンス要件

- 設定取得：`current_without_cache`でキャッシュをバイパスし、更新直後でも最新値を表示
- Query Limiting無効化：usage_data表示時はクエリ制限を無効化

## セキュリティ考慮事項

- 管理者権限（Admin）が必須
- 機密情報（AWSシークレットキー等）は空の場合に削除
- Service Pingダウンロード時にInternal Eventを記録

## 備考

- 本機能はEnterprise Edition（EE）で拡張される可能性があり、`prepend_mod_with`によりモジュールが追加される
- 設定パネルは動的に定義されており、EEでは追加パネルが存在する可能性がある

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | application_setting.rb | `app/models/application_setting.rb` | ApplicationSettingモデルの属性、バリデーションを理解 |

**読解のコツ**: ApplicationSettingは単一レコードで全設定を保持する。多数の属性があり、`Gitlab::ProcessMemoryCache`でキャッシュされている。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | application_settings_controller.rb | `app/controllers/admin/application_settings_controller.rb` | 各アクションの処理フローを理解 |

**主要処理フロー**:
1. **43-46行目**: VALID_SETTING_PANELSの定義と動的アクション生成
2. **54-56行目**: 各設定パネルアクション - submitted?ならperform_update
3. **58-64行目**: `integrations`アクション - インスタンスレベルのインテグレーション取得
4. **70-86行目**: `usage_data`アクション - Service Pingデータ表示/ダウンロード
5. **88-93行目**: `reset_registration_token`アクション - Runner登録トークンリセット
6. **230-248行目**: `perform_update`メソッド - 設定更新の共通処理

#### Step 3: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | update_service.rb | `app/services/application_settings/update_service.rb` | 設定更新ロジック |

### プログラム呼び出し階層図

```
Admin::ApplicationSettingsController
    │
    ├─ general/repository/ci_cd/... (動的生成)
    │      ├─ set_application_setting
    │      └─ perform_update (if submitted?)
    │             └─ ApplicationSettings::UpdateService#execute
    │
    ├─ integrations
    │      └─ Integration.find_or_initialize_all_non_project_specific
    │
    ├─ usage_data
    │      ├─ prerecorded_service_ping_data
    │      └─ Gitlab::Highlight (HTML表示時)
    │
    ├─ reset_registration_token
    │      └─ Ci::Runners::ResetRegistrationTokenService#execute
    │
    ├─ reset_health_check_token
    │      └─ ApplicationSetting#reset_health_check_access_token!
    │
    └─ reset_error_tracking_access_token
           └─ ApplicationSetting#reset_error_tracking_access_token!
```

### データフロー図

```
[入力]                    [処理]                           [出力]

管理者操作 ───────▶ Admin::ApplicationSettingsController ▶ HTMLレスポンス
  │                      │                                  │
  │                      ▼                                  │
  │         ApplicationSettings::UpdateService              │
  │                      │                                  │
  │                      ▼                                  │
  │            ApplicationSetting Model                     │
  │                      │                                  │
  └──────────────▶ application_settings テーブル ─────────▶ キャッシュ更新
                                                            │
                                                            ▼
                                                    全インスタンスに反映
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| application_settings_controller.rb | `app/controllers/admin/application_settings_controller.rb` | コントローラー | アプリケーション設定のエントリーポイント |
| application_setting.rb | `app/models/application_setting.rb` | モデル | アプリケーション設定データモデル |
| update_service.rb | `app/services/application_settings/update_service.rb` | サービス | 設定更新ロジック |
| application_settings_helper.rb | `app/helpers/application_settings_helper.rb` | ヘルパー | 設定関連のビューヘルパー |
| reset_registration_token_service.rb | `app/services/ci/runners/reset_registration_token_service.rb` | サービス | Runner登録トークンリセット |
