# 機能設計書 116-ジョブ管理

## 概要

本ドキュメントは、GitLab管理画面におけるジョブ管理機能の設計仕様を記述する。システム管理者が全CI/CDジョブの一覧表示と一括キャンセルを行うための機能である。

### 本機能の処理概要

**業務上の目的・背景**：GitLabインスタンスでは多数のCI/CDパイプラインが同時に実行され、それに伴い大量のジョブが生成される。システム管理者は、インスタンス全体のジョブ状況を把握し、必要に応じて実行中・保留中のジョブを一括でキャンセルする必要がある場合がある（例：緊急メンテナンス、リソース逼迫時等）。

**機能の利用シーン**：
- インスタンス全体のジョブ実行状況の監視
- 緊急時の実行中・保留中ジョブの一括キャンセル
- ジョブキューの状態確認

**主要な処理内容**：
1. CI/CDジョブ一覧の表示
2. 実行中・保留中ジョブの一括キャンセル

**関連システム・外部連携**：
- CI/CDパイプラインシステム
- Runnerシステム

**権限による制御**：
- 本機能は管理者（Admin）権限を持つユーザーのみがアクセス可能

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 262 | ジョブ一覧 | 主画面 | システムジョブ一覧表示 |

## 機能種別

参照 / 一括操作

## 入力仕様

### 入力パラメータ

#### ジョブ一覧表示時

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| runner_type | String | No | Runnerタイプでフィルタ | 有効なRunnerタイプ（feature flag有効時） |

### 入力データソース

- URLパラメータ（フィルタ条件）
- セッション情報（現在の管理者ユーザー）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| jobs | Array[Ci::Build] | ジョブ一覧データ |

### 出力先

- 画面表示（HTML）
- リダイレクト（キャンセル完了後）

## 処理フロー

### 処理シーケンス

```
1. ジョブ一覧表示（index）
   └─ render（Vue.jsコンポーネントで描画）
2. 全ジョブキャンセル（cancel_all）
   └─ Ci::Build.running_or_pending.each(&:cancel) → redirect
```

### フローチャート

```mermaid
flowchart TD
    A[管理者がジョブ管理画面にアクセス] --> B{操作種別}
    B -->|一覧表示| C[index画面表示]
    C --> D[Vue.jsコンポーネントで描画]

    B -->|一括キャンセル| E[Ci::Build.running_or_pending]
    E --> F[各ジョブにcancel呼び出し]
    F --> G[ジョブ一覧へリダイレクト]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-116-01 | キャンセル対象 | running（実行中）またはpending（保留中）のジョブのみキャンセル対象 | cancel_all実行時 |
| BR-116-02 | Runnerタイプフィルタ | admin_jobs_filter_runner_type feature flagが有効な場合のみRunnerタイプでフィルタ可能 | 一覧表示時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧表示 | ci_builds (p_ci_builds) | SELECT | ジョブ一覧取得 |
| 一括キャンセル | ci_builds (p_ci_builds) | UPDATE | ジョブ状態をキャンセルに更新 |

### テーブル別操作詳細

#### ci_builds（p_ci_builds）テーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, name, status, created_at等 | 各種フィルタ条件 | |
| UPDATE | status | canceled | running_or_pendingスコープで絞り込み |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | キャンセル失敗 | 個別ジョブのキャンセルに失敗 | 処理を継続（各ジョブは独立してキャンセル） |

### リトライ仕様

特になし（各ジョブのキャンセルは独立して実行）

## トランザクション仕様

- 各ジョブのキャンセルは独立したトランザクションで処理される
- 一括キャンセルは全体を1トランザクションでは囲まない

## パフォーマンス要件

- ジョブ一覧はページネーション対応
- 1ページあたり30件（BUILDS_PER_PAGE）

## セキュリティ考慮事項

- 管理者権限（Admin）が必須
- 一括キャンセルは強力な操作のため、確認ダイアログを表示することが推奨される

## 備考

- 本機能はEnterprise Edition（EE）で拡張される可能性があり、`prepend_mod`によりモジュールが追加される
- ジョブ一覧はVue.jsコンポーネントで描画される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | build.rb | `app/models/ci/build.rb` | Ci::Buildモデルの属性、状態遷移、cancelメソッドを理解 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | jobs_controller.rb | `app/controllers/admin/jobs_controller.rb` | 各アクションの処理フローを理解 |

**主要処理フロー**:
1. **4行目**: BUILDS_PER_PAGE = 30
2. **9-11行目**: feature flag push
3. **13行目**: `index`アクション - 一覧表示
4. **15-18行目**: `cancel_all`アクション - 全キャンセル処理

### プログラム呼び出し階層図

```
Admin::JobsController
    │
    ├─ index
    │      └─ (Vue.jsコンポーネントで描画)
    │
    └─ cancel_all
           └─ Ci::Build.running_or_pending
                  └─ each(&:cancel)
```

### データフロー図

```
[入力]                    [処理]                           [出力]

管理者操作 ───────▶ Admin::JobsController ───────▶ HTMLレスポンス
  │                      │
  │                      ▼
  │               Ci::Build Model
  │                      │
  └──────────────▶ ci_builds テーブル ────────────────▶ ジョブ状態更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| jobs_controller.rb | `app/controllers/admin/jobs_controller.rb` | コントローラー | ジョブ管理のエントリーポイント |
| build.rb | `app/models/ci/build.rb` | モデル | CIジョブデータモデル |
