# 機能設計書 117-バックグラウンドジョブ監視

## 概要

本ドキュメントは、GitLab管理画面におけるバックグラウンドジョブ監視機能の設計仕様を記述する。システム管理者がSidekiqによるバックグラウンドジョブの状態を監視するための機能である。

### 本機能の処理概要

**業務上の目的・背景**：GitLabは多くの非同期処理をSidekiqバックグラウンドジョブで実行する（メール送信、リポジトリ操作、CI/CD処理等）。システム管理者はこれらのバックグラウンドジョブの状態を監視し、キューの滞留やワーカーの異常を検知・対処する必要がある。

**機能の利用シーン**：
- Sidekiqジョブキューの状態確認
- バックグラウンドマイグレーションの進捗確認
- ジョブ処理の遅延・滞留の検知
- システムの健全性確認

**主要な処理内容**：
1. Sidekiqダッシュボード（管理UI）へのアクセス
2. バックグラウンドマイグレーションの一覧表示
3. バックグラウンドマイグレーションの詳細表示
4. バッチジョブの詳細表示

**関連システム・外部連携**：
- Sidekiq（バックグラウンドジョブ処理システム）
- Redis（Sidekiqのキューストレージ）
- データベースマイグレーションシステム

**権限による制御**：
- 本機能は管理者（Admin）権限を持つユーザーのみがアクセス可能

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 222 | バックグラウンドジョブ | 主画面 | Sidekiqジョブの管理 |
| 272 | バックグラウンドマイグレーション一覧 | 主画面 | バックグラウンドマイグレーション一覧表示 |
| 273 | バックグラウンドマイグレーション詳細 | 主画面 | バックグラウンドマイグレーション詳細表示 |
| 274 | バッチジョブ詳細 | 主画面 | バッチジョブ詳細表示 |

## 機能種別

監視 / 参照

## 入力仕様

### 入力パラメータ

本機能は主に参照機能であり、入力パラメータは最小限である。

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| (なし) | - | - | 参照のみ | - |

### 入力データソース

- Sidekiq API（キュー状態、ワーカー状態）
- データベース（バックグラウンドマイグレーション情報）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| sidekiq_dashboard | HTML | Sidekiq Web UIの埋め込み表示 |
| migrations | Array | バックグラウンドマイグレーション一覧 |
| batched_jobs | Array | バッチジョブ一覧 |

### 出力先

- 画面表示（HTML）

## 処理フロー

### 処理シーケンス

```
1. バックグラウンドジョブ画面表示
   └─ Sidekiq Web UIを埋め込み表示
2. バックグラウンドマイグレーション一覧
   └─ マイグレーション情報をDBから取得 → render
3. バックグラウンドマイグレーション詳細
   └─ 特定マイグレーションの詳細情報取得 → render
4. バッチジョブ詳細
   └─ 特定バッチジョブの詳細情報取得 → render
```

### フローチャート

```mermaid
flowchart TD
    A[管理者がバックグラウンドジョブ画面にアクセス] --> B{表示種別}
    B -->|Sidekiqダッシュボード| C[Sidekiq Web UI表示]
    B -->|マイグレーション一覧| D[バックグラウンドマイグレーション取得]
    D --> E[一覧画面表示]
    B -->|マイグレーション詳細| F[特定マイグレーション取得]
    F --> G[詳細画面表示]
    B -->|バッチジョブ詳細| H[特定バッチジョブ取得]
    H --> I[詳細画面表示]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-117-01 | Sidekiq UI制限 | Sidekiq Web UIは管理者のみがアクセス可能 | アクセス時 |
| BR-117-02 | マイグレーション表示 | 完了・進行中・失敗のマイグレーションを表示 | マイグレーション一覧時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| マイグレーション一覧 | batched_background_migrations | SELECT | マイグレーション情報取得 |
| バッチジョブ詳細 | batched_background_migration_jobs | SELECT | バッチジョブ情報取得 |

### テーブル別操作詳細

#### batched_background_migrationsテーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, job_class_name, status, progress等 | 全件または条件指定 | |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 500 | Sidekiq接続エラー | Redisへの接続失敗 | エラーページ表示 |
| 404 | 存在しないリソース | 指定されたマイグレーション/ジョブが見つからない | 404エラーページ表示 |

### リトライ仕様

特になし

## トランザクション仕様

- 参照のみのためトランザクション管理は不要

## パフォーマンス要件

- Sidekiq UIはリアルタイム更新対応
- マイグレーション一覧はページネーション対応

## セキュリティ考慮事項

- 管理者権限（Admin）が必須
- Sidekiq Web UIへのアクセスは認証済みセッションでのみ許可

## 備考

- Sidekiq Web UIはRackアプリケーションとしてマウントされている
- バックグラウンドマイグレーションはGitLabのアップグレード時に自動実行される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | background_jobs_controller.rb | `app/controllers/admin/background_jobs_controller.rb` | コントローラーの構造を理解 |

**読解のコツ**: このコントローラーは非常にシンプルで、feature_categoryの設定のみ。実際の処理はSidekiq Web UIやバックグラウンドマイグレーション用の別コントローラーで行われる。

### プログラム呼び出し階層図

```
Admin::BackgroundJobsController
    │
    └─ (Sidekiq Web UIへのルーティング)

バックグラウンドマイグレーション関連
    │
    ├─ バックグラウンドマイグレーション一覧
    │      └─ Gitlab::Database::BackgroundMigration
    │
    └─ バッチジョブ詳細
           └─ Gitlab::Database::BackgroundMigration::BatchedJob
```

### データフロー図

```
[入力]                    [処理]                           [出力]

管理者操作 ───────▶ Admin::BackgroundJobsController ▶ HTMLレスポンス
  │                      │
  │                      ▼
  │               Sidekiq Web UI
  │                      │
  └──────────────▶ Redis (Sidekiqキュー) ────────────▶ キュー状態表示
                         │
                         ▼
                  batched_background_migrations
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| background_jobs_controller.rb | `app/controllers/admin/background_jobs_controller.rb` | コントローラー | バックグラウンドジョブ画面のエントリーポイント |
| sidekiq.rb | `config/initializers/sidekiq.rb` | 初期化ファイル | Sidekiq設定、Web UI設定 |
