# 機能設計書 118-ブロードキャストメッセージ

## 概要

本ドキュメントは、GitLab管理画面におけるブロードキャストメッセージ機能の設計仕様を記述する。システム管理者が全ユーザーに対してメッセージを表示するための機能である。

### 本機能の処理概要

**業務上の目的・背景**：GitLabインスタンスの運用において、メンテナンス予定、重要なお知らせ、セキュリティ警告などを全ユーザーに周知する必要がある。本機能は管理者がバナーまたは通知形式でメッセージを作成・編集・削除し、表示期間やターゲットユーザーを制御できる機能である。

**機能の利用シーン**：
- 計画メンテナンスの事前告知
- 新機能リリースのお知らせ
- セキュリティ関連の警告表示
- 組織内連絡事項の周知
- 特定パスへのアクセス時のみ表示するメッセージ

**主要な処理内容**：
1. ブロードキャストメッセージ一覧の表示
2. 新規ブロードキャストメッセージの作成
3. 既存ブロードキャストメッセージの編集
4. ブロードキャストメッセージの削除
5. メッセージのプレビュー

**関連システム・外部連携**：
- Markdownレンダリングシステム
- Redisキャッシュシステム
- CLI表示システム

**権限による制御**：
- 本機能は管理者（Admin）権限を持つユーザーのみがアクセス可能
- ターゲットアクセスレベルでメッセージの表示対象を制御可能

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 250 | ブロードキャストメッセージ一覧 | 主画面 | ブロードキャストメッセージ管理 |
| 251 | ブロードキャストメッセージ編集 | 主画面 | ブロードキャストメッセージ編集 |

## 機能種別

CRUD操作

## 入力仕様

### 入力パラメータ

#### ブロードキャストメッセージ作成・編集時

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| message | String | Yes | メッセージ本文（Markdown対応） | 必須 |
| starts_at | DateTime | Yes | 表示開始日時 | 必須、有効な日時 |
| ends_at | DateTime | Yes | 表示終了日時 | 必須、有効な日時 |
| broadcast_type | String | Yes | メッセージタイプ | banner(1)/notification(2) |
| theme | String | No | バナーテーマ | indigo/light-indigo/blue/light-blue/green/light-green/red/light-red/dark/light |
| target_path | String | No | 表示対象パス（ワイルドカード対応） | パス形式 |
| target_access_levels | Array[Integer] | No | 表示対象アクセスレベル | GUEST(10)/PLANNER/REPORTER(20)/DEVELOPER(30)/MAINTAINER(40)/OWNER(50) |
| dismissable | Boolean | No | 非表示可能フラグ | true/false |
| show_in_cli | Boolean | No | CLI表示フラグ | true/false |

### 入力データソース

- 画面入力（メッセージ作成・編集フォーム）
- セッション情報（現在の管理者ユーザー）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| broadcast_messages | Array[System::BroadcastMessage] | メッセージ一覧 |
| broadcast_message | System::BroadcastMessage | 個別メッセージ |
| preview_html | String | プレビュー用HTML |

### 出力先

- 画面表示（HTML/JSON）
- リダイレクト（操作完了後）

## 処理フロー

### 処理シーケンス

```
1. メッセージ一覧表示（index）
   └─ find_broadcast_messages → render
2. メッセージ作成（create）
   └─ System::BroadcastMessage.new → save → redirect/render
3. メッセージ編集画面表示（edit）
   └─ find_broadcast_message → render
4. メッセージ更新（update）
   └─ find_broadcast_message → update → redirect/render
5. メッセージ削除（destroy）
   └─ find_broadcast_message → destroy → redirect
6. プレビュー（preview）
   └─ System::BroadcastMessage.new → render_broadcast_message
```

### フローチャート

```mermaid
flowchart TD
    A[管理者がブロードキャストメッセージ画面にアクセス] --> B{操作種別}
    B -->|一覧表示| C[find_broadcast_messages]
    C --> D[メッセージ一覧表示]

    B -->|作成| E[new メッセージ]
    E --> F[フォーム入力]
    F --> G[save]
    G --> H{成功?}
    H -->|Yes| I[一覧へリダイレクト]
    H -->|No| J[エラー表示]

    B -->|編集| K[find_broadcast_message]
    K --> L[編集フォーム表示]
    L --> M[フォーム入力]
    M --> N[update]
    N --> O{成功?}
    O -->|Yes| P[一覧へリダイレクト]
    O -->|No| Q[エラー表示]

    B -->|削除| R[find_broadcast_message]
    R --> S[destroy]
    S --> T[一覧へリダイレクト]

    B -->|プレビュー| U[render_broadcast_message]
    U --> V[プレビューHTML返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-118-01 | メッセージタイプ | banner（バナー表示）とnotification（通知表示）の2種類 | 作成・編集時 |
| BR-118-02 | 表示期間制御 | starts_at〜ends_atの期間のみ表示 | メッセージ表示時 |
| BR-118-03 | パスマッチング | target_pathが設定されている場合、そのパスにマッチする画面でのみ表示（ワイルドカード対応） | メッセージ表示時 |
| BR-118-04 | アクセスレベル制御 | target_access_levelsが設定されている場合、該当レベルのユーザーのみに表示 | メッセージ表示時 |
| BR-118-05 | キャッシュ更新 | メッセージの作成・更新・削除時にRedisキャッシュをフラッシュ | 変更操作後 |
| BR-118-06 | CLI表示制御 | show_in_cliがtrueの場合のみGitLab CLI（glab）に表示 | CLI利用時 |
| BR-118-07 | 非表示機能 | dismissableがtrueの場合、ユーザーが非表示にできる | メッセージ表示時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧表示 | broadcast_messages | SELECT | メッセージ一覧取得（ends_at降順） |
| 作成 | broadcast_messages | INSERT | 新規メッセージ作成 |
| 更新 | broadcast_messages | UPDATE | メッセージ更新 |
| 削除 | broadcast_messages | DELETE | メッセージ削除 |

### テーブル別操作詳細

#### broadcast_messagesテーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, message, starts_at, ends_at, broadcast_type, theme等 | ends_at DESC | ページネーション対応 |
| INSERT | message, starts_at, ends_at, broadcast_type, theme, target_path等 | フォーム入力値 | |
| UPDATE | message, starts_at, ends_at, broadcast_type, theme, target_path等 | フォーム入力値 | |
| DELETE | - | id指定 | |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 400 | バリデーションエラー | 必須項目未入力、日時不正等 | JSON: エラーメッセージ配列、HTML: フォーム再表示 |
| 404 | 存在しないリソース | 指定されたメッセージが見つからない | 404エラーページ表示 |

### リトライ仕様

特になし

## トランザクション仕様

- 各操作は単一トランザクションとして処理
- 保存後にRedisキャッシュをフラッシュ（after_commit）

## パフォーマンス要件

- メッセージ一覧はページネーション対応
- 現在のメッセージ取得はRedisキャッシュを使用（2週間有効）

## セキュリティ考慮事項

- 管理者権限（Admin）が必須
- メッセージ本文はMarkdownパイプライン（broadcast_message）で処理
- XSS対策としてサニタイズ処理を実施

## 備考

- テーマは10種類（indigo, light-indigo, blue, light-blue, green, light-green, red, light-red, dark, light）
- デフォルトテーマはindigo、デフォルト色は#E75E40（背景）、#FFFFFF（フォント）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | broadcast_message.rb | `app/models/system/broadcast_message.rb` | メッセージモデルの属性、バリデーション、キャッシュ管理を理解 |

**読解のコツ**: キャッシュ管理（CACHE_KEY, BANNER_CACHE_KEY等）とメッセージ取得ロジック（current_banner_messages等）を重点的に確認する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | broadcast_messages_controller.rb | `app/controllers/admin/broadcast_messages_controller.rb` | 各アクションの処理フローを理解 |

**主要処理フロー**:
1. **13-15行目**: `index`アクション - 一覧表示、新規メッセージ初期化
2. **19-39行目**: `create`アクション - メッセージ作成（JSON/HTML両対応）
3. **41-59行目**: `update`アクション - メッセージ更新（JSON/HTML両対応）
4. **62-69行目**: `destroy`アクション - メッセージ削除
5. **71-74行目**: `preview`アクション - プレビュー

### プログラム呼び出し階層図

```
Admin::BroadcastMessagesController
    │
    ├─ index
    │      ├─ find_broadcast_messages
    │      └─ System::BroadcastMessage.new
    │
    ├─ create
    │      ├─ System::BroadcastMessage.new
    │      └─ save → flush_redis_cache (after_commit)
    │
    ├─ update
    │      ├─ find_broadcast_message
    │      └─ update → flush_redis_cache (after_commit)
    │
    ├─ destroy
    │      ├─ find_broadcast_message
    │      └─ destroy → flush_redis_cache (after_commit)
    │
    └─ preview
           └─ render_broadcast_message (BroadcastMessagesHelper)
```

### データフロー図

```
[入力]                    [処理]                           [出力]

管理者操作 ───────▶ Admin::BroadcastMessagesController ▶ HTMLレスポンス
  │                      │                                │
  │                      ▼                                │
  │         System::BroadcastMessage Model               │
  │                      │                                │
  └──────────────▶ broadcast_messages テーブル ──────▶ キャッシュ更新
                         │                                │
                         ▼                                ▼
                  Redis Cache ─────────────────────▶ 全ユーザーに表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| broadcast_messages_controller.rb | `app/controllers/admin/broadcast_messages_controller.rb` | コントローラー | メッセージ管理のエントリーポイント |
| broadcast_message.rb | `app/models/system/broadcast_message.rb` | モデル | メッセージデータモデル |
| broadcast_messages_helper.rb | `app/helpers/admin/broadcast_messages_helper.rb` | ヘルパー | プレビュー表示等のヘルパー |
