# 機能設計書 119-デプロイキー管理

## 概要

本ドキュメントは、GitLab管理画面におけるデプロイキー管理機能の設計仕様を記述する。システム管理者がインスタンス全体で共有される公開デプロイキーの一覧表示、作成、編集、削除を行うための機能である。

### 本機能の処理概要

**業務上の目的・背景**：デプロイキーは、CI/CDパイプラインやデプロイスクリプトがGitリポジトリにアクセスするためのSSH公開鍵である。管理者が公開デプロイキー（複数プロジェクトで共有可能）を管理することで、セキュアなデプロイ環境を効率的に構築できる。

**機能の利用シーン**：
- 共有デプロイキーの新規作成
- 既存デプロイキーのタイトル編集
- 不要になったデプロイキーの削除
- デプロイキーの有効期限管理

**主要な処理内容**：
1. 公開デプロイキー一覧の表示
2. 新規公開デプロイキーの作成
3. 既存デプロイキーのタイトル編集
4. デプロイキーの削除

**関連システム・外部連携**：
- SSH認証システム
- Gitリポジトリアクセス

**権限による制御**：
- 本機能は管理者（Admin）権限を持つユーザーのみがアクセス可能
- 作成されたキーは公開デプロイキーとして複数プロジェクトで共有可能

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 255 | デプロイキー一覧 | 主画面 | システムデプロイキー一覧表示 |
| 256 | デプロイキー新規作成 | 主画面 | システムデプロイキー作成 |
| 257 | デプロイキー編集 | 主画面 | システムデプロイキー編集 |

## 機能種別

CRUD操作

## 入力仕様

### 入力パラメータ

#### デプロイキー作成時

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| title | String | Yes | キーのタイトル | 必須 |
| key | String | Yes | SSH公開鍵 | 必須、有効なSSH公開鍵形式 |
| expires_at | Date | No | 有効期限 | 有効な日付 |

#### デプロイキー編集時

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| title | String | Yes | キーのタイトル | 必須 |

### 入力データソース

- 画面入力（デプロイキー作成・編集フォーム）
- セッション情報（現在の管理者ユーザー）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| deploy_keys | Array[DeployKey] | 公開デプロイキー一覧 |
| deploy_key | DeployKey | 個別デプロイキー |
| flash_message | String | 操作結果メッセージ |

### 出力先

- 画面表示（HTML/JSON）
- リダイレクト（操作完了後）

## 処理フロー

### 処理シーケンス

```
1. デプロイキー一覧表示（index）
   └─ deploy_keys (DeployKey.are_public) → render
2. 新規作成画面表示（new）
   └─ deploy_keys.new → render
3. デプロイキー作成（create）
   └─ DeployKeys::CreateService#execute → redirect/render
4. 編集画面表示（edit）
   └─ deploy_key → render
5. デプロイキー更新（update）
   └─ deploy_key.update → redirect/render
6. デプロイキー削除（destroy）
   └─ deploy_key.destroy → redirect
```

### フローチャート

```mermaid
flowchart TD
    A[管理者がデプロイキー管理画面にアクセス] --> B{操作種別}
    B -->|一覧表示| C[DeployKey.are_public]
    C --> D[一覧画面表示]

    B -->|新規作成| E[new画面表示]
    E --> F[フォーム入力]
    F --> G[DeployKeys::CreateService.execute]
    G --> H{成功?}
    H -->|Yes| I[一覧へリダイレクト]
    H -->|No| J[エラー表示]

    B -->|編集| K[deploy_key取得]
    K --> L[編集フォーム表示]
    L --> M[フォーム入力]
    M --> N[deploy_key.update]
    N --> O{成功?}
    O -->|Yes| P[一覧へリダイレクト]
    O -->|No| Q[エラー表示]

    B -->|削除| R[deploy_key取得]
    R --> S[destroy]
    S --> T[一覧へリダイレクト]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-119-01 | 公開キーのみ管理 | 管理画面では公開デプロイキー（public: true）のみを管理 | 全操作 |
| BR-119-02 | 自動公開設定 | 作成時に自動的にpublic: trueが設定される | 作成時 |
| BR-119-03 | 組織紐付け | 作成時に現在の組織に紐付けられる | 作成時 |
| BR-119-04 | タイトルのみ編集可能 | 編集ではタイトルのみ変更可能（キー本体は変更不可） | 編集時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧表示 | keys (type='DeployKey') | SELECT | 公開デプロイキー一覧取得 |
| 作成 | keys | INSERT | 新規デプロイキー作成 |
| 更新 | keys | UPDATE | タイトル更新 |
| 削除 | keys | DELETE | デプロイキー削除 |

### テーブル別操作詳細

#### keysテーブル（DeployKeyとして）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, title, fingerprint, created_at, expires_at等 | type='DeployKey' AND public=true | |
| INSERT | title, key, expires_at, type, public, organization_id | フォーム入力値、public=true | DeployKeys::CreateService経由 |
| UPDATE | title | フォーム入力値 | |
| DELETE | - | id指定 | |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 404 | 存在しないリソース | 指定されたデプロイキーが見つからない | 404エラーページ表示 |
| 422 | バリデーションエラー | SSH公開鍵が無効、タイトル未入力等 | エラーメッセージを表示して再入力を促す |

### リトライ仕様

特になし

## トランザクション仕様

- 各操作は単一トランザクションとして処理

## パフォーマンス要件

- 特になし（一般的に公開デプロイキーの数は限られる）

## セキュリティ考慮事項

- 管理者権限（Admin）が必須
- SSH公開鍵のみを保存（秘密鍵は保存しない）
- キーのフィンガープリントを計算・保存して重複チェック

## 備考

- デプロイキーには有効期限を設定可能
- 公開デプロイキーは複数プロジェクトで共有可能
- プロジェクト固有のデプロイキーは別の管理画面で管理

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | deploy_key.rb | `app/models/deploy_key.rb` | DeployKeyモデルの属性、スコープ、Keyとの継承関係を理解 |

**読解のコツ**: DeployKeyはKeyモデルを継承しており、STI（Single Table Inheritance）パターンで実装されている。`are_public`スコープで公開キーを取得する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | deploy_keys_controller.rb | `app/controllers/admin/deploy_keys_controller.rb` | 各アクションの処理フローを理解 |

**主要処理フロー**:
1. **10行目**: `index`アクション - 公開キー一覧表示
2. **12-14行目**: `new`アクション - 新規作成フォーム
3. **16-24行目**: `create`アクション - DeployKeys::CreateService経由で作成、public: true設定
4. **26行目**: `edit`アクション - 編集フォーム
5. **29-35行目**: `update`アクション - タイトル更新
6. **38-44行目**: `destroy`アクション - 削除（JSON/HTML両対応）

#### Step 3: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | create_service.rb | `app/services/deploy_keys/create_service.rb` | デプロイキー作成ロジック |

### プログラム呼び出し階層図

```
Admin::DeployKeysController
    │
    ├─ index
    │      └─ deploy_keys (DeployKey.are_public)
    │
    ├─ new
    │      └─ deploy_keys.new
    │
    ├─ create
    │      └─ DeployKeys::CreateService#execute
    │             └─ merge(public: true, organization: Current.organization)
    │
    ├─ edit
    │      └─ deploy_key
    │
    ├─ update
    │      └─ deploy_key.update(update_params)
    │
    └─ destroy
           └─ deploy_key.destroy
```

### データフロー図

```
[入力]                    [処理]                           [出力]

管理者操作 ───────▶ Admin::DeployKeysController ───────▶ HTMLレスポンス
  │                      │
  │                      ▼
  │         DeployKeys::CreateService
  │                      │
  │                      ▼
  │              DeployKey Model
  │                      │
  └──────────────▶ keys テーブル ────────────────────▶ プロジェクトで利用可能
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| deploy_keys_controller.rb | `app/controllers/admin/deploy_keys_controller.rb` | コントローラー | デプロイキー管理のエントリーポイント |
| deploy_key.rb | `app/models/deploy_key.rb` | モデル | デプロイキーデータモデル |
| key.rb | `app/models/key.rb` | モデル | SSHキー基底モデル |
| create_service.rb | `app/services/deploy_keys/create_service.rb` | サービス | デプロイキー作成ロジック |
