# 機能設計書 120-ラベル管理

## 概要

本ドキュメントは、GitLab管理画面におけるラベル管理機能の設計仕様を記述する。システム管理者がインスタンス全体で使用されるテンプレートラベルの一覧表示、作成、編集、削除を行うための機能である。

### 本機能の処理概要

**業務上の目的・背景**：GitLabでは、イシューやマージリクエストにラベルを付与して分類・管理する。管理者がテンプレートラベル（template: true）を作成することで、新規プロジェクト作成時にこれらのラベルが自動的にコピーされ、組織全体で統一されたラベル体系を構築できる。

**機能の利用シーン**：
- 組織共通のラベル（例：Priority::High, Type::Bug等）の定義
- ラベルの色やタイトルの標準化
- 不要になったテンプレートラベルの削除

**主要な処理内容**：
1. テンプレートラベル一覧の表示
2. 新規テンプレートラベルの作成
3. 既存テンプレートラベルの編集
4. テンプレートラベルの削除

**関連システム・外部連携**：
- プロジェクト作成システム（テンプレートラベルの自動コピー）
- イシュー・マージリクエストシステム

**権限による制御**：
- 本機能は管理者（Admin）権限を持つユーザーのみがアクセス可能

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 264 | ラベル一覧 | 主画面 | システムラベル一覧表示 |
| 265 | ラベル新規作成 | 主画面 | システムラベル作成 |
| 266 | ラベル編集 | 主画面 | システムラベル編集 |

## 機能種別

CRUD操作

## 入力仕様

### 入力パラメータ

#### ラベル作成・編集時

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| title | String | Yes | ラベルタイトル | 必須 |
| description | String | No | ラベル説明 | 最大512KB |
| color | String | Yes | ラベル色 | 有効なカラーコード（例: #428BCA） |

### 入力データソース

- 画面入力（ラベル作成・編集フォーム）
- セッション情報（現在の管理者ユーザー）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| labels | Array[Label] | テンプレートラベル一覧 |
| label | Label | 個別ラベル |
| flash_message | String | 操作結果メッセージ |

### 出力先

- 画面表示（HTML）
- リダイレクト（操作完了後）

## 処理フロー

### 処理シーケンス

```
1. ラベル一覧表示（index）
   └─ Label.in_organization.templates → paginate → render
2. 新規作成画面表示（new）
   └─ Label.new → render
3. ラベル作成（create）
   └─ Labels::CreateService#execute(template: true) → redirect/render
4. ラベル詳細表示（show）
   └─ set_label → render
5. 編集画面表示（edit）
   └─ set_label → render
6. ラベル更新（update）
   └─ Labels::UpdateService#execute → redirect/render
7. ラベル削除（destroy）
   └─ @label.destroy → redirect
```

### フローチャート

```mermaid
flowchart TD
    A[管理者がラベル管理画面にアクセス] --> B{操作種別}
    B -->|一覧表示| C[Label.in_organization.templates]
    C --> D[ページネーション]
    D --> E[一覧画面表示]

    B -->|新規作成| F[new画面表示]
    F --> G[フォーム入力]
    G --> H[Labels::CreateService.execute]
    H --> I{成功?}
    I -->|Yes| J[一覧へリダイレクト]
    I -->|No| K[エラー表示]

    B -->|編集| L[set_label]
    L --> M[編集フォーム表示]
    M --> N[フォーム入力]
    N --> O[Labels::UpdateService.execute]
    O --> P{成功?}
    P -->|Yes| Q[一覧へリダイレクト]
    P -->|No| R[エラー表示]

    B -->|削除| S[set_label]
    S --> T{destroy成功?}
    T -->|Yes| U[一覧へリダイレクト（notice）]
    T -->|No| V[一覧へリダイレクト（alert）]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-120-01 | テンプレートラベルのみ管理 | 管理画面ではテンプレートラベル（template: true）のみを管理 | 全操作 |
| BR-120-02 | 組織スコープ | 現在の組織に属するラベルのみを表示・操作 | 全操作 |
| BR-120-03 | 説明サイズ制限 | ラベル説明は最大512KBまで | 作成・編集時 |
| BR-120-04 | 色バリデーション | カラーコードは有効な形式である必要がある | 作成・編集時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧表示 | labels | SELECT | テンプレートラベル一覧取得 |
| 作成 | labels | INSERT | 新規テンプレートラベル作成 |
| 更新 | labels | UPDATE | ラベル更新 |
| 削除 | labels, label_links等 | DELETE | ラベルと関連データ削除 |

### テーブル別操作詳細

#### labelsテーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, title, description, color等 | template=true AND organization_id=current | ページネーション対応 |
| INSERT | title, description, color, template, organization_id | フォーム入力値、template=true | Labels::CreateService経由 |
| UPDATE | title, description, color | フォーム入力値 | Labels::UpdateService経由 |
| DELETE | - | id指定 | 関連データも削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 404 | 存在しないリソース | 指定されたラベルが見つからない | 404エラーページ表示 |
| 422 | バリデーションエラー | タイトル重複、色形式不正等 | エラーメッセージを表示して再入力を促す |

### リトライ仕様

特になし

## トランザクション仕様

- 各操作は単一トランザクションとして処理
- 削除時は関連データ（label_links等）もカスケード削除

## パフォーマンス要件

- ラベル一覧はページネーション対応

## セキュリティ考慮事項

- 管理者権限（Admin）が必須
- 組織スコープでのアクセス制御

## 備考

- テンプレートラベルは新規プロジェクト作成時に自動的にコピーされる
- プロジェクト・グループ固有のラベルは別の管理画面で管理

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | label.rb | `app/models/label.rb` | Labelモデルの属性、スコープ、バリデーションを理解 |

**読解のコツ**: `templates`スコープと`in_organization`スコープの組み合わせでテンプレートラベルを取得する。`DESCRIPTION_LENGTH_MAX`で説明の最大サイズが定義されている。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | labels_controller.rb | `app/controllers/admin/labels_controller.rb` | 各アクションの処理フローを理解 |

**主要処理フロー**:
1. **9-11行目**: `index`アクション - 組織内のテンプレートラベル一覧取得、ページネーション
2. **15-17行目**: `new`アクション - 新規ラベルフォーム
3. **21-28行目**: `create`アクション - Labels::CreateService経由で作成（template: true）
4. **31-38行目**: `update`アクション - Labels::UpdateService経由で更新
5. **41-57行目**: `destroy`アクション - ラベル削除（JSON/HTML両対応）

#### Step 3: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | create_service.rb | `app/services/labels/create_service.rb` | ラベル作成ロジック |
| 3-2 | update_service.rb | `app/services/labels/update_service.rb` | ラベル更新ロジック |

### プログラム呼び出し階層図

```
Admin::LabelsController
    │
    ├─ index
    │      └─ Label.in_organization.templates.page
    │
    ├─ new
    │      └─ Label.new
    │
    ├─ create
    │      └─ Labels::CreateService#execute
    │             └─ (template: true, organization_id: Current.organization.id)
    │
    ├─ show
    │      └─ set_label
    │
    ├─ edit
    │      └─ set_label
    │
    ├─ update
    │      └─ Labels::UpdateService#execute
    │
    └─ destroy
           └─ @label.destroy
```

### データフロー図

```
[入力]                    [処理]                           [出力]

管理者操作 ───────▶ Admin::LabelsController ───────▶ HTMLレスポンス
  │                      │
  │                      ▼
  │           Labels::*Service
  │                      │
  │                      ▼
  │              Label Model
  │                      │
  └──────────────▶ labels テーブル ────────────────────▶ プロジェクト作成時にコピー
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| labels_controller.rb | `app/controllers/admin/labels_controller.rb` | コントローラー | ラベル管理のエントリーポイント |
| label.rb | `app/models/label.rb` | モデル | ラベルデータモデル |
| create_service.rb | `app/services/labels/create_service.rb` | サービス | ラベル作成ロジック |
| update_service.rb | `app/services/labels/update_service.rb` | サービス | ラベル更新ロジック |
