# 機能設計書 122-グループダッシュボード

## 概要

本ドキュメントは、GitLabにおけるグループダッシュボード機能の設計仕様を記述したものである。グループダッシュボードは、ユーザーが所属する全グループを一覧表示し、効率的なグループナビゲーションを提供する機能である。

### 本機能の処理概要

**業務上の目的・背景**：企業や大規模組織では、多数のグループが階層的に存在することが一般的である。グループダッシュボードは、ユーザーが自身の所属グループや利用可能なグループを素早く把握し、目的のグループにアクセスするためのナビゲーション基盤を提供する。組織構造の可視化と効率的なプロジェクト管理に寄与する。

**機能の利用シーン**：ナビゲーションメニューから「グループ」を選択した際に表示される。新規プロジェクトの作成先グループを探す場面、所属グループの活動状況を確認する場面、サブグループを含む組織構造を把握する場面などで利用される。

**主要な処理内容**：
1. ユーザーがアクセス可能なグループの検索・フィルタリング
2. グループツリー形式での階層的表示
3. 組織（Organization）によるスコープ制御
4. アクティブ/アーカイブ状態によるフィルタリング
5. グループ情報の効率的なレンダリング

**関連システム・外部連携**：Current.organizationを参照して現在の組織コンテキストでグループをフィルタリング。

**権限による制御**：ユーザーは自身がアクセス権を持つグループのみ表示される。all_available: falseにより、明示的に権限を持つグループのみが対象となる。クロスプロジェクトアクセスチェックはスキップされる。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 12 | グループ一覧 | 主画面 | 参加グループの一覧表示 |
| 20 | グループ探索 | 参照画面 | 公開グループの検索・探索 |

## 機能種別

データ取得・表示（READ操作）/ グループ階層表示

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| active | Boolean | No | アクティブグループのみ表示 | true/false |
| filter | String | No | グループ名フィルタ | 文字列 |
| sort | String | No | ソート順 | 許可されたソート順 |

### 入力データソース

- セッション情報（current_user）
- Current.organization（組織コンテキスト）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| groups | ActiveRecord::Relation<Group> | グループ一覧 |
| tree structure | JSON/HTML | グループツリー構造 |

### 出力先

- HTML画面（グループ一覧ビュー）
- JSON API（グループツリーデータ）

## 処理フロー

### 処理シーケンス

```
1. 認証チェック
   └─ 未認証の場合もパブリックグループは表示可能
2. GroupsFinder初期化
   └─ current_user、organization、activeパラメータ設定
3. グループ検索実行
   └─ all_available: falseで権限付きグループのみ
4. グループツリーレンダリング
   └─ GroupTree concernによる階層表示
5. レスポンス生成
   └─ HTML/JSON形式で返却
```

### フローチャート

```mermaid
flowchart TD
    A[リクエスト受信] --> B[GroupsFinder初期化]
    B --> C{all_available設定}
    C -->|false| D[権限付きグループ取得]
    D --> E{organizationフィルタ}
    E -->|あり| F[組織内グループに限定]
    E -->|なし| G[全グループ対象]
    F --> H[activeフィルタ適用]
    G --> H
    H --> I[グループツリーレンダリング]
    I --> J[レスポンス返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-122-01 | 権限ベースフィルタ | all_available: falseにより、ユーザーが明示的にアクセス権を持つグループのみ表示 | 常時 |
| BR-122-02 | 組織スコープ | Current.organizationが設定されている場合、その組織内のグループのみ表示 | organization設定時 |
| BR-122-03 | アクティブフィルタ | activeパラメータでアーカイブされていないグループのみ表示可能 | activeパラメータ指定時 |

### 計算ロジック

なし（データ取得・フィルタリングのみ）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| グループ一覧取得 | namespaces | SELECT | グループ情報取得（type = 'Group'） |
| 権限確認 | members | SELECT | ユーザーのグループメンバーシップ確認 |
| ルート取得 | routes | SELECT | グループパス情報取得 |

### テーブル別操作詳細

#### namespaces

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, name, path, parent_id, visibility_level | type = 'Group' AND organization_id = ? | 組織フィルタ適用時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 空リスト | アクセス可能なグループがない | 空の一覧を表示（エラーではない） |

### リトライ仕様

データベースタイムアウト時は標準的なRailsリトライ機構に従う。

## トランザクション仕様

読み取り専用のため、明示的なトランザクション管理は不要。

## パフォーマンス要件

- urgency: low
- with_routeスコープによるN+1クエリ防止
- GroupTreeによる効率的な階層レンダリング

## セキュリティ考慮事項

- クロスプロジェクトアクセスチェックはスキップ（skip_cross_project_access_check）
- グループ可視性レベルに基づくフィルタリング
- メンバーシップベースのアクセス制御

## 備考

- GroupTree concernを使用したツリー形式レンダリング
- EE版でGroupsFinderに追加フィルタが提供される可能性あり

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

グループモデルとその階層構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Group | `app/models/group.rb` | グループの基本属性とparent_id階層構造 |
| 1-2 | Namespace | `app/models/namespace.rb` | グループの親クラス、STI継承構造 |

**読解のコツ**: GroupはNamespaceを継承しており、type = 'Group'でSTI（Single Table Inheritance）を使用している。

#### Step 2: エントリーポイントを理解する

コントローラーの処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Dashboard::GroupsController | `app/controllers/dashboard/groups_controller.rb` | indexアクションの処理フロー |

**主要処理フロー**:
1. **12-21行目**: indexアクション - GroupsFinderでグループ取得し、render_group_treeで表示
2. **13-18行目**: GroupsFinder初期化 - all_available: false, organization, activeパラメータ

#### Step 3: グループ検索処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | GroupsFinder | `app/finders/groups_finder.rb` | グループ検索のメインロジック |

**主要処理フロー**:
- **45-51行目**: executeメソッド - フィルタ適用とソート
- **61-74行目**: all_groupsメソッド - 権限ベースのグループ取得
- **109-122行目**: filter_groupsメソッド - 各種フィルタの適用順序

#### Step 4: グループツリーレンダリングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | GroupTree | `app/controllers/concerns/group_tree.rb` | グループツリー構築ロジック |

### プログラム呼び出し階層図

```
Dashboard::GroupsController#index
    │
    └─ GroupsFinder.new(current_user, params).execute
           │
           ├─ all_groups
           │      ├─ owned_groups（owedパラメータ時）
           │      ├─ groups_with_min_access_level
           │      ├─ authorized_groups
           │      └─ public_groups
           │
           ├─ filter_groups
           │      ├─ by_organization
           │      ├─ by_active
           │      ├─ by_parent
           │      ├─ by_visibility
           │      └─ by_search
           │
           └─ sort
                  └─ with_route
```

### データフロー図

```
[入力]                    [処理]                              [出力]

current_user ───────────▶ Dashboard::GroupsController ──────▶ HTML View
                               │
organization ──────────────────┤
                               │
active param ──────────────────┤
                               │
                         GroupsFinder
                               │
                         ┌─────┴─────┐
                         │           │
                   authorized_groups public_groups
                         │           │
                         └─────┬─────┘
                               │
                         filter_groups
                               │
                         GroupTree#render_group_tree
                               │
                               ▼
                         groups (HTML/JSON)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Dashboard::GroupsController | `app/controllers/dashboard/groups_controller.rb` | コントローラー | エントリーポイント |
| Dashboard::ApplicationController | `app/controllers/dashboard/application_controller.rb` | 基底コントローラー | 認証・共通処理 |
| GroupsFinder | `app/finders/groups_finder.rb` | ファインダー | グループ検索ロジック |
| GroupTree | `app/controllers/concerns/group_tree.rb` | Concern | グループツリーレンダリング |
| Namespaces::GroupsFilter | `app/finders/concerns/namespaces/groups_filter.rb` | Concern | グループフィルタリング |
| Group | `app/models/group.rb` | モデル | グループデータ構造 |
| Namespace | `app/models/namespace.rb` | モデル | 基底名前空間 |
