# 機能設計書 128-バリューストリームアナリティクス

## 概要

本ドキュメントは、GitLabにおけるバリューストリームアナリティクス（Value Stream Analytics）機能の設計仕様を記述したものである。本機能は、ソフトウェア開発プロセスの各ステージ（Issue作成からデプロイまで）の所要時間を可視化し、開発サイクル全体の効率改善を支援する。

### 本機能の処理概要

**業務上の目的・背景**：DevOpsの成熟度向上には、開発プロセス全体を通じたリードタイムの測定と改善が重要である。バリューストリームアナリティクスは、アイデアから本番環境へのデプロイまでの各段階（Issue、Plan、Code、Test、Review、Staging、Production）の所要時間を測定し、ボトルネックの特定やプロセス改善の効果測定を可能にする。

**機能の利用シーン**：プロジェクトのAnalyticsメニューから「Value stream」を選択した際に表示される。スプリントレトロスペクティブでプロセスを振り返る場面、チームのベロシティを評価する場面、開発プロセスの改善施策を計画する場面などで利用される。

**主要な処理内容**：
1. 開発サイクルステージの時間計測
2. ステージ別統計（中央値、件数）の算出
3. サマリーメトリクス（デプロイ頻度、リードタイム等）の計算
4. 権限に基づくデータアクセス制御
5. 内部イベントの追跡

**関連システム・外部連携**：Issue、MergeRequest、Deploymentの各モデルからイベント情報を収集。Snowplowへの分析イベント送信（p_analytics_valuestream）。

**権限による制御**：Cycle Analytics読み取り権限（authorize_read_cycle_analytics!）が必要。プロジェクトへの読み取りアクセス権が前提。EE版ではグループレベルの分析も可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 102 | サイクルアナリティクス | 主画面 | 開発サイクル時間の分析表示 |

## 機能種別

データ取得・分析（READ操作）/ プロセス分析

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| namespace_id | String | Yes | プロジェクトの名前空間 | 有効な名前空間 |
| project_id | String | Yes | プロジェクトID | 有効なプロジェクト |
| created_after | Date | No | 分析開始日 | 有効な日付 |
| created_before | Date | No | 分析終了日 | 有効な日付 |
| author_username | String | No | 作成者フィルタ | 有効なユーザー名 |
| milestone_title | String | No | マイルストーンフィルタ | 有効なマイルストーン |
| label_name | Array | No | ラベルフィルタ | 有効なラベル名 |

### 入力データソース

- issues テーブル（ステージイベント）
- merge_requests テーブル（ステージイベント）
- deployments テーブル（デプロイイベント）
- analytics_cycle_analytics_stage_events テーブル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| summary | Array<Hash> | サマリーメトリクス |
| stats | Array<Hash> | ステージ別統計 |
| permissions | Hash | ユーザー権限情報 |

### 出力先

- HTML画面（ダッシュボード）
- JSON API

## 処理フロー

### 処理シーケンス

```
1. 権限チェック
   └─ authorize_read_cycle_analytics!
2. CycleAnalytics::ProjectLevel初期化
   └─ プロジェクトとオプション設定
3. RequestParams生成
   └─ フィルタパラメータ解析
4. サマリー計算
   └─ StageSummaryでメトリクス算出
5. ステージ統計計算
   └─ 各ステージの中央値・件数算出
6. イベント追跡
   └─ track_event (p_analytics_valuestream)
7. レスポンス生成
```

### フローチャート

```mermaid
flowchart TD
    A[リクエスト受信] --> B{権限チェック}
    B -->|No| C[403 Forbidden]
    B -->|Yes| D[ProjectLevel初期化]
    D --> E[RequestParams生成]
    E --> F{レスポンス形式}
    F -->|HTML| G[内部イベント追跡]
    F -->|JSON| H[サマリー計算]
    G --> I[HTMLレンダリング]
    H --> J[ステージ統計計算]
    J --> K[権限情報取得]
    K --> L[JSONレスポンス]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-128-01 | デフォルトステージ | Issue, Plan, Code, Test, Review, Staging, Productionの7ステージ | CE版 |
| BR-128-02 | タイムアウト処理 | GracefulTimeoutHandlingで長時間クエリを制御 | 常時 |
| BR-128-03 | ValueStream選択 | デフォルトValueStreamを使用（CE版） | CE版 |

### 計算ロジック

**ステージ時間計算**:
```ruby
# 各ステージの開始/終了イベントの時刻差を計算
# 例: Codeステージ = 最初のコミット時刻 - Issueの計画完了時刻
median_time = stage_events.map(&:duration).median
count = stage_events.count
```

**デフォルトステージ定義**:
- Issue: Issue作成からラベル付与まで
- Plan: ラベル付与から最初のコミットまで
- Code: 最初のコミットからMR作成まで
- Test: CI/CDパイプライン実行時間
- Review: MR作成からマージまで
- Staging: マージからステージングデプロイまで
- Production: ステージングから本番デプロイまで

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ステージイベント | analytics_cycle_analytics_issue_stage_events | SELECT | Issueステージイベント |
| ステージイベント | analytics_cycle_analytics_merge_request_stage_events | SELECT | MRステージイベント |
| サマリー | issues, merge_requests, deployments | SELECT | 統計算出 |

### テーブル別操作詳細

#### analytics_cycle_analytics_issue_stage_events

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | stage_event_hash_id, issue_id, start_event_timestamp, end_event_timestamp | namespace_id経由で取得 | ステージ時間算出 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 403 | Forbidden | 権限不足 | アクセス拒否 |
| 408 | Timeout | クエリタイムアウト | GracefulTimeoutHandling |

### リトライ仕様

GracefulTimeoutHandlingで制御。タイムアウト時は部分データを返却。

## トランザクション仕様

読み取り専用のため、明示的なトランザクション管理は不要。

## パフォーマンス要件

- feature_category: value_stream_management
- urgency: low
- GracefulTimeoutHandlingで長時間クエリを制御

## セキュリティ考慮事項

- Cycle Analytics読み取り権限の確認
- プロジェクト可視性に基づくアクセス制御
- ライセンス機能の確認（EE機能）

## 備考

- EE版ではグループレベル分析、カスタムステージ定義が可能
- prepend_mod_with('Analytics::CycleAnalytics::ProjectLevel')で拡張
- ライセンス機能: group_level_analytics_dashboard, cycle_analytics_for_projects

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

バリューストリームとステージの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Analytics::CycleAnalytics::ProjectLevel | `app/models/analytics/cycle_analytics/project_level.rb` | プロジェクトレベル分析クラス |
| 1-2 | Analytics::CycleAnalytics::Stage | `app/models/analytics/cycle_analytics/stage.rb` | ステージモデル |
| 1-3 | Analytics::CycleAnalytics::ValueStream | `app/models/analytics/cycle_analytics/value_stream.rb` | バリューストリームモデル |

**読解のコツ**:
- ProjectLevelはCE版のメインクラス。summaryとstatsメソッドが重要。
- Stageはstart_event_identifier/end_event_identifierでステージ境界を定義。

#### Step 2: エントリーポイントを理解する

コントローラーの処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Projects::CycleAnalyticsController | `app/controllers/projects/cycle_analytics_controller.rb` | showアクションの処理フロー |

**主要処理フロー**:
1. **12行目**: authorize_read_cycle_analytics!権限チェック
2. **14-18行目**: track_event設定
3. **33-50行目**: showアクション - HTML/JSON分岐
4. **64-70行目**: cycle_analytics_jsonメソッド - レスポンス構築

#### Step 3: 分析ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Analytics::CycleAnalytics::ProjectLevel#summary | `app/models/analytics/cycle_analytics/project_level.rb` (13-18行目) | サマリー算出 |
| 3-2 | Analytics::CycleAnalytics::ProjectLevel#stats | `app/models/analytics/cycle_analytics/project_level.rb` (25-29行目) | ステージ統計算出 |

### プログラム呼び出し階層図

```
Projects::CycleAnalyticsController#show
    │
    ├─ (HTML)
    │      └─ Gitlab::InternalEvents.track_event('view_cycle_analytics')
    │
    └─ (JSON)
           └─ cycle_analytics_json
                  │
                  ├─ @cycle_analytics.summary
                  │      └─ Gitlab::CycleAnalytics::StageSummary
                  │
                  ├─ @cycle_analytics.stats
                  │      └─ default_stage_names.map { |name| self[name].as_json }
                  │             └─ CycleAnalytics::ProjectLevelStageAdapter
                  │
                  └─ @cycle_analytics.permissions
                         └─ Gitlab::CycleAnalytics::Permissions
```

### データフロー図

```
[入力]                    [処理]                              [出力]

params ─────────────────▶ CycleAnalyticsController ─────────▶ HTML/JSON
                               │
                         ┌─────┴─────┐
                         │           │
           Analytics::CycleAnalytics::ProjectLevel
                         │
                   ┌─────┼─────┐
                   │     │     │
               summary  stats  permissions
                   │     │     │
            StageSummary │  Permissions
                   │     │     │
                   │  default_stages
                   │     │
                   │  StageAdapter
                   │     │
                   └─────┼─────┘
                         │
                         ▼
                  JSON Response
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Projects::CycleAnalyticsController | `app/controllers/projects/cycle_analytics_controller.rb` | コントローラー | エントリーポイント |
| Analytics::CycleAnalytics::ProjectLevel | `app/models/analytics/cycle_analytics/project_level.rb` | モデル | プロジェクトレベル分析 |
| Analytics::CycleAnalytics::Stage | `app/models/analytics/cycle_analytics/stage.rb` | モデル | ステージ定義 |
| Analytics::CycleAnalytics::ValueStream | `app/models/analytics/cycle_analytics/value_stream.rb` | モデル | バリューストリーム |
| Gitlab::CycleAnalytics::StageSummary | `lib/gitlab/cycle_analytics/stage_summary.rb` | ライブラリ | サマリー計算 |
| Gitlab::CycleAnalytics::Permissions | `lib/gitlab/cycle_analytics/permissions.rb` | ライブラリ | 権限チェック |
| CycleAnalytics::ProjectLevelStageAdapter | `app/models/cycle_analytics/project_level_stage_adapter.rb` | アダプター | ステージデータ変換 |
| CycleAnalyticsParams | `app/controllers/concerns/cycle_analytics_params.rb` | Concern | パラメータ処理 |
| GracefulTimeoutHandling | `app/controllers/concerns/graceful_timeout_handling.rb` | Concern | タイムアウト処理 |
