# 機能設計書 131-アラート管理

## 概要

本ドキュメントは、GitLabにおけるアラート管理機能の設計について記述する。外部モニタリングツール（Prometheus等）からのアラートを受信・管理し、インシデント対応のトリガーとなるアラートのライフサイクル管理機能を定義する。

### 本機能の処理概要

**業務上の目的・背景**：本番環境やステージング環境で稼働するアプリケーションやインフラストラクチャの障害・異常を迅速に検知し、適切な担当者に通知することで、サービスのダウンタイムを最小化する。外部のモニタリングツール（Prometheus、Datadog、PagerDuty等）からのアラートをGitLab上で一元管理することで、開発チームとオペレーションチームの連携を円滑にし、DevOps実践を支援する。

**機能の利用シーン**：
- 本番システムでCPU使用率やメモリ使用量が閾値を超えた際に自動でアラートを受信
- アプリケーションエラー率の急上昇を検知してオンコール担当者に通知
- 外部モニタリングサービスからのWebhookを受信してGitLab上でインシデントを管理
- 過去のアラート履歴を分析してシステムの傾向を把握

**主要な処理内容**：
1. HTTP統合エンドポイントを介した外部アラートの受信
2. アラートの重要度（Critical/High/Medium/Low/Info）による分類
3. アラートのステータス管理（Triggered/Acknowledged/Resolved）
4. アラートからインシデント（Issue）の自動生成
5. アラートへの担当者アサイン
6. アラートに関するシステムノート・コメントの管理
7. アラートのフィンガープリントによる重複検知と統合

**関連システム・外部連携**：
- Prometheus AlertManager
- 外部HTTP統合（汎用Webhook）
- Slack/Mattermost等への通知連携
- PagerDuty、Opsgenie等のインシデント管理ツール

**権限による制御**：
- `read_alert_management_alert`: アラート一覧・詳細の閲覧
- `update_alert_management_alert`: アラートのステータス変更、担当者アサイン
- `admin_operations`: HTTP統合の作成・編集・削除

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 100 | アラート管理 | 主機能 | アラートの一覧・管理 |
| 114 | 運用設定 | 補助機能 | 運用関連設定の管理 |

## 機能種別

CRUD操作 / イベント処理 / ステータス管理 / 外部連携

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| title | String | Yes | アラートタイトル | 最大200文字 |
| description | String | No | アラート詳細説明 | 最大1000文字 |
| severity | String | Yes | 重要度 | critical/high/medium/low/info/unknown |
| status | String | No | ステータス | triggered/acknowledged/resolved |
| started_at | DateTime | Yes | アラート発生日時 | ISO8601形式 |
| ended_at | DateTime | No | アラート終了日時 | ISO8601形式 |
| monitoring_tool | String | No | モニタリングツール名 | 最大100文字 |
| service | String | No | サービス名 | 最大100文字 |
| hosts | Array | No | 影響を受けたホスト | 各要素最大255文字 |
| fingerprint | String | No | アラートの一意識別子 | SHA256ハッシュ |
| assignee_ids | Array | No | 担当者ID | プロジェクトメンバーのユーザーID |

### 入力データソース

- 外部モニタリングツールからのHTTP POST（Webhook）
- GitLab UI上での手動入力・更新
- GraphQL APIからのミューテーション

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | Integer | アラートID |
| iid | Integer | プロジェクト内の一意ID |
| title | String | アラートタイトル |
| description | String | アラート詳細 |
| severity | String | 重要度 |
| status | String | 現在のステータス |
| events | Integer | 発生回数 |
| started_at | DateTime | 発生日時 |
| ended_at | DateTime | 終了日時 |
| assignees | Array | 担当者一覧 |
| issue | Object | 関連するイシュー |
| notes | Array | コメント・システムノート |

### 出力先

- GitLab UIでのアラート一覧・詳細表示
- REST API / GraphQL APIレスポンス
- Webhook連携による外部通知
- 関連イシューへのシステムノート

## 処理フロー

### 処理シーケンス

```
1. アラート受信
   └─ HTTP統合エンドポイントまたはPrometheus連携経由でアラートペイロードを受信
2. アラートペイロード解析
   └─ Gitlab::AlertManagement::Payloadでペイロードを正規化
3. 重複チェック
   └─ fingerprintを使用して既存の未解決アラートと照合
4. アラート作成/更新
   └─ 新規の場合は作成、重複の場合はイベント数をインクリメント
5. 後処理実行
   └─ インシデント自動作成、Webhook通知、システムノート追加
6. レスポンス返却
   └─ 処理結果をJSON形式で返却
```

### フローチャート

```mermaid
flowchart TD
    A[アラート受信] --> B{ペイロード検証}
    B -->|有効| C[フィンガープリント計算]
    B -->|無効| X[エラーレスポンス]
    C --> D{既存アラート存在?}
    D -->|Yes| E[イベント数インクリメント]
    D -->|No| F[新規アラート作成]
    E --> G[ステータス確認]
    F --> G
    G --> H{自動インシデント作成?}
    H -->|Yes| I[インシデント作成]
    H -->|No| J[Webhook実行]
    I --> J
    J --> K[レスポンス返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-131-01 | 重複アラート統合 | 同一fingerprintの未解決アラートが存在する場合、新規作成せずイベント数をインクリメント | fingerprint一致かつステータスがresolvedでない |
| BR-131-02 | 自動解決 | ended_atが設定されたアラートは自動的にresolvedステータスになる | ended_atが設定されている |
| BR-131-03 | 担当者権限チェック | 担当者にはアラート閲覧権限が必要 | 担当者アサイン時 |
| BR-131-04 | インシデント作成制限 | 1アラートにつき1イシューのみ作成可能 | インシデント作成時 |

### 計算ロジック

- **イベント数カウント**: 同一fingerprintのアラート受信ごとに`events`カラムをインクリメント
- **重要度ソート**: critical(0) < high(1) < medium(2) < low(3) < info(4) < unknown(5) の順で数値が小さいほど重要

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| アラート作成 | alert_management_alerts | INSERT | 新規アラートレコード作成 |
| アラート更新 | alert_management_alerts | UPDATE | ステータス・担当者等の更新 |
| イベント登録 | alert_management_alerts | UPDATE | eventsカラムのインクリメント |
| 担当者アサイン | alert_management_alert_assignees | INSERT/DELETE | 担当者の追加・削除 |
| ノート追加 | notes | INSERT | システムノート・コメント追加 |
| インシデント作成 | issues | INSERT | 関連イシューの作成 |

### テーブル別操作詳細

#### alert_management_alerts

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | title, description, severity, status, started_at | 受信ペイロードから抽出 | iidは自動採番 |
| UPDATE | status, ended_at, events | ステータス変更値、イベント数+1 | - |
| SELECT | project_id, fingerprint | プロジェクトIDとfingerprint | 重複チェック用 |

#### alert_management_http_integrations

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name, active, endpoint_identifier | ユーザー入力値 | トークンは自動生成 |
| SELECT | project_id, active | プロジェクトIDとactive=true | 有効な統合の取得 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 401 | Unauthorized | 無効なトークン | 正しいトークンで再試行 |
| 403 | Forbidden | 権限不足 | 適切な権限を付与 |
| 422 | Unprocessable Entity | バリデーションエラー | 入力値を修正 |
| 400 | Bad Request | 不正なペイロード形式 | ペイロード形式を確認 |

### リトライ仕様

外部Webhook通知失敗時は、最大3回まで指数バックオフでリトライ

## トランザクション仕様

- アラート作成・更新はトランザクション内で実行
- 関連するシステムノート、担当者アサインは同一トランザクション
- インシデント作成は別トランザクションで実行（失敗してもアラート作成はロールバックしない）

## パフォーマンス要件

- アラート受信エンドポイントは99パーセンタイルで500ms以内にレスポンス
- アラート一覧取得は100件以下で100ms以内

## セキュリティ考慮事項

- HTTP統合トークンはSHA256でハッシュ化して保存
- アラートペイロードはサニタイズ処理を実施
- 担当者アサインは権限チェックを実施
- 監査ログにアラートステータス変更を記録

## 備考

- アラート参照形式: `^alert#123`
- Prometheusアラートは`monitoring_tool`が自動設定される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

アラート管理の中核となるデータモデルを理解することが最初のステップである。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | alert.rb | `app/models/alert_management/alert.rb` | アラートのデータ構造、バリデーション、スコープを理解 |
| 1-2 | http_integration.rb | `app/models/alert_management/http_integration.rb` | HTTP統合設定のデータ構造を理解 |
| 1-3 | alert_assignee.rb | `app/models/alert_management/alert_assignee.rb` | 担当者との関連を理解 |

**読解のコツ**: AlertモデルはIncidentManagement::Escalatableをincludeしており、ステータス管理の多くはこのconcernに委譲されている。`enum :severity`と`enum :domain`の定義に注目。

#### Step 2: エントリーポイントを理解する

アラート機能のUIエントリーポイントとなるコントローラーを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | alert_management_controller.rb | `app/controllers/projects/alert_management_controller.rb` | 画面表示のエントリーポイント |
| 2-2 | alert_management_helper.rb | `app/helpers/projects/alert_management_helper.rb` | フロントエンドへのデータ受け渡し |

**主要処理フロー**:
1. **6行目**: `authorize_read_alert_management_alert!`で閲覧権限をチェック
2. **12行目**: `index`アクションでアラート一覧画面を表示
3. **14-16行目**: `details`アクションでアラート詳細画面を表示、`@alert_id`をセット

#### Step 3: アラート更新サービスを理解する

アラートのステータス変更や担当者アサインのビジネスロジック。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | update_service.rb | `app/services/alert_management/alerts/update_service.rb` | アラート更新の中核ロジック |

**主要処理フロー**:
- **19-35行目**: `execute`メソッドで権限チェック、パラメータフィルタ、更新実行
- **83-86行目**: `handle_changes`で担当者変更・ステータス変更の後処理
- **116-127行目**: `filter_status`でステータス遷移の妥当性チェック
- **142-148行目**: `filter_duplicate`で重複アラートへのステータス変更を制限

#### Step 4: インシデント作成サービスを理解する

アラートからイシュー（インシデント）を作成するロジック。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | create_alert_issue_service.rb | `app/services/alert_management/create_alert_issue_service.rb` | インシデント作成ロジック |

**主要処理フロー**:
- **17-28行目**: `execute`メソッドで権限チェック、既存イシューチェック、インシデント作成
- **40-48行目**: `create_incident`でIncidentManagement::Incidents::CreateServiceを呼び出し
- **57-60行目**: `perform_after_create_tasks`でタイトル更新とシステムノート追加

#### Step 5: HTTP統合サービスを理解する

外部からのアラート受信設定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | create_service.rb | `app/services/alert_management/http_integrations/create_service.rb` | HTTP統合作成ロジック |

**主要処理フロー**:
- **6-26行目**: `execute`メソッドでトランザクション内で統合を作成
- **15-18行目**: `too_many_integrations?`で統合数の制限チェック

### プログラム呼び出し階層図

```
AlertManagementController
    │
    ├─ index (アラート一覧)
    │      └─ AlertManagementHelper#alert_management_data
    │
    └─ details (アラート詳細)
           └─ AlertManagementHelper#alert_management_detail_data

AlertManagement::Alerts::UpdateService
    │
    ├─ filter_params
    │      ├─ filter_status
    │      ├─ filter_assignees
    │      └─ filter_duplicate
    │
    └─ handle_changes
           ├─ handle_assignement
           │      ├─ TodoService#reassigned_assignable
           │      └─ SystemNoteService#change_issuable_assignees
           │
           └─ handle_status_change
                  ├─ SystemNoteService#change_alert_status
                  └─ TodoService#resolve_todos_for_target

AlertManagement::CreateAlertIssueService
    │
    ├─ create_incident
    │      └─ IncidentManagement::Incidents::CreateService
    │
    └─ perform_after_create_tasks
           ├─ update_title_for
           └─ SystemNoteService#new_alert_issue
```

### データフロー図

```
[入力]                      [処理]                         [出力]

外部モニタリング ──────▶ HTTP統合エンドポイント ──────▶ AlertManagement::Alert
(Prometheus等)              │                              │
                           ▼                              ▼
                    ペイロード解析              アラート一覧/詳細画面
                           │                              │
                           ▼                              ▼
                    重複チェック ──────────────▶ システムノート
                           │                              │
                           ▼                              ▼
              AlertManagement::CreateAlertIssueService    Issue
                                                    (インシデント)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| alert.rb | `app/models/alert_management/alert.rb` | モデル | アラートのデータモデル定義 |
| http_integration.rb | `app/models/alert_management/http_integration.rb` | モデル | HTTP統合設定 |
| alert_assignee.rb | `app/models/alert_management/alert_assignee.rb` | モデル | 担当者アサイン |
| metric_image.rb | `app/models/alert_management/metric_image.rb` | モデル | メトリクス画像 |
| alert_management_controller.rb | `app/controllers/projects/alert_management_controller.rb` | コントローラー | UI表示制御 |
| update_service.rb | `app/services/alert_management/alerts/update_service.rb` | サービス | アラート更新ロジック |
| create_alert_issue_service.rb | `app/services/alert_management/create_alert_issue_service.rb` | サービス | インシデント作成 |
| create_service.rb | `app/services/alert_management/http_integrations/create_service.rb` | サービス | HTTP統合作成 |
| alert_management_helper.rb | `app/helpers/projects/alert_management_helper.rb` | ヘルパー | ビューヘルパー |
| alert_management_service.rb | `app/services/system_notes/alert_management_service.rb` | サービス | システムノート |
| alert_management_alerts_api.js | `app/assets/javascripts/api/alert_management_alerts_api.js` | JavaScript | API呼び出し |
| alert_management_table.vue | `app/assets/javascripts/alert_management/components/alert_management_table.vue` | Vue | 一覧表示コンポーネント |
