# 機能設計書 134-組織管理

## 概要

本ドキュメントは、GitLabにおける組織管理機能の設計について記述する。複数のグループやプロジェクトを束ねる上位概念としての「組織（Organization）」を管理し、大規模なエンタープライズ環境での階層的な権限管理とリソース管理を実現する機能を定義する。

### 本機能の処理概要

**業務上の目的・背景**：大規模な組織では、複数の部門・チームがそれぞれGitLabのグループやプロジェクトを持ち、これらを横断的に管理する必要がある。組織管理機能により、グループの上位概念として「組織」を導入し、複数のグループ・プロジェクトを論理的にまとめて管理できる。これにより、エンタープライズレベルでのガバナンス、リソース管理、アクセス制御を統一的に行える。

**機能の利用シーン**：
- 企業全体を代表する組織を作成し、配下に各部門のグループを配置
- 組織レベルでのユーザー管理と権限設定
- 組織配下のグループ・プロジェクトの一覧表示
- 組織全体のアクティビティ監視
- 管理者による組織の一元管理

**主要な処理内容**：
1. 組織の新規作成・編集・設定
2. 組織配下のグループ・プロジェクト管理
3. 組織ユーザーの管理
4. 組織のアクティビティ表示
5. CRM組織・連絡先の管理

**関連システム・外部連携**：
- グループ管理システム
- プロジェクト管理システム
- ユーザー管理システム
- CRM（顧客関係管理）

**権限による制御**：
- `read_organization`: 組織情報の閲覧
- `admin_organization`: 組織の管理
- `create_organization`: 組織の新規作成
- `read_organization_user`: 組織ユーザーの閲覧

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 182 | 組織一覧 | 主機能 | 組織の一覧表示 |
| 183 | 組織新規作成 | 主機能 | 新規組織の作成 |
| 184 | 組織詳細 | 主機能 | 組織のトップページ表示 |
| 185 | 組織ユーザー | 主機能 | 組織ユーザーの管理 |
| 186 | 組織グループ・プロジェクト | 主機能 | 組織配下のグループ・プロジェクト表示 |
| 187 | 組織アクティビティ | 主機能 | 組織アクティビティの表示 |
| 188 | 組織設定 | 主機能 | 組織の全般設定 |
| 167 | CRM組織一覧 | 補助機能 | CRM組織の一覧表示 |
| 168 | CRM連絡先一覧 | 補助機能 | CRM連絡先の一覧表示 |
| 239 | 組織一覧（管理者） | 補助機能 | 管理者向け組織一覧 |

## 機能種別

CRUD操作 / 階層管理 / ユーザー管理 / アクセス制御

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | String | Yes | 組織名 | - |
| path | String | Yes | 組織パス（URL） | 一意性、URL形式 |
| description | String | No | 組織説明 | - |
| visibility_level | String | No | 可視性レベル | private/internal/public |

### 入力データソース

- GitLab UI上でのユーザー入力
- GraphQL APIからのミューテーション
- 管理者画面からの操作

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | Integer | 組織ID |
| name | String | 組織名 |
| path | String | 組織パス |
| description | String | 組織説明 |
| groups | Array | 配下のグループ一覧 |
| projects | Array | 配下のプロジェクト一覧 |
| users | Array | 組織ユーザー一覧 |
| activity | Array | アクティビティイベント |

### 出力先

- GitLab UIでの組織一覧・詳細表示
- GraphQL APIレスポンス

## 処理フロー

### 処理シーケンス

```
1. 組織一覧取得リクエスト
   └─ ユーザーがアクセス可能な組織を取得
2. 組織詳細表示
   └─ 組織の基本情報、配下リソースの概要を表示
3. グループ・プロジェクト取得
   └─ 組織に属するグループとプロジェクトを取得
4. アクティビティ取得
   └─ 組織配下のイベントを時系列で取得
5. ユーザー管理
   └─ 組織に属するユーザーの一覧・権限管理
```

### フローチャート

```mermaid
flowchart TD
    A[組織一覧リクエスト] --> B{認証済み?}
    B -->|Yes| C[OrganizationsFinder]
    B -->|No| D[ログイン画面]
    C --> E[アクセス可能組織取得]
    E --> F[組織一覧表示]

    G[組織詳細リクエスト] --> H{閲覧権限?}
    H -->|Yes| I[組織情報取得]
    H -->|No| X[403 Forbidden]
    I --> J[配下リソース取得]
    J --> K[組織詳細表示]

    L[アクティビティ取得] --> M[EventCollection生成]
    M --> N[プロジェクト/グループのイベント収集]
    N --> O[可視性フィルタ]
    O --> P[アクティビティ表示]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-134-01 | パス一意性 | 組織パスはシステム全体で一意 | 組織作成/更新時 |
| BR-134-02 | リソース上限 | 組織配下のリソース取得は1000件まで | リソース一覧取得時 |
| BR-134-03 | アクティビティ上限 | アクティビティ取得はデフォルト20件 | アクティビティ取得時 |
| BR-134-04 | 可視性制御 | ユーザーに見えるイベントのみ表示 | アクティビティ取得時 |

### 計算ロジック

- **リソース取得上限**: DEFAULT_RESOURCE_LIMIT = 1000
- **アクティビティ取得上限**: DEFAULT_ACTIVITY_EVENT_LIMIT = 20

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 組織作成 | organizations | INSERT | 組織レコード作成 |
| 組織更新 | organizations | UPDATE | 組織情報更新 |
| グループ取得 | namespaces | SELECT | 組織配下のグループ取得 |
| プロジェクト取得 | projects | SELECT | 組織配下のプロジェクト取得 |
| イベント取得 | events | SELECT | アクティビティイベント取得 |

### テーブル別操作詳細

#### organizations

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name, path, description | ユーザー入力値 | - |
| UPDATE | name, description | 更新値 | pathは変更不可の場合あり |
| SELECT | id, path | 組織IDまたはパス | 組織取得 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 403 | Forbidden | 閲覧/管理権限なし | 適切な権限を付与 |
| 404 | Not Found | 組織が存在しない | 正しい組織を指定 |
| 422 | Unprocessable Entity | バリデーションエラー | 入力値を修正 |

### リトライ仕様

該当なし（同期処理）

## トランザクション仕様

- 組織作成時は単一トランザクションで実行
- 関連リソースの作成は別トランザクション

## パフォーマンス要件

- 組織一覧取得は100組織以下で200ms以内
- アクティビティ取得は20件以下で300ms以内

## セキュリティ考慮事項

- 組織へのアクセスは権限チェックを厳格に実施
- アクティビティ表示時は各イベントの可視性を個別チェック
- 管理者以外は自身が所属する組織のみ閲覧可能

## 備考

- 組織機能はフィーチャーフラグ`organization_switching`で制御される場合がある
- CRM組織・連絡先機能は組織管理の一部として提供

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

組織管理機能のUIエントリーポイント。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | organizations_controller.rb | `app/controllers/organizations/organizations_controller.rb` | 組織画面の制御 |
| 1-2 | admin/organizations_controller.rb | `app/controllers/admin/organizations_controller.rb` | 管理者向け組織管理 |

**主要処理フロー（organizations_controller.rb）**:
- **8-9行目**: 定数定義（DEFAULT_RESOURCE_LIMIT = 1000, DEFAULT_ACTIVITY_EVENT_LIMIT = 20）
- **14行目**: `authorize_read_organization!`で閲覧権限チェック
- **19行目**: フィーチャーフラグ`organization_switching`のプッシュ
- **23行目**: `index`アクションで組織一覧
- **25-27行目**: `new`アクションで新規作成画面
- **29行目**: `show`アクションで組織詳細
- **31-48行目**: `activity`アクションでアクティビティ取得
- **50行目**: `groups_and_projects`アクションでリソース一覧

#### Step 2: アクティビティ取得ロジック

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | organizations_controller.rb | `app/controllers/organizations/organizations_controller.rb` | アクティビティ取得 |

**主要処理フロー**:
- **81-91行目**: `load_events`メソッドでEventCollection生成
- **68-73行目**: `projects`メソッドでProjectsFinder使用
- **75-79行目**: `groups`メソッドでOrganizations::GroupsFinder使用
- **40-41行目**: イベントの可視性フィルタ（`visible_to_user?`）

#### Step 3: Finderクラス

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | organizations_finder.rb | `app/finders/organizations/organizations_finder.rb` | 組織検索 |

### プログラム呼び出し階層図

```
OrganizationsController
    │
    ├─ index (組織一覧)
    │      └─ Organizations::OrganizationsFinder
    │
    ├─ show (組織詳細)
    │      └─ authorize_read_organization!
    │
    ├─ activity (アクティビティ)
    │      ├─ load_events
    │      │      ├─ projects (ProjectsFinder)
    │      │      ├─ groups (Organizations::GroupsFinder)
    │      │      └─ EventCollection
    │      │             └─ Events::RenderService
    │      │
    │      └─ Profile::EventSerializer
    │
    └─ groups_and_projects
           ├─ ProjectsFinder
           └─ Organizations::GroupsFinder

Admin::OrganizationsController
    │
    └─ 組織管理機能（管理者向け）
```

### データフロー図

```
[入力]                       [処理]                          [出力]

ユーザーリクエスト ───────▶ OrganizationsController ───────▶ 組織一覧画面
      │                           │                              │
      ▼                           ▼                              ▼
組織パス/ID           OrganizationsFinder              組織詳細画面
      │                           │                              │
      ▼                           ▼                              ▼
                      ProjectsFinder                   グループ/プロジェクト一覧
                      GroupsFinder                             │
                           │                                   ▼
                           ▼                              アクティビティ画面
                      EventCollection
                           │
                           ▼
                      Events::RenderService
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| organizations_controller.rb | `app/controllers/organizations/organizations_controller.rb` | コントローラー | 組織画面制御 |
| admin/organizations_controller.rb | `app/controllers/admin/organizations_controller.rb` | コントローラー | 管理者向け |
| organizations_finder.rb | `app/finders/organizations/organizations_finder.rb` | Finder | 組織検索 |
| organizations_resolver.rb | `app/graphql/resolvers/organizations/organizations_resolver.rb` | GraphQL | 組織解決 |
| organizations_helper.rb | `app/helpers/routing/organizations_helper.rb` | ヘルパー | ルーティングヘルパー |
| organizations_view.vue | `app/assets/javascripts/organizations/shared/components/organizations_view.vue` | Vue | 一覧表示 |
| organizations_list.vue | `app/assets/javascripts/organizations/shared/components/list/organizations_list.vue` | Vue | リストコンポーネント |
| organizations.query.graphql | `app/assets/javascripts/organizations/shared/graphql/queries/organizations.query.graphql` | GraphQL | クエリ |
| crm/organizations_controller.rb | `app/controllers/groups/crm/organizations_controller.rb` | コントローラー | CRM組織 |
