# 機能設計書 136-アクティビティフィード

## 概要

本ドキュメントは、GitLabにおけるアクティビティフィード機能の設計について記述する。プロジェクト、グループ、ユーザーの活動履歴を時系列で表示し、コラボレーションの可視化を実現する機能を定義する。

### 本機能の処理概要

**業務上の目的・背景**：ソフトウェア開発チームでは、チームメンバーの活動状況を把握し、プロジェクトの進捗を追跡することが重要である。アクティビティフィード機能により、コミット、イシュー、マージリクエスト、コメント等の活動を一元的に表示し、チームの生産性と協調性を向上させる。

**機能の利用シーン**：
- プロジェクトのトップページでの最近のアクティビティ確認
- グループダッシュボードでのグループ全体の活動把握
- ユーザープロフィールでの個人の貢献履歴表示
- 組織レベルでの活動監視
- カレンダービューでの活動量可視化

**主要な処理内容**：
1. イベントの収集と保存
2. アクティビティフィードの時系列表示
3. イベントタイプ別フィルタリング
4. ユーザー権限に基づく可視性制御
5. カレンダー活動ビューの提供
6. RSSフィードの提供

**関連システム・外部連携**：
- イシュー管理システム
- マージリクエスト管理システム
- コミット管理システム
- Wikiシステム
- デザイン管理システム

**権限による制御**：
- イベントはターゲットオブジェクトの権限に基づいて表示制御
- プライベートプロジェクトのイベントはメンバーのみ閲覧可能

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 18 | アクティビティ画面 | 主機能 | ユーザーアクティビティの表示 |
| 24 | プロジェクト詳細 | 補助機能 | プロジェクトアクティビティの表示 |
| 141 | グループ詳細 | 補助機能 | グループアクティビティの表示 |
| 166 | アチーブメント | 補助機能 | アチーブメントの管理 |
| 187 | 組織アクティビティ | 補助機能 | 組織アクティビティの表示 |
| 218 | カレンダー活動 | 補助機能 | ユーザーカレンダー活動の表示 |

## 機能種別

データ表示 / フィルタリング / イベント収集 / RSS配信

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| offset | Integer | No | 取得開始位置 | - |
| limit | Integer | No | 取得件数 | デフォルト: 20 |
| event_filter | String | No | イベントタイプフィルタ | all/push/merge/issue/comments等 |

### 入力データソース

- eventsテーブルからのイベント取得
- プロジェクト/グループ/ユーザーの関連イベント

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | Integer | イベントID |
| action | String | アクション種別 |
| author | Object | イベント作者 |
| target | Object | ターゲットオブジェクト |
| created_at | DateTime | イベント発生日時 |
| project | Object | 関連プロジェクト |
| group | Object | 関連グループ |

### 出力先

- GitLab UIでのアクティビティフィード表示
- REST API / GraphQL APIレスポンス
- RSSフィード

## 処理フロー

### 処理シーケンス

```
1. アクティビティリクエスト受信
   └─ フィルタ条件、ページネーション情報を受け取る
2. イベント収集
   └─ EventCollectionでプロジェクト/グループからイベント収集
3. 可視性フィルタ
   └─ 各イベントの閲覧権限をチェック
4. レンダリング
   └─ Events::RenderServiceでHTMLレンダリング
5. シリアライズ
   └─ EventSerializerでJSON変換
6. レスポンス返却
```

### フローチャート

```mermaid
flowchart TD
    A[アクティビティリクエスト] --> B[EventCollection生成]
    B --> C[イベント取得]
    C --> D{フィルタ適用?}
    D -->|Yes| E[イベントタイプフィルタ]
    D -->|No| F[全イベント]
    E --> G[可視性チェック]
    F --> G
    G --> H[visible_to_user?]
    H -->|Yes| I[表示対象に追加]
    H -->|No| J[スキップ]
    I --> K[Events::RenderService]
    J --> K
    K --> L[EventSerializer]
    L --> M[レスポンス返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-136-01 | 可視性制御 | ユーザーが閲覧できるイベントのみ表示 | 全イベント取得時 |
| BR-136-02 | デフォルト件数 | 明示的指定がない場合は20件取得 | アクティビティ取得時 |
| BR-136-03 | プロジェクト活動更新 | イベント作成時にプロジェクトのlast_activity_atを更新 | イベント作成時 |
| BR-136-04 | 貢献カウント | push, comment, issue操作等が貢献としてカウント | 貢献統計時 |

### 計算ロジック

- **イベントアクション種別**: created(1), updated(2), closed(3), reopened(4), pushed(5), commented(6), merged(7), joined(8), left(9), destroyed(10), expired(11), approved(12)
- **貢献対象**: push, comment, イシュー/MR/デザインの作成・更新・マージ・削除

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| イベント作成 | events | INSERT | イベントレコード作成 |
| イベント取得 | events | SELECT | アクティビティ取得 |
| プッシュ情報取得 | push_event_payloads | SELECT | プッシュイベント詳細 |
| プロジェクト更新 | projects | UPDATE | last_activity_at更新 |

### テーブル別操作詳細

#### events

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | author_id, action, target_type, target_id, project_id, group_id | イベント情報 | fingerprintで重複検知 |
| SELECT | project_id / group_id / author_id | 関連オブジェクトID | created_at降順 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 403 | Forbidden | 閲覧権限なし | 適切な権限を付与 |
| 404 | Not Found | プロジェクト/グループが存在しない | 正しいパスを指定 |

### リトライ仕様

該当なし（同期処理）

## トランザクション仕様

- イベント作成後のプロジェクト更新はafter_createコールバックで実行
- インポート時はイベント作成をスキップ可能

## パフォーマンス要件

- アクティビティフィード取得は20件以下で300ms以内
- ポーリングではなくページネーションを使用

## セキュリティ考慮事項

- 各イベントは`visible_to_user?`メソッドで個別に可視性をチェック
- プライベートプロジェクトのイベントは非メンバーには非表示
- シークレット情報を含むイベントは適切にマスキング

## 備考

- イベントの保持期間はインスタンス設定に依存
- 大量イベントのパフォーマンス最適化のためバッチ削除に対応

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

アクティビティフィードの中核となるイベントモデルを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | event.rb | `app/models/event.rb` | イベントのデータ構造、アクション種別 |

**読解のコツ（event.rb）**:
- **15-28行目**: ACTIONSハッシュでアクション種別を定義
- **32-37行目**: アクション種別のグルーピング（PROJECT_ACTIONS, WIKI_ACTIONS等）
- **39-49行目**: TARGET_TYPESでターゲットオブジェクト種別を定義
- **56行目**: enum :action でアクションをenum定義
- **113-124行目**: contributionsスコープで貢献イベントを抽出
- **179-185行目**: visible_to_user?メソッドで可視性チェック
- **299-329行目**: action_nameメソッドでアクション名を取得

#### Step 2: コントローラーを理解する

アクティビティ表示のエントリーポイント。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | projects_controller.rb | `app/controllers/projects_controller.rb` | プロジェクトアクティビティ |

**主要処理フロー**:
- プロジェクト/グループ/組織のアクティビティはそれぞれのコントローラーで処理
- `event_filter`ヘルパーでフィルタ条件を取得
- `EventCollection`でイベントを収集

#### Step 3: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | render_service.rb | `app/services/events/render_service.rb` | イベントレンダリング |

### プログラム呼び出し階層図

```
ProjectsController / GroupsController / OrganizationsController
    │
    ├─ activity (アクティビティ取得)
    │      ├─ event_filter (フィルタ条件取得)
    │      └─ EventCollection
    │             ├─ projects (プロジェクト一覧)
    │             ├─ groups (グループ一覧)
    │             └─ to_a (イベント取得)
    │
    └─ レスポンス生成
           ├─ Events::RenderService#execute
           └─ EventSerializer / Profile::EventSerializer

Event (モデル)
    │
    ├─ visible_to_user? (可視性チェック)
    │      └─ capability (権限マッピング)
    │             └─ Ability.allowed?
    │
    ├─ present (プレゼンター)
    │      └─ EventPresenter
    │
    └─ after_create
           └─ update_project
                  ├─ reset_project_activity
                  └─ set_last_repository_updated_at
```

### データフロー図

```
[入力]                       [処理]                          [出力]

ユーザー操作 ───────────────▶ Event作成 ──────────────────▶ events テーブル
(コミット、イシュー等)               │                              │
                                   ▼                              ▼
                          update_project              アクティビティリクエスト
                          (last_activity_at更新)              │
                                                              ▼
                                                       EventCollection
                                                              │
                                                              ▼
                                                       visible_to_user?
                                                              │
                                                              ▼
                                                    Events::RenderService
                                                              │
                                                              ▼
                                                      アクティビティ表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| event.rb | `app/models/event.rb` | モデル | イベントモデル |
| push_event.rb | `app/models/push_event.rb` | モデル | プッシュイベント |
| push_event_payload.rb | `app/models/push_event_payload.rb` | モデル | プッシュペイロード |
| event_collection.rb | `app/models/event_collection.rb` | モデル | イベントコレクション |
| render_service.rb | `app/services/events/render_service.rb` | サービス | レンダリング |
| destroy_service.rb | `app/services/events/destroy_service.rb` | サービス | イベント削除 |
| event_presenter.rb | `app/presenters/event_presenter.rb` | プレゼンター | 表示用変換 |
| event_serializer.rb | `app/serializers/event_serializer.rb` | シリアライザー | JSON変換 |
