# 機能設計書 142-ヘルプシステム

## 概要

本ドキュメントは、GitLabのヘルプシステム機能に関する設計書である。ヘルプシステムはGitLabのドキュメントへのアクセス、バージョン情報表示、キーボードショートカット一覧などの情報提供機能を担う。

### 本機能の処理概要

ヘルプシステムは、ユーザーがGitLabの使い方や機能について学習・参照するための機能である。GitLabに同梱されたMarkdownドキュメントを表示するほか、外部のドキュメントサイトへのリダイレクト、インスタンス固有の設定情報表示など、多岐にわたるヘルプ機能を提供する。

**業務上の目的・背景**：ユーザーがGitLabの操作方法や機能詳細を理解するための情報源を提供する。オフライン環境でも利用可能な組み込みドキュメントと、オンライン環境ではより詳細な外部ドキュメントサイトへの誘導を両立させることで、様々な利用環境に対応する。

**機能の利用シーン**：
- GitLabの機能や操作方法を調べたいとき
- キーボードショートカットを確認したいとき
- インスタンスの設定情報（GitLabのバージョン、設定値）を確認したいとき
- 特定の機能についてのドキュメントを参照したいとき
- ヘルプドロワー（サイドパネル）で簡易的なヘルプを表示したいとき

**主要な処理内容**：
1. Markdownドキュメントの読み込みとHTML変換
2. YAML Front Matterの処理（タイトル抽出、本文分離）
3. 外部ドキュメントサイトへのリダイレクト判定
4. メディアファイル（画像、動画、音声）の配信
5. インスタンス設定情報の表示
6. ヘルプドロワーコンテンツの提供

**関連システム・外部連携**：
- 外部ドキュメントサイト（gitlab_docs設定またはhelp_page_documentation_base_url設定）
- Hugoドキュメントシステム（Markdown変換）

**権限による制御**：
- 公開制限設定（public_visibility_restricted?）がない限り認証不要
- 2要素認証要求はスキップ

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 315 | ヘルプトップ | 主機能 | ヘルプトップページ表示 |
| 316 | ヘルプ記事 | 主機能 | ヘルプ記事表示 |
| 317 | インスタンス設定 | 主機能 | インスタンス設定情報表示 |
| 318 | ドロワー表示 | 主機能 | ヘルプドロワー表示 |

## 機能種別

情報表示 / ドキュメント配信

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| path | String | No | ドキュメントのパス（showアクション） | パストラバーサル攻撃対策あり |
| format | String | No | レスポンス形式（md, html, png, gif, jpeg, mp4, mp3） | 許可形式のみ |
| markdown_file | String | No | ドロワー表示用Markdownファイルパス | パストラバーサル攻撃対策あり |

### 入力データソース

- URLパスからドキュメントパスを取得
- ファイルシステム（Rails.root/doc/配下のMarkdownファイル）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| @help_index | String | トップページのHTML変換済みMarkdown |
| @markdown | String | 個別ページのHTML変換済みMarkdown |
| @path | String | 現在表示中のドキュメントパス |
| @instance_configuration | InstanceConfiguration | インスタンス設定情報オブジェクト |
| メディアファイル | Binary | 画像・動画・音声ファイル |

### 出力先

- ブラウザ画面（helpレイアウト）
- 外部ドキュメントサイトへのリダイレクト
- ファイルダウンロード（メディアファイル）

## 処理フロー

### 処理シーケンス

```
1. indexアクション（トップページ）
   └─ doc/index.md を読み込み
   └─ Markdown内リンクを /help/ プレフィックス付きに変換
   └─ HTML変換して表示

2. showアクション（個別ページ）
   └─ パスのクリーニング（パストラバーサル対策）
   └─ 外部ドキュメントサイトへのリダイレクト判定
   └─ Markdownファイル読み込み
   └─ YAML Front Matter処理（タイトル抽出）
   └─ Hugo形式の変換処理
   └─ HTML変換して表示

3. メディアファイル配信
   └─ png, gif, jpeg, mp4, mp3形式の判定
   └─ ファイル存在確認
   └─ インラインで配信

4. drawersアクション（ドロワー表示）
   └─ パスのクリーニング
   └─ Markdownファイル読み込み
   └─ レイアウトなしでHTML描画
```

### フローチャート

```mermaid
flowchart TD
    A[リクエスト受信] --> B{アクション判定}
    B -->|index| C[doc/index.md読み込み]
    B -->|show| D[パスクリーニング]
    B -->|shortcuts| E[ショートカット表示]
    B -->|instance_configuration| F[設定情報表示]
    B -->|drawers| G[ドロワー表示]
    B -->|redirect_to_docs| H[外部サイトリダイレクト]

    C --> I[リンク変換]
    I --> J[HTML変換・表示]

    D --> K{外部リダイレクト?}
    K -->|Yes| L[外部URLへリダイレクト]
    K -->|No| M{ファイル形式判定}

    M -->|Markdown/HTML| N[Markdown読み込み]
    M -->|メディア| O{ファイル存在?}

    N --> P[Front Matter処理]
    P --> Q[Hugo変換]
    Q --> J

    O -->|Yes| R[ファイル配信]
    O -->|No| S[404エラー]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-142-01 | 認証スキップ | 公開制限がない場合は認証不要 | public_visibility_restricted? = false |
| BR-142-02 | 2FA要求スキップ | 2要素認証要求をスキップ | 常時 |
| BR-142-03 | 外部リダイレクト優先 | 外部ドキュメントURLが設定されている場合はリダイレクト | gitlab_docs.enabled = true または help_page_documentation_base_url 設定時 |
| BR-142-04 | バージョンセグメント | プレリリースでない場合はURLにバージョン番号を含める | Gitlab.pre_release? = false |
| BR-142-05 | Hugo記法変換 | HugoのMarkdown記法をGitLab Flavored Markdownに変換 | 常時 |

### 計算ロジック

**バージョンセグメント生成**:
```ruby
version = Gitlab.version_info
version_segment = [version.major, version.minor].join('.')
# 例: 17.0
```

**ドキュメントファイルパス生成**:
```ruby
documentation_file_path = "#{version_segment}/#{path}/"
# 例: 17.0/user/project/issues/
```

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 設定取得 | application_settings | SELECT | help_page_documentation_base_url取得 |

### テーブル別操作詳細

#### application_settings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | help_page_documentation_base_url | current_application_settings | 外部ドキュメントURL取得（DEPRECATED） |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 404 | Not Found | ドキュメントファイルが存在しない | errors/not_found テンプレート表示 |
| 404 | Not Found | メディアファイルが存在しない | head :not_found |
| 404 | Not Found | 不明なファイル形式 | head :not_found |

### リトライ仕様

特になし

## トランザクション仕様

読み取り専用のためトランザクション管理不要

## パフォーマンス要件

- ファイル読み込みはキャッシュ活用推奨
- feature_category: not_owned（未分類）

## セキュリティ考慮事項

- パストラバーサル攻撃対策（Rack::Utils.clean_path_info）
- 許可されたファイル形式のみ配信
- 外部URLの検証（Gitlab::UrlSanitizer.valid_web?）

## 備考

- レイアウトは'help'を使用
- YAML Front Matter形式のドキュメントをサポート
- Hugo形式のMarkdownをGitLab Flavored Markdownに変換
- index.mdが存在しない場合は_index.mdを代替検索

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

メインコントローラの処理フローを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | help_controller.rb | `app/controllers/help_controller.rb` | ヘルプシステムのエントリーポイント、各アクションの処理 |

**主要処理フロー**:
1. **4行目**: skip_before_action :authenticate_user! - 認証スキップ条件
2. **5行目**: skip_before_action :check_two_factor_requirement - 2FAスキップ
3. **12行目**: YAML_FRONT_MATTER_REGEXP - Front Matter解析用正規表現
4. **14-23行目**: index アクション - トップページ表示、リンク変換処理
5. **25-52行目**: show アクション - 個別ページ表示、形式判定
6. **54-56行目**: redirect_to_docs - 外部サイトリダイレクト
7. **60-62行目**: instance_configuration - インスタンス設定表示
8. **64-73行目**: drawers - ドロワー表示
9. **78-90行目**: get_markdown_without_frontmatter - Front Matter処理

**読解のコツ**:
- `respond_to`ブロックで複数の形式（markdown, html, png等）を処理
- `documentation_base_url`メソッドでリダイレクト先URLを決定

#### Step 2: Markdown変換処理を理解する

Hugo形式のMarkdownをGitLab Flavored Markdownに変換する処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | hugo_transformer.rb | `lib/gitlab/help/hugo_transformer.rb` | Hugo記法の変換処理 |

#### Step 3: インスタンス設定情報を理解する

インスタンス設定情報の取得処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | instance_configuration.rb | `app/models/instance_configuration.rb` | 設定情報オブジェクト |

### プログラム呼び出し階層図

```
HelpController
    │
    ├─ index
    │      ├─ markdown_for(doc/index.md)
    │      │      └─ get_markdown_without_frontmatter
    │      │             └─ Gitlab::Help::HugoTransformer#transform
    │      └─ gsub! (リンク変換)
    │
    ├─ show
    │      ├─ Rack::Utils.clean_path_info (パスクリーニング)
    │      ├─ redirect_to_documentation_website? 判定
    │      │      └─ documentation_url
    │      │             └─ documentation_base_url
    │      └─ render_documentation
    │             └─ markdown_for
    │
    ├─ instance_configuration
    │      └─ InstanceConfiguration.new
    │
    └─ drawers
           └─ Rack::Utils.clean_path_info
```

### データフロー図

```
[入力]                    [処理]                         [出力]

URLパス(/help/...)   ───▶  HelpController            ───▶  HTMLページ
                           ├─ ファイル読み込み              or
                           ├─ Front Matter処理              リダイレクト
                           ├─ Hugo変換                      or
                           └─ Markdown→HTML変換             ファイル配信
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| help_controller.rb | `app/controllers/help_controller.rb` | コントローラ | ヘルプシステムのエントリーポイント |
| hugo_transformer.rb | `lib/gitlab/help/hugo_transformer.rb` | ライブラリ | Hugo形式Markdown変換 |
| instance_configuration.rb | `app/models/instance_configuration.rb` | モデル | インスタンス設定情報 |
| help.html.haml | `app/views/layouts/help.html.haml` | レイアウト | ヘルプページレイアウト |
| index.html.haml | `app/views/help/index.html.haml` | ビュー | トップページテンプレート |
| show.html.haml | `app/views/help/show.html.haml` | ビュー | 個別ページテンプレート |
| drawers.html.haml | `app/views/help/drawers.html.haml` | ビュー | ドロワーテンプレート |
| shortcuts.html.haml | `app/views/help/shortcuts.html.haml` | ビュー | ショートカット一覧 |
| instance_configuration.html.haml | `app/views/help/instance_configuration.html.haml` | ビュー | インスタンス設定画面 |
