# 機能設計書 143-ヘルスチェック

## 概要

本ドキュメントは、GitLabのヘルスチェック機能に関する設計書である。ヘルスチェック機能はシステムの正常性を確認するためのエンドポイントを提供し、Kubernetes等のオーケストレーションツールとの連携やモニタリングシステムとの統合に使用される。

### 本機能の処理概要

ヘルスチェック機能は、GitLabインスタンスの稼働状態を監視するためのAPIエンドポイントを提供する。Kubernetesのreadinessプローブ、livenessプローブに対応した2つの主要エンドポイントを持ち、データベース、Redis、Gitalyなどの依存サービスの状態も含めた包括的なヘルスチェックを実行できる。

**業務上の目的・背景**：コンテナオーケストレーション環境（Kubernetes等）やロードバランサーとの連携において、GitLabインスタンスの稼働状態を機械的に判定する必要がある。アプリケーションレベルでの正常性確認により、障害発生時の自動復旧（Pod再起動等）やトラフィック制御を実現する。

**機能の利用シーン**：
- Kubernetesのreadinessプローブとしてサービスの準備状態を確認
- Kubernetesのlivenessプローブとしてサービスの生存状態を確認
- ロードバランサーのヘルスチェックとしてバックエンドの状態を監視
- 監視システム（Prometheus、Datadog等）との連携
- 運用スクリプトからのサービス状態確認

**主要な処理内容**：
1. Masterプロセスの稼働確認
2. データベース接続確認
3. Redis接続確認（各インスタンス）
4. Gitaly接続確認
5. チェック結果の集約とJSON応答

**関連システム・外部連携**：
- Kubernetesオーケストレーションシステム
- ロードバランサー
- 監視・アラートシステム
- Gitalyサーバー
- PostgreSQLデータベース
- Redisインスタンス群

**権限による制御**：
- 許可リストに登録されたモニタリングクライアントからのアクセスのみ許可
- RequiresAllowlistedMonitoringClient concernによる制御

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 220 | システム情報 | 補助機能 | システム情報の表示 |
| 221 | ヘルスチェック | 主機能 | ヘルスチェック画面の表示 |
| 223 | データベース診断 | 補助機能 | データベース診断画面の表示 |
| 270 | Gitalyサーバー一覧 | 補助機能 | Gitalyサーバー状態表示 |

## 機能種別

システム監視 / APIエンドポイント

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| all | Boolean | No | 全サービスチェックフラグ（readinessのみ） | true/falseまたは未指定 |

### 入力データソース

- HTTPリクエストパラメータ
- 許可リストIPアドレス（モニタリングクライアント）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| status | String | 全体ステータス（"ok" または "failed"） |
| {check_name} | Object | 各チェック結果オブジェクト |
| {check_name}.status | String | 個別チェックステータス |
| {check_name}.message | String | チェック結果メッセージ（オプション） |

### 出力先

- JSON形式HTTPレスポンス
- HTTPステータスコード（200 OK または 503 Service Unavailable）

**レスポンス例（成功時）**:
```json
{
  "status": "ok",
  "master_check": {
    "status": "ok"
  }
}
```

**レスポンス例（all=true、成功時）**:
```json
{
  "status": "ok",
  "master_check": { "status": "ok" },
  "db_check": { "status": "ok" },
  "redis_check": { "status": "ok" },
  "gitaly_check": { "status": "ok" }
}
```

## 処理フロー

### 処理シーケンス

```
1. リクエスト受信（GET /-/readiness または GET /-/liveness）
   └─ HealthControllerへディスパッチ

2. 許可リストチェック
   └─ RequiresAllowlistedMonitoringClient による検証
   └─ 許可されていない場合は404またはアクセス拒否

3. チェック対象の決定
   └─ readiness: params[:all] ? ALL_CHECKS : CHECKS
   └─ liveness: チェックなし（空配列）

4. チェック実行
   └─ Gitlab::HealthChecks::Probes::Collection.new(*checks).execute
   └─ 各チェッククラスのreadiness/livenessメソッド実行

5. 結果レスポンス
   └─ result.success? の判定
   └─ 失敗時: X-GitLab-Custom-Error ヘッダ設定
   └─ JSON形式で結果を返却
```

### フローチャート

```mermaid
flowchart TD
    A[リクエスト受信] --> B{許可リストチェック}
    B -->|不許可| C[アクセス拒否]
    B -->|許可| D{エンドポイント判定}

    D -->|readiness| E{all パラメータ?}
    D -->|liveness| F[チェックなし]

    E -->|true| G[全サービスチェック]
    E -->|false/未指定| H[Masterチェックのみ]

    G --> I[チェック実行]
    H --> I
    F --> J[空チェック実行]

    I --> K{全チェック成功?}
    J --> K

    K -->|Yes| L[200 OK + JSON]
    K -->|No| M[503 + X-GitLab-Custom-Error]
    M --> N[JSON レスポンス]
    L --> N
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-143-01 | 許可リストアクセス制御 | 許可されたモニタリングクライアントのみアクセス可能 | 常時 |
| BR-143-02 | readinessデフォルト | readinessはデフォルトでMasterチェックのみ実行 | all パラメータなし |
| BR-143-03 | readiness全チェック | all=trueで全サービスチェック実行 | all=true |
| BR-143-04 | livenessは軽量 | livenessは追加チェックなしで即時応答 | 常時 |
| BR-143-05 | カスタムエラーヘッダ | 失敗時はX-GitLab-Custom-Errorヘッダを設定 | チェック失敗時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 接続確認 | - | SELECT 1 | データベース接続の疎通確認（DbCheck） |

### テーブル別操作詳細

#### データベース接続チェック

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | - | SELECT 1 | 接続確認クエリ |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 404/403 | アクセス拒否 | 許可リスト外からのアクセス | RequiresAllowlistedMonitoringClient による制御 |
| 503 | Service Unavailable | いずれかのチェックが失敗 | X-GitLab-Custom-Error ヘッダ付きで詳細をJSONで返却 |

### リトライ仕様

- クライアント側でのリトライを想定（Kubernetesプローブ設定等）
- サーバー側でのリトライは行わない

## トランザクション仕様

読み取り専用のためトランザクション管理不要

## パフォーマンス要件

- livenessエンドポイントは即時応答（チェックなし）
- readinessエンドポイントは数秒以内に応答
- タイムアウトはクライアント側（Kubernetes設定等）で制御

## セキュリティ考慮事項

- 許可リストによるアクセス制御（RequiresAllowlistedMonitoringClient）
- CSRF保護（protect_from_forgery with: :exception）
- 内部情報の露出を最小限に抑制
- X-GitLab-Custom-Error ヘッダでWorkhorseの静的エラーページを無効化

## 備考

- BaseActionControllerを継承（ApplicationControllerではない）
- Kubernetesのprobe設定と連携して使用
- 各チェッククラスはGitlab::HealthChecks名前空間に定義

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

メインコントローラの処理フローを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | health_controller.rb | `app/controllers/health_controller.rb` | ヘルスチェックのエントリーポイント |

**主要処理フロー**:
1. **3行目**: BaseActionController継承（軽量なベースコントローラ）
2. **4行目**: protect_from_forgery - CSRF保護
3. **5行目**: RequiresAllowlistedMonitoringClient - 許可リスト制御
4. **7-16行目**: CHECKS, ALL_CHECKS定数 - チェック対象の定義
5. **18-22行目**: readiness アクション - 準備状態チェック
6. **24-27行目**: liveness アクション - 生存状態チェック
7. **31-39行目**: render_checks - チェック実行と結果レンダリング

**読解のコツ**:
- `params[:all]`の有無でチェック範囲が変わる
- `X-GitLab-Custom-Error`ヘッダでWorkhorseのエラーページを抑制

#### Step 2: チェック実行機構を理解する

チェック実行のコレクションクラスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | collection.rb | `lib/gitlab/health_checks/probes/collection.rb` | チェック集約実行 |

#### Step 3: 個別チェッククラスを理解する

各サービスのチェック実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | master_check.rb | `lib/gitlab/health_checks/master_check.rb` | Masterプロセスチェック |
| 3-2 | db_check.rb | `lib/gitlab/health_checks/db_check.rb` | データベースチェック |
| 3-3 | gitaly_check.rb | `lib/gitlab/health_checks/gitaly_check.rb` | Gitalyチェック |

#### Step 4: アクセス制御を理解する

許可リストによるアクセス制御を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | requires_allowlisted_monitoring_client.rb | `app/controllers/concerns/requires_allowlisted_monitoring_client.rb` | 許可リスト制御 |

### プログラム呼び出し階層図

```
HealthController
    │
    ├─ readiness
    │      └─ render_checks(params[:all] ? ALL_CHECKS : CHECKS)
    │             └─ Gitlab::HealthChecks::Probes::Collection.new(*checks)
    │                    └─ .execute
    │                           ├─ MasterCheck.readiness
    │                           ├─ DbCheck.readiness (all=true時)
    │                           ├─ Redis::*Check.readiness (all=true時)
    │                           └─ GitalyCheck.readiness (all=true時)
    │
    └─ liveness
           └─ render_checks([])
                  └─ Gitlab::HealthChecks::Probes::Collection.new
                         └─ .execute (空チェック)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

HTTP GET              ───▶  HealthController          ───▶  JSON Response
(/-/readiness               ├─ 許可リストチェック            { status: "ok/failed",
 /-/liveness)               ├─ チェック対象決定                checks... }
                            ├─ チェック実行
                            └─ 結果集約
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| health_controller.rb | `app/controllers/health_controller.rb` | コントローラ | ヘルスチェックエントリーポイント |
| base_action_controller.rb | `app/controllers/base_action_controller.rb` | コントローラ | 軽量ベースコントローラ |
| requires_allowlisted_monitoring_client.rb | `app/controllers/concerns/requires_allowlisted_monitoring_client.rb` | Concern | 許可リスト制御 |
| collection.rb | `lib/gitlab/health_checks/probes/collection.rb` | ライブラリ | チェック集約実行 |
| master_check.rb | `lib/gitlab/health_checks/master_check.rb` | ライブラリ | Masterプロセスチェック |
| db_check.rb | `lib/gitlab/health_checks/db_check.rb` | ライブラリ | データベースチェック |
| gitaly_check.rb | `lib/gitlab/health_checks/gitaly_check.rb` | ライブラリ | Gitalyチェック |
| redis/cache_check.rb | `lib/gitlab/health_checks/redis/cache_check.rb` | ライブラリ | Redis Cacheチェック |
