# 機能設計書 149-イシュー/MRテンプレート

## 概要

本ドキュメントは、GitLabのイシュー/MRテンプレート機能に関する設計書である。この機能は、イシューやマージリクエスト作成時に適用可能なテンプレートを管理・提供する。

### 本機能の処理概要

イシュー/MRテンプレート機能は、プロジェクト内の`.gitlab/issue_templates/`および`.gitlab/merge_request_templates/`ディレクトリに配置されたMarkdownファイルをテンプレートとして利用できるようにする機能である。テンプレートの一覧取得、個別テンプレートの取得、テンプレート名一覧の取得をAPI形式で提供する。

**業務上の目的・背景**：イシューやマージリクエストを作成する際に、必要な情報を漏れなく記載するためのテンプレートを提供する。バグ報告、機能要望、プルリクエストなど、目的に応じたテンプレートを用意することで、開発プロセスの標準化と品質向上を図る。

**機能の利用シーン**：
- イシュー作成時のテンプレート選択
- マージリクエスト作成時のテンプレート選択
- プロジェクト設定でのテンプレート一覧確認
- APIからのテンプレート取得

**主要な処理内容**：
1. テンプレート一覧の取得
2. 個別テンプレートの取得
3. テンプレート名一覧の取得
4. カテゴリ別テンプレートの分類

**関連システム・外部連携**：
- Gitリポジトリ（テンプレートファイルの格納場所）
- Gitaly（ファイル読み込み）

**権限による制御**：
- イシューテンプレート: read_issue権限が必要
- MRテンプレート: read_merge_request権限が必要

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 48 | 課題新規作成 | 補助機能 | イシューテンプレートの適用 |
| 62 | MR新規作成 | 補助機能 | MRテンプレートの適用 |
| 211 | コメントテンプレート | 主機能 | コメントテンプレートの管理 |

## 機能種別

データ取得 / APIエンドポイント

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| template_type | String | Yes | テンプレート種別（issue, merge_request） | ルート制約により制限 |
| key | String | Yes（showアクション） | テンプレート名 | 存在するテンプレート |

### 入力データソース

- URLパラメータ
- リポジトリ内のテンプレートファイル（.gitlab/{issue,merge_request}_templates/*.md）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| templates | Array | テンプレートオブジェクトの配列（indexアクション） |
| template | Object | 個別テンプレートオブジェクト（showアクション） |
| template_names | Array | テンプレート名の配列（namesアクション） |

**テンプレートオブジェクト構造**:
```json
{
  "name": "Bug Report",
  "content": "## Summary\n\n## Steps to reproduce\n..."
}
```

### 出力先

- JSON形式HTTPレスポンス

## 処理フロー

### 処理シーケンス

```
1. テンプレートリクエスト受信
   └─ template_type パラメータからテンプレートクラス決定

2. 権限確認
   └─ authorize_can_read_issuable!
   └─ read_issue または read_merge_request 権限確認

3. テンプレート取得
   └─ index: template_subsets(project) で一覧取得
   └─ show: find(key, project) で個別取得
   └─ names: TemplateFinder.all_template_names で名前一覧取得

4. JSON形式でレスポンス
   └─ Gitlab::Json.dump でシリアライズ
```

### フローチャート

```mermaid
flowchart TD
    A[テンプレートリクエスト] --> B[template_type判定]

    B -->|issue| C[IssueTemplate クラス]
    B -->|merge_request| D[MergeRequestTemplate クラス]

    C --> E{権限確認}
    D --> E

    E -->|read_issue| F[テンプレート取得]
    E -->|read_merge_request| F
    E -->|権限なし| G[アクセス拒否]

    F --> H{アクション判定}
    H -->|index| I[template_subsets]
    H -->|show| J[find by key]
    H -->|names| K[all_template_names]

    I --> L[JSON レスポンス]
    J --> L
    K --> L
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-149-01 | テンプレート格納場所 | イシューテンプレートは.gitlab/issue_templates/に格納 | 常時 |
| BR-149-02 | テンプレート格納場所 | MRテンプレートは.gitlab/merge_request_templates/に格納 | 常時 |
| BR-149-03 | ファイル形式 | テンプレートファイルは.md拡張子 | 常時 |
| BR-149-04 | 権限分離 | template_typeに応じた権限チェック | 常時 |
| BR-149-05 | キャッシュ活用 | リポジトリのキャッシュ機構を活用 | 常時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし（リポジトリファイル読み込みのみ） |

### テーブル別操作詳細

本機能はデータベースを直接操作せず、Gitリポジトリからファイルを読み込む。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 403 | Forbidden | read_issue/read_merge_request権限なし | アクセス拒否 |
| 404 | Not Found | 指定されたテンプレートが存在しない | 404エラー |

### リトライ仕様

特になし

## トランザクション仕様

データベース操作なしのためトランザクション管理不要

## パフォーマンス要件

- urgency: low（namesアクション）
- feature_category: source_code_management
- リポジトリのキャッシュ機構を活用

## セキュリティ考慮事項

- template_typeに応じた権限チェック（read_issue, read_merge_request）
- ルート制約によりtemplate_typeの値を制限

## 備考

- テンプレートファイルはリポジトリのデフォルトブランチから読み込まれる
- テンプレート名のキャッシュはリポジトリ側で管理
- カテゴリ機能によりテンプレートを分類可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

メインコントローラの処理フローを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | templates_controller.rb | `app/controllers/projects/templates_controller.rb` | テンプレート機能のエントリーポイント |

**主要処理フロー**:
1. **4行目**: authenticate_user! - 認証必須
2. **5行目**: authorize_can_read_issuable! - 権限確認
3. **6行目**: get_template_class - テンプレートクラス決定
4. **11-17行目**: index アクション - テンプレート一覧取得
5. **19-25行目**: show アクション - 個別テンプレート取得
6. **27-31行目**: names アクション - テンプレート名一覧取得
7. **41-45行目**: authorize_can_read_issuable! - 権限確認ロジック
8. **47-50行目**: get_template_class - テンプレートクラス決定ロジック

**読解のコツ**:
- template_typeはURLルーティングで制約される（issue or merge_request）
- @template_typeにIssueTemplateまたはMergeRequestTemplateクラスが設定される

#### Step 2: テンプレートクラスを理解する

イシューテンプレートの実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | issue_template.rb | `lib/gitlab/template/issue_template.rb` | イシューテンプレートクラス |

**主要処理フロー**:
1. **7-8行目**: extension - ファイル拡張子（.md）
2. **11-12行目**: base_dir - テンプレート格納ディレクトリ
3. **15-16行目**: finder - テンプレートファインダー
4. **19-27行目**: template_names - テンプレート名取得（キャッシュ活用）

#### Step 3: テンプレートファインダーを理解する

テンプレート検索の実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | repo_template_finder.rb | `lib/gitlab/template/finders/repo_template_finder.rb` | リポジトリテンプレートファインダー |

### プログラム呼び出し階層図

```
Projects::TemplatesController
    │
    ├─ authorize_can_read_issuable!
    │      └─ authorize_action!([:read_, params[:template_type]].join)
    │
    ├─ get_template_class
    │      └─ template_types[params[:template_type]]
    │             ├─ Gitlab::Template::IssueTemplate
    │             └─ Gitlab::Template::MergeRequestTemplate
    │
    ├─ index
    │      └─ @template_type.template_subsets(project)
    │
    ├─ show
    │      └─ @template_type.find(params[:key], project)
    │
    └─ names
           └─ TemplateFinder.all_template_names(project, template_type.pluralize)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

GET /templates/issue    ───▶  TemplatesController       ───▶  JSON (templates)
                              ├─ 権限確認
                              ├─ IssueTemplate.template_subsets
                              └─ Gitlab::Json.dump

GET /templates/issue/:key ──▶ TemplatesController       ───▶  JSON (template)
                              ├─ 権限確認
                              ├─ IssueTemplate.find
                              └─ Gitlab::Json.dump
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| templates_controller.rb | `app/controllers/projects/templates_controller.rb` | コントローラ | テンプレート機能エントリーポイント |
| issue_template.rb | `lib/gitlab/template/issue_template.rb` | ライブラリ | イシューテンプレートクラス |
| merge_request_template.rb | `lib/gitlab/template/merge_request_template.rb` | ライブラリ | MRテンプレートクラス |
| base_template.rb | `lib/gitlab/template/base_template.rb` | ライブラリ | テンプレート基底クラス |
| repo_template_finder.rb | `lib/gitlab/template/finders/repo_template_finder.rb` | ライブラリ | リポジトリテンプレートファインダー |
| template_finder.rb | `app/finders/template_finder.rb` | ファインダー | テンプレート検索 |
