# 機能設計書 19-ブランチ管理

## 概要

本ドキュメントは、GitLabにおけるブランチ管理機能の設計仕様を定義する。ブランチの作成、削除、一覧表示機能について、処理フロー、入出力仕様、ビジネスルールを記載する。

### 本機能の処理概要

ブランチ管理機能は、Gitリポジトリのブランチを管理する機能である。開発者はブランチの一覧確認、新規作成、削除、マージ済みブランチの一括削除などを行うことができる。

**業務上の目的・背景**：Git開発ワークフローにおいて、ブランチは並行開発の基盤となる。フィーチャーブランチ、リリースブランチ、ホットフィックスブランチなどを効率的に管理することで、チーム開発を円滑に進めることができる。

**機能の利用シーン**：
- 新機能開発のためにフィーチャーブランチを作成する場合
- マージ済みの不要なブランチを削除して整理する場合
- 特定のコミットやタグからブランチを作成する場合
- アクティブなブランチと古いブランチを確認する場合
- ブランチ間の差分コミット数を確認する場合

**主要な処理内容**：
1. ブランチ一覧の取得と表示
2. ブランチの作成（指定refから）
3. ブランチの削除
4. マージ済みブランチの一括削除
5. ブランチのパイプライン状態表示
6. 関連マージリクエストの表示

**関連システム・外部連携**：
- Gitalyサーバーとの連携（Git操作）
- CI/CDパイプラインとの連携（ステータス表示）
- マージリクエストとの連携

**権限による制御**：
- ブランチ一覧閲覧：read_code権限
- ブランチ作成/削除：push_code権限
- 保護ブランチの削除：追加の権限チェック

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 35 | ブランチ一覧 | 主画面 | ブランチの一覧表示 |
| 36 | ブランチ新規作成 | 主画面 | 新規ブランチの作成処理 |

## 機能種別

CRUD操作（Create/Read/Delete）

## 入力仕様

### 入力パラメータ（一覧表示）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| namespace_id | String | Yes | 名前空間パス | 存在する名前空間 |
| project_id | String | Yes | プロジェクトパス | 存在するプロジェクト |
| state | String | No | 状態フィルタ | all/active/stale/overview |
| sort | String | No | ソート順 | name/updated_asc/updated_desc |
| search | String | No | 検索文字列 | - |
| page | Integer | No | ページ番号 | 正の整数 |

### 入力パラメータ（作成）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| branch_name | String | Yes | ブランチ名 | 有効なブランチ名 |
| ref | String | Yes | 基点となるref | 存在するref |

### 入力データソース

- 画面入力：ブランチ名、基点ref
- URLパラメータ：プロジェクト識別子、フィルタ条件

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| branches | Array | ブランチ一覧 |
| branch | Gitlab::Git::Branch | 作成されたブランチ |
| pipeline_statuses | Hash | パイプライン状態 |
| merged_branch_names | Set | マージ済みブランチ名 |

### 出力先

- 画面表示：ブランチ一覧UI
- JSON API：ブランチ情報のJSON

## 処理フロー

### 処理シーケンス（一覧表示）

```
1. 一覧表示リクエスト
   └─ BranchesController#indexが呼び出される

2. 権限チェック
   └─ authorize_read_code!で閲覧権限を確認

3. ブランチ取得
   └─ BranchesFinder/BranchesByModeServiceでブランチ取得

4. 関連情報取得
   ├─ マージ済みブランチ判定
   ├─ パイプライン状態取得
   └─ 関連マージリクエスト取得

5. レスポンス生成
   └─ HTML/JSON形式で返却
```

### 処理シーケンス（作成）

```
1. 作成リクエスト
   └─ BranchesController#createが呼び出される

2. 権限チェック
   └─ authorize_push_code!で作成権限を確認

3. ブランチ作成
   └─ Branches::CreateService#execute
      └─ repository.add_branch

4. 結果処理
   ├─ 成功: ブランチツリー画面にリダイレクト
   └─ 失敗: エラー表示
```

### フローチャート

```mermaid
flowchart TD
    A[ブランチ操作リクエスト] --> B{操作種別?}
    B -->|一覧| C{閲覧権限?}
    C -->|No| D[403エラー]
    C -->|Yes| E[ブランチ取得]
    E --> F[関連情報取得]
    F --> G[一覧表示]

    B -->|作成| H{作成権限?}
    H -->|No| D
    H -->|Yes| I{ref有効?}
    I -->|No| J[refエラー]
    I -->|Yes| K{ブランチ名有効?}
    K -->|No| L[名前エラー]
    K -->|Yes| M[ブランチ作成]
    M --> N[ツリー表示へリダイレクト]

    B -->|削除| O{削除権限?}
    O -->|No| D
    O -->|Yes| P[ブランチ削除]
    P --> Q[一覧へリダイレクト]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 閲覧権限 | read_code権限が必要 | 一覧表示時 |
| BR-02 | 作成権限 | push_code権限が必要 | 作成時 |
| BR-03 | 削除権限 | push_code権限が必要 | 削除時 |
| BR-04 | ブランチ名規則 | Gitの命名規則に準拠 | 作成時 |
| BR-05 | ref必須 | 作成時に基点refが必要 | 作成時 |
| BR-06 | 保護ブランチ制限 | 保護ブランチは追加権限が必要 | 削除時 |
| BR-07 | マージ済み判定 | デフォルトブランチにマージ済みか判定 | 一覧表示時 |

### 計算ロジック

- **アクティブ/古いブランチ判定**: 最終コミット日時による分類
- **分岐コミット数**: デフォルトブランチとの差分コミット数

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| MR取得 | merge_requests | SELECT | 関連MR取得 |

### Gitalyへのリクエスト

| 操作 | 内容 | 備考 |
|-----|------|------|
| FindAllBranches | ブランチ一覧取得 | - |
| UserCreateBranch | ブランチ作成 | - |
| UserDeleteBranch | ブランチ削除 | - |
| FindMergedBranches | マージ済み判定 | - |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 403 | Forbidden | 権限がない | 権限を確認 |
| 404 | Not Found | refが存在しない | 正しいrefを指定 |
| - | バリデーションエラー | ブランチ名不正 | 名前を修正 |
| - | 重複エラー | ブランチが既に存在 | 別の名前を指定 |
| - | 保護エラー | 保護ブランチの削除 | 保護設定を解除 |

### リトライ仕様

- エラー時は入力内容を修正して再試行

## トランザクション仕様

- Gitへのブランチ操作は原子的に実行

## パフォーマンス要件

- allow_n_plus_1_callsでN+1クエリを許容（大量ブランチ対応）
- ブランチ数が多い場合はページネーション

## セキュリティ考慮事項

- 作成/削除権限の厳格なチェック
- 保護ブランチの追加制御
- ブランチ名のサニタイズ

## 備考

- デプロイメントプラットフォームがある場合、空リポジトリへの最初のブランチ作成時に自動デプロイ設定画面へ遷移
- マージ済みブランチの一括削除は非同期で実行

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Gitブランチオブジェクトを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | branch.rb | `lib/gitlab/git/branch.rb` | Gitブランチオブジェクトの構造 |

**読解のコツ**: ブランチはtarget（コミットSHA）とname（ブランチ名）を持つ。

#### Step 2: エントリーポイントを理解する

コントローラーのブランチ操作処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | branches_controller.rb | `app/controllers/projects/branches_controller.rb` | 各アクションの処理フロー |

**主要処理フロー**:
1. **19-54行目**: indexアクション、ブランチ一覧取得
2. **76-119行目**: createアクション、ブランチ作成
3. **122-136行目**: destroyアクション、ブランチ削除
4. **138-144行目**: destroy_all_merged、マージ済み一括削除

#### Step 3: ブランチ作成サービスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | create_service.rb | `app/services/branches/create_service.rb` | ブランチ作成ロジック |

**主要処理フロー**:
- **11-22行目**: execute、バリデーションとブランチ作成
- **78-104行目**: create_branch、repository.add_branchの呼び出し

### プログラム呼び出し階層図

```
Projects::BranchesController#index
    │
    ├─ authorize_read_code! (権限チェック)
    │
    ├─ fetch_branches_by_mode
    │      └─ BranchesByModeService / BranchesFinder
    │
    ├─ fetch_merge_requests_for_branches
    │
    └─ Ci::CommitStatusesFinder (パイプライン状態)

Projects::BranchesController#create
    │
    ├─ authorize_push_code! (権限チェック)
    │
    └─ Branches::CreateService#execute
           ├─ validate_ref (ref検証)
           ├─ branch_validation_service.execute (名前検証)
           └─ repository.add_branch (ブランチ作成)

Projects::BranchesController#destroy
    │
    ├─ authorize_push_code! (権限チェック)
    │
    └─ Branches::DeleteService#execute
           └─ repository.rm_branch (ブランチ削除)
```

### データフロー図

```
[入力]               [処理]                    [出力]

フィルタ条件 ───▶ BranchesController ───▶ ブランチ一覧
                       │
                       ▼
               BranchesFinder
                       │
                       ▼
               Gitaly RPC ───▶ ブランチデータ
                       │
                       ▼
               パイプライン状態取得
                       │
                       ▼
               一覧表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| branches_controller.rb | `app/controllers/projects/branches_controller.rb` | コントローラー | ブランチ操作のエントリーポイント |
| create_service.rb | `app/services/branches/create_service.rb` | サービス | ブランチ作成処理 |
| delete_service.rb | `app/services/branches/delete_service.rb` | サービス | ブランチ削除処理 |
| delete_merged_service.rb | `app/services/branches/delete_merged_service.rb` | サービス | マージ済み一括削除 |
| validate_new_service.rb | `app/services/branches/validate_new_service.rb` | サービス | ブランチ名検証 |
| branches_finder.rb | `app/finders/branches_finder.rb` | Finder | ブランチ検索 |
| branches_by_mode_service.rb | `app/services/projects/branches_by_mode_service.rb` | サービス | モード別ブランチ取得 |
