# 機能設計書 24-リポジトリグラフ

## 概要

本ドキュメントは、GitLabにおけるリポジトリグラフ（ネットワークグラフ）機能の設計を定義する。ブランチ・コミットの履歴を視覚的なグラフ形式で表示し、リポジトリの分岐・マージの流れを把握できる機能である。

### 本機能の処理概要

リポジトリグラフ機能は、Gitリポジトリのコミット履歴をネットワーク図として視覚化し、ブランチ間の関係性やマージポイントを直感的に理解できる機能である。

**業務上の目的・背景**：複数のブランチで並行開発を行う現代のソフトウェア開発において、ブランチの分岐・統合の状況を把握することは重要である。本機能により、開発チームはプロジェクトの開発フロー全体を俯瞰し、ブランチ戦略の妥当性確認や、マージタイミングの判断に活用できる。特に複雑なブランチ構造を持つプロジェクトでは、テキストベースのログよりも視覚的なグラフの方が理解しやすい。

**機能の利用シーン**：
- プロジェクトのブランチ構造を俯瞰的に確認する
- 特定のブランチがどこから分岐したかを調査する
- マージの履歴を視覚的に追跡する
- 開発チーム内でブランチ戦略を共有する
- リリースブランチとフィーチャーブランチの関係を確認する

**主要な処理内容**：
1. 指定されたブランチ/タグのコミット履歴をGitalyから取得
2. Network::Graphクラスによるグラフデータの構築
3. コミットノードと接続線の座標計算
4. インタラクティブなグラフ表示（ズーム、パン）
5. 特定コミットへのジャンプ機能

**関連システム・外部連携**：Gitalyサーバーとの連携によるコミット履歴取得

**権限による制御**：リポジトリへの読み取り権限（read_code）が必要。プライベートプロジェクトではプロジェクトメンバーまたは適切な権限を持つユーザーのみアクセス可能。非デフォルトブランチでフィーチャーフラグ有効時は認証必須。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 44 | ネットワークグラフ | 主機能 | ブランチ・コミットのグラフ表示 |

## 機能種別

データ参照・表示処理（SELECT）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| ref | String | Yes | ブランチ名、タグ名、またはコミットSHA | 有効なGit参照 |
| filter_ref | String | No | 表示対象のブランチフィルタ | - |
| extended_sha1 | String | No | ジャンプ先のコミットSHA | 有効なコミットSHA |

### 入力データソース

- URL パス: `/project_namespace/project_name/-/network/:ref`
- クエリパラメータによるオプション指定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| graph | Network::Graph | グラフオブジェクト |
| graph.commits | Array | コミットノード配列 |
| commit.sha | String | コミットSHA |
| commit.x | Integer | X座標（水平位置） |
| commit.y | Integer | Y座標（垂直位置） |
| commit.space | Integer | レーン番号（並列ブランチ用） |
| commit.parent_spaces | Array | 親コミットへの接続情報 |
| url | String | JSONデータ取得用URL |
| commit_url | String | コミット詳細へのURLテンプレート |

### 出力先

- HTML: ブラウザへのインタラクティブグラフ表示
- JSON: グラフデータのAjax取得

## 処理フロー

### 処理シーケンス

```
1. リクエスト受信・認証確認
   └─ authorize_read_code!, require_auth?
2. 参照の検証
   └─ assign_ref_vars でブランチ/タグ/コミット解決
3. オプション設定
   └─ assign_options でフィルタ・ジャンプ先設定
4. コミット取得（ジャンプ先指定時）
   └─ assign_commit で対象コミット取得
5. HTMLレスポンス
   └─ グラフUI表示、URL設定
6. JSONレスポンス（Ajax）
   └─ Network::Graph によるグラフデータ構築
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{プロジェクトが空?}
    B -->|Yes| C[404エラー]
    B -->|No| D{参照が有効?}
    D -->|No| C
    D -->|Yes| E{認証必要?}
    E -->|Yes| F{認証済み?}
    F -->|No| G[ログイン要求]
    F -->|Yes| H[オプション設定]
    E -->|No| H
    H --> I{extended_sha1指定?}
    I -->|Yes| J[対象コミット取得]
    I -->|No| K[レスポンス処理]
    J --> K
    K --> L{レスポンス形式}
    L -->|HTML| M[グラフUI表示]
    L -->|JSON| N[グラフデータ構築]
    M --> O{コミット未検出?}
    O -->|Yes| P[フラッシュ警告]
    O -->|No| Q[終了]
    P --> Q
    N --> Q
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-24-01 | 認証要求 | 非デフォルトブランチは認証が必要（フィーチャーフラグ） | require_login_for_commit_tree有効時 |
| BR-24-02 | フィルタリング | filter_refで特定ブランチのみ表示可能 | filter_ref指定時 |
| BR-24-03 | ジャンプ | extended_sha1で特定コミットにフォーカス | extended_sha1指定時 |
| BR-24-04 | 未検出警告 | 指定コミットが見つからない場合は警告表示 | コミット未検出時 |

### 計算ロジック

**グラフレイアウト計算**：
- 各コミットにX/Y座標とspaceを割り当て
- 並列ブランチは異なるレーン（space）に配置
- 親子関係に基づいて接続線を描画

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| グラフ構築 | - | - | Gitalyから直接取得（DBアクセスなし） |

### テーブル別操作詳細

本機能では主にGitaly経由でGitリポジトリにアクセスするため、直接的なデータベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 404 | NotFound | プロジェクトが空の場合 | エラーページ表示 |
| 401 | Unauthorized | 認証が必要なアクセス | ログインページへリダイレクト |
| Flash Alert | Warning | 指定コミットが見つからない | フラッシュメッセージ表示 |

### リトライ仕様

特になし（読み取り専用操作）

## トランザクション仕様

読み取り専用のため、トランザクション管理は不要

## パフォーマンス要件

- 大きなリポジトリではコミット数を制限
- インクリメンタル読み込みによるUI応答性確保
- JSONデータの分割取得サポート

## セキュリティ考慮事項

- authorize_read_code! による読み取り権限の確認
- フィーチャーフラグによる追加認証要求（非デフォルトブランチ）

## 備考

- 大規模リポジトリでは全履歴の表示に時間がかかる可能性
- ブランチフィルタで表示範囲を絞ることで応答性向上

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

グラフデータを格納するデータ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | graph.rb | `lib/network/graph.rb` | グラフ構築のメインクラス |
| 1-2 | commit.rb | `lib/network/commit.rb` | グラフ用コミットクラス |

**読解のコツ**: Network::Graph がどのようにコミット履歴からグラフ構造を構築するかを理解する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | network_controller.rb | `app/controllers/projects/network_controller.rb` | コントローラーの主要アクション |

**主要処理フロー**:
1. **16-37行目**: show - グラフ表示のメインアクション
2. **39-41行目**: assign_options - オプション設定
3. **43-47行目**: assign_commit - ジャンプ先コミット取得
4. **50-54行目**: require_auth? - 認証要求判定

#### Step 3: グラフ構築処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | graph.rb | `lib/network/graph.rb` | グラフデータの構築アルゴリズム |

**主要処理フロー**:
- **32行目**: Network::Graph.new - グラフオブジェクト生成
- project, ref, commit, filter_ref パラメータによる構築

### プログラム呼び出し階層図

```
NetworkController#show
    │
    ├─ ExtractsPath#assign_ref_vars
    │      └─ Repository#find_branch / find_tag
    │
    ├─ require_auth?
    │      └─ フィーチャーフラグ確認
    │
    ├─ assign_options
    │      └─ filter_ref, extended_sha1 設定
    │
    ├─ assign_commit（extended_sha1指定時）
    │      └─ Repository#commit
    │
    └─ respond_to
           ├─ format.html（UIレンダリング）
           └─ format.json
                  └─ Network::Graph.new
                         └─ Gitaly経由でコミット取得
```

### データフロー図

```
[入力]                    [処理]                         [出力]

URL パラメータ    ───▶  NetworkController       ───▶  HTML/JSON
(ref, filter_ref)       │
                        ▼
                   ExtractsPath
                   (参照解決)
                        │
                        ▼
                   Network::Graph.new
                        │
                        ▼
                   Gitaly Server ──────────────────▶  コミット履歴
                   (Git log取得)
                        │
                        ▼
                   グラフレイアウト計算 ───────────▶  座標付きグラフデータ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| network_controller.rb | `app/controllers/projects/network_controller.rb` | コントローラー | グラフ表示のエントリーポイント |
| graph.rb | `lib/network/graph.rb` | ライブラリ | グラフ構築ロジック |
| commit.rb | `lib/network/commit.rb` | ライブラリ | グラフ用コミットクラス |
| extracts_path.rb | `app/controllers/concerns/extracts_path.rb` | Concern | パス・参照の抽出 |
| show.html.haml | `app/views/projects/network/show.html.haml` | ビュー | グラフ表示テンプレート |
| show.json.jbuilder | `app/views/projects/network/show.json.jbuilder` | ビュー | グラフJSONテンプレート |
