# 機能設計書 33-自動マージ

## 概要

本ドキュメントは、GitLabのマージリクエストにおける自動マージ機能の設計仕様を記載する。本機能はCI/CD成功後の自動マージ設定を提供する。

### 本機能の処理概要

自動マージ機能は、CI/CDパイプラインの成功やすべてのマージ条件が満たされた後に、マージリクエストを自動的にマージする機能である。「Merge when checks pass（チェック通過時にマージ）」として知られる。

**業務上の目的・背景**：開発者がCIパイプラインの完了を待つ必要なく、条件が満たされれば自動的にマージを行うことで、開発フローの効率化を図る。レビュー完了後、CIの完了を待つ時間を有効活用できる。

**機能の利用シーン**：コードレビューが完了し承認を得たが、CIパイプラインがまだ実行中の場合に、開発者が「チェック通過時にマージ」を設定する。CIが成功し、すべてのマージ条件が満たされると自動的にマージが実行される。

**主要な処理内容**：
1. 自動マージの有効化設定
2. マージ条件のチェック（CI成功、承認完了、ディスカッション解決等）
3. 条件充足時の自動マージ実行
4. 自動マージのキャンセル
5. 自動マージの中止（条件未達成時）

**関連システム・外部連携**：CI/CDパイプラインとの連携、NotificationServiceを通じたメール通知、SystemNoteServiceによるシステムノート

**権限による制御**：マージリクエストのマージ権限を持つユーザーのみが自動マージを設定可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 63 | MR詳細 | 主画面 | 自動マージ設定、キャンセル |
| 113 | MR設定 | 参照画面 | 自動マージ設定の管理 |

## 機能種別

ワークフロー自動化（自動マージ制御）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| merge_request_id | Integer | Yes | 対象マージリクエストのID | 存在チェック |
| strategy | String | No | 自動マージ戦略 | 有効な戦略名 |
| sha | String | Yes | マージ対象のコミットSHA | 最新のHEADと一致 |
| should_remove_source_branch | Boolean | No | ソースブランチ削除フラグ | - |
| commit_message | String | No | マージコミットメッセージ | - |
| squash_commit_message | String | No | スカッシュコミットメッセージ | - |

### 入力データソース

- 画面入力（自動マージ設定）
- マージリクエストの現在の状態
- CI/CDパイプラインの状態

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| status | Symbol | 処理結果（:success, :failed等） |
| merge_request | MergeRequest | 更新されたマージリクエスト |
| message | String | エラーメッセージ（エラー時） |

### 出力先

- 画面表示（マージリクエストの状態更新）
- データベース（merge_requestsテーブルのauto_merge関連カラム）
- 通知（メール、システムノート）

## 処理フロー

### 処理シーケンス

```
1. 自動マージ有効化
   └─ AutoMergeService#executeで戦略選択・設定保存
2. 条件監視
   └─ AutoMergeProcessWorkerが定期的/イベント駆動で条件チェック
3. 条件充足時
   └─ MergeWhenChecksPassService#processでマージ実行
4. キャンセル時
   └─ AutoMergeService#cancelで設定解除
5. 中止時（条件未達成）
   └─ AutoMergeService#abortで理由付きで設定解除
```

### フローチャート

```mermaid
flowchart TD
    A[MR詳細画面] --> B{マージ可能?}
    B -->|Yes| C[通常マージ]
    B -->|No| D{自動マージ利用可能?}
    D -->|No| E[マージ不可表示]
    D -->|Yes| F[自動マージ設定]
    F --> G[設定保存]
    G --> H[システムノート追加]
    H --> I[条件監視開始]
    I --> J{条件充足?}
    J -->|No| K{キャンセル?}
    K -->|Yes| L[自動マージ解除]
    K -->|No| M{条件失敗?}
    M -->|Yes| N[自動マージ中止]
    M -->|No| I
    J -->|Yes| O[マージ実行]
    O --> P[完了通知]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-33-01 | 利用可能条件 | mergeableでない、かつパイプラインが進行中の場合に利用可能 | 自動マージ設定時 |
| BR-33-02 | マージトレイン優先 | マージトレインが有効な場合は自動マージ利用不可 | 自動マージ設定時 |
| BR-33-03 | CI必須チェック | CIが有効な場合、パイプライン成功が必須 | マージ実行判定時 |
| BR-33-04 | mergeableチェック | すべてのマージ条件が満たされていること | マージ実行判定時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 有効化 | merge_requests | UPDATE | auto_merge_enabled, merge_user_id, merge_params更新 |
| キャンセル | merge_requests | UPDATE | auto_merge_enabled = false |
| マージ実行 | merge_requests | UPDATE | state更新 |
| システムノート | notes | INSERT | 自動マージ関連ノート追加 |

### テーブル別操作詳細

#### merge_requests

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | auto_merge_enabled | true / false | 自動マージ有効フラグ |
| UPDATE | merge_user_id | 設定ユーザーのID | マージ実行ユーザー |
| UPDATE | merge_params | JSON（sha, commit_message等） | マージパラメータ |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | :failed | 自動マージが利用不可能 | エラーメッセージ表示 |
| 406 | NotAcceptable | キャンセル/中止時に自動マージ未設定 | エラーメッセージ返却 |

### リトライ仕様

AutoMergeProcessWorkerによる定期チェックが実質的なリトライとして機能。

## トランザクション仕様

- 自動マージ設定更新はトランザクション内で処理
- マージ実行はMergeServiceに委譲

## パフォーマンス要件

- merge_statusの状態変更イベントで自動マージ処理をトリガー
- 非同期ワーカー（AutoMergeProcessWorker）で処理

## セキュリティ考慮事項

- マージ権限チェック
- merge_userの記録による追跡可能性

## 備考

- EE版では「add_to_merge_train_when_checks_pass」戦略も利用可能
- Feature flag `auto_merge_on_merge_status_change` で状態変更時の処理を制御

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

自動マージに関連するデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | merge_request.rb | `app/models/merge_request.rb` | auto_merge_enabled, merge_user, merge_params |
| 1-2 | merge_schedule.rb | `app/models/merge_requests/merge_schedule.rb` | スケジュール管理 |

**読解のコツ**: merge_requestsテーブルのauto_merge_関連カラムとmerge_paramsの構造を確認。

#### Step 2: エントリーポイントを理解する

サービスクラスがエントリーポイントとなる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | auto_merge_service.rb | `app/services/auto_merge_service.rb` | 戦略選択と各操作のディスパッチ |

**主要処理フロー**:
1. **29-36行目**: executeメソッド - 自動マージ有効化
2. **46-51行目**: processメソッド - 条件チェックとマージ実行
3. **54-59行目**: cancelメソッド - 自動マージキャンセル
4. **62-68行目**: abortメソッド - 自動マージ中止

#### Step 3: 戦略クラスを理解する

具体的なマージ戦略の実装。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | merge_when_checks_pass_service.rb | `app/services/auto_merge/merge_when_checks_pass_service.rb` | MWCP戦略の実装 |
| 3-2 | base_service.rb | `app/services/auto_merge/base_service.rb` | 基底クラス |

**主要処理フロー**:
- **merge_when_checks_pass_service.rb 16-28行目**: processメソッド - CI成功・mergeable判定
- **merge_when_checks_pass_service.rb 46-56行目**: availability_details - 利用可能条件判定

#### Step 4: ワーカーを理解する

非同期処理を担当するワーカー。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | auto_merge_process_worker.rb | `app/workers/auto_merge_process_worker.rb` | イベント駆動のマージ処理 |

### プログラム呼び出し階層図

```
AutoMergeService
    │
    ├─ execute
    │      └─ MergeWhenChecksPassService#execute
    │              └─ SystemNoteService.merge_when_checks_pass
    │
    ├─ process
    │      └─ MergeWhenChecksPassService#process
    │              ├─ diff_head_pipeline_success?
    │              ├─ mergeable?
    │              └─ merge_request.merge_async
    │
    ├─ cancel
    │      └─ MergeWhenChecksPassService#cancel
    │              └─ SystemNoteService.cancel_auto_merge
    │
    └─ abort
           └─ MergeWhenChecksPassService#abort
                  └─ SystemNoteService.abort_auto_merge
```

### データフロー図

```
[入力]                    [処理]                              [出力]

自動マージ設定 ───▶ AutoMergeService#execute
                         │
                         ▼
                   MergeWhenChecksPassService
                         │
                         ▼
                   merge_request更新 ───▶ auto_merge_enabled = true
                         │
                         ▼
                   SystemNoteService ───▶ システムノート追加

(パイプライン完了)
       │
       ▼
AutoMergeProcessWorker ───▶ AutoMergeService#process
                                   │
                                   ▼
                             MergeService ───▶ マージ実行
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| auto_merge_service.rb | `app/services/auto_merge_service.rb` | サービス | 戦略選択・ディスパッチ |
| merge_when_checks_pass_service.rb | `app/services/auto_merge/merge_when_checks_pass_service.rb` | サービス | MWCP戦略実装 |
| base_service.rb | `app/services/auto_merge/base_service.rb` | サービス | 基底クラス |
| auto_merge_process_worker.rb | `app/workers/auto_merge_process_worker.rb` | ワーカー | 非同期マージ処理 |
| merge_request.rb | `app/models/merge_request.rb` | モデル | MRモデル |
| system_note_service.rb | `app/services/system_note_service.rb` | サービス | システムノート作成 |
