# 機能設計書 34-ドラフトマージリクエスト

## 概要

本ドキュメントは、GitLabのドラフトマージリクエスト（Draft MR / WIP MR）機能の設計仕様を記載する。本機能は作業中状態のマージリクエスト管理を提供する。

### 本機能の処理概要

ドラフトマージリクエスト機能は、作業中（Work In Progress）のマージリクエストを明示的にマークし、意図しないマージを防止する機能である。

**業務上の目的・背景**：開発者がコード変更の途中段階でレビューやフィードバックを得たい場合に、誤ってマージされることを防ぎつつ、チームメンバーと共有できる。CI/CDの実行やコードレビューを先行して行いながら、まだマージ準備ができていないことを明示できる。

**機能の利用シーン**：実装途中のコードをレビュアーに共有してフィードバックを得たい場合、CIパイプラインの結果を確認しながら作業を続けたい場合、大きな変更を段階的にレビューしたい場合に利用される。

**主要な処理内容**：
1. マージリクエスト作成時にドラフト状態で作成
2. タイトルに「Draft:」または「WIP:」プレフィックスの自動付与/除去
3. ドラフト状態の切り替え（Draft/Ready）
4. ドラフト状態でのマージブロック
5. ドラフト状態のMR一覧フィルタリング

**関連システム・外部連携**：マージ可能性チェック（MergeabilityCheckService）、NotificationServiceを通じた状態変更通知

**権限による制御**：マージリクエストの編集権限を持つユーザーがドラフト状態を切り替え可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 62 | MR新規作成 | 主画面 | ドラフト状態でのMR作成 |
| 63 | MR詳細 | 主画面 | ドラフト状態の表示・切り替え |
| 64 | MR編集 | 参照画面 | ドラフト状態の編集 |

## 機能種別

状態管理（ドラフト/Ready切り替え）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| merge_request_id | Integer | Yes | 対象マージリクエストのID | 存在チェック |
| title | String | Yes | マージリクエストのタイトル | Draft:プレフィックス含む/含まない |
| draft | Boolean | No | ドラフトフラグ | - |

### 入力データソース

- 画面入力（タイトル、ドラフトチェックボックス）
- クイックアクション（/draft, /ready）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| merge_request | MergeRequest | 更新されたマージリクエスト |
| draft | Boolean | ドラフト状態 |

### 出力先

- 画面表示（マージリクエストのドラフト状態表示）
- データベース（merge_requestsテーブルのdraft列）

## 処理フロー

### 処理シーケンス

```
1. MR作成/更新時
   └─ before_validation :set_draft_statusでタイトルからドラフト状態を判定
2. タイトル解析
   └─ work_in_progress?メソッドでDraft:/WIP:プレフィックスを検出
3. ドラフト状態設定
   └─ draftカラムを更新
4. マージ可能性チェック
   └─ MergeabilityCheckServiceでドラフト状態をチェック
```

### フローチャート

```mermaid
flowchart TD
    A[MR作成/更新] --> B{タイトルにDraft:?}
    B -->|Yes| C[draft = true]
    B -->|No| D{タイトルにWIP:?}
    D -->|Yes| C
    D -->|No| E[draft = false]
    C --> F[DB保存]
    E --> F
    F --> G[マージ可能性チェック]
    G --> H{ドラフト?}
    H -->|Yes| I[マージブロック]
    H -->|No| J[他の条件チェック]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-34-01 | プレフィックス検出 | タイトルが「Draft:」「WIP:」「[Draft]」「[WIP]」「(Draft)」「Draft -」で始まる場合はドラフト | MR作成/更新時 |
| BR-34-02 | マージブロック | ドラフト状態のMRはマージ不可 | マージ実行時 |
| BR-34-03 | 自動マージブロック | ドラフト状態では自動マージも利用不可 | 自動マージ設定時 |
| BR-34-04 | 大文字小文字 | プレフィックスは大文字小文字を区別しない | タイトル解析時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ドラフト状態更新 | merge_requests | UPDATE | draft列の更新 |

### テーブル別操作詳細

#### merge_requests

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | draft | true / false | ドラフト状態フラグ |
| UPDATE | title | タイトル文字列 | プレフィックス付き/なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | マージブロック | ドラフト状態でマージ試行 | ドラフト解除を促すメッセージ |

### リトライ仕様

特になし

## トランザクション仕様

通常のモデル更新トランザクション内で処理。

## パフォーマンス要件

- スコープ `drafts` による効率的なフィルタリング

## セキュリティ考慮事項

- マージリクエスト編集権限チェック

## 備考

- 「WIP:」は従来の表記で、「Draft:」が推奨される
- クイックアクション `/draft` と `/ready` でも状態切り替え可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ドラフト状態に関連するモデルの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | merge_request.rb | `app/models/merge_request.rb` | draft列、work_in_progress?メソッド |

**読解のコツ**: `before_validation :set_draft_status`コールバックがタイトルからドラフト状態を判定。

#### Step 2: ドラフト判定ロジックを理解する

タイトルからのドラフト状態判定ロジック。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | merge_request.rb | `app/models/merge_request.rb` | set_draft_status、work_in_progress?メソッド |

**主要処理フロー**:
1. **170行目**: before_validation :set_draft_status
2. work_in_progress?でタイトルのプレフィックスを検出
3. draftカラムを更新

#### Step 3: マージ可能性チェックを理解する

ドラフト状態がマージ可能性に与える影響。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | check_draft_status_service.rb | `app/services/merge_requests/mergeability/check_draft_status_service.rb` | ドラフト状態チェック |

**主要処理フロー**:
- ドラフト状態の場合はmergeability checkで失敗を返す

### プログラム呼び出し階層図

```
MergeRequest#save
    │
    └─ before_validation :set_draft_status
           │
           └─ work_in_progress?
                  └─ タイトルパターンマッチ

MergeabilityCheckService
    │
    └─ CheckDraftStatusService#execute
           │
           └─ merge_request.draft?
```

### データフロー図

```
[入力]                    [処理]                              [出力]

タイトル入力 ───▶ set_draft_status
                       │
                       ▼
                 work_in_progress?
                       │
                       ▼
                 draft列更新 ───▶ merge_requests.draft

マージ要求 ───▶ MergeabilityCheckService
                       │
                       ▼
                 CheckDraftStatusService
                       │
                       ▼
                 ドラフトならブロック
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| merge_request.rb | `app/models/merge_request.rb` | モデル | ドラフト状態管理 |
| check_draft_status_service.rb | `app/services/merge_requests/mergeability/check_draft_status_service.rb` | サービス | マージ可能性チェック |
| merge_requests_controller.rb | `app/controllers/projects/merge_requests_controller.rb` | コントローラー | MR操作 |
