# 機能設計書 36-イシュー作成

## 概要

本ドキュメントは、GitLabのイシュー作成機能の設計仕様を記載する。本機能はバグ報告、機能要望、タスクなどのイシュー作成を提供する。

### 本機能の処理概要

イシュー作成機能は、プロジェクト内でバグ報告、機能要望、タスクなどの作業項目（イシュー）を作成する機能である。

**業務上の目的・背景**：ソフトウェア開発においてバグの追跡、機能要望の管理、タスクの割り当ては不可欠である。イシュー機能によりチーム内での作業の可視化、優先順位付け、進捗管理が可能となる。

**機能の利用シーン**：ユーザーがバグを発見した際の報告、新機能の提案、開発タスクの登録、スプリント計画でのタスク作成など、様々な場面で利用される。

**主要な処理内容**：
1. イシューの基本情報入力（タイトル、説明）
2. メタデータ設定（担当者、マイルストーン、ラベル、期限）
3. イシューテンプレートの適用
4. ディスカッション解決とのリンク（MRからのイシュー作成）
5. 関連イシューの設定
6. 機密イシューの作成

**関連システム・外部連携**：NotificationServiceを通じたメール通知、Webhookによる外部システム連携、サービスデスク（メールからのイシュー作成）

**権限による制御**：プロジェクトへのcreate_issue権限を持つユーザーがイシューを作成可能。機密イシューの作成も権限に依存。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 48 | 課題新規作成 | 主画面 | 新規課題の作成処理 |
| 47 | 課題一覧 | 遷移元画面 | 新規作成画面への遷移 |
| 13 | 課題一覧（ダッシュボード） | 参照画面 | 作成後の一覧表示 |

## 機能種別

データ作成（CRUD - Create）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| title | String | Yes | イシューのタイトル | 空文字不可、最大255文字 |
| description | String | No | イシューの説明 | Markdown対応 |
| assignee_ids | Array[Integer] | No | 担当者のユーザーID | 有効なユーザー |
| milestone_id | Integer | No | マイルストーンID | 有効なマイルストーン |
| label_ids | Array[Integer] | No | ラベルID配列 | 有効なラベル |
| due_date | Date | No | 期限日 | 日付形式 |
| confidential | Boolean | No | 機密フラグ | - |
| discussion_to_resolve | String | No | 解決するディスカッションID | - |

### 入力データソース

- 画面入力（フォーム）
- イシューテンプレート
- MRディスカッションからのコンテキスト

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| issue | Issue | 作成されたイシュー |
| iid | Integer | プロジェクト内イシュー番号 |

### 出力先

- 画面表示（イシュー詳細画面へリダイレクト）
- データベース（issuesテーブル）
- 通知（メール、Webhook）

## 処理フロー

### 処理シーケンス

```
1. 入力検証
   └─ パラメータのバリデーション
2. イシュー構築
   └─ BuildServiceでイシューオブジェクト作成
3. テンプレート適用
   └─ デフォルトテンプレートがあれば説明に適用
4. イシュー保存
   └─ CreateServiceでDB保存
5. 後処理
   └─ 通知、Todo作成、ディスカッション解決
6. リダイレクト
   └─ イシュー詳細画面へ遷移
```

### フローチャート

```mermaid
flowchart TD
    A[新規作成画面] --> B[フォーム入力]
    B --> C{テンプレート選択?}
    C -->|Yes| D[テンプレート適用]
    C -->|No| E[直接入力]
    D --> F[入力検証]
    E --> F
    F --> G{バリデーション成功?}
    G -->|No| H[エラー表示]
    H --> B
    G -->|Yes| I[イシュー保存]
    I --> J[通知送信]
    J --> K{MRからの作成?}
    K -->|Yes| L[ディスカッション解決]
    K -->|No| M[イシュー詳細へ]
    L --> M
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-36-01 | タイトル必須 | タイトルは必須項目 | イシュー作成時 |
| BR-36-02 | iid自動採番 | プロジェクト内で一意のiidを自動採番 | イシュー作成時 |
| BR-36-03 | スパムチェック | 新規イシューはスパムチェック対象 | イシュー作成時 |
| BR-36-04 | レート制限 | 一定期間内の作成数に制限 | イシュー作成時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| イシュー作成 | issues | INSERT | イシューレコード追加 |
| 担当者設定 | issue_assignees | INSERT | 担当者関連付け |
| ラベル設定 | label_links | INSERT | ラベル関連付け |
| イベント記録 | events | INSERT | 作成イベント記録 |

### テーブル別操作詳細

#### issues

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | project_id | 対象プロジェクトID | |
| INSERT | author_id | 作成者ユーザーID | |
| INSERT | title | タイトル | |
| INSERT | description | 説明 | |
| INSERT | iid | 自動採番 | |
| INSERT | state_id | 1 (opened) | |
| INSERT | confidential | 機密フラグ | |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 403 | Forbidden | create_issue権限なし | エラーメッセージ表示 |
| 422 | Unprocessable | バリデーションエラー | エラーメッセージ表示 |
| 429 | TooManyRequests | レート制限超過 | 待機を促すメッセージ |

### リトライ仕様

特になし

## トランザクション仕様

イシュー作成と関連レコードの作成は同一トランザクション内で実行。

## パフォーマンス要件

- urgency :low指定（低優先度）
- PlacementWorkerで位置決めを非同期処理

## セキュリティ考慮事項

- create_issue権限チェック
- スパムチェック
- 機密イシューのアクセス制御

## 備考

- WorkItem（ワークアイテム）への移行が進行中
- インシデントタイプのイシューは特別な処理あり

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

イシューモデルの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | issue.rb | `app/models/issue.rb` | イシューモデル定義 |
| 1-2 | issuable.rb | `app/models/concerns/issuable.rb` | 共通concern |

**読解のコツ**: Issuable concernを継承しており、共通機能（担当者、ラベル、マイルストーン等）はそちらで定義。

#### Step 2: コントローラーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | issues_controller.rb | `app/controllers/projects/issues_controller.rb` | new, createアクション |

**主要処理フロー**:
1. **108-132行目**: newアクション - BuildServiceでイシュー構築
2. **166-198行目**: createアクション - CreateServiceでイシュー作成

#### Step 3: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | build_service.rb | `app/services/issues/build_service.rb` | イシュー構築 |
| 3-2 | create_service.rb | `app/services/issues/create_service.rb` | イシュー作成 |

**主要処理フロー**:
- **create_service.rb 20-44行目**: executeメソッド
- **create_service.rb 50-68行目**: before_create, after_create

### プログラム呼び出し階層図

```
IssuesController
    │
    ├─ new
    │      └─ Issues::BuildService#execute
    │
    └─ create
           └─ Issues::CreateService#execute
                  ├─ BuildService#execute
                  ├─ before_create (spam check)
                  ├─ issue.save
                  └─ after_create
                         ├─ resolve_discussions
                         ├─ NewIssueWorker.perform_async
                         └─ Gitlab::EventStore.publish
```

### データフロー図

```
[入力]                    [処理]                              [出力]

フォーム入力 ───▶ IssuesController#create
                       │
                       ▼
                 CreateService
                       │
                       ▼
                 BuildService ───▶ Issue構築
                       │
                       ▼
                 issue.save ───▶ issuesテーブル
                       │
                       ▼
                 after_create
                       │
                       ├─▶ NewIssueWorker (通知)
                       └─▶ EventStore (イベント)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| issues_controller.rb | `app/controllers/projects/issues_controller.rb` | コントローラー | イシュー操作 |
| issue.rb | `app/models/issue.rb` | モデル | イシューモデル |
| build_service.rb | `app/services/issues/build_service.rb` | サービス | イシュー構築 |
| create_service.rb | `app/services/issues/create_service.rb` | イシュー作成 |
| base_service.rb | `app/services/issues/base_service.rb` | サービス | 基底クラス |
| new_issue_worker.rb | `app/workers/new_issue_worker.rb` | ワーカー | 非同期通知 |
