# 機能設計書 39-イシューボード

## 概要

本ドキュメントは、GitLabのイシューボード機能の設計仕様を記載する。本機能はカンバン形式でイシューを視覚的に管理する機能を提供する。

### 本機能の処理概要

イシューボード機能は、イシューをカンバンボード形式で視覚的に表示・管理する機能である。ラベルや担当者に基づいてリストを作成し、ドラッグ&ドロップでイシューの状態を変更できる。

**業務上の目的・背景**：アジャイル開発やカンバン方式でのプロジェクト管理において、タスクの可視化は重要である。イシューボードにより、プロジェクトの状態を一目で把握し、ワークフローに沿ったタスク管理が可能となる。

**機能の利用シーン**：スプリント計画でのタスク配置、進捗確認、デイリースクラムでの状況共有、バックログの優先順位付け、ワークフロー（To Do -> Doing -> Done）に沿った作業管理。

**主要な処理内容**：
1. ボードの作成・編集・削除
2. リスト（カラム）の追加・削除・並び替え
3. イシューのリスト間移動（ドラッグ&ドロップ）
4. イシューのフィルタリング
5. バックログリスト・クローズリストの自動生成
6. 複数ボードの管理

**関連システム・外部連携**：GraphQL APIによるリアルタイム更新

**権限による制御**：read_issue_board権限でボード閲覧可能。admin_issue_board権限でボード作成・編集可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 50 | ボード一覧 | 主画面 | 課題ボードの一覧表示 |
| 51 | ボード表示 | 主画面 | カンバン形式での課題管理 |
| 152 | ボード一覧（グループ） | 参照画面 | グループ課題ボードの一覧表示 |
| 153 | ボード表示（グループ） | 参照画面 | グループ課題ボードの表示 |

## 機能種別

視覚化管理（カンバンボード）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| board_id | Integer | No | ボードID | 存在チェック |
| name | String | No | ボード名 | - |
| list_params | Hash | No | リスト作成パラメータ | - |
| list_params.label_id | Integer | No | ラベルID | 有効なラベル |
| issue_id | Integer | No | 移動するイシューID | 存在チェック |
| from_list_id | Integer | No | 移動元リストID | - |
| to_list_id | Integer | No | 移動先リストID | - |

### 入力データソース

- 画面入力（ボード作成、ドラッグ&ドロップ）
- API呼び出し

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| board | Board | ボード情報 |
| lists | Array[List] | リスト一覧 |
| issues | Array[Issue] | リスト内イシュー |

### 出力先

- 画面表示（カンバンボード表示）
- データベース（boards, lists, label_linksテーブル等）

## 処理フロー

### 処理シーケンス

```
1. ボード取得/作成
   └─ BoardsFinder / CreateServiceでボード操作
2. リスト取得
   └─ 各リストのイシューを取得
3. イシュー表示
   └─ 各リストにイシューをレンダリング
4. ドラッグ&ドロップ
   └─ Lists::MoveIssueServiceでイシュー移動
5. ラベル更新
   └─ 移動先リストのラベルを付与、移動元を削除
```

### フローチャート

```mermaid
flowchart TD
    A[ボード画面アクセス] --> B{ボード存在?}
    B -->|No| C[デフォルトボード作成]
    B -->|Yes| D[ボード読み込み]
    C --> D
    D --> E[リスト一覧取得]
    E --> F[各リストのイシュー取得]
    F --> G[ボード表示]
    G --> H{ドラッグ&ドロップ?}
    H -->|Yes| I[MoveIssueService]
    I --> J[ラベル付け替え]
    J --> K[表示更新]
    K --> G
    H -->|No| L{リスト追加?}
    L -->|Yes| M[リスト作成]
    M --> G
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-39-01 | デフォルトリスト | バックログとクローズリストは自動作成 | ボード作成時 |
| BR-39-02 | ラベル連動 | リスト間移動でラベルを自動付け替え | イシュー移動時 |
| BR-39-03 | 複数ボード | 有料プランで複数ボード作成可能 | ボード作成時 |
| BR-39-04 | スコープ | ボードはプロジェクトまたはグループに属する | ボード作成時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ボード作成 | boards | INSERT | ボードレコード作成 |
| リスト作成 | lists | INSERT | リストレコード作成 |
| イシュー移動 | label_links | INSERT/DELETE | ラベル付け替え |
| イシュー移動 | issues | UPDATE | relative_position更新 |

### テーブル別操作詳細

#### boards

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | project_id / group_id | 親リソースID | |
| INSERT | name | ボード名 | |

#### lists

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | board_id | ボードID | |
| INSERT | label_id | ラベルID | ラベルリストの場合 |
| INSERT | list_type | 'backlog', 'closed', 'label' | リスト種別 |
| INSERT | position | 表示位置 | |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 403 | Forbidden | read_issue_board権限なし | エラーメッセージ表示 |
| - | ServiceError | ボード作成失敗 | エラーメッセージ返却 |

### リトライ仕様

特になし

## トランザクション仕様

イシュー移動とラベル更新は同一トランザクション内で実行。

## パフォーマンス要件

- urgency :low指定
- イシューのページネーション

## セキュリティ考慮事項

- read_issue_board権限チェック
- admin_issue_board権限チェック（編集時）

## 備考

- EE版では追加機能（担当者リスト、マイルストーンリスト、重み等）
- GraphQL APIでのリアルタイム更新対応

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | board.rb | `app/models/board.rb` | ボードモデル |
| 1-2 | list.rb | `app/models/list.rb` | リストモデル |

**読解のコツ**: boardsとlistsの1対多関係、listsとlabelsの関連を理解。

#### Step 2: コントローラーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | boards_controller.rb | `app/controllers/projects/boards_controller.rb` | ボード操作 |

**主要処理フロー**:
- BoardsFinder, CreateServiceの使用
- authorize_read_board!による権限チェック

#### Step 3: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | create_service.rb | `app/services/boards/create_service.rb` | ボード作成 |

**主要処理フロー**:
- **6-8行目**: executeメソッド
- **19-31行目**: create_board!メソッド - バックログ/クローズリスト自動作成

### プログラム呼び出し階層図

```
BoardsController
    │
    ├─ index/show
    │      └─ BoardsFinder#execute
    │
    └─ create
           └─ Boards::CreateService#execute
                  │
                  ├─ can_create_board?
                  │
                  └─ create_board!
                         ├─ boards.create
                         ├─ lists.create(list_type: :backlog)
                         └─ lists.create(list_type: :closed)
```

### データフロー図

```
[入力]                    [処理]                              [出力]

ボードアクセス ───▶ BoardsFinder
                       │
                       ▼
                 Board取得 ───▶ ボード情報
                       │
                       ▼
                 Lists取得 ───▶ リスト一覧
                       │
                       ▼
                 Issues取得 ───▶ カンバン表示

ドラッグ&ドロップ ───▶ MoveIssueService
                            │
                            ▼
                      ラベル更新 ───▶ イシュー表示更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| boards_controller.rb | `app/controllers/projects/boards_controller.rb` | コントローラー | ボード操作 |
| board.rb | `app/models/board.rb` | モデル | ボードモデル |
| list.rb | `app/models/list.rb` | モデル | リストモデル |
| create_service.rb | `app/services/boards/create_service.rb` | サービス | ボード作成 |
| boards_finder.rb | `app/finders/boards/boards_finder.rb` | ファインダー | ボード検索 |
| boards_actions.rb | `app/controllers/concerns/boards_actions.rb` | concern | 共通アクション |
