# 機能設計書 40-ラベル管理

## 概要

本ドキュメントは、GitLabのラベル管理機能の設計仕様を記載する。本機能はイシュー、マージリクエストに付与するラベルの作成・編集・削除を提供する。

### 本機能の処理概要

ラベル管理機能は、プロジェクトやグループ内でイシューやマージリクエストを分類・整理するためのラベルを作成・編集・削除する機能である。

**業務上の目的・背景**：プロジェクト管理において、タスクの分類、優先度付け、ステータス管理は重要である。ラベルを活用することで、イシューやMRを効率的にフィルタリング、グルーピングでき、プロジェクトの可視化と管理が容易になる。

**機能の利用シーン**：バグ/機能要望/改善の分類ラベル作成、優先度ラベル（high/medium/low）作成、フロントエンド/バックエンドなどの技術分類、スプリントやマイルストーンに関連するラベル作成。

**主要な処理内容**：
1. ラベルの作成（名前、色、説明）
2. ラベルの編集
3. ラベルの削除
4. ラベルの優先度設定
5. プロジェクトラベルのグループラベルへの昇格
6. デフォルトラベルの一括生成

**関連システム・外部連携**：イシューボードとの連携（ラベルベースのリスト）

**権限による制御**：admin_label権限を持つユーザーがラベルを管理可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 56 | ラベル一覧 | 主画面 | プロジェクトラベルの一覧表示 |
| 57 | ラベル新規作成 | 主画面 | 新規ラベルの作成 |
| 58 | ラベル編集 | 主画面 | ラベルの編集処理 |
| 145 | ラベル一覧（グループ） | 参照画面 | グループラベルの一覧表示 |

## 機能種別

マスタ管理（CRUD）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| title | String | Yes | ラベル名 | 空文字不可、一意制約 |
| color | String | Yes | ラベル色（HEX形式） | 有効な色コード |
| description | String | No | ラベルの説明 | - |
| lock_on_merge | Boolean | No | マージ時のロック | プロジェクト設定による |

### 入力データソース

- 画面入力（ラベル作成/編集フォーム）
- デフォルトラベル生成

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| label | Label | 作成/更新されたラベル |

### 出力先

- 画面表示（ラベル一覧の更新）
- データベース（labelsテーブル）

## 処理フロー

### 処理シーケンス

```
1. 権限チェック
   └─ admin_label権限の確認
2. 入力検証
   └─ パラメータのバリデーション
3. ラベル操作
   └─ CreateService/UpdateServiceで処理
4. 完了
   └─ ラベル一覧へリダイレクト
```

### フローチャート

```mermaid
flowchart TD
    A[ラベル管理画面] --> B{操作種別}
    B -->|作成| C[CreateService]
    B -->|編集| D[UpdateService]
    B -->|削除| E[label.destroy]
    B -->|昇格| F[PromoteService]
    B -->|優先度設定| G[prioritize!]
    C --> H{成功?}
    D --> H
    E --> H
    F --> H
    G --> H
    H -->|Yes| I[ラベル一覧へ]
    H -->|No| J[エラー表示]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-40-01 | 名前一意 | 同一スコープ内でラベル名は一意 | 作成/編集時 |
| BR-40-02 | 色必須 | ラベル色は必須 | 作成/編集時 |
| BR-40-03 | 昇格制限 | プロジェクトラベルのみグループに昇格可能 | 昇格時 |
| BR-40-04 | 削除時の影響 | ラベル削除時は関連付けも削除 | 削除時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ラベル作成 | labels | INSERT | ラベルレコード作成 |
| ラベル編集 | labels | UPDATE | ラベル情報更新 |
| ラベル削除 | labels | DELETE | ラベルレコード削除 |
| 優先度設定 | label_priorities | INSERT/UPDATE | 優先度設定 |
| 関連付け削除 | label_links | DELETE | ラベル削除時に連動 |

### テーブル別操作詳細

#### labels

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | project_id / group_id | 親リソースID | |
| INSERT | title | ラベル名 | |
| INSERT | color | HEX色コード | |
| INSERT | description | 説明文 | |
| INSERT | type | 'ProjectLabel' / 'GroupLabel' | |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 404 | NotFound | admin_label権限なし | 404表示 |
| - | バリデーションエラー | 名前重複、必須項目不足 | エラーメッセージ表示 |

### リトライ仕様

特になし

## トランザクション仕様

ラベル削除と関連レコード削除は依存関係で処理。

## パフォーマンス要件

- urgency :low指定
- ラベルのプリロード対応

## セキュリティ考慮事項

- admin_label権限チェック
- admin_group_labels権限チェック（グループラベル昇格時）

## 備考

- Feature flag `labels_archive` でアーカイブ機能制御
- lock_on_merge機能はプロジェクト設定による

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | label.rb | `app/models/label.rb` | ラベルモデル |
| 1-2 | project_label.rb | `app/models/project_label.rb` | プロジェクトラベル |
| 1-3 | group_label.rb | `app/models/group_label.rb` | グループラベル |

**読解のコツ**: STI（Single Table Inheritance）による継承構造を理解。

#### Step 2: コントローラーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | labels_controller.rb | `app/controllers/projects/labels_controller.rb` | ラベル操作 |

**主要処理フロー**:
- **24-41行目**: indexアクション - ラベル一覧表示
- **48-61行目**: createアクション - ラベル作成
- **66-73行目**: updateアクション - ラベル更新
- **89-96行目**: destroyアクション - ラベル削除
- **129-158行目**: promoteアクション - グループラベルへ昇格

#### Step 3: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | create_service.rb | `app/services/labels/create_service.rb` | ラベル作成 |

**主要処理フロー**:
- **10-27行目**: executeメソッド - ラベル作成処理

### プログラム呼び出し階層図

```
LabelsController
    │
    ├─ index
    │      └─ LabelsFinder#execute
    │              └─ Preloaders::LabelsPreloader
    │
    ├─ create
    │      └─ Labels::CreateService#execute
    │              └─ project.labels.create
    │
    ├─ update
    │      └─ Labels::UpdateService#execute
    │              └─ label.update
    │
    ├─ destroy
    │      └─ label.destroy
    │
    └─ promote
           └─ Labels::PromoteService#execute
```

### データフロー図

```
[入力]                    [処理]                              [出力]

ラベル作成 ───▶ Labels::CreateService
                    │
                    ▼
              パラメータ変換 ───▶ color_name_to_hex
                    │
                    ▼
              labels.create ───▶ labelsテーブル
                    │
                    ▼
              リダイレクト ───▶ ラベル一覧

ラベル昇格 ───▶ Labels::PromoteService
                    │
                    ▼
              グループラベル作成
                    │
                    ▼
              プロジェクトラベル削除
                    │
                    ▼
              label_links更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| labels_controller.rb | `app/controllers/projects/labels_controller.rb` | コントローラー | ラベル操作 |
| label.rb | `app/models/label.rb` | モデル | ラベル基底モデル |
| project_label.rb | `app/models/project_label.rb` | モデル | プロジェクトラベル |
| group_label.rb | `app/models/group_label.rb` | モデル | グループラベル |
| create_service.rb | `app/services/labels/create_service.rb` | サービス | ラベル作成 |
| update_service.rb | `app/services/labels/update_service.rb` | サービス | ラベル更新 |
| promote_service.rb | `app/services/labels/promote_service.rb` | サービス | ラベル昇格 |
| labels_finder.rb | `app/finders/labels_finder.rb` | ファインダー | ラベル検索 |
| labels_preloader.rb | `app/models/preloaders/labels_preloader.rb` | プリローダー | ラベルプリロード |
