# 機能設計書 52-アーティファクト管理

## 概要

本ドキュメントは、GitLabのCI/CDジョブで生成されたアーティファクト（ビルド成果物、テスト結果など）の保存・管理・ダウンロード機能について記述した機能設計書である。

### 本機能の処理概要

アーティファクト管理機能は、CI/CDパイプラインのジョブ実行時に生成されるファイル（ビルド成果物、テストレポート、カバレッジレポートなど）を保存し、後から参照・ダウンロードできるようにするための機能である。

**業務上の目的・背景**：CI/CDパイプラインでは、ビルドされたバイナリ、テスト結果、コードカバレッジレポートなど、様々な成果物が生成される。これらの成果物を一元管理し、後続のジョブで利用したり、開発者がダウンロードして確認できるようにすることで、継続的インテグレーションの効果を最大化する。

**機能の利用シーン**：
- ビルドジョブで生成されたバイナリをデプロイジョブで使用する場合
- テスト結果レポートをマージリクエストに表示する場合
- カバレッジレポートをプロジェクト統計に反映する場合
- 特定のビルド成果物を開発者がダウンロードする場合
- セキュリティスキャン結果を確認する場合

**主要な処理内容**：
1. アーティファクト一覧の表示
2. アーティファクトのダウンロード（archive形式）
3. アーティファクト内のファイルブラウズ
4. 個別ファイルの表示・ダウンロード
5. アーティファクトの保持（keep）設定
6. アーティファクトの削除
7. 最新成功ビルドのアーティファクト取得

**関連システム・外部連携**：
- オブジェクトストレージ（S3互換、GCS等）
- Workhorse（ファイル配信プロキシ）
- GitLab Pages（外部ファイルリンク）

**権限による制御**：
- アーティファクト閲覧: `read_build`および`read_job_artifacts`権限が必要
- アーティファクト削除: `delete_job_artifact`権限が必要
- アーティファクト保持: `keep_job_artifacts`権限が必要

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 70 | ジョブ詳細 | 補助機能 | アーティファクトのダウンロード |
| 76 | アーティファクト一覧 | 主画面 | ジョブアーティファクトの一覧表示 |

## 機能種別

CRUD操作 / ファイル操作 / データ配信

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| job_id | Integer | Yes（特定ジョブ指定時） | ジョブID | 存在チェック |
| ref_name_and_path | String | No | ブランチ/タグとパス | - |
| path | String | No | アーティファクト内のパス | - |
| file_type | String | No | ファイルタイプ（archive, trace等） | enum値 |
| proxy | Boolean | No | プロキシダウンロード | - |

### 入力データソース

- URLパラメータ（ジョブID、パス）
- APIリクエスト（REST/GraphQL）
- CI/CDパイプラインからの自動アップロード

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| file | Binary | アーティファクトファイル |
| entries | Array | ブラウズ時のエントリ一覧 |
| metadata | Object | ファイルメタデータ |

### 出力先

- ファイルダウンロード（ブラウザ）
- 画面表示（ファイルブラウザ）
- JSONレスポンス（API）
- リダイレクト（外部URL）

## 処理フロー

### 処理シーケンス

```
1. リクエスト受信
   └─ ジョブID/ref/パスの解析

2. 権限チェック
   └─ read_build, read_job_artifacts の確認

3. ビルド/アーティファクト特定
   └─ ジョブIDまたはref+ジョブ名から特定

4. アーティファクトファイル取得
   └─ ローカルストレージまたはオブジェクトストレージから

5. レスポンス生成
   └─ ダウンロード/表示/リダイレクト
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{認証・権限チェック}
    B -->|権限なし| C[403 Forbidden]
    B -->|権限あり| D{ビルド特定}
    D -->|job_id指定| E[ジョブIDから取得]
    D -->|ref指定| F[ref+ジョブ名から取得]
    E --> G{アーティファクト存在?}
    F --> G
    G -->|No| H[404 Not Found]
    G -->|Yes| I{操作種別}
    I -->|download| J[ファイル送信]
    I -->|browse| K[エントリ一覧表示]
    I -->|file| L{外部リンク?}
    L -->|Yes| M[リダイレクト/警告]
    L -->|No| N[ファイル表示]
    J --> O[終了]
    K --> O
    M --> O
    N --> O
    C --> O
    H --> O
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-52-01 | アーティファクト有効期限 | デフォルトで30日後に期限切れ（設定可能） | アーティファクト作成時 |
| BR-52-02 | サイズ制限 | プランに応じた最大サイズ制限あり | アップロード時 |
| BR-52-03 | 外部リンク警告 | GitLab Pages外部リンクは警告ページを表示 | 設定有効時 |
| BR-52-04 | keep設定 | 手動でkeep設定すると有効期限が無効化 | keep操作時 |
| BR-52-05 | アクセス制御 | private/public/none/maintainerの4段階 | アクセス時 |

### 計算ロジック

- 最大アーティファクトサイズ: `ci_max_artifact_size_{type}` プランリミットから計算
- 有効期限: `expire_at = created_at + artifacts:expire_in` 設定値

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧取得 | p_ci_job_artifacts | SELECT | ジョブに紐づくアーティファクト取得 |
| 削除 | p_ci_job_artifacts | DELETE | アーティファクトレコード削除 |
| keep設定 | ci_builds | UPDATE | locked属性の更新 |
| 統計更新 | project_statistics | UPDATE | build_artifacts_sizeの更新 |

### テーブル別操作詳細

#### p_ci_job_artifacts

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | job_id | ジョブIDで絞り込み | - |
| SELECT | file_type | ファイルタイプで絞り込み | - |
| DELETE | id | 指定IDのレコード削除 | 統計も更新 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 403 | Forbidden | 権限不足 | アクセス権限を確認 |
| 404 | Not Found | アーティファクト未検出 | ジョブID/パスを確認 |
| 404 | Not Found | zipアーティファクト以外のrawアクセス | file_typeを確認 |

### リトライ仕様

- ダウンロード失敗時はクライアント側でリトライ
- オブジェクトストレージ一時障害時は自動リトライなし

## トランザクション仕様

- アーティファクト削除時は統計更新も含めてトランザクション管理
- FastDestroyAllによる効率的な一括削除をサポート

## パフォーマンス要件

- アーティファクト一覧取得: 1秒以内
- ファイルダウンロード: ファイルサイズ依存
- ブラウズ操作: 2秒以内

## セキュリティ考慮事項

- アクセシビリティ設定（public/private/none/maintainer）による制御
- 外部リンク警告機能（XSS対策）
- 監査ログへのダウンロード記録（EE）

## 備考

- アーティファクトはパーティションテーブル（p_ci_job_artifacts）に保存
- ファイル保存先はローカルまたはオブジェクトストレージ（設定による）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | job_artifact.rb | `app/models/ci/job_artifact.rb` | アーティファクトの属性、関連、スコープを理解する |

**読解のコツ**:
- `enum :accessibility` (31行目) でアクセスレベルの種類を確認
- `enum :file_type` (105行目) でファイルタイプの種類を確認
- `belongs_to :job` (34-39行目) でジョブとの関連を確認
- `update_project_statistics` (48行目) で統計更新の仕組みを確認

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | artifacts_controller.rb | `app/controllers/projects/artifacts_controller.rb` | 各アクションの処理フローを確認 |

**主要処理フロー**:
- **25行目**: indexアクションでアーティファクト一覧
- **27-34行目**: destroyアクションでアーティファクト削除
- **37-43行目**: downloadアクションでファイルダウンロード
- **46-52行目**: browseアクションでファイルブラウズ
- **61-81行目**: fileアクションで個別ファイル表示
- **84-91行目**: rawアクションでZIP内ファイル直接取得
- **93-98行目**: keepアクションでアーティファクト保持設定

#### Step 3: ファイル取得ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | artifacts_controller.rb | `app/controllers/projects/artifacts_controller.rb` | build特定ロジック (132-163行目) |

**主要処理フロー**:
- **144-145行目**: job_idからビルドを取得
- **148-155行目**: ref+SHAからビルドを取得
- **158-162行目**: ref+ジョブ名からビルドを取得

### プログラム呼び出し階層図

```
Projects::ArtifactsController
    │
    ├─ #download
    │      ├─ artifact_file (JobArtifactからファイル取得)
    │      └─ send_upload (Workhorse経由でファイル送信)
    │
    ├─ #browse
    │      └─ build.artifacts_metadata_entry (メタデータからエントリ取得)
    │
    ├─ #file
    │      ├─ entry.blob (Blobオブジェクト取得)
    │      └─ redirect_to external_url (外部リンク時)
    │
    ├─ #raw
    │      └─ send_artifacts_entry (ZIP内ファイル送信)
    │
    └─ #destroy
           └─ artifact.destroy (アーティファクト削除)
```

### データフロー図

```
[入力]               [処理]                        [出力]

ジョブID/ref ───▶ ArtifactsController ───▶ ファイルダウンロード
                         │
                         ▼
                 Ci::JobArtifact (Model)
                         │
                         ▼
                 JobArtifactUploader
                         │
                         ▼
               ローカル/オブジェクトストレージ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| job_artifact.rb | `app/models/ci/job_artifact.rb` | モデル | アーティファクトのデータモデル |
| artifacts_controller.rb | `app/controllers/projects/artifacts_controller.rb` | コントローラー | アーティファクト操作のエンドポイント |
| job_artifact_uploader.rb | `app/uploaders/job_artifact_uploader.rb` | アップローダー | ファイルアップロード/ダウンロード処理 |
| enums/ci/job_artifact.rb | `lib/gitlab/ci/enums/job_artifact.rb` | Enum定義 | ファイルタイプ・フォーマットの定義 |
