# 機能設計書 53-パイプラインエディタ

## 概要

本ドキュメントは、GitLabのWeb UI上で.gitlab-ci.ymlファイルを編集・検証するパイプラインエディタ機能について記述した機能設計書である。

### 本機能の処理概要

パイプラインエディタ機能は、CI/CD設定ファイル（.gitlab-ci.yml）をWeb UI上で視覚的に編集し、リアルタイムで構文検証やパイプラインのプレビューを行うための機能である。

**業務上の目的・背景**：CI/CD設定は複雑になりがちであり、YAML構文エラーや設定ミスがパイプライン実行失敗の原因となる。パイプラインエディタを使用することで、設定の編集・検証・コミットを一箇所で行い、設定ミスを未然に防ぐことができる。

**機能の利用シーン**：
- 新規プロジェクトでCI/CD設定を初めて作成する場合
- 既存のCI/CD設定を変更する場合
- 設定変更前に構文チェックを行いたい場合
- パイプラインの構造を視覚的に確認したい場合
- CI設定テンプレートを適用したい場合

**主要な処理内容**：
1. .gitlab-ci.ymlファイルの読み込み・表示
2. YAML構文のリアルタイム検証（CI Lint）
3. パイプライン構造のビジュアライゼーション
4. 編集内容のコミット
5. CI設定テンプレートの適用
6. ジョブアシスタントによる設定支援

**関連システム・外部連携**：
- CI Lint API（構文検証）
- リポジトリサービス（ファイル読み書き）
- パイプラインサービス（シミュレーション）

**権限による制御**：
- パイプラインエディタへのアクセス: プロジェクトへのコラボレーション権限が必要
- ファイルのコミット: リポジトリへの書き込み権限が必要

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 74 | パイプラインエディタ | 主画面 | .gitlab-ci.ymlの編集 |
| 75 | CI Lint | 主画面 | CI設定の構文チェック |

## 機能種別

ファイル編集 / バリデーション / ビジュアライゼーション

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| content | String | Yes（編集時） | CI設定ファイルの内容 | YAML構文チェック |
| branch_name | String | No | 対象ブランチ | ブランチ存在チェック |
| commit_message | String | Yes（コミット時） | コミットメッセージ | 空文字チェック |

### 入力データソース

- リポジトリ内の.gitlab-ci.ymlファイル
- 画面上のエディタ入力
- CI設定テンプレート

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| content | String | CI設定ファイルの内容 |
| valid | Boolean | 構文検証結果 |
| errors | Array | エラーメッセージリスト |
| warnings | Array | 警告メッセージリスト |
| merged_yaml | String | includeを展開した最終YAML |
| stages | Array | ステージ一覧 |
| jobs | Array | ジョブ一覧 |

### 出力先

- 画面表示（エディタ、ビジュアライゼーション）
- リポジトリ（コミット時）
- JSONレスポンス（API経由）

## 処理フロー

### 処理シーケンス

```
1. 権限チェック
   └─ can_collaborate_with_project? の確認

2. エディタ画面表示
   └─ フロントエンドコンポーネントの読み込み

3. CI設定ファイル読み込み（フロントエンド→GraphQL）
   └─ リポジトリから.gitlab-ci.ymlを取得

4. 編集・検証（フロントエンド→CI Lint API）
   └─ リアルタイムでYAML構文検証

5. コミット（フロントエンド→GraphQL Mutation）
   └─ リポジトリへのファイルコミット
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{コラボレーション権限?}
    B -->|No| C[404 Not Found]
    B -->|Yes| D[エディタ画面表示]
    D --> E[.gitlab-ci.yml読み込み]
    E --> F{ファイル存在?}
    F -->|No| G[新規作成モード]
    F -->|Yes| H[既存内容表示]
    G --> I[編集操作]
    H --> I
    I --> J[リアルタイム構文検証]
    J --> K{構文エラー?}
    K -->|Yes| L[エラー表示]
    K -->|No| M[パイプラインビジュアライゼーション]
    L --> I
    M --> N{コミット実行?}
    N -->|No| I
    N -->|Yes| O[リポジトリへコミット]
    O --> P[終了]
    C --> P
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-53-01 | コラボレーション権限 | エディタ表示にはプロジェクトへのコラボレーション権限が必要 | アクセス時 |
| BR-53-02 | YAML構文検証 | 編集内容は即座にCI Lintで検証される | 編集時 |
| BR-53-03 | include展開 | include指定のファイルは展開して検証される | 検証時 |
| BR-53-04 | デフォルトブランチ | 初期表示はデフォルトブランチのファイル | 初期表示時 |

### 計算ロジック

- 特になし（編集・検証機能のため）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | - | - | フロントエンドベースの機能のためDBへの直接操作なし |

### テーブル別操作詳細

- パイプラインエディタ自体はDB操作を行わない
- コミット時はリポジトリサービス経由でGitに書き込み
- パイプライン実行時に初めてci_pipelinesテーブルにレコード作成

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 404 | Not Found | コラボレーション権限なし | プロジェクトへのアクセス権限を確認 |
| 422 | Validation Error | YAML構文エラー | エラーメッセージに従い修正 |
| 409 | Conflict | コミット時のコンフリクト | 最新のファイルを取得して再編集 |

### リトライ仕様

- 構文検証はクライアント側でリトライ
- コミット失敗時は自動リトライなし

## トランザクション仕様

- DB操作なしのためトランザクション管理不要
- コミットはGitのトランザクションに依存

## パフォーマンス要件

- エディタ画面表示: 2秒以内
- 構文検証（CI Lint）: 3秒以内
- ビジュアライゼーション更新: 1秒以内

## セキュリティ考慮事項

- プロジェクトへのコラボレーション権限チェック
- コミット時の書き込み権限チェック
- CI変数のマスキング（シミュレーション時）

## 備考

- フロントエンドはVue.jsベースのSPA
- 主要なロジックはGraphQL API経由で実行
- ci_job_assistant_drawer機能フラグでジョブアシスタント制御

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

パイプラインエディタはフロントエンドベースの機能であるため、バックエンドコントローラーはシンプルである。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | pipeline_editor_controller.rb | `app/controllers/projects/ci/pipeline_editor_controller.rb` | コントローラーの構造と権限チェックを確認 |

**読解のコツ**:
- **4行目**: `before_action :check_can_collaborate!` でコラボレーション権限チェック
- **5-7行目**: `push_frontend_feature_flag` でジョブアシスタント機能フラグを設定
- **9行目**: `feature_category :pipeline_composition` で機能カテゴリを確認
- **13行目**: showアクションは空（フロントエンドにレンダリングを委譲）
- **17-18行目**: `can_collaborate_with_project?` で権限チェックの実装

#### Step 2: フロントエンドコンポーネントを理解する

フロントエンドのVue.jsコンポーネントがエディタの主要ロジックを担う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.js | `app/assets/javascripts/ci/pipeline_editor/` | エディタのエントリーポイント |
| 2-2 | pipeline_editor_app.vue | `app/assets/javascripts/ci/pipeline_editor/` | メインアプリケーションコンポーネント |

**読解のコツ**:
- フロントエンドコードはJavaScriptディレクトリに配置
- GraphQL APIとの通信でデータ取得・更新を実行

### プログラム呼び出し階層図

```
Projects::Ci::PipelineEditorController#show
    │
    └─ check_can_collaborate!
           └─ can_collaborate_with_project?(@project)

[フロントエンド]
Vue.js App
    │
    ├─ GraphQL Query: getCiConfigData
    │      └─ .gitlab-ci.yml 取得
    │
    ├─ GraphQL Query: lintCI
    │      └─ CI Lint API 呼び出し
    │
    └─ GraphQL Mutation: commitCiFile
           └─ リポジトリへコミット
```

### データフロー図

```
[入力]               [処理]                        [出力]

ブラウザ ───▶ PipelineEditorController ───▶ HTMLページ
                      │                           │
                      ▼                           ▼
               Vue.js アプリ ◀──────────── フロントエンド
                      │
                      ▼
               GraphQL API
                      │
          ┌───────────┼───────────┐
          ▼           ▼           ▼
    リポジトリ   CI Lint API   コミットAPI
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| pipeline_editor_controller.rb | `app/controllers/projects/ci/pipeline_editor_controller.rb` | コントローラー | エディタ画面のエントリーポイント |
| pipeline_editor/ | `app/assets/javascripts/ci/pipeline_editor/` | フロントエンド | Vue.jsエディタコンポーネント |
| ci_lint.rb | `lib/gitlab/ci/lint.rb` | ライブラリ | CI構文検証ロジック |
| get_ci_config_data.query.graphql | `app/graphql/queries/ci/` | GraphQL | CI設定データ取得クエリ |
