# 機能設計書 56-デプロイメント履歴

## 概要

本ドキュメントは、GitLabの各環境へのデプロイ履歴を表示・管理する機能について記述した機能設計書である。

### 本機能の処理概要

デプロイメント履歴機能は、各環境へのデプロイ履歴を追跡し、いつ・誰が・どのバージョン（コミット）をデプロイしたかを可視化する機能である。

**業務上の目的・背景**：本番環境で問題が発生した際、どのデプロイが原因かを特定するためにデプロイ履歴が必要となる。また、監査目的でいつ・誰がデプロイを行ったかを記録し、確認できることが重要である。本機能により、デプロイの追跡可能性（トレーサビリティ）を確保できる。

**機能の利用シーン**：
- 本番環境での障害調査時に直近のデプロイを確認する場合
- 特定のコミットがいつ本番にデプロイされたかを確認する場合
- デプロイの監査ログを確認する場合
- ロールバック先のデプロイを特定する場合
- マージリクエストと本番デプロイの関連を確認する場合

**主要な処理内容**：
1. デプロイメント一覧の表示（環境別）
2. 個別デプロイメントの詳細表示
3. デプロイメントとコミット/ジョブの関連表示
4. Jira連携でのデプロイ情報同期

**関連システム・外部連携**：
- Jira（デプロイ情報同期）
- Webhook（デプロイイベント通知）
- Git（コミット情報）

**権限による制御**：
- デプロイメント閲覧: `read_deployment`権限が必要

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 78 | 環境詳細 | 補助機能 | デプロイ履歴の表示 |
| 81 | デプロイ詳細 | 主画面 | 個別デプロイの詳細表示 |

## 機能種別

データ閲覧 / 履歴管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| environment_id | Integer | Yes | 環境ID | 存在チェック |
| id | Integer | Yes（詳細表示時） | デプロイメントIID | 存在チェック |
| after | DateTime | No | この日時以降のデプロイを取得 | - |

### 入力データソース

- URLパラメータ（環境ID、デプロイメントIID）
- クエリパラメータ（フィルタ条件）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | Integer | デプロイメントID |
| iid | Integer | プロジェクト内連番 |
| ref | String | ブランチ/タグ名 |
| sha | String | コミットSHA |
| status | String | ステータス（created/running/success/failed/canceled/skipped/blocked） |
| created_at | DateTime | 作成日時 |
| finished_at | DateTime | 完了日時 |
| deployed_by | Object | デプロイ実行者 |
| deployable | Object | 関連ジョブ |

### 出力先

- 画面表示（デプロイメント一覧、詳細）
- JSONレスポンス（API）

## 処理フロー

### 処理シーケンス

```
1. 認証・権限チェック
   └─ read_deployment 権限の確認

2. 環境の特定
   └─ environment_idから環境を取得

3. デプロイメントデータ取得
   └─ 環境に紐づくデプロイメント一覧/詳細取得

4. 関連データ取得
   └─ デプロイ実行者、ジョブ、コミット情報

5. レスポンス生成
   └─ JSON/HTMLレスポンス
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{read_deployment権限?}
    B -->|No| C[アクセス拒否]
    B -->|Yes| D[環境取得]
    D --> E{環境存在?}
    E -->|No| F[404 Not Found]
    E -->|Yes| G{操作種別}
    G -->|一覧| H[デプロイメント一覧取得]
    G -->|詳細| I[デプロイメント詳細取得]
    H --> J[シリアライズ]
    I --> J
    J --> K[レスポンス生成]
    K --> L[終了]
    C --> L
    F --> L
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-56-01 | IIDはプロジェクトスコープ | デプロイメントIIDはプロジェクト内で一意の連番 | デプロイメント作成時 |
| BR-56-02 | 状態遷移 | created→running→success/failed/canceled/skipped | デプロイメント実行中 |
| BR-56-03 | アーカイブ | 古いデプロイメントは一定数を超えるとアーカイブ | 自動処理 |
| BR-56-04 | Jira同期 | Jira連携設定時はデプロイ情報を自動同期 | 状態変更時 |
| BR-56-05 | MRメトリクス | 本番デプロイ時にMRの初回デプロイ日時を記録 | 成功時 |

### 計算ロジック

- `deployed_at`: statusがsuccessの場合のfinished_at
- `short_sha`: SHAの先頭8文字
- `previous_deployment`: 同一環境の直前の成功デプロイメント

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧取得 | deployments | SELECT | 環境に紐づくデプロイメント取得 |
| 詳細取得 | deployments | SELECT | IIDでデプロイメント取得 |
| 関連取得 | users, ci_builds | SELECT | デプロイ実行者、ジョブ情報取得 |

### テーブル別操作詳細

#### deployments

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | environment_id | 指定環境ID | - |
| SELECT | created_at | after以降で絞り込み | オプション |
| SELECT | status | 表示対象ステータス | VISIBLE_STATUSES |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 403 | Forbidden | 権限不足 | プロジェクトへのアクセス権限を取得 |
| 404 | Not Found | 環境またはデプロイメント未検出 | 正しいIDを確認 |

### リトライ仕様

- 閲覧操作のためリトライ不要

## トランザクション仕様

- 閲覧操作のためトランザクション管理不要
- デプロイメント作成/更新は別機能（CI/CD）で管理

## パフォーマンス要件

- デプロイメント一覧取得: 1秒以内
- デプロイメント詳細取得: 500ms以内

## セキュリティ考慮事項

- プロジェクト単位での権限チェック
- デプロイトークン使用時のアクセス制限

## 備考

- ARCHIVABLE_OFFSET: 50000（この数を超えるとアーカイブ対象）
- VISIBLE_STATUSES: running, success, failed, canceled, blocked
- FINISHED_STATUSES: success, failed, canceled

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | deployment.rb | `app/models/deployment.rb` | デプロイメントの属性、関連、状態遷移を理解する |

**読解のコツ**:
- **16行目**: `ARCHIVABLE_OFFSET = 50_000` でアーカイブ閾値を確認
- **73-75行目**: `VISIBLE_STATUSES`, `FINISHED_STATUSES`, `UPCOMING_STATUSES` で各ステータスグループを確認
- **77-148行目**: `state_machine :status` で状態遷移を確認
- **158-166行目**: `enum :status` でステータスの種類を確認
- **256-258行目**: `commit`メソッドでコミット取得ロジックを確認

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | deployments_controller.rb | `app/controllers/projects/deployments_controller.rb` | 各アクションの処理フローを確認 |

**主要処理フロー**:
- **4-5行目**: before_actionで権限チェックと環境取得
- **11-17行目**: indexアクションでデプロイメント一覧取得（JSON）
- **20-25行目**: showアクションでデプロイメント詳細取得
- **30-31行目**: environmentメソッドで環境取得

#### Step 3: シリアライザーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | deployment_serializer.rb | `app/serializers/deployment_serializer.rb` | JSON出力フォーマットを確認 |

### プログラム呼び出し階層図

```
Projects::DeploymentsController
    │
    ├─ #index
    │      ├─ environment.deployments
    │      └─ DeploymentSerializer#represent_concise
    │
    └─ #show
           └─ project.deployments.find_by_iid!
```

### データフロー図

```
[入力]               [処理]                        [出力]

環境ID/
デプロイIID ───▶ DeploymentsController ───▶ デプロイ一覧/詳細
                      │
                      ▼
              Deployment (Model)
                      │
          ┌───────────┼───────────┐
          ▼           ▼           ▼
    deployments    ci_builds     users
     テーブル       テーブル      テーブル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| deployment.rb | `app/models/deployment.rb` | モデル | デプロイメントのデータモデル |
| deployments_controller.rb | `app/controllers/projects/deployments_controller.rb` | コントローラー | デプロイメント閲覧のエンドポイント |
| deployment_serializer.rb | `app/serializers/deployment_serializer.rb` | シリアライザー | JSON出力フォーマット |
| deployments_finder.rb | `app/finders/deployments_finder.rb` | Finder | デプロイメント検索ロジック |
