# 機能設計書 6-プロジェクトスター

## 概要

本ドキュメントは、GitLabにおけるプロジェクトスター（お気に入り）機能の詳細設計を記述する。この機能は、ユーザーがプロジェクトをスター（お気に入り）に追加または削除するための機能である。

### 本機能の処理概要

プロジェクトスター機能は、ユーザーが関心のあるプロジェクトをブックマークし、後から簡単にアクセスできるようにするための機能を提供する。

**業務上の目的・背景**：多数のプロジェクトの中から、特に関心のあるプロジェクトを素早く見つけられるようにする必要がある。スター機能により、ユーザーは重要なプロジェクトをマークし、ダッシュボードやプロジェクト一覧でフィルタリングできる。また、プロジェクトの人気度を示す指標としても機能する。

**機能の利用シーン**：
- 頻繁にアクセスするプロジェクトをブックマークする時
- 興味のあるオープンソースプロジェクトをフォローする時
- プロジェクトの人気度を確認する時
- スターしたプロジェクト一覧からプロジェクトを探す時

**主要な処理内容**：
1. ユーザー認証確認
2. スター状態のトグル（追加/削除）
3. スターカウントの更新
4. JSONレスポンス返却

**関連システム・外部連携**：
- 特になし（シンプルなDB操作のみ）

**権限による制御**：
- 認証済みユーザーのみ使用可能
- プロジェクトへのアクセス権は不要（公開プロジェクトであれば誰でもスター可能）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 11 | プロジェクト一覧 | 補助機能 | プロジェクトのスター追加・削除 |
| 24 | プロジェクト詳細 | 補助機能 | スター追加・削除 |
| 29 | スター一覧 | 主画面 | スターしたユーザー一覧表示 |

## 機能種別

CRUD操作（Create/Delete）/ トグル操作

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| なし | - | - | toggle_starはパラメータ不要 | - |

### 入力データソース

- 画面操作（スターボタンクリック）
- API リクエスト（REST API / GraphQL）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| star_count | Integer | 更新後のスター数 |

### 出力先

- データベース（users_star_projectsテーブル）
- JSONレスポンス

## 処理フロー

### 処理シーケンス

```
1. リクエスト受付（ProjectsController#toggle_star）
   └─ 認証確認

2. スター状態トグル
   └─ current_user.toggle_star(@project)

3. プロジェクトリセット
   └─ @project.reset（キャッシュクリア）

4. JSONレスポンス返却
   └─ star_count を返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始: toggle_star リクエスト] --> B{認証済み?}
    B -->|No| C[認証エラー]
    B -->|Yes| D{既にスター済み?}
    D -->|Yes| E[スター削除]
    D -->|No| F[スター追加]
    E --> G[star_count デクリメント]
    F --> H[star_count インクリメント]
    G --> I[プロジェクトリセット]
    H --> I
    I --> J[JSONレスポンス]
    J --> K[終了]
    C --> K
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 認証必須 | スター操作には認証が必要 | 常時 |
| BR-002 | トグル動作 | 同じ操作で追加/削除が切り替わる | 常時 |
| BR-003 | 重複禁止 | 同一ユーザーが同一プロジェクトに複数スター不可 | 常時 |

### 計算ロジック

スターカウント：
```ruby
# projectsテーブルのstar_countカラム
# users_star_projectsの関連レコード数と同期
star_count = project.starrers.count
```

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| スター追加 | users_star_projects | INSERT | スター関係追加 |
| スター削除 | users_star_projects | DELETE | スター関係削除 |
| カウント更新 | projects | UPDATE | star_count更新 |

### テーブル別操作詳細

#### users_star_projects

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | user_id | current_user.id | スター追加時 |
| INSERT | project_id | project.id | スター追加時 |
| DELETE | - | WHERE user_id AND project_id | スター削除時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E001 | 認証エラー | 未認証ユーザー | ログイン |

### リトライ仕様

- 特になし（シンプルな操作のため）

## トランザクション仕様

- スター追加/削除とカウント更新は別トランザクション
- カウンターキャッシュにより最終的一貫性

## パフォーマンス要件

- スター操作は即座に完了（100ms以内）
- 低緊急度（urgency: :low）として設定

## セキュリティ考慮事項

- 認証チェック必須
- CSRF保護

## 備考

- スターカウントはプロジェクトの人気度指標として表示される
- スターしたプロジェクトはダッシュボードでフィルタリング可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | projects_controller.rb | `app/controllers/projects_controller.rb` | toggle_starアクションの実装 |

**主要処理フロー**:
1. **347-354行目**: toggle_starアクションの定義

#### Step 2: モデル層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | user.rb | `app/models/user.rb` | toggle_starメソッドの実装 |
| 2-2 | users_star_project.rb | `app/models/users_star_project.rb` | スター関係モデル |

### プログラム呼び出し階層図

```
ProjectsController#toggle_star
    │
    ├─ current_user.toggle_star(@project)
    │      │
    │      ├─ starred?(project) チェック
    │      │      └─ starred_projects.exists?(project.id)
    │      │
    │      └─ [スター済み]
    │             └─ star(project) / unstar(project)
    │
    ├─ @project.reset
    │
    └─ render json: { star_count: @project.star_count }
```

### データフロー図

```
[入力]                      [処理]                           [出力]

スターボタン          ProjectsController#toggle_star
クリック                      │
         │                   │
         ▼                   ▼
              ┌───────────────────────────────┐
              │ current_user.toggle_star      │
              │                               │
              │ スター済み? → unstar          │
              │ 未スター?   → star            │
              └─────────────┬─────────────────┘
                            │
                            ▼
              ┌───────────────────────────────┐      ┌─────────────────────┐
              │ DB操作                         │ ───▶ │ users_star_projects │
              │ INSERT / DELETE               │      └─────────────────────┘
              └─────────────┬─────────────────┘
                            │
                            ▼
              ┌───────────────────────────────┐
              │ JSON レスポンス               │ ───▶ { star_count: N }
              └───────────────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| projects_controller.rb | `app/controllers/projects_controller.rb` | ソース | コントローラー |
| user.rb | `app/models/user.rb` | ソース | toggle_star, star, unstarメソッド |
| users_star_project.rb | `app/models/users_star_project.rb` | ソース | スター関係モデル |
| project.rb | `app/models/project.rb` | ソース | star_count, starrersリレーション |
